-- MySQL dump 10.13  Distrib 5.7.28, for Win64 (x86_64)
--
-- Host: antares    Database: security_demo
-- ------------------------------------------------------
-- Server version	5.6.23-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `address`
--

DROP TABLE IF EXISTS `address`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `address` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `district` varchar(20) NOT NULL,
  `postal_code` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `address`
--

LOCK TABLES `address` WRITE;
/*!40000 ALTER TABLE `address` DISABLE KEYS */;
INSERT INTO `address` VALUES (5,'1913 Hanoi Way','Nagasaki','35200'),(6,'1121 Loja Avenue','California','17886'),(7,'692 Joliet Street','Attika','83579'),(8,'1566 Inegl Manor','Mandalay','53561'),(9,'53 Idfu Parkway','Nantou','42399'),(10,'1795 Santiago de Compostela Way','Texas','18743'),(11,'900 Santiago de Compostela Parkway','Central Serbia','93896'),(12,'478 Joliet Way','Hamilton','77948'),(13,'613 Korolev Drive','Masqat','45844'),(14,'1531 Sal Drive','Esfahan','53628'),(15,'1542 Tarlac Parkway','Kanagawa','1027'),(16,'808 Bhopal Manor','Haryana','10672'),(17,'270 Amroha Parkway','Osmaniye','29610'),(18,'770 Bydgoszcz Avenue','California','16266'),(19,'419 Iligan Lane','Madhya Pradesh','72878'),(20,'360 Toulouse Parkway','England','54308'),(21,'270 Toulon Boulevard','Kalmykia','81766'),(22,'320 Brest Avenue','Kaduna','43331'),(23,'1417 Lancaster Avenue','Northern Cape','72192'),(24,'1688 Okara Way','Nothwest Border Prov','21954'),(25,'262 A Corua (La Corua) Parkway','Dhaka','34418'),(26,'28 Charlotte Amalie Street','Rabat-Sal-Zammour-Z','37551'),(27,'1780 Hino Boulevard','Liepaja','7716'),(28,'96 Tafuna Way','Crdoba','99865'),(29,'934 San Felipe de Puerto Plata Street','Sind','99780'),(30,'18 Duisburg Boulevard','','58327'),(31,'217 Botshabelo Place','Southern Mindanao','49521'),(32,'1425 Shikarpur Manor','Bihar','65599'),(33,'786 Aurora Avenue','Yamaguchi','65750'),(34,'1668 Anpolis Street','Taipei','50199'),(35,'33 Gorontalo Way','West Bengali','30348'),(36,'176 Mandaluyong Place','Uttar Pradesh','65213'),(37,'127 Purnea (Purnia) Manor','Piemonte','79388'),(38,'61 Tama Street','Okayama','94065'),(39,'391 Callao Drive','Midi-Pyrnes','34021'),(40,'334 Munger (Monghyr) Lane','Markazi','38145'),(41,'1440 Fukuyama Loop','Henan','47929'),(42,'269 Cam Ranh Parkway','Chisinau','34689'),(43,'306 Antofagasta Place','Esprito Santo','3989'),(44,'671 Graz Street','Oriental','94399'),(45,'42 Brindisi Place','Yerevan','16744'),(46,'1632 Bislig Avenue','Nonthaburi','61117'),(47,'1447 Imus Way','Tahiti','48942'),(48,'1998 Halifax Drive','Lipetsk','76022'),(49,'1718 Valencia Street','Antofagasta','37359'),(50,'46 Pjatigorsk Lane','Moscow (City)','23616'),(51,'686 Garland Manor','Cear','52535'),(52,'909 Garland Manor','Tatarstan','69367'),(53,'725 Isesaki Place','Mekka','74428'),(54,'115 Hidalgo Parkway','Khartum','80168');
/*!40000 ALTER TABLE `address` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer`
--

DROP TABLE IF EXISTS `customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(91) DEFAULT NULL,
  `address` varchar(50) DEFAULT NULL,
  `zip_code` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer`
--

LOCK TABLES `customer` WRITE;
/*!40000 ALTER TABLE `customer` DISABLE KEYS */;
INSERT INTO `customer` VALUES (1,'MARY SMITH','1913 Hanoi Way','35200'),(2,'PATRICIA JOHNSON','1121 Loja Avenue','17886'),(3,'LINDA WILLIAMS','692 Joliet Street','83579'),(4,'BARBARA JONES','1566 Inegl Manor','53561'),(5,'ELIZABETH BROWN','53 Idfu Parkway','42399'),(6,'JENNIFER DAVIS','1795 Santiago de Compostela Way','18743'),(7,'MARIA MILLER','900 Santiago de Compostela Parkway','93896'),(8,'LISA ANDERSON','1542 Tarlac Parkway','1027'),(9,'NANCY THOMAS','808 Bhopal Manor','10672');
/*!40000 ALTER TABLE `customer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment`
--

DROP TABLE IF EXISTS `payment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payment` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `manager_id` int(11) DEFAULT NULL,
  `customer_id` smallint(5) unsigned NOT NULL,
  `amount` decimal(5,2) DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `completed` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_payment_customer` (`customer_id`),
  KEY `fk_payment_manager` (`manager_id`),
  CONSTRAINT `fk_payment_customer` FOREIGN KEY (`customer_id`) REFERENCES `customer` (`id`),
  CONSTRAINT `fk_payment_manager` FOREIGN KEY (`manager_id`) REFERENCES `phpgen_users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=181 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment`
--

LOCK TABLES `payment` WRITE;
/*!40000 ALTER TABLE `payment` DISABLE KEYS */;
INSERT INTO `payment` VALUES (1,2,1,2.99,'2016-05-25 11:30:37',0),(2,3,1,0.99,'2016-05-28 10:35:23',0),(3,4,1,5.99,'2016-06-15 00:54:12',1),(4,4,1,0.99,'2016-06-15 18:02:53',0),(55,3,2,2.99,'2016-08-19 06:26:04',1),(60,8,3,1.99,'2016-05-27 17:17:09',1),(61,4,3,2.99,'2016-05-29 22:43:55',0),(62,9,3,8.99,'2016-06-16 01:34:05',0),(86,5,4,4.99,'2016-06-15 09:31:28',0),(87,4,4,0.99,'2016-06-16 08:08:40',1),(88,9,4,2.99,'2016-06-16 14:01:27',1),(104,8,4,6.99,'2016-08-20 00:00:00',1),(105,2,4,4.99,'2016-08-21 04:53:37',0),(106,9,4,2.99,'2016-08-22 13:58:23',0),(107,7,4,1.99,'2016-08-23 07:43:00',0),(108,7,5,0.99,'2016-05-29 07:25:16',0),(109,3,5,6.99,'2016-05-31 11:15:43',1),(144,4,5,0.99,'2016-08-22 17:37:02',0),(145,9,5,0.99,'2016-02-14 00:00:00',1),(146,4,6,4.99,'2016-05-25 08:43:32',1),(147,8,6,2.99,'2016-05-28 11:09:14',0),(148,3,6,0.99,'2016-05-30 01:25:01',1),(149,8,6,3.99,'2016-06-16 03:41:38',0),(171,3,6,4.99,'2016-08-21 09:49:28',0),(172,4,6,5.99,'2016-08-23 02:51:24',1),(173,5,6,0.99,'2016-08-23 06:41:32',0),(174,5,7,5.99,'2016-05-25 00:00:00',1),(175,4,7,0.99,'2016-05-25 19:30:46',0),(176,8,7,2.99,'2016-05-29 09:27:00',1),(177,9,7,4.99,'2016-05-30 21:07:15',0),(178,3,7,5.99,'2016-05-31 08:44:29',0),(179,2,7,0.99,'2016-06-16 00:00:00',0),(180,5,7,2.99,'2016-06-18 05:03:36',0);
/*!40000 ALTER TABLE `payment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `phpgen_user_perms`
--

DROP TABLE IF EXISTS `phpgen_user_perms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `phpgen_user_perms` (
  `user_id` int(11) NOT NULL,
  `page_name` varchar(255) NOT NULL,
  `perm_name` varchar(6) NOT NULL,
  PRIMARY KEY (`user_id`,`page_name`,`perm_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `phpgen_user_perms`
--

LOCK TABLES `phpgen_user_perms` WRITE;
/*!40000 ALTER TABLE `phpgen_user_perms` DISABLE KEYS */;
INSERT INTO `phpgen_user_perms` VALUES (-1,'testimonial','INSERT'),(-1,'testimonial','SELECT'),(0,'','SELECT'),(0,'v_advanced_custom_record_permissions','DELETE'),(0,'v_advanced_custom_record_permissions','INSERT'),(0,'v_advanced_custom_record_permissions','SELECT'),(0,'v_advanced_custom_record_permissions','UPDATE'),(0,'v_public_privileges','INSERT'),(1,'','ADMIN'),(2,'customer','ADMIN'),(2,'payment','ADMIN'),(2,'payment01','ADMIN'),(2,'v_admin_panel','ADMIN'),(3,'customer','DELETE'),(3,'customer','UPDATE'),(3,'payment','DELETE'),(3,'payment','INSERT'),(3,'payment','SELECT'),(3,'payment','UPDATE'),(3,'payment01','DELETE'),(3,'payment01','INSERT'),(3,'payment01','SELECT'),(3,'payment01','UPDATE'),(4,'customer','INSERT'),(4,'payment','DELETE'),(4,'payment','INSERT'),(4,'payment','SELECT'),(4,'payment','UPDATE'),(4,'payment01','DELETE'),(4,'payment01','INSERT'),(4,'payment01','SELECT'),(4,'payment01','UPDATE'),(4,'v_public_privileges','UPDATE'),(5,'','UPDATE'),(5,'payment','DELETE'),(5,'payment','INSERT'),(5,'payment','SELECT'),(5,'payment','UPDATE'),(5,'payment01','DELETE'),(5,'payment01','INSERT'),(5,'payment01','SELECT'),(5,'payment01','UPDATE');
/*!40000 ALTER TABLE `phpgen_user_perms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `phpgen_users`
--

DROP TABLE IF EXISTS `phpgen_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `phpgen_users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(500) DEFAULT NULL,
  `user_password` varchar(128) DEFAULT NULL,
  `sales_department_id` int(11) DEFAULT NULL,
  `is_head_manager` int(11) DEFAULT NULL,
  `is_blocked` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`user_id`),
  KEY `fk_users_sales_department` (`sales_department_id`),
  CONSTRAINT `fk_users_sales_department` FOREIGN KEY (`sales_department_id`) REFERENCES `sales_department` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `phpgen_users`
--

LOCK TABLES `phpgen_users` WRITE;
/*!40000 ALTER TABLE `phpgen_users` DISABLE KEYS */;
INSERT INTO `phpgen_users` VALUES (1,'admin','c7ad44cbad762a5da0a452f9e854fdc1e0e7a52a38015f23f3eab1d80b931dd472634dfac71cd34ebc35d16ab7fb8a90c81f975113d6c7538dc69dd8de9077ec',NULL,NULL,0),(2,'page_admin','3fcbeb4fb1b88bc3c4bab385f23c8c16d338c99b0d380bed65aa19cd4498cd11f8834cee8fae70de6c5871598c0269bbebb9cdd2384a3f206f484a18fed00061',NULL,NULL,0),(3,'mike','a91d24d7eab7683bc73b857d42dfc48a9577c600ccb5e7d7adabab54eebc112232f3de2539208f22a560ad320d1f2cda5a5f1a127baf6bf871b0e282c2b85220',1,0,0),(4,'john','b7fcc6e612145267d2ffea04be754a34128c1ed8133a09bfbbabd6afe6327688aa71d47343dd36e719f35f30fa79aec540e91b81c214fddfe0bedd53370df46d',1,0,0),(5,'gloria','47cb016fc371a44dda83f884ae03798d2a2cd258a365e4af573c6faa70e9ee9abb75590a3b01a4ab48c50ea630ab17b53018ee045b144f40a8b1e41ebe9404c5',1,1,0),(6,'redirected_user','8744c83d0fba57dfed6e269fdda1aa98e03506eff0a37f68396f96295a35c7e20988d9932be808a9c001ccc4aa336c609c693ad83e53b93ca845767e7ebf0fcf',NULL,NULL,0),(7,'jack','77c62ff676394d2e1962c6f7be65ea23b5650a3e69359b4337f9dc4ea6165afec4787529e690708b1a8c9fb89fe105c151838a9ea235f7b1763982f6256f5b92',2,1,0),(8,'david','a917d01789b58dfd3a702c715496269886f5d363d7445f42ee7b963e9de2a1da7dfbf0b88248ca648e69927353c0a76aaccd1d9b2ef1e32a7fe18ca3710f8929',2,0,0),(9,'lisa','f13b7762550dd9df698fbd960475185551ef43c605cdbac9a3af401ddef35b52507fd95ddf09c5edfb7782ef8c3420ea274774d31f1aff6ff92c0c1731964252',2,0,0),(10,'blocked_user','b8fd3633bbb7dfe9981040323ccd1b460e52d794e1ffe13cd55f24d5a0a50eee3ba045d017a3d0116ffcbd53607edeb0609f09c18fc55e7a5e5bb89a4df8ca3a',NULL,NULL,1);
/*!40000 ALTER TABLE `phpgen_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_membership`
--

DROP TABLE IF EXISTS `role_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_membership` (
  `role_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`role_id`,`user_id`),
  KEY `fk_membership_user` (`user_id`),
  CONSTRAINT `fk_membership_role` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`),
  CONSTRAINT `fk_membership_user` FOREIGN KEY (`user_id`) REFERENCES `phpgen_users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_membership`
--

LOCK TABLES `role_membership` WRITE;
/*!40000 ALTER TABLE `role_membership` DISABLE KEYS */;
INSERT INTO `role_membership` VALUES (1,3),(3,3),(1,4),(2,4),(1,5),(3,7),(2,8),(2,9),(3,9);
/*!40000 ALTER TABLE `role_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_permissions`
--

DROP TABLE IF EXISTS `role_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_permissions` (
  `role_id` int(11) NOT NULL,
  `page_name` varchar(255) NOT NULL,
  `allow_view` tinyint(1) DEFAULT '0',
  `allow_add` tinyint(1) DEFAULT '0',
  `allow_edit` tinyint(1) DEFAULT '0',
  `allow_delete` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`role_id`,`page_name`),
  KEY `fk_role_permssions_role` (`role_id`),
  CONSTRAINT `fk_permissions_roles` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_permissions`
--

LOCK TABLES `role_permissions` WRITE;
/*!40000 ALTER TABLE `role_permissions` DISABLE KEYS */;
INSERT INTO `role_permissions` VALUES (1,'v_advanced_custom_page_permissions_2',1,1,1,1),(2,'v_advanced_custom_page_permissions_2',1,1,0,0),(3,'v_advanced_custom_page_permissions_2',1,0,0,0);
/*!40000 ALTER TABLE `role_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Sales'),(2,'Marketing'),(3,'Finance');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_department`
--

DROP TABLE IF EXISTS `sales_department`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_department`
--

LOCK TABLES `sales_department` WRITE;
/*!40000 ALTER TABLE `sales_department` DISABLE KEYS */;
INSERT INTO `sales_department` VALUES (1,'Eastern Region Sales'),(2,'Western Region Sales');
/*!40000 ALTER TABLE `sales_department` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonial`
--

DROP TABLE IF EXISTS `testimonial`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `testimonial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) NOT NULL,
  `message` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonial`
--

LOCK TABLES `testimonial` WRITE;
/*!40000 ALTER TABLE `testimonial` DISABLE KEYS */;
INSERT INTO `testimonial` VALUES (1,'Giuseppe Maxia','We are constantly testing everything related to MySQL world and MySQL Maestro is, so far, the best tool we have tried.'),(2,'Andrew Maclean','I am really quite impressed with the software. You and your people are doing a wonderful job. I actually have spent a while researching PostgreSQL admin/code generators and yours seems to fit our needs nicely. Your interface is beautiful.'),(3,'Piter Jason','I wanted to take this opportunity to thank SQL Maestro Group for providing me the tools to succeed. I have no doubt that without them I would have failed to do my job. I am proud that I have suceeded. Thank you.');
/*!40000 ALTER TABLE `testimonial` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Temporary table structure for view `v_admin_panel`
--

DROP TABLE IF EXISTS `v_admin_panel`;
/*!50001 DROP VIEW IF EXISTS `v_admin_panel`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `v_admin_panel` AS SELECT 
 1 AS `id`,
 1 AS `name`,
 1 AS `address`,
 1 AS `zip_code`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary table structure for view `v_advanced_after_login`
--

DROP TABLE IF EXISTS `v_advanced_after_login`;
/*!50001 DROP VIEW IF EXISTS `v_advanced_after_login`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `v_advanced_after_login` AS SELECT 
 1 AS `id`,
 1 AS `name`,
 1 AS `address`,
 1 AS `zip_code`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary table structure for view `v_advanced_custom_page_permissions_1`
--

DROP TABLE IF EXISTS `v_advanced_custom_page_permissions_1`;
/*!50001 DROP VIEW IF EXISTS `v_advanced_custom_page_permissions_1`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `v_advanced_custom_page_permissions_1` AS SELECT 
 1 AS `id`,
 1 AS `customer_id`,
 1 AS `amount`,
 1 AS `payment_date`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary table structure for view `v_advanced_custom_page_permissions_2`
--

DROP TABLE IF EXISTS `v_advanced_custom_page_permissions_2`;
/*!50001 DROP VIEW IF EXISTS `v_advanced_custom_page_permissions_2`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `v_advanced_custom_page_permissions_2` AS SELECT 
 1 AS `id`,
 1 AS `customer_id`,
 1 AS `amount`,
 1 AS `payment_date`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary table structure for view `v_advanced_custom_record_permissions`
--

DROP TABLE IF EXISTS `v_advanced_custom_record_permissions`;
/*!50001 DROP VIEW IF EXISTS `v_advanced_custom_record_permissions`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `v_advanced_custom_record_permissions` AS SELECT 
 1 AS `id`,
 1 AS `manager_id`,
 1 AS `customer_id`,
 1 AS `amount`,
 1 AS `sale_date`,
 1 AS `completed`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary table structure for view `v_public_privileges`
--

DROP TABLE IF EXISTS `v_public_privileges`;
/*!50001 DROP VIEW IF EXISTS `v_public_privileges`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `v_public_privileges` AS SELECT 
 1 AS `id`,
 1 AS `name`,
 1 AS `district`,
 1 AS `postal_code`*/;
SET character_set_client = @saved_cs_client;

--
-- Final view structure for view `v_admin_panel`
--

/*!50001 DROP VIEW IF EXISTS `v_admin_panel`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50001 VIEW `v_admin_panel` AS select `customer`.`id` AS `id`,`customer`.`name` AS `name`,`customer`.`address` AS `address`,`customer`.`zip_code` AS `zip_code` from `customer` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_advanced_after_login`
--

/*!50001 DROP VIEW IF EXISTS `v_advanced_after_login`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = latin1 */;
/*!50001 SET character_set_results     = latin1 */;
/*!50001 SET collation_connection      = latin1_swedish_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50001 VIEW `v_advanced_after_login` AS select `customer`.`id` AS `id`,`customer`.`name` AS `name`,`customer`.`address` AS `address`,`customer`.`zip_code` AS `zip_code` from `customer` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_advanced_custom_page_permissions_1`
--

/*!50001 DROP VIEW IF EXISTS `v_advanced_custom_page_permissions_1`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50001 VIEW `v_advanced_custom_page_permissions_1` AS select `payment`.`id` AS `id`,`payment`.`customer_id` AS `customer_id`,`payment`.`amount` AS `amount`,`payment`.`payment_date` AS `payment_date` from `payment` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_advanced_custom_page_permissions_2`
--

/*!50001 DROP VIEW IF EXISTS `v_advanced_custom_page_permissions_2`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50001 VIEW `v_advanced_custom_page_permissions_2` AS select `payment`.`id` AS `id`,`payment`.`customer_id` AS `customer_id`,`payment`.`amount` AS `amount`,`payment`.`payment_date` AS `payment_date` from `payment` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_advanced_custom_record_permissions`
--

/*!50001 DROP VIEW IF EXISTS `v_advanced_custom_record_permissions`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50001 VIEW `v_advanced_custom_record_permissions` AS select `payment`.`id` AS `id`,`payment`.`manager_id` AS `manager_id`,`payment`.`customer_id` AS `customer_id`,`payment`.`amount` AS `amount`,`payment`.`payment_date` AS `sale_date`,`payment`.`completed` AS `completed` from `payment` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_public_privileges`
--

/*!50001 DROP VIEW IF EXISTS `v_public_privileges`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50001 VIEW `v_public_privileges` AS select `address`.`id` AS `id`,`address`.`name` AS `name`,`address`.`district` AS `district`,`address`.`postal_code` AS `postal_code` from `address` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2022-10-12 10:18:26
