<?php

function fillPrivileges(IPermissionSet $privileges, &$resultPrivileges, $privilegeLevel) {
    if (!array_key_exists('select', $resultPrivileges) && $privileges->hasViewGrant()) {
        $resultPrivileges['select'] = $privilegeLevel;
    }
    if (!array_key_exists('update', $resultPrivileges) && $privileges->HasEditGrant()) {
        $resultPrivileges['update'] = $privilegeLevel;
    }
    if (!array_key_exists('delete', $resultPrivileges) && $privileges->hasDeleteGrant()) {
        $resultPrivileges['delete'] = $privilegeLevel;
    }
    if (!array_key_exists('insert', $resultPrivileges) && $privileges->hasAddGrant()) {
        $resultPrivileges['insert'] = $privilegeLevel;
    }
    if (!array_key_exists('admin', $resultPrivileges) && $privileges->HasAdminGrant()) {
        $resultPrivileges['admin'] = $privilegeLevel;
    }
}

function getUserPrivileges($userName, $dataSourceName) {
    $result = array();
    $tableBasedGrantManager = CreateGrantManager();

    $securityInfo = $tableBasedGrantManager->RetrieveSecurityInfo($userName, false);

    if (!empty($securityInfo[$dataSourceName])) {
        $privilegeLevel = 'Page level (directly to the user)';
        $privileges = $securityInfo[$dataSourceName];
        fillPrivileges($privileges, $result, $privilegeLevel);
    }
    if (!empty($securityInfo[""])) {
        $privilegeLevel = 'Application level (directly to the user)';
        $privileges = $securityInfo[""];
        fillPrivileges($privileges, $result, $privilegeLevel);
    }

    $securityInfo = $tableBasedGrantManager->RetrieveSecurityInfo('');

    if (!empty($securityInfo[$dataSourceName])) {
        $privilegeLevel = 'Page level (inherited from PUBLIC)';
        $privileges = $securityInfo[$dataSourceName];
        fillPrivileges($privileges, $result, $privilegeLevel);
    }
    if (!empty($securityInfo[""])) {
        $privilegeLevel = 'Application level (inherited from PUBLIC)';
        $privileges = $securityInfo[""];
        fillPrivileges($privileges, $result, $privilegeLevel);
    }

    return $result;
}

function getUserPrivilegesHTML($userName, $dataSourceName) {
    $userPrivileges = getUserPrivileges($userName, $dataSourceName);

    if (array_key_exists('admin', $userPrivileges)) {
        return '<p>Current user <span class="identifier">' . $userName . '</span> has the ADMIN privilege for this page granted at the ' . $userPrivileges['admin'] .'. He can read, change, and delete all the records of the page as well as add the new records and <a href="phpgen_admin.php">manage the page access permissions</a>.</p>';
    }

    $smarty = new Smarty();
    $smarty->assign('user_name', $userName);
    $smarty->assign('user_privileges', $userPrivileges);
    $smarty->template_dir = 'components/templates/custom_templates';
    $html = $smarty->fetch('user_privileges.tpl');

    return $html;
}

function getOnAfterLoginEventCode() {
    $loginFileName = 'login.php';
    if (!file_exists($loginFileName)) {
        return '';
    }

    $code = file_get_contents($loginFileName);
    $posBegin = strpos($code, 'function OnAfterLogin');
    $posEnd = strpos($code, 'OnAfterFailedLoginAttempt');
    if ($posBegin === false || $posEnd === false) {
        return '';
    }

    $code = substr($code, $posBegin, $posEnd - $posBegin);
    $posEnd = strrpos($code, '}');
    if ($posEnd === false) {
        return '';
    }

    $code = substr($code, 0, $posEnd + 1);
    return '<pre><code class="php">' . htmlspecialchars($code) . '</code></pre>';
}

function getCustomPagePermissionsPagesDescription($descriptionFileName, $sqlFileName) {
    $targetDir = 'external_data/doc/';
    $smarty = new Smarty();
    $smarty->assign('Contents', '<pre><code class="sql hljs">' . file_get_contents($targetDir . $sqlFileName) . '</code></pre>');
    $smarty->template_dir = $targetDir;
    $html = $smarty->fetch($descriptionFileName);

    return $html;
}

function getCustomPagePermissions1PageDescription() {
    return getCustomPagePermissionsPagesDescription('custom_page_permissions1.tpl', 'custom_page_permissions1_table_definitions.txt');
}

function getCustomPagePermissions1Code() {
    return '<pre><code class="php">' . file_get_contents('external_data/doc/custom_page_permissions1_code.php') . '</code></pre>';
}

function getCustomPagePermissions2PageDescription() {
    return getCustomPagePermissionsPagesDescription('custom_page_permissions2.tpl', 'custom_page_permissions2_table_definitions.txt');
}

function getCustomPagePermissions2Code() {
    return '<pre><code class="php">' . file_get_contents('external_data/doc/custom_page_permissions2_code.php') . '</code></pre>';
}
