function CustomizePagePermissions($pageName, $userId, $userName, $connection, &$permissions)
{
    if (GetApplication()->IsLoggedInAsAdmin()) {
        return;
    }

    // retrieving permissions for roles the current user belongs to
    $sql =
        "SELECT" .
        "  rp.allow_view," .
        "  rp.allow_add," .
        "  rp.allow_edit," .
        "  rp.allow_delete " .
        "FROM role_permissions rp " .
        "WHERE " .
        "rp.role_id IN " .
        "(SELECT role_id " .
        "FROM role_membership " .
        "WHERE user_id = %d) " .
        "AND rp.page_name = '%s'";

    $result = $connection->fetchAll(sprintf($sql, $userId, $pageName));

    if (empty($result)) {
        return;
    }

    $permissions->setGrants(false, false, false, false);

    foreach ($result as $row) {
        //permissions are calculated as sum of permissions granted to the roles current user belongs to
        $permissions->setViewGrant($permissions->HasViewGrant() || ($row['allow_view'] > 0));
        $permissions->setAddGrant($permissions->HasAddGrant() || ($row['allow_add'] > 0));
        $permissions->setEditGrant($permissions->HasEditGrant() || ($row['allow_edit'] > 0));
        $permissions->setDeleteGrant($permissions->HasDeleteGrant() || ($row['allow_delete'] > 0));
    }
}
