function CustomizePagePermissions($pageName, $userId, $userName, $connection, &$permissions)
{
    // do not apply these rules for site admins
    if (GetApplication()->IsLoggedInAsAdmin()) {
        return;
    }

    // retrieving user roles
    $sql =
        "SELECT r.role_name " .
        "FROM role_membership rm " .
        "INNER JOIN roles r ON r.id = rm.role_id " .
        "WHERE rm.user_id = %d";
    $result = $connection->fetchAll(sprintf($sql, $userId));

    if (empty($result)) {
        return;
    }

    $permissions->setGrants(false, false, false, false);

    // iterating through retrieved roles
    foreach ($result as $row) {
        if ($row['role_name'] === 'Sales') {
            $permissions->setGrants(true, true, true, true);
            break;
        } else if ($row['role_name'] === 'Marketing') {
            $permissions->setViewGrant(true);
            $permissions->setAddGrant(true);
        } else if ($row['role_name'] === 'Finance') {
           $permissions->setViewGrant(true);
        }
    }
}
