<p>
    This and the <a href="advanced_custom_page_permissions_2.php">next</a> example learns how to implement a role-based permission model in your application
    with the <a href="http://www.sqlmaestro.com/products/mysql/phpgenerator/help/01_03_04_36_on_get_custom_page_permissions/" target="_blank">OnGetCustomPagePermissions</a> event.
    Such models can simplify the permission management as permissions are granted to a role (group of users) rather than to individual users.
    Any user included into a role automatically gets the permissions that are assigned to the role.
</p>
<p>
    For this purpose we created two tables:
    <span class="identifier">Roles</span> (to store roles) and
    <span class="identifier">Role Membership</span> (to store links between roles and members (users)).
    Click the area below to see the SQL definitions of these tables.
</p>
{include file="../../components/templates/custom_templates/spoiler.tpl" Title='Table definitions'}
<p>
    Assume each user in our application may belong to one or multiple roles.
    Our goal is to provide access to this page according to the following rules:
</p>
<ul>
    <li>Site admins and members of the <span class="identifier">Sales</span> role must have full access to the records.
    <li>Members of the <span class="identifier">Marketing</span> role can only view existing records and add new ones.
    <li>Members of the <span class="identifier">Finance</span> role can only view existing records.
    <li>If some member belongs to multiple roles then effective permissions for him must be calculated as sum of permissions granted to all the roles he belongs to.</li>
</ul>
{include file="role_membership.html"}
<p>
    Click any link in the table above to see the page under the corresponding user. Click the
    <span><i class="icon-question"></i></span> button to see the <a href="#" class="detailed-description">event handler code</a>.
</p>
