<div class="well pgui-login">

    <p class="text-center"><img class="pgui-login-avatar" src="components/assets/img/login_avatar.png" alt="User avatar" /></p>

    {if !is_null($SecurityFeedbackPositive)}
    <div class="alert alert-success">
        <button data-dismiss="alert" class="close" type="button">&times;</button>
        {$SecurityFeedbackPositive}
    </div>
    {/if}
    {if !is_null($SecurityFeedbackNegative)}
    <div class="alert alert-danger">
        <button data-dismiss="alert" class="close" type="button">&times;</button>
        {$SecurityFeedbackNegative}
    </div>
    {/if}

    <form method="post">
        <div class="form-group">
            <input placeholder="{$Captions->GetMessageString('Username')}" type="text" name="username" class="form-control" id="username">
        </div>

        <div class="form-group">
            <input placeholder="{$Captions->GetMessageString('Password')}" type="password" name="password" class="form-control" id="password">
        </div>

        {if $ReCaptcha && $ReCaptcha->isCheckboxCaptcha()}
            <div class="form-group">
                <div class="g-recaptcha" data-sitekey="{$ReCaptcha->getSiteKey()}"{if $ReCaptcha->getUseDarkColorTheme()} data-theme="dark"{/if}></div>
            </div>
        {/if}

        <div class="form-group">
            <div class="checkbox">
                <label>
                    <input type="checkbox" name="saveidentity" id="saveidentity" {if $LoginControl->GetLastSaveidentity()} checked="checked"{/if}>
                    {$Captions->GetMessageString('RememberMe')}
                </label>
            </div>
        </div>

        {if $LoginControl->GetErrorMessage() != '' }
            <div class="alert alert-danger">
                {$LoginControl->GetErrorMessage()}
            </div>
        {/if}

        <div class="form-group text-center">
            {* <Custom template> *}
            <div class="btn-group">
                <button class="btn btn-primary" type="submit">{$Captions->GetMessageString('Login')}</button>
                <button class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                    <span class="caret"></span>
                </button>

                <ul class="dropdown-menu">
                    <li><a class="login-as" href="#" data-username="admin" data-password="admin">Login as admin</a></li>
                    <li><a class="login-as" href="#" data-username="page_admin" data-password="page_admin">Login as page_admin</a></li>
                    <li><a class="login-as" href="#" data-username="john" data-password="john">Login as john</a></li>
                    <li><a class="login-as" href="#" data-username="mike" data-password="mike">Login as mike</a></li>
                    <li><a class="login-as" href="#" data-username="gloria" data-password="gloria">Login as gloria</a></li>
                    <li><a class="login-as" href="#" data-username="redirected_user" data-password="redirected_user">Login as redirected_user</a></li>
                    <li><a class="login-as" href="#" data-username="blocked_user" data-password="blocked_user">Login as blocked_user</a></li>
                </ul>
            </div>
            {* </Custom template> *}

            {if $LoginControl->CanLoginAsGuest()}
                &nbsp;<a href="{$LoginControl->GetLoginAsGuestLink()|escapeurl}" class="btn btn-default">{$Captions->GetMessageString('LoginAsGuest')}</a>
            {/if}
        </div>

    </form>

    {if $LoginControl->getEmailBasedFeaturesEnabled()}
    <div class="pgui-login-footer">
        {if $LoginControl->getRecoveringPasswordEnabled()}
            <p class="text-center">
                {$Captions->GetMessageString('ForgotPassword')}
            </p>
        {/if}
        {if $LoginControl->getSelfRegistrationEnabled()}
            <p class="text-center">
                {$Captions->GetMessageString('RegisterHere')}
            </p>
            <p class="text-center">
                {$Captions->GetMessageString('ResendVerificationEmailHere')}
            </p>
        {/if}
    </div>
    {/if}

</div>