<?php

function extractTemplateFileCode($fileName) {
    $body = file_get_contents($fileName);
    return '<pre><code class="tpl">' . htmlspecialchars($body) . '</code></pre>';
}

function extractMethodCode($object, $methodName) {
    $method = new ReflectionMethod($object, $methodName);
    $filename = $method->getFileName();
    $start_line = $method->getStartLine() - 1; // it's actually - 1, otherwise you wont get the function() block
    $end_line = $method->getEndLine();
    $length = $end_line - $start_line;
    $source = file($filename);
    $body = implode("", array_slice($source, $start_line, $length));
    return '<pre><code class="php">' . htmlspecialchars($body) . '</code></pre>';
}


function extractClientEventCode(Page $page, $events) {
    $grid = $page->getGrid();
    $listings = array();

    if (is_scalar($events)) {
        $events = array($events);
    }

    foreach ($events as $event) {
        $body = '';
        switch ($event) {
            case 'OnBeforePageLoad':
                $body = $page->GetCustomClientScript();
                break;
            case 'OnAfterPageLoad':
                $body = $page->GetOnPageLoadedClientScript();
                break;
            case 'OnInsertFormValidate':
                $body = $grid->GetInsertClientValidationScript();
                break;
            case 'OnEditFormValidate':
                $body = $grid->GetEditClientValidationScript();
                break;
            case 'OnInsertFormEditorValueChanged':
                $body = $grid->GetInsertClientEditorValueChangedScript();
                break;
            case 'OnEditFormEditorValueChanged':
                $body = $grid->GetEditClientEditorValueChangedScript();
                break;
            case 'OnInsertFormLoaded':
                $body = $grid->GetInsertClientFormLoadedScript();
                break;
            case 'OnEditFormLoaded':
                $body = $grid->GetEditClientFormLoadedScript();
                break;
            default:
                exit("code_extractor.php: unknown client event $event");
        }

        $listings[$event] = $body;
    }

    $result = '<br>';
    foreach ($listings as $event => $listing) {
        $result .= sprintf(
            "<p><pre><code class=\"js\">// %s event body\n %s</code></pre></p>",
            $event,
            htmlspecialchars($listing)
        );
    }

    return $result;
}

function extractFunctionCode($functionName) {
    $func = new ReflectionFunction($functionName);
    $fileName = $func->getFileName();
    $source = file($fileName);
    $startLine = $func->getStartLine() - 1;
    $endLine = $func->getEndLine();
    $length = $endLine - $startLine;

    $body =  implode("", array_slice($source, $startLine, $length));
    return '<pre><code class="php">' . htmlspecialchars($body) . '</code></pre>';
}
