<?php

include_once 'external_libs/geshi/geshi.php';
include_once 'external_libs/SQLFormatter/SqlFormatter.php';

function formatAndHighlightCode($textToHighlight, &$highlightedText, &$handled)
{
    $language = 'mysql';
    $formatted_sql = SqlFormatter::format($textToHighlight, false);
    $geshi = new GeSHi($formatted_sql, $language);
    $highlightedText =
        '<div align="left">'.$geshi->parse_code().'</div>';
    $handled = true;
}

function applyDatasetFilter(Dataset $dataset) {
    if (GetApplication()->IsGETValueSet('database'))
        $value = GetApplication()->GetGETValue('database');
    else
        $value = ArrayUtils::GetArrayValueDef($_COOKIE, 'database');
    if (StringUtils::IsNullOrEmpty($value)) {
        $globalConnectionOptions = GetGlobalConnectionOptions();
        $value = $globalConnectionOptions['database'];
    }
    if (!StringUtils::IsNullOrEmpty($value)) {
        $dataset->AddFieldFilter('Database_name', new FieldFilter($value, '='));
        setcookie('database', $value);
    }
}