-- MySQL dump 10.13  Distrib 5.7.28, for Win64 (x86_64)
--
-- Host: altair    Database: nba_demo
-- ------------------------------------------------------
-- Server version	5.6.10-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `arena`
--

DROP TABLE IF EXISTS `arena`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arena` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `caption` varchar(50) NOT NULL,
  `lat` decimal(9,6) NOT NULL,
  `lng` decimal(9,6) NOT NULL,
  `logo` varchar(100) NOT NULL,
  `about` text NOT NULL,
  `photo` varchar(100) NOT NULL,
  `capacity` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arena`
--

LOCK TABLES `arena` WRITE;
/*!40000 ALTER TABLE `arena` DISABLE KEYS */;
INSERT INTO `arena` VALUES (1,'TD Garden',42.366303,-71.062228,'nba_images/arenas/td_garden_logo.png','<strong>TD Garden</strong> is the home arena for the Boston Bruins of the National Hockey League and Boston Celtics of the National Basketball Association. It is owned by Delaware North, whose CEO, Jeremy Jacobs, also owns the Bruins. It is the site of the annual Beanpot college hockey tournament, and hosts the annual Hockey East Championships. The arena has also hosted many major national sporting events including the 1999 and 2003 NCAA Division I Men&#39;s Basketball regional first and second rounds, the 2009 and 2012 Sweet Sixteen and Elite Eight, the 1998 Frozen Four, the 2004 Frozen Four, the 2014 United States Figure Skating Championships, the 2006 Women&#39;s Final Four, and the 2015 Frozen Four.','nba_images/arenas/td_garden_photo.jpg',17565),(2,'Quicken Loans Arena',41.496389,-81.688056,'nba_images/arenas/the_q_arena_logo.png','<strong>Quicken Loans</strong> Arena, commonly known as &quot;The Q&quot;, is a multi-purpose arena in downtown Cleveland, Ohio, United States. The building is the home of the Cleveland Cavaliers of the National Basketball Association (NBA), the Lake Erie Monsters of the American Hockey League (AHL), and the Cleveland Gladiators of the Arena Football League (AFL). It also serves as a secondary arena for Cleveland State Vikings men&#39;s and women&#39;s basketball.','nba_images/arenas/the_q_arena_photo.jpg',20562),(3,'Philips Arena',33.757222,-84.396389,'nba_images/arenas/philips_arena_logo.png','<strong>Philips Arena</strong> is home to the Atlanta Hawks, of the National Basketball Association, and the Atlanta Dream, of the Women&#39;s National Basketball Association. It also served as home to the National Hockey League&#39;s Atlanta Thrashers from 1999-2011, before the team moved to Winnipeg. It is owned by the Atlanta Fulton County Recreation Authority and operated by Atlanta Spirit, LLC, the group of investors that also owns the Hawks.','nba_images/arenas/philips_arena_photo.jpg',18238),(4,'Time Warner Cable Arena',35.225000,-80.839167,'nba_images/arenas/twarena_logo.jpg','<strong>Time Warner Cable Arena</strong> (originally Charlotte Bobcats Arena and commonly The Hive, Time Warner Arena, or The Cable Box), is an entertainment and sports venue, located in center city Charlotte, North Carolina. It is owned by the city of Charlotte, and operated by the Charlotte Hornets of the NBA. It made its grand opening in October 2005 as the Charlotte Bobcats Arena, with a concert by the Rolling Stones and hosted its first Bobcats game on November 5, 2005. The arena&#39;s current center-hung video screen, known as &quot;Hornets TV&quot;, measures 16 feet by 28 feet and features a wraparound mural of uptown Charlotte.','nba_images/arenas/twcarena_photo.jpg',20200),(5,'Barclays Center',40.682661,-73.975225,'nba_images/arenas/barclays_center_logo.png','<strong>Barclays Center</strong> is a multi-purpose indoor arena in Brooklyn, New York City. It sits partially on a platform over the Metropolitan Transportation Authority (MTA)-owned Vanderbilt Yards rail yard at Atlantic Avenue for the Long Island Rail Road (LIRR). It is part of a $4.9 billion future business and residential complex now known as Pacific Park.','nba_images/arenas/barclays_center_photo.jpg',18103),(6,'Madison Square Garden',40.750556,-73.993611,'nba_images/arenas/madison_square_garden_logo.png','<strong>Madison Square Garden</strong> (often called MSG or simply The Garden) is a multi-purpose indoor arena in the New York City borough of Manhattan, New York. Located in Midtown Manhattan between 7th and 8th Avenues from 31st to 33rd Streets, it is situated atop Pennsylvania Station. It is the fourth venue to bear the name &quot;Madison Square Garden&quot;, the first two (1879 and 1890) of which were located on Madison Square, on East 26th Street and Madison Avenue, with the third Madison Square Garden further uptown at Eighth Avenue and 50th Street. The Garden is used for professional basketball and ice hockey, as well as boxing, concerts, ice shows, circuses, professional wrestling and other forms of sports and entertainment. It is close to other midtown Manhattan landmarks, including the Empire State Building, Koreatown, and Macy&#39;s at Herald Square. It is home to the New York Rangers of the National Hockey League, the New York Knicks of the National Basketball Association, and residency to singer-songwriter Billy Joel.','nba_images/arenas/madison_square_garden_photo.jpg',18200),(7,'Wells Fargo Center',39.901111,-75.171944,'nba_images/arenas/wells_fargo_center_logo.png','<strong>The Wells Fargo Center</strong> (Spectrum II (prior to construction), formerly the CoreStates Center, First Union Center and Wachovia Center is a multi-purpose indoor arena located in Philadelphia, Pennsylvania. It is the home arena of the Philadelphia Flyers of the National Hockey League, the Philadelphia 76ers of the National Basketball Association, and the Philadelphia Soul of the Arena Football League. The Wells Fargo Center was completed in 1996 to replace the Spectrum as the home arena of the Flyers and 76ers, on the former site of John F. Kennedy Stadium (originally Philadelphia Municipal Stadium) at a cost of $210 million, largely privately financed (though the city and state helped to pay for the local infrastructure). It is owned by Comcast Spectacor, which also owns the Flyers, and is operated by its arena-management subsidiary, Global Spectrum.','nba_images/arenas/wells_fargo_center_photo.jpg',19500),(8,'United Center',41.880556,-87.674167,'nba_images/arenas/united_center_logo.png','<strong>United Center</strong>&nbsp;is an indoor sports arena located in the Near West Side neighborhood of Chicago, Illinois. The United Center is home to both the Chicago Bulls of the National Basketball Association (NBA) and the Chicago Blackhawks of the National Hockey League (NHL). The arena is named after its city-based corporate sponsor, United Airlines.\r\n<p></p>\r\n<p>The plan to build the arena was created by then Blackhawks owner Bill Wirtz and Bulls owner Jerry Reinsdorf. The United Center&#39;s predecessor was the Chicago Stadium, the original &quot;Madhouse on Madison&quot;, which was demolished after the new arena opened for business on August 18, 1994. The first ever event at the United Center was the WWF event SummerSlam (1994). Due to the 1994&ndash;95 NHL lockout, the Blackhawks did not move in until January 1995.</p>\r\n\r\n<p>The east side of the stadium features statues of Michael Jordan (known as &quot;The Spirit&quot;), Bobby Hull and Stan Mikita, while a statue of various Blackhawks sits to the north on Madison Street, where the Chicago Stadium was located.</p>\r\n\r\n<p>Despite being merged with Continental Airlines in May 2010, the original United Airlines logo and United name still remain with the arena. United Airlines pays about $1.8 million per year until 2014 for its naming rights.</p>\r\n','nba_images/arenas/united_center_photo.jpg',20500),(9,'Staples Center',34.043056,-118.267222,'nba_images/arenas/staples_center_logo.png','<strong>Staples Center</strong>&nbsp;is a multi-purpose&nbsp;sports arena in Downtown Los Angeles. Adjacent to the L.A. Live development, it is located next to the Los Angeles Convention Center complex along Figueroa Street. Opening on October 17, 1999, it is one of the major sporting facilities in the Greater Los Angeles Area.</p>\r\n\r\n<p>It is owned and operated by the L.A. Arena Company and Anschutz Entertainment Group. The arena is home to the Los Angeles Lakers and the Los Angeles Clippers of the National Basketball Association (NBA), the Los Angeles Kings of the National Hockey League (NHL), and the Los Angeles Sparks of the Women&#39;s National Basketball Association (WNBA). The Los Angeles Avengers of the Arena Football League (AFL) and the Los Angeles D-Fenders of the NBA D-League were also tenants; the Avengers were folded in 2009, and the D-Fenders moved to the Lakers&#39; practice facility at the Toyota Sports Center in El Segundo, California for the 2011&ndash;12 season.[6] Staples Center is also host to over 250 events and nearly 4 million guests each year.[7] It is the only arena in the NBA shared by two teams, as well as one of only two North American professional sports venues to host two teams from the same league; MetLife Stadium, the home of the National Football League&#39;s New York Giants and New York Jets, is the other','nba_images/arenas/staples_center_photo.jpg',18118),(10,'Moda Center',45.531667,-122.666667,'nba_images/arenas/moda_center_logo.png','<strong>Moda Center</strong>, formerly known as the&nbsp;<strong>Rose Garden</strong>, is the primary indoor sports arena in Portland, Oregon, United States. It is suitable for large indoor events of all sorts, including basketball, ice hockey, rodeos, circuses, conventions, ice shows, concerts, and dramatic productions. The arena has a capacity of 19,441 spectators when configured for basketball, fewer for other events. The arena is equipped with state-of-the-art acoustics and other amenities.\r\n\r\nIt is owned by Vulcan Inc., a holding company owned by Paul Allen, and is currently managed by Anschutz Entertainment Group and AEG Live. The primary tenant is the Portland Trail Blazers NBA franchise, also owned by Allen. The other major tenant of the building today is the major junior hockey franchise Portland Winterhawks of the Western Hockey League, which splits its schedule with the Memorial Coliseum next door. In addition to the Blazers and Winterhawks, several other professional sports franchises, and the Portland State University men&#39;s basketball team, either currently play home games in Moda Center, or have done so in the past. In addition, Moda Center is a popular venue for concerts and other artistic productions.</p>\r\n\r\n<p>Construction began in 1993, and the arena opened on October 12, 1995. The arena cost US$262 million to build; construction was financed with funds obtained by a variety of sources, including the City of Portland, Allen&#39;s personal fortune, and $155 million in bonds issued by a consortium of mutual funds and insurance companies. These bonds would become the subject of an acrimonious 2004 bankruptcy in which the Oregon Arena Corporation, the holding company which owned the arena at the time, would forfeit title to the arena in lieu of repaying the bonds per the payment terms. Allen would later repurchase the arena from the creditors in 2007.\r\n','nba_images/arenas/moda_center_photo.jpg',19980),(11,'Air Canada Centre',43.643333,-79.379167,'nba_images/arenas/air_canada_centre_logo.png','<strong>Air Canada Centre (ACC)</strong>&nbsp;is a multi-purpose indoor sporting arena located on Bay Street in the South Core district of Downtown Toronto, Ontario, Canada. It is the home of the Toronto Maple Leafs of the National Hockey League (NHL), the Toronto Raptors of the National Basketball Association (NBA) and the Toronto Rock of the National Lacrosse League (NLL). In addition, the Toronto Marlies of the American Hockey League play occasional games at the arena, and the Raptors 905 of the NBA Development League plan to play occasional games at the venue as well. The area was previously home to the Toronto Phantoms of the Arena Football League (AFL) during their brief existence. The arena is popularly known as the ACC or the Hangar (the latter nickname came from its sponsorship by Air Canada).</p>\r\n\r\n<p>The arena is owned and operated by Maple Leaf Sports &amp; Entertainment Ltd. (MLSE), the same group that owns both the Leafs and Raptors, as well as their respective development teams, and is 665,000 square feet (61,800 square metres) in size. In 2008, the ACC was the fifth busiest arena in the world and the busiest in Canada. Air Canada Centre is connected to Union Station and the underground pedestrian PATH system, providing access to public transportation (TTC&#39;s Union subway station and GO Transit). There are also 13,000 parking spaces.\r\n\r\nThe Air Canada Centre has, from its initial design to completion, revolutionized many concepts included in new arenas and stadiums built since then. These features include luxury suites accessible on the ground floor, splitting the main scoreboard into several sections, rotating all sponsor signage in the bowl at once (to allow dominant messaging), and multiple restaurants in and out of the main arena bowl view.','nba_images/arenas/acc_photo.jpg',19800),(12,'Amway Center',28.539167,-81.383611,'nba_images/arenas/amway_center_logo.png','<strong>Amway Center</strong>&nbsp;is a sports and entertainment venue in Orlando, Florida, located in the Downtown area. It is part of Downtown Orlando Master Plan 3: a plan that also involves improvements to the Citrus Bowl and a new performing arts center. The arena is home to the Orlando Magic of the NBA, the Orlando Predators of the Arena Football League, theOrlando Solar Bears of the ECHL, and hosted the 2012 NBA All-Star Game, plus the 2015 ECHL All-Star Game.\r\nAmway Center hosted the second and third round games of the NCAA Division I Men&rsquo;s Basketball Tournament in 2014. On January 14, 2013, the Arena Football League&#39;s Board of Directors voted to award ArenaBowl XXVI to Orlando in the summer of 2013. It hosted UFC on Fox: dos Anjos vs. Cerrone 2 on December 19, 2015, and will hold the 2016 Royal Rumble on January 24.','nba_images/arenas/amway_center_photo.jpg',20000),(13,'Verizon Center',38.898056,-77.020833,'nba_images/arenas/verision_center_logo.png','<strong>Verizon Center</strong>, formerly known as the MCI Center, is a sports and entertainment arena in Washington, D.C.\r\n\r\nNamed after its sponsor, the telecommunications company Verizon Communications, the Verizon Center has been nicknamed the &quot;Phone Booth&quot; by local fans, because of its historical association with various telecommunications companies, such as MCI Inc. and Verizon. Located in the Chinatown neighborhood of Washington, D.C., the Verizon Center sits atop the Gallery Place rapid transit station of the Washington Metro.','nba_images/arenas/verizon_center_photo.jpg',18277),(14,'American Airlines Arena',25.781389,-80.188056,'nba_images/arenas/aaa_logo.jpg','<strong>American Airlines Arena</strong>&nbsp;is a sports and entertainment arena located in Downtown Miami, Florida along Biscayne Bay. It was constructed beginning in 1998 as a replacement for the Miami Arena and was designed by the architecture firms Arquitectonica and 360 Architecture. The Arena is home to the Miami Heat of the National Basketball Association.\r\n\r\nThe AmericanAirlines Arena is directly served by the Miami Metrorail at Government Center station via free transfers to Metromover Omni Loop, providing direct service toFreedom Tower and Park West stations. The Arena is also within walking distance from the Historic Overtown/Lyric Theatre Metrorail station.</p>\r\n\r\n<p>The AmericanAirlines Arena has 2,105 club seats, 80 luxury suites, and 76 private boxes. The Waterfront Theater is Florida&#39;s largest theater which is housed within the arena, that can seat between 3,000 and 5,800. The theater can be configured for concerts, family events, musical theatre and other stage shows. American Airlines which has a hub at Miami International Airport maintains the AmericanAirlines Arena Travel Center at the venue.\r\n\r\nThe airline also holds the naming rights for another NBA venue, the American Airlines Center for the Dallas Mavericks, which opened in 2001. AmericanAirlines Center should not be confused with AmericanAirlines Arena.\r\n','nba_images/arenas/aaa_photo.jpg',19600),(15,'The Palace of Auburn Hills',42.696944,-83.245556,'nba_images/arenas/the_palace_of_auburn_hills_logo.png','<strong>The Palace of Auburn Hills</strong>&nbsp;(commonly referred to as&nbsp;<strong>The Palace</strong>) is a sports and entertainment venue in the Detroit suburb of Auburn Hills, Michigan. The arena opened in 1988 and is the home of the Detroit Pistons of the National Basketball Association (NBA). It was the home of the Detroit Shock of the Women&#39;s National Basketball Association (WNBA), the Detroit Vipers of the International Hockey League, the Detroit Safari of the Continental Indoor Soccer League, and the Detroit Fury of the Arena Football League.','nba_images/arenas/palace_auburn_hills_photo.jpg',24276),(16,'Bankers Life Fieldhouse',39.763889,-86.155556,'nba_images/arenas/bankers_life_fieldhouse_logo.jpg','<strong>Bankers Life Fieldhouse</strong>&nbsp;is an indoor arena located in downtown Indianapolis, Indiana, USA. It is the home of the Indiana Pacers of the National Basketball Association and theIndiana Fever of the Women&#39;s National Basketball Association. The Fieldhouse also hosts college basketball games (including the annual Big Ten Conference tournaments), indoor concerts, and ice hockey.\r\n\r\nThe arena opened in November 1999 as Conseco Fieldhouse to replace Market Square Arena. The naming rights to the venue were sold to Conseco, a financial services organization based in nearby Carmel, Indiana. In May 2010, the company renamed itself as CNO Financial Group, but the Conseco name was retained by the Fieldhouse. In December 2011, CNO Financial Group changed the name of the Fieldhouse to Bankers Life Fieldhouse, after one of its subsidiaries, Bankers Life and Casualty.\r\n\r\nUnlike other multipurpose arenas, the arena was designed primarily for basketball. Nevertheless, the arena can accommodate an NHL-sized rink, but the seating capacity would be reduced to 12,300 for ice hockey, as the seating arrangement is asymmetrical. Many of the seats on one end of the arena have obstructed views, which results in poor sightlines for ice hockey\r\n','nba_images/arenas/bankers_life_fieldhouse_photo.jpg',18165),(17,'Target Center',44.979444,-93.276111,'nba_images/arenas/target_center_logo.png','<strong>Target Center</strong>&nbsp;is a multi-purpose arena located in downtown Minneapolis, Minnesota. Target Center hosts major family shows, concerts, sporting events, graduations and private events. Target Corporation is the original and current naming rights partner of the arena. It contains 702 club seats and 68 suites.\r\n\r\nThe center is home to the NBA&#39;s Minnesota Timberwolves, the WNBA&#39;s Minnesota Lynx. The facility has also hosted the LFL&#39;s Minnesota Valkyrie, the RHI&#39;s Minnesota Arctic Blast and the Arena Football League&#39;s Minnesota Fighting Pike in the past.\r\n','nba_images/arenas/target_center_photo.jpg',19356),(18,'Chesapeake Energy Arena',35.463333,-97.515000,'nba_images/arenas/chesapeake_energy_arena_logo.png','<strong>Chesapeake Energy Arena</strong>, originally known as the&nbsp;Ford Center&nbsp;from 2002 to 2010 and&nbsp;<strong>Oklahoma City Arena</strong>&nbsp;until 2011, is an arena located in downtown Oklahoma City,Oklahoma, United States. It opened in 2002 and since 2008 has served as the home venue of the Oklahoma City Thunder of the National Basketball Association (NBA). Previously, Chesapeake Energy Arena was home to the Oklahoma City Blazers of the Central Hockey League (CHL) from 2002 until the team folded in July 2009, and the Oklahoma City Yard Dawgz of AF2 from 2004 to 2009 when the team moved to the Cox Convention Center. In addition to its use as a sports venue, Chesapeake Energy Arena hosts concerts, family and social events, conventions, ice shows, and civic events. The arena is owned by the city and operated by the SMG property management company and has 18,203 seats in the basketball configuration, 18,036 for hockey, and can seat up to 19,711 for concerts.\r\n\r\nFrom 2005 to 2007 the arena also served as the temporary home for the New Orleans Hornets of the NBA when the Hornets were forced to play games elsewhere following extensive damage to New Orleans Arena and the city of New Orleans from Hurricane Katrina. During the two seasons in Oklahoma City, the team was known as the New Orleans/Oklahoma City Hornets. The response from fans while the Hornets played in Oklahoma City was an impetus to the city being discussed prior to 2008 as a future NBA team, either by relocationor expansion.\r\n','nba_images/arenas/chesapeake_energy_arena_photo.jpg',18203),(19,'Sleep Train Arena',38.649167,-121.518056,'nba_images/arenas/sleep_train_arena_logo.jpg','<strong>Sleep Train Arena</strong>, originally ARCO Arena and later Power Balance Pavilion, is an indoor arena located in Sacramento, California, United States. Opened in 1988, it is the home of the Sacramento Kings of the National Basketball Association (NBA). The arena is named for The Sleep Train, a chain of mattress and bed retailers based in Rocklin, California.','nba_images/arenas/sleep_train_arena_photo.jpg',17317),(20,'AT&T Center',29.426944,-98.437500,'nba_images/arenas/att_center_logo.jpg','<strong>AT&amp;T Center</strong>&nbsp;is a multi-purpose indoor arena on the east side of San Antonio, Texas, USA. It seats 18,418 for basketball, 16,151 for ice hockey, and 19,000 for concerts or gatherings, and contains 2,018 club seats, 50 luxury suites and 32 bathrooms.\r\n\r\nThe arena was completed in 2002, as the SBC Center, at a cost of $175 million, financed by county-issued bonds, which were supported by a hotel-occupancy and car-rental tax increase and an additional contribution of $28.5 million from the Spurs. SBC Communications, Inc., purchased the naming rights to the facility under a 20-year, $41 million naming rights agreement with Bexar County, the San Antonio Spurs, and the San Antonio Stock Show &amp; Rodeo in July 2000. SBC Communications changed its name to AT&amp;T Inc. in November 2005. The arena officially changed its name to AT&amp;T Center in January 2006.</p>\r\n\r\n<p>The Professional Rodeo Cowboys Association holds the San Antonio Stock Show &amp; Rodeo and an Xtreme Bulls tour event annually there. The Rodeo is held in February, necessitating the Spurs to make a long road trip during this time (commonly referred to as the &quot;Rodeo Road Trip&quot;).\r\n\r\nOn the weekend of August 1&ndash;2, 2009, the Professional Bull Riders hosted a Built Ford Tough Series event there (an event previously held at the Alamodome in 2007 and 2008).\r\n\r\nIn addition to many local community and sporting events, the center hosts San Antonio Sports Car Association autocross competitions in the parking lot each month.\r\n','nba_images/arenas/att_center_photo.jpg',18581),(21,'Talking Stick Resort Arena',33.445833,-112.071389,'nba_images/arenas/talking_stick_resort_arena_logo.jpg','<strong>Talking Stick Resort Arena</strong>&nbsp;(formerly America West Arena and US Airways Center) is a sports and entertainment arena in downtown Phoenix, Arizona. It opened on June 6, 1992, at a construction cost of $89 million.\r\n\r\nIt is home to the Phoenix Suns of the National Basketball Association (NBA), the Phoenix Mercury of the Women&#39;s National Basketball Association (WNBA) and the Arena Football League&#39;s Arizona Rattlers. The ECHL&#39;s Phoenix RoadRunners played at the arena from their inaugural 2005&ndash;06 season until they ceased operations at the conclusion of the 2008&ndash;09 season.\r\n\r\nLocated near Chase Field (the Arizona Diamondbacks&#39; home ballpark), the arena is one million square feet in size on an 11-acre site. These two major league sports venues are half of those used by Phoenix area professional teams, the other two being University of Phoenix Stadium and Gila River Arena (formerly Jobing.com Arena) in the neighboring Phoenix suburb of Glendale.\r\n\r\nRenovations were completed in March 2003, which feature a 16,000-square-foot air-conditioned glass-enclosed atrium built on the northwest side of the arena, to keep patrons cool while waiting in line for tickets or spending time inside the building before events. The total cost was estimated at around $67 million. The upgrading of US Airways Center was done as part of the Phoenix Suns&#39; plan to keep it economically competitive after Jobing.com Arena opened. Former Suns owner Jerry Colangelo originally thought of the renovations after visiting Staples Center in Los Angeles and envisioned a similar entertainment district in Phoenix.\r\n\r\nThe arena also features the Verve Lounge, a high-class exclusive bar lounge.','nba_images/arenas/talking_stick_resort_arena_photo.jpg',18422),(22,'Toyota Center',29.750833,-95.362222,'nba_images/arenas/toyota_center_logo.png','<strong>Toyota Center</strong>&nbsp;is an indoor arena located in downtown Houston, Texas. It is named after the Japanese automobile manufacturer Toyota. The arena is home to the Houston Rockets of the National Basketball Association, the principal users of the building, and the former home of the Houston Aeros of the American Hockey League.\r\n\r\nRockets owner Leslie Alexander first began to request a new arena in 1995, and attempted to release the Rockets from their lease at The Summit, which ran until 2003. However, he was denied by arena owner Chuck Watson, then-owner of the Aeros, who also wanted control of a new arena. The two sides agreed to equal control over an arena in a deal signed in 1997, but the proposal was rejected by city voters in a 1999 referendum. It was not until the city and the Rockets signed an amended agreement in 2001, excluding the Aeros, that the proposal was accepted.\r\n\r\n<p>Construction began in July 2001, and the new arena was officially opened in October 2003. The total costs were $235 million, with the city of Houston paying the majority, and the Rockets paying for enhancements. Toyota paid $100 million for the naming rights.</p>\r\n','nba_images/arenas/toyota_center_photo.jpg',18043),(23,'Vivint Smart Home Arena',40.768333,-111.901111,'nba_images/arenas/vivint_smart_home_arena_logo.jpg','<strong>Vivint Smart Home Arena</strong>&nbsp;is an indoor arena located in Salt Lake City, Utah, United States. The building is owned by Jazz Basketball Investors, Inc., the estate of Larry H. Miller. The arena is the home of the Utah Jazz of the National Basketball Association (NBA) and has been the home venue for other professional athletic teams such as the Utah Blaze of the Arena Football League and the Utah Starzz of the Women&#39;s National Basketball Association (WNBA). It seats 19,911 for basketball, has 56 luxury suites, and 668 club seats.\r\n\r\nOpened in 1991, the arena was known as the Delta Center, under a naming rights deal with Delta Air Lines which has a hub at Salt Lake City International Airport. Salt Lake City-based EnergySolutions purchased the naming rights in November 2006, after Delta decided not to renew their 15-year contract due to filing for Chapter 11 bankruptcy the year prior. From 2006 to 2015 it was known as EnergySolutions Arena. On October 26, 2015, the arena was renamed as part of a 10-year naming rights contract with the Provo, Utah-based home security system provider Vivint.\r\n\r\nThe arena was also home to the figure skating and short track speed skating competitions of the 2002 Winter Olympics, where it was referred to as the Salt Lake Ice Center.\r\n','nba_images/arenas/energy_solutions_arena_photo.jpg',19911),(24,'FedEx Forum',35.138333,-90.050556,'nba_images/arenas/fed_ex_forum_logo.png','<strong>FedExForum</strong>&nbsp;is an arena located in downtown Memphis, Tennessee. It is the home of the Memphis Grizzlies of the NBA and the NCAA Division I men&#39;s basketball program of theUniversity of Memphis, both of whom previously played home games at the Pyramid Arena. The arena officially opened in September 2004 after much debate and also a derechowind storm on July 22, 2003 that nearly brought down the cranes that were building it near the famed Beale Street. It was built at a cost of $250 million and is owned by the City of Memphis; naming rights were purchased by one of Memphis&#39; most well-known businesses, FedEx, for $92 million. FedExForum was financed using $250 million of public bonds, which were issued by the Memphis Public Building Authority (PBA). The venue also has the capability of hosting ice hockey games, concerts, and family shows.','nba_images/arenas/fed_exf_forum_photo.jpg',18119),(25,'Pepsi Center',39.748611,-105.007500,'nba_images/arenas/pepsi_center_logo.png','<strong>Pepsi Center</strong>&nbsp;is an American multi-purpose arena located in Denver, Colorado. The arena is home to the Denver Nuggets of the National Basketball Association (NBA), the Colorado Avalanche of the National Hockey League (NHL), and the Colorado Mammoth of the National Lacrosse League. When not in use by one of Denver&#39;s sports teams, the building frequently serves as a concert venue.','nba_images/arenas/pepsi_center_photo.jpg',18007),(26,'Oracle Arena',37.750278,-122.203056,'nba_images/arenas/oracle_arena_logo.png','<strong>Oracle Arena</strong>&nbsp;(originally&nbsp;<strong>Oakland-Alameda County Coliseum Arena</strong>, formerly&nbsp;<strong>The Arena in Oakland</strong>&nbsp;and&nbsp;<strong>Oakland Arena</strong>&nbsp;and commonly&nbsp;<strong>Oakland Coliseum Arena</strong>) is an indoor arena located in Oakland, California. It is the home of the Golden State Warriors.\r\n\r\nIt has a capacity of 19,596, making it the largest of the three NBA arenas in California by capacity, with the Staples Center in Los Angeles (the current home of both the Lakers and Clippers) second, and the Sleep Train Arena in Sacramento third. It is the oldest arena in the NBA.\r\n','nba_images/arenas/oracle_arena_photo.jpg',19596),(27,'Smoothie King Center',29.948889,-90.081944,'nba_images/arenas/smoothie_king_center_logo.jpg','<strong>Smoothie King Center</strong>&nbsp;(originally&nbsp;<strong>New Orleans Arena</strong>) is a multi-purpose indoor arena in New Orleans, Louisiana. It is located in the city&#39;s Central Business District, adjacent to the Mercedes-Benz Superdome.\r\n\r\nIt has been home to the New Orleans Pelicans (formerly the Hornets) of the NBA since 2002.\r\n\r\nStarting in February 2004, the New Orleans VooDoo, of the Arena Football League (AFL), played their home games in the arena until the team disbanded in 2008. The VooDoo resumed play at the arena in March 2011, until after the 2015 AFL season when the franchise folded.\r\n','nba_images/arenas/smoothie_king_center_photo.jpg',18000),(28,'American Airlines Center',32.790556,-96.810278,'nba_images/arenas/american_airlines_center_logo.png','<strong>American Airlines Center</strong>&nbsp;(<strong>AAC</strong>) is a multi-purpose arena, located in the Victory Park neighborhood, near downtown Dallas, Texas.\r\n\r\nThe venue serves as the home to the Dallas Mavericks of the National Basketball Association, and the Dallas Stars of the National Hockey League. The arena is also used for concerts and other live entertainment. It opened in 2001 at a cost of $420 million.\r\n','nba_images/arenas/american_airlines_center_photo.jpg',18500),(29,'BMO Harris Bradley Center',43.043611,-87.916944,'nba_images/arenas/bmo_harris_bradley_center_logo.jpg','<strong>BMO Harris Bradley Center</strong>&nbsp;(originally&nbsp;<strong>Bradley Center</strong>) is an indoor arena located on the northwest corner of North 4th and West State Streets in downtown Milwaukee,Wisconsin.\r\n\r\nIt is home to the Milwaukee Bucks of the NBA, the Marquette University men&#39;s basketball team, and the Milwaukee Admirals of the AHL (and formerly of the IHL). It is also the former home of the Milwaukee Wave of the MISL, from 1988 to 2003, the original Milwaukee Mustangs of the AFL from 1994 to 2001, along with the second incarnation of the team from 2009 to 2012 and the Badger Hockey Showdown from 1989 to 2002.\r\n','nba_images/arenas/bmo_bradley_center_photo.jpg',19000);
/*!40000 ALTER TABLE `arena` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `channel`
--

DROP TABLE IF EXISTS `channel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `channel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `short_caption` varchar(30) NOT NULL,
  `full_caption` text NOT NULL,
  `logo` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `channel`
--

LOCK TABLES `channel` WRITE;
/*!40000 ALTER TABLE `channel` DISABLE KEYS */;
INSERT INTO `channel` VALUES (0,'No national TV translation','There was not national TV translation for this game.','nba_images/channels/nochannel.png'),(1,'TNT','Turner Network Television, Inc.','nba_images/channels/tnt.png'),(2,'ESPN','Entertainment and Sports Programming Network','nba_images/channels/espn.png'),(3,'NBA TV','NBA TV','nba_images/channels/nbatv.png'),(4,'ABC','American Broadcasting Company','nba_images/channels/abc.png');
/*!40000 ALTER TABLE `channel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `college`
--

DROP TABLE IF EXISTS `college`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `college` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `college`
--

LOCK TABLES `college` WRITE;
/*!40000 ALTER TABLE `college` DISABLE KEYS */;
INSERT INTO `college` VALUES (1,'Pepperdine'),(2,'UCLA'),(3,'Michigan State'),(4,'Texas'),(5,'West Virginia'),(6,'Villanova'),(7,'Connecticut'),(8,'Oklahoma State'),(9,'Rice'),(10,'Fresno State'),(11,'Nevada-Las Vegas'),(12,'Blinn Coll. TX (JC)'),(13,'California'),(14,'Syracuse'),(15,'Arizona'),(16,'St. John\'s'),(17,'Kansas'),(18,'South Florida'),(19,'Kentucky'),(20,'South Carolina'),(21,'Northeastern'),(22,'Oregon State'),(23,'Louisiana State'),(24,'Michigan'),(25,'Texas Tech'),(26,'Duke'),(27,'Kansas State'),(28,'Florida International'),(29,'Colorado'),(30,'Maryland'),(31,'Pittsburgh'),(32,'Utah'),(33,'Florida'),(34,'Penn State'),(35,'Georgia Tech'),(36,'Cal State Fullerton'),(37,'Iowa'),(38,'Arkansas'),(39,'Oregon'),(40,'Cal State-Fullerton'),(41,'Texas-San Antonio'),(42,'Clemson'),(43,'La Salle'),(44,'Massachusetts'),(45,'Purdue'),(46,'Memphis'),(47,'Notre Dame'),(48,'Hawaii'),(49,'North Carolina'),(50,'DePaul'),(51,'Hofstra'),(52,'Stanford'),(53,'Temple'),(54,'Ohio State'),(55,'Illinois'),(56,'Seton Hall'),(57,'Mississippi State'),(58,'Bowling Green'),(59,'Auburn'),(60,'Alabama'),(61,'Marquette'),(62,'Arizona State'),(63,'Missouri'),(64,'Rutgers'),(65,'n/a'),(66,'Boston College'),(67,'Wake Forest'),(68,'Wisconsin'),(69,'Arkansas-Little Rock'),(70,'Texas State'),(71,'Colgate'),(72,'Louisville'),(73,'Augsburg'),(74,'New Mexico'),(75,'Providence'),(76,'Indiana'),(77,'Georgetown'),(78,'Detroit Mercy'),(79,'Austin Peay'),(80,'Washington'),(81,'Georgia'),(82,'North Carolina State'),(83,'IUPUI'),(84,'St. Louis'),(85,'Minnesota'),(86,'Jackson State'),(87,'Florida A&M'),(88,'Duquesne'),(89,'Tulane'),(90,'Westchester HS (Los Angeles, CA)'),(91,'Charleston (SC)'),(92,'Houston'),(93,'Miami (Fla.)'),(94,'Texas A&M'),(95,'Central Michigan'),(96,'Creighton'),(97,'Western Kentucky'),(98,'Nebraska'),(99,'UNLV'),(100,'Cincinnati'),(101,'Western Carolina'),(102,'Virginia'),(103,'USC'),(104,'Nevada-Reno'),(105,'George Washington'),(106,'Louisiana Tech'),(107,'Rhode Island'),(108,'Meridian CC (MS)'),(109,'Gonzaga'),(110,'Shaw'),(111,'Oklahoma'),(112,'Santa Clara'),(113,'Saint Joseph\'s'),(114,'Bradley'),(115,'Xavier (Ohio)'),(116,'Utah Valley University'),(117,'Wyoming'),(118,'Delta State'),(119,'Drexel'),(120,'Southern Methodist'),(121,'Tulsa'),(122,'Alabama-Birmingham'),(123,'Murray State'),(124,'Baylor'),(125,'Colorado State'),(126,'Eastern Washington'),(127,'Miami (Ohio)'),(128,'Iowa State'),(129,'Texas Christian'),(130,'Rider'),(131,'Florida State'),(132,'Portland State'),(133,'Virginia Union'),(134,'Tennessee'),(135,'Washington State'),(136,'San Diego State');
/*!40000 ALTER TABLE `college` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conference`
--

DROP TABLE IF EXISTS `conference`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conference` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `caption` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conference`
--

LOCK TABLES `conference` WRITE;
/*!40000 ALTER TABLE `conference` DISABLE KEYS */;
INSERT INTO `conference` VALUES (1,'Eastern'),(2,'Western');
/*!40000 ALTER TABLE `conference` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `country`
--

DROP TABLE IF EXISTS `country`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `country` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `short_name` varchar(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `country`
--

LOCK TABLES `country` WRITE;
/*!40000 ALTER TABLE `country` DISABLE KEYS */;
INSERT INTO `country` VALUES (1,'USA','us'),(2,'France','fr'),(3,'Brazil','br'),(4,'Italy','it'),(5,'Latvia','lv'),(6,'Spain','es'),(7,'Ukraine','ua'),(8,'Argentina','ar'),(9,'Poland','pl'),(10,'I.R. of Iran','ir'),(11,'Lithuania','lt'),(12,'Congo','cg'),(14,'Australia','au'),(15,'Russia','ru'),(16,'Montenegro','me'),(17,'Slovenia','si'),(18,'Germany','de'),(19,'Turkey','tr'),(20,'Georgia','ge'),(22,'China','cn'),(23,'Croatia','hr'),(24,'Canada','ca'),(25,'Great Britain','gb'),(26,'New Zealand','nz'),(27,'Dominican Republic','do'),(28,'Greece','gr'),(29,'Puerto Rico','pr'),(30,'Senegal','sn');
/*!40000 ALTER TABLE `country` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `division`
--

DROP TABLE IF EXISTS `division`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `division` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `caption` char(30) NOT NULL,
  `conference_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_division_conference` (`conference_id`),
  CONSTRAINT `fk_division_conference` FOREIGN KEY (`conference_id`) REFERENCES `conference` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `division`
--

LOCK TABLES `division` WRITE;
/*!40000 ALTER TABLE `division` DISABLE KEYS */;
INSERT INTO `division` VALUES (1,'Atlantic',1),(2,'Central',1),(3,'Southeast',1),(4,'Southwest',2),(5,'Northwest',2),(6,'Pacific',2);
/*!40000 ALTER TABLE `division` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `game`
--

DROP TABLE IF EXISTS `game`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `game` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `game_date` date NOT NULL,
  `home_team_id` int(11) NOT NULL,
  `away_team_id` int(11) NOT NULL,
  `channel_id` int(11) NOT NULL DEFAULT '0',
  `round_id` int(11) NOT NULL DEFAULT '0',
  `game_number` int(11) NOT NULL DEFAULT '0',
  `season_id` int(11) NOT NULL,
  `recap` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_game_date_home_away_teams` (`game_date`,`home_team_id`,`away_team_id`),
  KEY `fk_game_away_team` (`away_team_id`),
  KEY `fk_game_channel` (`channel_id`),
  KEY `fk_game_home_team` (`home_team_id`),
  KEY `fk_game_round` (`round_id`),
  KEY `fk_game_season` (`season_id`),
  CONSTRAINT `fk_game_away_team` FOREIGN KEY (`away_team_id`) REFERENCES `team` (`id`),
  CONSTRAINT `fk_game_channel` FOREIGN KEY (`channel_id`) REFERENCES `channel` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_game_home_team` FOREIGN KEY (`home_team_id`) REFERENCES `team` (`id`),
  CONSTRAINT `fk_game_round` FOREIGN KEY (`round_id`) REFERENCES `round` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_game_season` FOREIGN KEY (`season_id`) REFERENCES `season` (`year`)
) ENGINE=InnoDB AUTO_INCREMENT=2639 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `game`
--

LOCK TABLES `game` WRITE;
/*!40000 ALTER TABLE `game` DISABLE KEYS */;
INSERT INTO `game` VALUES (1320,'2013-10-29',16,10,0,0,0,2013,'https://youtube.com/watch?v=DJ1ve2Td_s0'),(1321,'2013-10-29',14,3,1,0,0,2013,'https://youtube.com/watch?v=MV7tQLR06h0'),(1322,'2013-10-29',5,28,1,0,0,2013,'https://youtube.com/watch?v=aeHFxndkox8'),(1323,'2013-10-30',30,11,0,0,0,2013,'https://youtube.com/watch?v=T0auBzaUcxw'),(1324,'2013-10-30',2,13,3,0,0,2013,'https://youtube.com/watch?v=rGG-jcY3n0o'),(1325,'2013-10-30',9,1,0,0,0,2013,'https://youtube.com/watch?v=b6BiCA3QPco'),(1326,'2013-10-30',22,29,0,0,0,2013,'https://youtube.com/watch?v=Ty18GP5tceM'),(1327,'2013-10-30',19,25,0,0,0,2013,'https://youtube.com/watch?v=ag2OrEUxlpE'),(1328,'2013-10-30',27,16,0,0,0,2013,'https://youtube.com/watch?v=0Rb8zuWMZtE'),(1329,'2013-10-30',26,5,3,0,0,2013,'https://youtube.com/watch?v=oTuxYtHlvhM'),(1330,'2013-10-30',20,24,0,0,0,2013,'https://youtube.com/watch?v=FWTZ47OcHPM'),(1331,'2013-10-30',8,14,0,0,0,2013,'https://youtube.com/watch?v=MEB1R5SFHSw'),(1332,'2013-10-30',7,4,0,0,0,2013,'https://youtube.com/watch?v=Wm50NAMFpY4'),(1333,'2013-10-30',23,18,0,0,0,2013,'https://youtube.com/watch?v=wP3UR3gIlGs'),(1334,'2013-10-30',17,10,0,0,0,2013,'https://youtube.com/watch?v=UOBEk9AOTN0'),(1335,'2013-10-30',21,6,0,0,0,2013,'https://youtube.com/watch?v=zKiq6BR-ucY'),(1336,'2013-10-30',15,12,0,0,0,2013,'https://youtube.com/watch?v=P9fOVd43VYE'),(1337,'2013-10-31',28,26,1,0,0,2013,'https://youtube.com/watch?v=3K2vLMH-LYs'),(1338,'2013-10-31',3,7,1,0,0,2013,'https://www.youtube.com/watch?v=ZAHAj7ACSEo'),(1339,'2013-11-01',29,2,0,0,0,2013,'https://youtube.com/watch?v=i7qBErQ-FhU'),(1340,'2013-11-01',22,30,0,0,0,2013,'https://youtube.com/watch?v=W4SD5Dy6QY8'),(1341,'2013-11-01',24,15,0,0,0,2013,NULL),(1342,'2013-11-01',19,28,0,0,0,2013,'https://youtube.com/watch?v=Hx1WDL5o0_Y'),(1343,'2013-11-01',13,14,2,0,0,2013,'https://youtube.com/watch?v=BEJbAg2GHMM'),(1344,'2013-11-01',1,4,0,0,0,2013,NULL),(1345,'2013-11-01',10,27,0,0,0,2013,'https://youtube.com/watch?v=ktjOlF5Nuy8'),(1346,'2013-11-01',17,18,0,0,0,2013,'https://youtube.com/watch?v=LA3SJ44lqzg'),(1347,'2013-11-01',12,8,0,0,0,2013,'https://youtube.com/watch?v=VcKXJo5UKr0'),(1348,'2013-11-01',25,6,0,0,0,2013,'https://youtube.com/watch?v=Z8B7V8Diacg'),(1349,'2013-11-01',5,20,2,0,0,2013,'https://youtube.com/watch?v=95A3crc6DLI'),(1350,'2013-11-01',11,9,0,0,0,2013,'https://youtube.com/watch?v=MVss-UK_a1o'),(1351,'2013-11-01',21,23,0,0,0,2013,'https://youtube.com/watch?v=YzDXOYvAEvc'),(1352,'2013-11-02',27,29,0,0,0,2013,'https://youtube.com/watch?v=RuvNKlWMqsA'),(1353,'2013-11-02',8,3,3,0,0,2013,'https://youtube.com/watch?v=-UXTRX3PiGs'),(1354,'2013-11-02',16,2,0,0,0,2013,'https://youtube.com/watch?v=JmFDVCqDVj8'),(1355,'2013-11-02',23,22,0,0,0,2013,'https://youtube.com/watch?v=475w45IaLE8'),(1356,'2013-11-02',30,24,0,0,0,2013,'https://youtube.com/watch?v=UOI-iJcGt1s'),(1357,'2013-11-02',6,20,0,0,0,2013,'https://youtube.com/watch?v=4xdZNioZk44'),(1358,'2013-11-02',26,19,0,0,0,2013,'https://youtube.com/watch?v=cNfphNB_CrM'),(1359,'2013-11-02',4,9,0,0,0,2013,'https://youtube.com/watch?v=K0RJbNsBUbY'),(1360,'2013-11-03',5,11,0,0,0,2013,'https://youtube.com/watch?v=UQLwzH5tcd0'),(1361,'2013-11-03',10,13,0,0,0,2013,'https://youtube.com/watch?v=bF042-CwJuU'),(1362,'2013-11-03',15,1,0,0,0,2013,'https://youtube.com/watch?v=UkE5-HGxKUE'),(1363,'2013-11-03',7,17,0,0,0,2013,'https://youtube.com/watch?v=p-SW-hNqcBI'),(1364,'2013-11-03',18,21,3,0,0,2013,'https://www.youtube.com/watch?v=8SKzSaSL1zM'),(1365,'2013-11-03',14,12,0,0,0,2013,'https://youtube.com/watch?v=9JMpTcdnGRg'),(1366,'2013-11-04',24,1,0,0,0,2013,'https://www.youtube.com/watch?v=-f_pqczagQ0'),(1367,'2013-11-04',8,26,0,0,0,2013,'https://youtube.com/watch?v=73zm2OGHBzs'),(1368,'2013-11-04',28,22,3,0,0,2013,'https://youtube.com/watch?v=T7w81vec-r0'),(1369,'2013-11-04',2,17,0,0,0,2013,'https://youtube.com/watch?v=hRyITUntoDg'),(1370,'2013-11-05',19,11,0,0,0,2013,'https://youtube.com/watch?v=rrch0IagULc'),(1371,'2013-11-05',7,29,0,0,0,2013,NULL),(1372,'2013-11-05',6,22,0,0,0,2013,'https://youtube.com/watch?v=oP6KDQhKAVg'),(1373,'2013-11-05',15,16,0,0,0,2013,'https://youtube.com/watch?v=1deTaNwgHJY'),(1374,'2013-11-05',30,5,0,0,0,2013,'https://youtube.com/watch?v=Dj--Y4iknUs'),(1375,'2013-11-05',9,14,0,0,0,2013,'https://youtube.com/watch?v=ihMslGWSC4Q'),(1376,'2013-11-05',27,21,0,0,0,2013,'https://youtube.com/watch?v=TM3w2H2y3vU'),(1377,'2013-11-05',25,20,0,0,0,2013,'https://youtube.com/watch?v=lkOdTgQq59o'),(1378,'2013-11-05',13,23,0,0,0,2013,'https://youtube.com/watch?v=Vl2irzhX3UU'),(1379,'2013-11-06',16,3,2,0,0,2013,'https://youtube.com/watch?v=LdXDpSYTgWI'),(1380,'2013-11-06',4,2,0,0,0,2013,'https://youtube.com/watch?v=EUaIcKg7Xjk'),(1381,'2013-11-06',18,30,2,0,0,2013,'https://youtube.com/watch?v=Zb6Xc4akLQU'),(1382,'2013-11-06',17,26,0,0,0,2013,NULL),(1383,'2013-11-06',10,28,0,0,0,2013,'https://youtube.com/watch?v=bDi9UY5qNJs'),(1384,'2013-11-06',24,27,0,0,0,2013,'https://youtube.com/watch?v=xOHsytA77HQ'),(1385,'2013-11-06',20,21,0,0,0,2013,'https://youtube.com/watch?v=xcwa8Bi0pA4'),(1386,'2013-11-06',29,9,0,0,0,2013,'https://www.youtube.com/watch?v=iXsQgSmiPrI'),(1387,'2013-11-06',1,23,0,0,0,2013,'https://youtube.com/watch?v=FA3U572lZPk'),(1388,'2013-11-06',8,12,0,0,0,2013,'https://youtube.com/watch?v=du2mGenANXI'),(1389,'2013-11-07',25,11,0,0,0,2013,'https://youtube.com/watch?v=5x1YNOzf5sc'),(1390,'2013-11-07',14,28,1,0,0,2013,'https://youtube.com/watch?v=ZW4p7B-hBfY'),(1391,'2013-11-07',22,5,1,0,0,2013,'https://youtube.com/watch?v=4K_HbHMBxag'),(1392,'2013-11-08',12,13,0,0,0,2013,'https://youtube.com/watch?v=prmHyOZbd_M'),(1393,'2013-11-08',10,1,0,0,0,2013,'https://youtube.com/watch?v=2FXx-cefn3U'),(1394,'2013-11-08',8,2,0,0,0,2013,'https://youtube.com/watch?v=-xmSyjIgRFI'),(1395,'2013-11-08',17,30,0,0,0,2013,'https://youtube.com/watch?v=AzL7UT1xwas'),(1396,'2013-11-08',21,25,0,0,0,2013,'https://youtube.com/watch?v=JM9PQV4J0QY'),(1397,'2013-11-08',20,26,0,0,0,2013,'https://youtube.com/watch?v=p67iNiGMIxo'),(1398,'2013-11-08',27,5,0,0,0,2013,'https://youtube.com/watch?v=-SAOJP7rNhg'),(1399,'2013-11-08',29,7,3,0,0,2013,'https://youtube.com/watch?v=UxA5rQ2D0_U'),(1400,'2013-11-08',15,18,0,0,0,2013,'https://youtube.com/watch?v=5VsQh83GPUM'),(1401,'2013-11-08',6,19,3,0,0,2013,'https://youtube.com/watch?v=c20nuv-7Qzs'),(1402,'2013-11-08',16,9,0,0,0,2013,'https://youtube.com/watch?v=FLXhs3EzuZk'),(1403,'2013-11-08',3,23,0,0,0,2013,'https://youtube.com/watch?v=44i2ywLorcI'),(1404,'2013-11-09',14,1,0,0,0,2013,'https://youtube.com/watch?v=Pk5_nojBps8'),(1405,'2013-11-09',4,30,0,0,0,2013,'https://youtube.com/watch?v=cYfA12XHiHI'),(1406,'2013-11-09',24,26,0,0,0,2013,'https://youtube.com/watch?v=L8Rt9uQ4sUY'),(1407,'2013-11-09',13,16,3,0,0,2013,'https://youtube.com/watch?v=B9C3LKE-cHg'),(1408,'2013-11-09',22,28,0,0,0,2013,'https://youtube.com/watch?v=9_5m41bh8g8'),(1409,'2013-11-09',11,10,0,0,0,2013,'https://youtube.com/watch?v=nAKEygro5nQ'),(1410,'2013-11-09',2,8,0,0,0,2013,'https://www.youtube.com/watch?v=VQ0VbJ2DWqU'),(1411,'2013-11-09',19,6,0,0,0,2013,'https://youtube.com/watch?v=QJS9pTS0gaA'),(1412,'2013-11-09',9,23,0,0,0,2013,'https://youtube.com/watch?v=ygnV-IKn6Bk'),(1413,'2013-11-10',5,17,0,0,0,2013,'https://youtube.com/watch?v=HdHQeFizeu8'),(1414,'2013-11-10',21,27,0,0,0,2013,'https://youtube.com/watch?v=TM3w2H2y3vU'),(1415,'2013-11-10',7,20,0,0,0,2013,'https://youtube.com/watch?v=0ldserC6hCk'),(1416,'2013-11-10',18,12,0,0,0,2013,'https://youtube.com/watch?v=O50lfT5tk1A'),(1417,'2013-11-11',29,11,0,0,0,2013,'https://www.youtube.com/watch?v=RqO4yp0daMs'),(1418,'2013-11-11',3,2,0,0,0,2013,'https://youtube.com/watch?v=OJ90r14FJds'),(1419,'2013-11-11',23,25,3,0,0,2013,'https://youtube.com/watch?v=_R9YbKYuSwY'),(1420,'2013-11-11',6,15,0,0,0,2013,'https://youtube.com/watch?v=Lzz-xiROxxs'),(1421,'2013-11-11',16,24,0,0,0,2013,'https://youtube.com/watch?v=sLyLuwHVxiU'),(1422,'2013-11-11',28,17,0,0,0,2013,'https://youtube.com/watch?v=hFZiFQPfawA'),(1423,'2013-11-11',1,10,0,0,0,2013,'https://youtube.com/watch?v=3pYLfio2BmA'),(1424,'2013-11-11',8,20,0,0,0,2013,'https://youtube.com/watch?v=mcwIzmtUe2M'),(1425,'2013-11-11',22,9,0,0,0,2013,'https://youtube.com/watch?v=fvfvdNJPEIs'),(1426,'2013-11-12',26,15,0,0,0,2013,'https://youtube.com/watch?v=jXI6JOh6x5E'),(1427,'2013-11-12',14,4,0,0,0,2013,'https://youtube.com/watch?v=lQV9wk4AsCo'),(1428,'2013-11-12',5,27,0,0,0,2013,'https://youtube.com/watch?v=PfDV75H7Xb8'),(1429,'2013-11-12',30,12,0,0,0,2013,'https://youtube.com/watch?v=06br2ESyQy4'),(1430,'2013-11-13',19,13,0,0,0,2013,'https://youtube.com/watch?v=t91HCcpC2Po'),(1431,'2013-11-13',1,29,0,0,0,2013,'https://youtube.com/watch?v=cQ5YdzFLyFk'),(1432,'2013-11-13',17,2,0,0,0,2013,'https://youtube.com/watch?v=nZWEeILyQTg'),(1433,'2013-11-13',8,22,0,0,0,2013,'https://youtube.com/watch?v=SsZ4in7CNAU'),(1434,'2013-11-13',25,5,0,0,0,2013,'https://youtube.com/watch?v=PvjOqtGza3M'),(1435,'2013-11-13',10,4,0,0,0,2013,'https://youtube.com/watch?v=kFNHXc8ffuc'),(1436,'2013-11-13',23,27,0,0,0,2013,'https://youtube.com/watch?v=3vnp99FlkQk'),(1437,'2013-11-13',11,7,2,0,0,2013,'https://youtube.com/watch?v=B-54A_pZN3Q'),(1438,'2013-11-13',28,18,2,0,0,2013,'https://youtube.com/watch?v=PtHyWBb5oeM'),(1439,'2013-11-13',6,21,0,0,0,2013,'https://youtube.com/watch?v=XSMBhagVIAc'),(1440,'2013-11-13',24,9,0,0,0,2013,'https://youtube.com/watch?v=xYfuQjmr7EE'),(1441,'2013-11-13',20,12,0,0,0,2013,'https://youtube.com/watch?v=fCbiAF67P68'),(1442,'2013-11-14',7,22,1,0,0,2013,'https://youtube.com/watch?v=4n_AqfI-3ew'),(1443,'2013-11-14',26,18,1,0,0,2013,'https://youtube.com/watch?v=5IrDVQxzNjw'),(1444,'2013-11-15',21,13,0,0,0,2013,'https://youtube.com/watch?v=lsBHXHnRWhA'),(1445,'2013-11-15',2,29,0,0,0,2013,'https://youtube.com/watch?v=-Milu58ynGA'),(1446,'2013-11-15',9,3,0,0,0,2013,'https://youtube.com/watch?v=cUXGlbPNTNY'),(1447,'2013-11-15',14,30,0,0,0,2013,'https://youtube.com/watch?v=T-BwrkXCmPQ'),(1448,'2013-11-15',19,15,2,0,0,2013,'https://youtube.com/watch?v=jHFpT1cFxqE'),(1449,'2013-11-15',5,24,0,0,0,2013,'https://youtube.com/watch?v=EoAWmkuM8hU'),(1450,'2013-11-15',16,4,0,0,0,2013,'https://youtube.com/watch?v=LYzIRKTNNx4'),(1451,'2013-11-15',25,17,2,0,0,2013,'https://youtube.com/watch?v=cPrt-IM5rqc'),(1452,'2013-11-15',11,8,0,0,0,2013,'https://youtube.com/watch?v=ylDGigO95Mk'),(1453,'2013-11-15',1,6,0,0,0,2013,'https://youtube.com/watch?v=TjvuY9dfpok'),(1454,'2013-11-15',23,20,0,0,0,2013,'https://youtube.com/watch?v=sbQfb_sSfGY'),(1455,'2013-11-16',7,11,0,0,0,2013,'https://youtube.com/watch?v=nzKUDkx_DJg'),(1456,'2013-11-16',28,13,3,0,0,2013,'https://youtube.com/watch?v=xo_GSKubYOQ'),(1457,'2013-11-16',17,1,0,0,0,2013,'https://youtube.com/watch?v=1MB7eWF2_XM'),(1458,'2013-11-16',12,2,0,0,0,2013,'https://youtube.com/watch?v=dkqrr2zSn4U'),(1459,'2013-11-16',10,30,0,0,0,2013,'https://youtube.com/watch?v=h8k5Ryfz6YY'),(1460,'2013-11-16',22,25,0,0,0,2013,'https://youtube.com/watch?v=hTbl6Yv-YWM'),(1461,'2013-11-16',3,16,0,0,0,2013,'https://youtube.com/watch?v=pD0o-DD9aCY'),(1462,'2013-11-16',29,14,0,0,0,2013,'https://www.youtube.com/watch?v=3Mj_4fEHwyE'),(1463,'2013-11-16',4,18,0,0,0,2013,'https://youtube.com/watch?v=jnYGIDfmOSc'),(1464,'2013-11-16',27,8,0,0,0,2013,'https://youtube.com/watch?v=v9I-aL11UYI'),(1465,'2013-11-16',26,23,0,0,0,2013,'https://youtube.com/watch?v=5YnurkZF-Iw'),(1466,'2013-11-17',5,15,0,0,0,2013,'https://www.youtube.com/watch?v=ng2k_wymnkk'),(1467,'2013-11-17',19,24,0,0,0,2013,'https://youtube.com/watch?v=YvgN8fqrtLA'),(1468,'2013-11-17',9,6,0,0,0,2013,'https://youtube.com/watch?v=If27YqL7ZNw'),(1469,'2013-11-18',3,29,0,0,0,2013,'https://www.youtube.com/watch?v=T8DUjxSZA2M'),(1470,'2013-11-18',18,25,0,0,0,2013,'https://youtube.com/watch?v=hVQxSqHPwqE'),(1471,'2013-11-18',23,26,0,0,0,2013,'https://youtube.com/watch?v=4glgMA8srks'),(1472,'2013-11-18',28,24,0,0,0,2013,'https://youtube.com/watch?v=z5itCzkA82Q'),(1473,'2013-11-18',30,8,0,0,0,2013,'https://youtube.com/watch?v=YDmQhFqLu1w'),(1474,'2013-11-18',13,6,0,0,0,2013,'https://youtube.com/watch?v=GxPGB-7VIvk'),(1475,'2013-11-19',14,11,0,0,0,2013,'https://youtube.com/watch?v=tpLG0YczOnM'),(1476,'2013-11-19',22,1,0,0,0,2013,'https://youtube.com/watch?v=GgV5egqwcYE'),(1477,'2013-11-19',12,17,0,0,0,2013,'https://youtube.com/watch?v=_FjH6cDEZ1w'),(1478,'2013-11-19',15,7,0,0,0,2013,'https://youtube.com/watch?v=wcSsaxo9wdo'),(1479,'2013-11-19',19,21,0,0,0,2013,'https://youtube.com/watch?v=BtJPw5JA4xc'),(1480,'2013-11-20',29,13,0,0,0,2013,'https://youtube.com/watch?v=qFGkfBGwM1M'),(1481,'2013-11-20',20,1,0,0,0,2013,'https://youtube.com/watch?v=gbhmqC1WKkk'),(1482,'2013-11-20',11,15,0,0,0,2013,'https://youtube.com/watch?v=vBIBcJt6cD8'),(1483,'2013-11-20',30,22,2,0,0,2013,'https://youtube.com/watch?v=Tlu-hrpZREo'),(1484,'2013-11-20',7,16,2,0,0,2013,'https://youtube.com/watch?v=9nX35OkgNYA'),(1485,'2013-11-20',17,28,0,0,0,2013,'https://youtube.com/watch?v=_G2M_C-61_M'),(1486,'2013-11-20',26,24,0,0,0,2013,'https://youtube.com/watch?v=d0QM2t3ErpU'),(1487,'2013-11-20',10,14,0,0,0,2013,'https://youtube.com/watch?v=cdiyvTvdHGU'),(1488,'2013-11-20',4,6,0,0,0,2013,'https://youtube.com/watch?v=pjXGztb9MXo'),(1489,'2013-11-20',21,19,0,0,0,2013,'https://youtube.com/watch?v=Yi7TNHkkgDs'),(1490,'2013-11-20',8,9,0,0,0,2013,'https://youtube.com/watch?v=HHEVU5iX_Hc'),(1491,'2013-11-20',27,23,0,0,0,2013,'https://youtube.com/watch?v=RGQL52qDXRo'),(1492,'2013-11-20',2,12,0,0,0,2013,'https://youtube.com/watch?v=fZkhU3VlZTs'),(1493,'2013-11-21',25,3,1,0,0,2013,'https://youtube.com/watch?v=S8iDZajBCss'),(1494,'2013-11-21',18,28,1,0,0,2013,'https://youtube.com/watch?v=JBYUFOOcW4M'),(1495,'2013-11-22',15,11,0,0,0,2013,'https://youtube.com/watch?v=jpD4sTT0yuQ'),(1496,'2013-11-22',17,13,0,0,0,2013,'https://youtube.com/watch?v=7J-441xigwI'),(1497,'2013-11-22',6,3,0,0,0,2013,'https://youtube.com/watch?v=ofzKsobHclA'),(1498,'2013-11-22',27,2,0,0,0,2013,'https://youtube.com/watch?v=5j19l8E6zNY'),(1499,'2013-11-22',5,26,2,0,0,2013,'https://youtube.com/watch?v=VhK5wcFCB2c'),(1500,'2013-11-22',1,16,0,0,0,2013,'https://youtube.com/watch?v=pM0OBAXC4G8'),(1501,'2013-11-22',8,4,0,0,0,2013,'https://youtube.com/watch?v=OVgtYnlxM_Q'),(1502,'2013-11-22',29,21,0,0,0,2013,'https://youtube.com/watch?v=v1IInVPjNIY'),(1503,'2013-11-22',24,20,2,0,0,2013,'https://youtube.com/watch?v=P6-Ijv-vjWc'),(1504,'2013-11-22',30,23,0,0,0,2013,'https://youtube.com/watch?v=gnjtu-o6ASY'),(1505,'2013-11-22',9,12,0,0,0,2013,'https://youtube.com/watch?v=DTxp9GTbjA8'),(1506,'2013-11-23',11,1,0,0,0,2013,'https://youtube.com/watch?v=fRnenmLexjc'),(1507,'2013-11-23',4,29,0,0,0,2013,'https://youtube.com/watch?v=tkCvRq__4ao'),(1508,'2013-11-23',20,2,0,0,0,2013,'https://youtube.com/watch?v=iVhc7RuK_B4'),(1509,'2013-11-23',25,30,3,0,0,2013,'https://youtube.com/watch?v=C0tCchY5hsY'),(1510,'2013-11-23',22,17,0,0,0,2013,'https://youtube.com/watch?v=G6SlAO2-KX4'),(1511,'2013-11-23',12,7,0,0,0,2013,'https://youtube.com/watch?v=G188xCxCEC4'),(1512,'2013-11-23',14,10,0,0,0,2013,'https://youtube.com/watch?v=vs8kVKTwP_s'),(1513,'2013-11-23',16,8,0,0,0,2013,'https://youtube.com/watch?v=Z1YTEU0CQhk'),(1514,'2013-11-23',26,6,0,0,0,2013,'https://youtube.com/watch?v=Lc073G-1CfI'),(1515,'2013-11-23',28,19,0,0,0,2013,'https://youtube.com/watch?v=g3gaeWWVoHY'),(1516,'2013-11-24',28,3,0,0,0,2013,'https://youtube.com/watch?v=Z2gBVNXhOFY'),(1517,'2013-11-24',13,15,0,0,0,2013,'https://youtube.com/watch?v=2jI1FtIJNpM'),(1518,'2013-11-24',10,21,3,0,0,2013,'https://youtube.com/watch?v=ZyhSxFFfdFU'),(1519,'2013-11-24',5,19,0,0,0,2013,'https://youtube.com/watch?v=aV9RKGR5Jq0'),(1520,'2013-11-24',18,23,0,0,0,2013,'https://youtube.com/watch?v=Xx7KJyQXSGY'),(1521,'2013-11-25',29,1,0,0,0,2013,'https://youtube.com/watch?v=M_GWyUPnLaQ'),(1522,'2013-11-25',23,3,3,0,0,2013,'https://youtube.com/watch?v=yx33dBBD1TU'),(1523,'2013-11-25',30,25,0,0,0,2013,'https://www.youtube.com/watch?v=6MyQWh0Sxhw'),(1524,'2013-11-25',24,22,0,0,0,2013,'https://youtube.com/watch?v=0ggKMwvwa4E'),(1525,'2013-11-25',15,4,0,0,0,2013,'https://youtube.com/watch?v=M7SoCHJ81FU'),(1526,'2013-11-25',16,17,0,0,0,2013,'https://youtube.com/watch?v=7dpUJig6UGk'),(1527,'2013-11-25',20,27,0,0,0,2013,'https://youtube.com/watch?v=T5zwXV-2sQk'),(1528,'2013-11-25',6,7,0,0,0,2013,'https://youtube.com/watch?v=Wbbm1fxzu9s'),(1529,'2013-11-25',14,21,0,0,0,2013,'https://youtube.com/watch?v=V3aE7dX2I70'),(1530,'2013-11-26',9,13,0,0,0,2013,'https://youtube.com/watch?v=6zwZ3E7F-88'),(1531,'2013-11-26',27,26,0,0,0,2013,'https://youtube.com/watch?v=bqB7c2-3wiQ'),(1532,'2013-11-26',12,5,0,0,0,2013,'https://youtube.com/watch?v=fspUmpzI5Jc'),(1533,'2013-11-26',11,10,0,0,0,2013,'https://youtube.com/watch?v=jH5vX3dFvj8'),(1534,'2013-11-27',22,11,0,0,0,2013,'https://youtube.com/watch?v=60Nhln1yjsc'),(1535,'2013-11-27',15,3,0,0,0,2013,'https://youtube.com/watch?v=E6T82_oqsno'),(1536,'2013-11-27',17,25,0,0,0,2013,'https://youtube.com/watch?v=-4sInaHzo1U'),(1537,'2013-11-27',30,26,0,0,0,2013,'https://youtube.com/watch?v=v4CUu1nfQ_c'),(1538,'2013-11-27',29,16,0,0,0,2013,'https://www.youtube.com/watch?v=LPrt_8lF4fM'),(1539,'2013-11-27',13,5,0,0,0,2013,'https://youtube.com/watch?v=sKjyB-k4Djo'),(1540,'2013-11-27',1,24,0,0,0,2013,'https://youtube.com/watch?v=QSnp6R3S-ks'),(1541,'2013-11-27',2,14,2,0,0,2013,'https://youtube.com/watch?v=7mhLPcZ87GM'),(1542,'2013-11-27',28,7,3,0,0,2013,'https://youtube.com/watch?v=XA4tX4sfXjY'),(1543,'2013-11-27',10,8,0,0,0,2013,'https://youtube.com/watch?v=P__eCrSgTGA'),(1544,'2013-11-27',21,6,0,0,0,2013,'https://youtube.com/watch?v=Udbbh3TV1Dk'),(1545,'2013-11-27',18,20,0,0,0,2013,'https://youtube.com/watch?v=cCFY3_twXMo'),(1546,'2013-11-27',4,12,0,0,0,2013,'https://youtube.com/watch?v=qbJcFJQd0v0'),(1547,'2013-11-29',22,13,0,0,0,2013,'https://youtube.com/watch?v=LHhKAOiNGLM'),(1548,'2013-11-29',1,2,0,0,0,2013,'https://youtube.com/watch?v=jFtJtSmc28k'),(1549,'2013-11-29',11,30,0,0,0,2013,'https://youtube.com/watch?v=1asjZ7wKxgA'),(1550,'2013-11-29',18,26,3,0,0,2013,'https://youtube.com/watch?v=CufLDa6Jty4'),(1551,'2013-11-29',19,28,0,0,0,2013,'https://youtube.com/watch?v=kP0Hn10vCrQ'),(1552,'2013-11-29',15,5,0,0,0,2013,'https://youtube.com/watch?v=Fr8zpFVBfuw'),(1553,'2013-11-29',9,14,0,0,0,2013,'https://youtube.com/watch?v=SkfQznKRXkQ'),(1554,'2013-11-29',29,4,0,0,0,2013,'https://youtube.com/watch?v=jDWUhuJu80Y'),(1555,'2013-11-29',8,27,0,0,0,2013,'https://youtube.com/watch?v=s-ICk4CHeyk'),(1556,'2013-11-29',25,7,0,0,0,2013,'https://youtube.com/watch?v=uyka5JPivOo'),(1557,'2013-11-29',23,21,0,0,0,2013,'https://youtube.com/watch?v=vLA5_CuLjlU'),(1558,'2013-11-29',10,20,0,0,0,2013,'https://youtube.com/watch?v=i4Qzma8azbM'),(1559,'2013-11-29',16,12,0,0,0,2013,'https://youtube.com/watch?v=NsKSSW0r2nU'),(1560,'2013-11-30',12,11,0,0,0,2013,'https://youtube.com/watch?v=BCYYT-lvE6I'),(1561,'2013-11-30',24,13,3,0,0,2013,'https://youtube.com/watch?v=H16xK-Pqsb0'),(1562,'2013-11-30',4,1,0,0,0,2013,'https://youtube.com/watch?v=M_GWyUPnLaQ'),(1563,'2013-11-30',2,3,0,0,0,2013,'https://youtube.com/watch?v=p1RaFx4O1QI'),(1564,'2013-11-30',20,22,0,0,0,2013,'https://youtube.com/watch?v=HR5sWbeGEN8'),(1565,'2013-11-30',30,17,0,0,0,2013,'https://youtube.com/watch?v=ZNV851yJb1M'),(1566,'2013-11-30',21,23,0,0,0,2013,'https://youtube.com/watch?v=x8lYR5xoHHo'),(1567,'2013-12-01',14,29,0,0,0,2013,'https://www.youtube.com/watch?v=35YZUStNctI'),(1568,'2013-12-01',9,25,0,0,0,2013,'https://youtube.com/watch?v=Ds3gc_xDwE4'),(1569,'2013-12-01',19,26,0,0,0,2013,'https://youtube.com/watch?v=N2ehLIrVoGk'),(1570,'2013-12-01',28,16,0,0,0,2013,'https://youtube.com/watch?v=E8fHyzAXDpc'),(1571,'2013-12-01',18,17,0,0,0,2013,'https://youtube.com/watch?v=BZqUFg_rWo8'),(1572,'2013-12-01',7,27,0,0,0,2013,'https://youtube.com/watch?v=HiJC5UPdMDg'),(1573,'2013-12-01',15,8,0,0,0,2013,'https://youtube.com/watch?v=oGsSIYt9dmw'),(1574,'2013-12-01',5,6,0,0,0,2013,'https://youtube.com/watch?v=UPngy-3GQJo'),(1575,'2013-12-02',20,11,0,0,0,2013,'https://youtube.com/watch?v=leiaTay8RWM'),(1576,'2013-12-02',23,22,0,0,0,2013,'https://youtube.com/watch?v=sMaNE1gvk4o'),(1577,'2013-12-02',6,16,0,0,0,2013,'https://youtube.com/watch?v=AlTxw_Z-QSU'),(1578,'2013-12-02',3,27,0,0,0,2013,'https://youtube.com/watch?v=I84No463KaE'),(1579,'2013-12-02',12,10,3,0,0,2013,'https://youtube.com/watch?v=1E6oCjb3sAQ'),(1580,'2013-12-03',30,29,0,0,0,2013,'https://youtube.com/watch?v=yAXpGk8orJQ'),(1581,'2013-12-03',13,25,0,0,0,2013,'https://youtube.com/watch?v=OV65G80i4Ko'),(1582,'2013-12-03',14,15,0,0,0,2013,'https://youtube.com/watch?v=yPnntr8kkd8'),(1583,'2013-12-03',1,4,0,0,0,2013,'https://youtube.com/watch?v=cRPeMVbr01E'),(1584,'2013-12-03',19,18,0,0,0,2013,'https://youtube.com/watch?v=y36GDb7u5Yg'),(1585,'2013-12-03',8,10,0,0,0,2013,'https://youtube.com/watch?v=Cqw8UiiHL0c'),(1586,'2013-12-03',24,21,0,0,0,2013,'https://youtube.com/watch?v=aDFqV6tlyYk'),(1587,'2013-12-03',26,9,0,0,0,2013,'https://youtube.com/watch?v=a3LKC_BBIV4'),(1588,'2013-12-04',27,30,0,0,0,2013,'https://youtube.com/watch?v=gMBOrgKk0yY'),(1589,'2013-12-04',2,25,0,0,0,2013,'https://youtube.com/watch?v=ZEIUKp_SyB8'),(1590,'2013-12-04',4,15,0,0,0,2013,'https://youtube.com/watch?v=1ROd0nWWGpU'),(1591,'2013-12-04',23,16,0,0,0,2013,'https://youtube.com/watch?v=MXonSxUTYIA'),(1592,'2013-12-04',11,28,0,0,0,2013,'https://youtube.com/watch?v=8QsYcqySFYk'),(1593,'2013-12-04',6,18,0,0,0,2013,'https://youtube.com/watch?v=5tr_dyz2OyM'),(1594,'2013-12-04',22,21,0,0,0,2013,'https://youtube.com/watch?v=0SscqsL2igc'),(1595,'2013-12-05',24,28,0,0,0,2013,'https://youtube.com/watch?v=Y76YgqczZIU'),(1596,'2013-12-05',3,14,1,0,0,2013,'https://youtube.com/watch?v=t9mDicldybM'),(1597,'2013-12-05',13,7,1,0,0,2013,'https://youtube.com/watch?v=SG32VlVpUIk'),(1598,'2013-12-06',11,2,0,0,0,2013,'https://youtube.com/watch?v=zKNMgucp6pw'),(1599,'2013-12-06',1,25,2,0,0,2013,'https://youtube.com/watch?v=nXI2TLOVTnc'),(1600,'2013-12-06',22,26,0,0,0,2013,'https://youtube.com/watch?v=KPSGa84mHd8'),(1601,'2013-12-06',19,5,0,0,0,2013,'https://youtube.com/watch?v=sTjywU4VBdw'),(1602,'2013-12-06',12,4,0,0,0,2013,'https://youtube.com/watch?v=qbEMR4RqkTg'),(1603,'2013-12-06',27,18,0,0,0,2013,'https://youtube.com/watch?v=UmYALov4fWM'),(1604,'2013-12-06',7,10,0,0,0,2013,'https://youtube.com/watch?v=GMFYDNrAsrs'),(1605,'2013-12-06',29,8,0,0,0,2013,'https://youtube.com/watch?v=FjABrIcmNWA'),(1606,'2013-12-06',21,9,0,0,0,2013,'https://youtube.com/watch?v=LksEvGloVGI'),(1607,'2013-12-06',6,23,0,0,0,2013,'https://youtube.com/watch?v=KABFW1bfsCM'),(1608,'2013-12-07',4,13,0,0,0,2013,'https://youtube.com/watch?v=esqqbJV1uXY'),(1609,'2013-12-07',6,30,3,0,0,2013,'https://youtube.com/watch?v=uEDHy4PBWow'),(1610,'2013-12-07',8,25,0,0,0,2013,'https://youtube.com/watch?v=M1sKqPy-4bA'),(1611,'2013-12-07',3,15,0,0,0,2013,'https://youtube.com/watch?v=w8ExCfRTm8c'),(1612,'2013-12-07',24,26,0,0,0,2013,'https://youtube.com/watch?v=wGHbTz-jxHY'),(1613,'2013-12-07',20,16,0,0,0,2013,'https://youtube.com/watch?v=SvDmHqW8ZN8'),(1614,'2013-12-07',2,28,0,0,0,2013,'https://youtube.com/watch?v=rBSzqAwHi0E'),(1615,'2013-12-07',17,14,0,0,0,2013,'https://youtube.com/watch?v=PX2-aYM0AZE'),(1616,'2013-12-07',23,19,0,0,0,2013,'https://youtube.com/watch?v=B4dyXBptU6U'),(1617,'2013-12-08',7,1,0,0,0,2013,'https://youtube.com/watch?v=8SuYGUJB4OE'),(1618,'2013-12-08',18,16,0,0,0,2013,'https://youtube.com/watch?v=VVMM2Tq89rE'),(1619,'2013-12-08',15,14,0,0,0,2013,'https://youtube.com/watch?v=LwCh2wtGY-s'),(1620,'2013-12-08',22,10,0,0,0,2013,'https://youtube.com/watch?v=hIdSjU3taEg'),(1621,'2013-12-08',5,9,0,0,0,2013,'https://youtube.com/watch?v=bRuTYNAum70'),(1622,'2013-12-09',19,30,0,0,0,2013,'https://youtube.com/watch?v=maQlLZIYo_A'),(1623,'2013-12-09',12,25,3,0,0,2013,'https://youtube.com/watch?v=A_ANTiDqCGE'),(1624,'2013-12-09',29,26,0,0,0,2013,'https://www.youtube.com/watch?v=XRpIpNrGnXQ'),(1625,'2013-12-09',8,28,0,0,0,2013,'https://youtube.com/watch?v=VThr5s01tR0'),(1626,'2013-12-09',24,10,0,0,0,2013,'https://www.youtube.com/watch?v=5UIFA0_Pihk'),(1627,'2013-12-09',23,6,0,0,0,2013,'https://youtube.com/watch?v=V5b86JWf3og'),(1628,'2013-12-10',13,1,0,0,0,2013,'https://youtube.com/watch?v=QuPhuHAC_9o'),(1629,'2013-12-10',16,14,0,0,0,2013,'https://youtube.com/watch?v=VOGfxxe-Dr4'),(1630,'2013-12-10',3,4,0,0,0,2013,'https://youtube.com/watch?v=HTY2Fis_04I'),(1631,'2013-12-10',15,17,0,0,0,2013,'https://youtube.com/watch?v=6iQ22344TUM'),(1632,'2013-12-10',2,7,0,0,0,2013,'https://youtube.com/watch?v=bgJlt1M1pkQ'),(1633,'2013-12-10',11,18,0,0,0,2013,'https://youtube.com/watch?v=MlToTXXo2yk'),(1634,'2013-12-10',5,21,0,0,0,2013,'https://youtube.com/watch?v=0N1TWhz0Jls'),(1635,'2013-12-10',9,20,0,0,0,2013,'https://youtube.com/watch?v=wia9EYZkvjY'),(1636,'2013-12-11',7,3,2,0,0,2013,'https://youtube.com/watch?v=N4Jt5BGCYks'),(1637,'2013-12-11',26,30,2,0,0,2013,'https://youtube.com/watch?v=yMnTtEzgA80'),(1638,'2013-12-11',27,15,0,0,0,2013,'https://youtube.com/watch?v=ThX-obclD6c'),(1639,'2013-12-11',1,28,0,0,0,2013,'https://youtube.com/watch?v=UWk_7iO-AEs'),(1640,'2013-12-11',24,18,0,0,0,2013,'https://youtube.com/watch?v=V1r-Q1VyYJ4'),(1641,'2013-12-11',29,10,0,0,0,2013,'https://www.youtube.com/watch?v=2ZZLH0XJilY'),(1642,'2013-12-11',17,8,0,0,0,2013,'https://youtube.com/watch?v=SKHzMkNQAq4'),(1643,'2013-12-11',4,20,0,0,0,2013,'https://youtube.com/watch?v=ev0G5m1iUSo'),(1644,'2013-12-11',19,23,0,0,0,2013,'https://youtube.com/watch?v=Vqg0Ml-jN9k'),(1645,'2013-12-12',6,22,1,0,0,2013,'https://youtube.com/watch?v=AEtNx3zlECc'),(1646,'2013-12-12',13,28,1,0,0,2013,'https://youtube.com/watch?v=vgQJRNICUig'),(1647,'2013-12-13',15,13,0,0,0,2013,'https://youtube.com/watch?v=T7ZZHdCfdxg'),(1648,'2013-12-13',16,29,0,0,0,2013,'https://youtube.com/watch?v=MKTWJFGA_is'),(1649,'2013-12-13',4,3,0,0,0,2013,'https://youtube.com/watch?v=hQ0NK1658hU'),(1650,'2013-12-13',10,2,0,0,0,2013,'https://youtube.com/watch?v=X7zW1za9c3c'),(1651,'2013-12-13',26,22,2,0,0,2013,'https://youtube.com/watch?v=vDYogw-pAGM'),(1652,'2013-12-13',18,5,2,0,0,2013,'https://youtube.com/watch?v=UUkUDkqFERc'),(1653,'2013-12-13',27,24,0,0,0,2013,'https://youtube.com/watch?v=HBMZ9XWQRvg'),(1654,'2013-12-13',20,17,0,0,0,2013,'https://youtube.com/watch?v=UDYcaaWtyhM'),(1655,'2013-12-13',1,7,0,0,0,2013,'https://youtube.com/watch?v=_CtWBDEo9Wc'),(1656,'2013-12-13',9,8,0,0,0,2013,'https://youtube.com/watch?v=zoXXaO1L7L8'),(1657,'2013-12-13',21,19,0,0,0,2013,'https://youtube.com/watch?v=ZZ7UL2uhMb4'),(1658,'2013-12-13',25,23,0,0,0,2013,'https://youtube.com/watch?v=PesRa2t9njg'),(1659,'2013-12-13',11,12,0,0,0,2013,'https://youtube.com/watch?v=MxKeBSZ6Fio'),(1660,'2013-12-14',7,11,0,0,0,2013,'https://youtube.com/watch?v=-hyt6E3hwig'),(1661,'2013-12-14',14,2,0,0,0,2013,'https://youtube.com/watch?v=5_1L47iYnMA'),(1662,'2013-12-14',12,28,0,0,0,2013,'https://youtube.com/watch?v=6UeUHb3sJo0'),(1663,'2013-12-14',29,5,0,0,0,2013,'https://www.youtube.com/watch?v=SPHxq4wT41w'),(1664,'2013-12-14',30,4,3,0,0,2013,'https://youtube.com/watch?v=Ih7PklxqrHs'),(1665,'2013-12-14',8,6,0,0,0,2013,'https://youtube.com/watch?v=vMy7u5gezlg'),(1666,'2013-12-14',23,20,0,0,0,2013,'https://youtube.com/watch?v=wI84jRfF9Zs'),(1667,'2013-12-14',3,9,0,0,0,2013,'https://youtube.com/watch?v=i53BGyThL9k'),(1668,'2013-12-15',21,26,0,0,0,2013,'https://youtube.com/watch?v=RRAg29XKJKI'),(1669,'2013-12-15',19,22,0,0,0,2013,'https://youtube.com/watch?v=i42-743l1as'),(1670,'2013-12-15',24,17,0,0,0,2013,'https://youtube.com/watch?v=X7Joa5mBm-s'),(1671,'2013-12-15',25,27,0,0,0,2013,'https://youtube.com/watch?v=XWk9EKio3pA'),(1672,'2013-12-15',18,10,0,0,0,2013,'https://youtube.com/watch?v=QxGrjL4PuSA'),(1673,'2013-12-15',15,6,0,0,0,2013,'https://youtube.com/watch?v=0Db5KsVdHcg'),(1674,'2013-12-16',16,15,0,0,0,2013,'https://youtube.com/watch?v=k8hpmD5bwog'),(1675,'2013-12-16',11,5,0,0,0,2013,'https://www.youtube.com/watch?v=dvTLw20iwB4'),(1676,'2013-12-16',1,17,3,0,0,2013,'https://youtube.com/watch?v=d0XKBcC1eIM'),(1677,'2013-12-16',3,10,0,0,0,2013,'https://youtube.com/watch?v=kHP8z8QwGHs'),(1678,'2013-12-16',13,8,0,0,0,2013,'https://youtube.com/watch?v=C2LEy6jmHgs'),(1679,'2013-12-16',28,20,0,0,0,2013,'https://youtube.com/watch?v=GIKkxOf3axk'),(1680,'2013-12-16',14,23,0,0,0,2013,'https://youtube.com/watch?v=btLOXj9mjIw'),(1681,'2013-12-16',7,12,0,0,0,2013,'https://youtube.com/watch?v=fchWVmCYkss'),(1682,'2013-12-17',24,5,0,0,0,2013,'https://youtube.com/watch?v=ESwE0--FmuQ'),(1683,'2013-12-17',26,27,0,0,0,2013,'https://youtube.com/watch?v=RhkK0WIWoq4'),(1684,'2013-12-17',25,18,0,0,0,2013,'https://youtube.com/watch?v=OrLb2zxwaN0'),(1685,'2013-12-17',2,6,0,0,0,2013,'https://youtube.com/watch?v=rz_HM7Cg31w'),(1686,'2013-12-17',29,19,0,0,0,2013,'https://www.youtube.com/watch?v=SAbKJTPa6d4'),(1687,'2013-12-18',9,29,0,0,0,2013,'https://www.youtube.com/watch?v=rtaHeLKIDSQ'),(1688,'2013-12-18',22,3,2,0,0,2013,'https://youtube.com/watch?v=lwmjrcWLmqo'),(1689,'2013-12-18',1,15,0,0,0,2013,'https://youtube.com/watch?v=leoWUHgO_yI'),(1690,'2013-12-18',14,16,2,0,0,2013,'https://youtube.com/watch?v=g4WzRwDXLjU'),(1691,'2013-12-18',30,24,0,0,0,2013,'https://youtube.com/watch?v=I2XyhCDqUOY'),(1692,'2013-12-18',28,27,0,0,0,2013,'https://youtube.com/watch?v=_dONTrX8zRo'),(1693,'2013-12-18',4,7,0,0,0,2013,'https://youtube.com/watch?v=Wa_h6J8_FlQ'),(1694,'2013-12-18',17,6,0,0,0,2013,'https://youtube.com/watch?v=sflZnNPB-m4'),(1695,'2013-12-18',21,20,0,0,0,2013,'https://youtube.com/watch?v=DfolYlsAGLA'),(1696,'2013-12-18',11,19,0,0,0,2013,'https://youtube.com/watch?v=vBO9gL89d7o'),(1697,'2013-12-18',10,23,0,0,0,2013,'https://youtube.com/watch?v=Z27IDVy9kGY'),(1698,'2013-12-18',13,12,0,0,0,2013,'https://youtube.com/watch?v=Q2EB_Nf_Mac'),(1699,'2013-12-19',18,3,1,0,0,2013,'https://youtube.com/watch?v=j0xpKjbsaC4'),(1700,'2013-12-19',26,20,1,0,0,2013,'https://youtube.com/watch?v=QF4VwFENbN4'),(1701,'2013-12-20',8,13,0,0,0,2013,'https://youtube.com/watch?v=ge5Gx36wIrM'),(1702,'2013-12-20',15,29,0,0,0,2013,'https://www.youtube.com/watch?v=okxdB8EKDMQ'),(1703,'2013-12-20',16,22,2,0,0,2013,'https://youtube.com/watch?v=zSgus8sPNIM'),(1704,'2013-12-20',2,4,0,0,0,2013,'https://youtube.com/watch?v=4wUxOLWRXAY'),(1705,'2013-12-20',5,17,2,0,0,2013,'https://www.youtube.com/watch?v=f_44v_NEojI'),(1706,'2013-12-20',25,21,0,0,0,2013,'https://youtube.com/watch?v=-DaRdlUjx74'),(1707,'2013-12-20',14,19,0,0,0,2013,'https://youtube.com/watch?v=93GxIDbENCo'),(1708,'2013-12-20',30,9,0,0,0,2013,'https://youtube.com/watch?v=KDYDrpeyIKM'),(1709,'2013-12-20',11,23,0,0,0,2013,'https://youtube.com/watch?v=3zuqp-pstd4'),(1710,'2013-12-21',3,2,3,0,0,2013,'https://youtube.com/watch?v=itG0Rq6O9X0'),(1711,'2013-12-21',21,30,0,0,0,2013,'https://youtube.com/watch?v=NfiQtoUtAdI'),(1712,'2013-12-21',28,25,3,0,0,2013,'https://youtube.com/watch?v=Us-O2Sx4Exc'),(1713,'2013-12-21',15,22,0,0,0,2013,'https://youtube.com/watch?v=jip3esOE_iA'),(1714,'2013-12-21',26,5,0,0,0,2013,NULL),(1715,'2013-12-21',7,24,0,0,0,2013,'https://youtube.com/watch?v=EFO26W64HUg'),(1716,'2013-12-21',6,27,0,0,0,2013,'https://youtube.com/watch?v=Pvl-GxOUQAA'),(1717,'2013-12-21',20,18,0,0,0,2013,'https://youtube.com/watch?v=4Gxqkybber0'),(1718,'2013-12-21',4,8,0,0,0,2013,'https://youtube.com/watch?v=rJ6enL4sedQ'),(1719,'2013-12-21',10,19,0,0,0,2013,'https://youtube.com/watch?v=dJmx9ne442Q'),(1720,'2013-12-21',29,23,0,0,0,2013,'https://www.youtube.com/watch?v=dbpFLfos9lA'),(1721,'2013-12-21',1,12,0,0,0,2013,'https://youtube.com/watch?v=45rEQp1aJs4'),(1722,'2013-12-22',16,1,0,0,0,2013,'https://youtube.com/watch?v=GvDCIxV5ygU'),(1723,'2013-12-22',28,17,0,0,0,2013,'https://youtube.com/watch?v=Z1GVTGszTok'),(1724,'2013-12-22',18,9,0,0,0,2013,'https://youtube.com/watch?v=4VrTH5p_HLE'),(1725,'2013-12-23',14,11,0,0,0,2013,'https://youtube.com/watch?v=XMcCJRH4B1k'),(1726,'2013-12-23',22,30,0,0,0,2013,'https://youtube.com/watch?v=DFPjMifPMRU'),(1727,'2013-12-23',2,15,0,0,0,2013,'https://youtube.com/watch?v=cFgVgvJFwJc'),(1728,'2013-12-23',25,26,0,0,0,2013,'https://youtube.com/watch?v=yJR0cpFE7rY'),(1729,'2013-12-23',13,16,0,0,0,2013,'https://youtube.com/watch?v=iktK_g2jwoI'),(1730,'2013-12-23',21,5,0,0,0,2013,'https://youtube.com/watch?v=AnajbRoH0vc'),(1731,'2013-12-23',29,4,0,0,0,2013,'https://youtube.com/watch?v=tkCvRq__4ao'),(1732,'2013-12-23',19,27,3,0,0,2013,'https://youtube.com/watch?v=CRml3NzCaAs'),(1733,'2013-12-23',10,7,0,0,0,2013,'https://youtube.com/watch?v=VXWFPgEQUKg'),(1734,'2013-12-23',20,9,0,0,0,2013,'https://youtube.com/watch?v=rNdIql-w0as'),(1735,'2013-12-23',24,23,0,0,0,2013,'https://youtube.com/watch?v=8uo2l9iljCs'),(1736,'2013-12-25',13,3,2,0,0,2013,'https://youtube.com/watch?v=sHq4GZkMmrQ'),(1737,'2013-12-25',20,22,2,0,0,2013,'https://youtube.com/watch?v=WZOYBH3E0G8'),(1738,'2013-12-25',26,28,2,0,0,2013,'https://youtube.com/watch?v=8GULK2Lxf1M'),(1739,'2013-12-25',5,14,4,0,0,2013,'https://youtube.com/watch?v=vCfDPTm99Hc'),(1740,'2013-12-25',7,18,4,0,0,2013,'https://youtube.com/watch?v=SEAwmXw2p6Q'),(1741,'2013-12-26',2,11,0,0,0,2013,'https://youtube.com/watch?v=MV5uE_qxKIY'),(1742,'2013-12-26',6,28,1,0,0,2013,'https://youtube.com/watch?v=UXxTCwORTQk'),(1743,'2013-12-26',22,24,1,0,0,2013,'https://youtube.com/watch?v=984wGPETn3c'),(1744,'2013-12-26',30,20,0,0,0,2013,'https://youtube.com/watch?v=fj9XZP35lfI'),(1745,'2013-12-27',27,25,0,0,0,2013,'https://youtube.com/watch?v=-edTaR0l81I'),(1746,'2013-12-27',10,15,0,0,0,2013,'https://youtube.com/watch?v=BYJd1WXQ0BY'),(1747,'2013-12-27',23,5,0,0,0,2013,'https://youtube.com/watch?v=5TBrWJa5Tsw'),(1748,'2013-12-27',19,14,0,0,0,2013,'https://youtube.com/watch?v=k-HouMocu08'),(1749,'2013-12-27',13,4,0,0,0,2013,'https://youtube.com/watch?v=PcBMw7eB8WI'),(1750,'2013-12-27',29,18,0,0,0,2013,'https://www.youtube.com/watch?v=poUSVUybgeA'),(1751,'2013-12-27',26,21,0,0,0,2013,'https://youtube.com/watch?v=HP3eVBscFNg'),(1752,'2013-12-27',7,9,0,0,0,2013,'https://youtube.com/watch?v=wOJrmC6RRU8'),(1753,'2013-12-27',17,12,3,0,0,2013,'https://youtube.com/watch?v=2IGTRXozbng'),(1754,'2013-12-28',16,13,3,0,0,2013,'https://youtube.com/watch?v=l6sKqSkEwe4'),(1755,'2013-12-28',11,29,0,0,0,2013,'https://www.youtube.com/watch?v=b-A2PTbwGGw'),(1756,'2013-12-28',1,2,0,0,0,2013,'https://youtube.com/watch?v=3Y-s52sxzok'),(1757,'2013-12-28',3,30,0,0,0,2013,'https://youtube.com/watch?v=JazHD80A7XQ'),(1758,'2013-12-28',24,25,0,0,0,2013,NULL),(1759,'2013-12-28',12,15,0,0,0,2013,'https://youtube.com/watch?v=gP-xIawHZPQ'),(1760,'2013-12-28',6,14,0,0,0,2013,'https://www.youtube.com/watch?v=TkP3s8QkMXc'),(1761,'2013-12-28',4,17,0,0,0,2013,'https://youtube.com/watch?v=PQKGXvb2uIE'),(1762,'2013-12-28',22,27,0,0,0,2013,'https://youtube.com/watch?v=jvjQ7p4oYas'),(1763,'2013-12-28',9,7,0,0,0,2013,'https://youtube.com/watch?v=N1hc-bN0-bg'),(1764,'2013-12-28',21,8,0,0,0,2013,'https://youtube.com/watch?v=C56kFqhyppk'),(1765,'2013-12-28',28,23,0,0,0,2013,'https://youtube.com/watch?v=cAV77B3gtfU'),(1766,'2013-12-29',10,11,0,0,0,2013,'https://youtube.com/watch?v=0lTBB02p18w'),(1767,'2013-12-29',2,26,0,0,0,2013,'https://youtube.com/watch?v=jwBV5XdjVxA'),(1768,'2013-12-29',18,22,3,0,0,2013,'https://youtube.com/watch?v=Wk7A3LQLJMM'),(1769,'2013-12-29',5,8,0,0,0,2013,'https://youtube.com/watch?v=DE4eXg9OH3M'),(1770,'2013-12-29',20,19,0,0,0,2013,'https://youtube.com/watch?v=QWLNkl2x2z4'),(1771,'2013-12-30',23,29,0,0,0,2013,'https://youtube.com/watch?v=X_cRTCK337U'),(1772,'2013-12-30',24,3,3,0,0,2013,'https://youtube.com/watch?v=IUmF6s6myCg'),(1773,'2013-12-30',17,30,0,0,0,2013,'https://youtube.com/watch?v=RS9Ee7mqafs'),(1774,'2013-12-30',25,14,0,0,0,2013,'https://youtube.com/watch?v=tIwnfhXbsBM'),(1775,'2013-12-30',28,21,0,0,0,2013,'https://youtube.com/watch?v=O2x4s0qwLnQ'),(1776,'2013-12-30',27,6,0,0,0,2013,'https://youtube.com/watch?v=DXSQLDfExz8'),(1777,'2013-12-30',15,12,0,0,0,2013,'https://youtube.com/watch?v=5C7uOeMyCaY'),(1778,'2013-12-31',1,11,0,0,0,2013,'https://youtube.com/watch?v=BlkLshjw02g'),(1779,'2013-12-31',20,13,0,0,0,2013,'https://youtube.com/watch?v=0h73_OJD_kI'),(1780,'2013-12-31',16,2,0,0,0,2013,'https://youtube.com/watch?v=v-orKqLuqrs'),(1781,'2013-12-31',10,26,0,0,0,2013,'https://youtube.com/watch?v=5Eq588gFe5s'),(1782,'2013-12-31',5,4,0,0,0,2013,'https://youtube.com/watch?v=RbfYP02b7cQ'),(1783,'2013-12-31',18,6,0,0,0,2013,'https://youtube.com/watch?v=DqNXFWKIUQs'),(1784,'2013-12-31',22,19,0,0,0,2013,'https://youtube.com/watch?v=I2LNC2sz95A'),(1785,'2013-12-31',3,9,0,0,0,2013,'https://youtube.com/watch?v=fE1vG4CJ-Ek'),(1786,'2014-01-01',28,29,0,0,0,2013,'https://www.youtube.com/watch?v=bUFS3z4e6_o'),(1787,'2014-01-01',12,30,0,0,0,2013,'https://youtube.com/watch?v=xDilJFxsC_U'),(1788,'2014-01-01',9,16,0,0,0,2013,'https://youtube.com/watch?v=4gbaTspstqI'),(1789,'2014-01-01',17,27,0,0,0,2013,'https://youtube.com/watch?v=ajrK3nOPwx8'),(1790,'2014-01-01',25,8,0,0,0,2013,'https://youtube.com/watch?v=pWwifYoHJ0o'),(1791,'2014-01-02',18,13,3,0,0,2013,'https://youtube.com/watch?v=CT8iO6Ro8Ig'),(1792,'2014-01-02',3,1,0,0,0,2013,'https://youtube.com/watch?v=szqsOPplrXQ'),(1793,'2014-01-02',6,29,0,0,0,2013,'https://youtube.com/watch?v=MXsLya-qNVI'),(1794,'2014-01-02',14,26,0,0,0,2013,'https://youtube.com/watch?v=RPKgM7nUMqI'),(1795,'2014-01-02',21,24,0,0,0,2013,'https://youtube.com/watch?v=AnCuERG9Qi4'),(1796,'2014-01-02',23,4,0,0,0,2013,'https://youtube.com/watch?v=V35j2L_t0fQ'),(1797,'2014-01-02',20,7,0,0,0,2013,'https://youtube.com/watch?v=v0jKNpD21EM'),(1798,'2014-01-02',2,10,0,0,0,2013,'https://youtube.com/watch?v=zmrZyma3T3k'),(1799,'2014-01-02',19,8,0,0,0,2013,NULL),(1800,'2014-01-03',11,26,0,0,0,2013,'https://youtube.com/watch?v=gddaSUmVdpE'),(1801,'2014-01-03',30,28,0,0,0,2013,'https://www.youtube.com/watch?v=sWw4eQ4-kdg'),(1802,'2014-01-03',25,24,0,0,0,2013,'https://youtube.com/watch?v=HWuObJfplBs'),(1803,'2014-01-03',1,27,0,0,0,2013,'https://youtube.com/watch?v=TfJc9JwONMc'),(1804,'2014-01-03',22,7,3,0,0,2013,'https://youtube.com/watch?v=3A32xSumaN8'),(1805,'2014-01-03',12,9,0,0,0,2013,'https://youtube.com/watch?v=SnjGGpAj_S4'),(1806,'2014-01-03',5,23,0,0,0,2013,'https://youtube.com/watch?v=KLRKRycsi6k'),(1807,'2014-01-04',3,11,0,0,0,2013,'https://youtube.com/watch?v=kqNSJYEo_gs'),(1808,'2014-01-04',19,29,0,0,0,2013,'https://www.youtube.com/watch?v=UuHDwPETXzM'),(1809,'2014-01-04',13,2,0,0,0,2013,'https://youtube.com/watch?v=c20knBWmr1Q'),(1810,'2014-01-04',20,28,0,0,0,2013,'https://youtube.com/watch?v=gtOcmUC4wC0'),(1811,'2014-01-04',10,14,0,0,0,2013,'https://youtube.com/watch?v=UALFOx_47oI'),(1812,'2014-01-04',21,4,0,0,0,2013,'https://youtube.com/watch?v=zlvzMR7ABeE'),(1813,'2014-01-04',16,27,0,0,0,2013,'https://youtube.com/watch?v=7xv_1KboDk8'),(1814,'2014-01-04',17,18,0,0,0,2013,'https://youtube.com/watch?v=uQKKhdkWPh8'),(1815,'2014-01-04',6,8,0,0,0,2013,'https://youtube.com/watch?v=5klYRAtxukU'),(1816,'2014-01-05',18,1,0,0,0,2013,'https://youtube.com/watch?v=6e3ijNLm9pw'),(1817,'2014-01-05',5,25,0,0,0,2013,'https://youtube.com/watch?v=G0g9WQ0oBIY'),(1818,'2014-01-05',12,26,0,0,0,2013,'https://youtube.com/watch?v=_-B0CZv1hXE'),(1819,'2014-01-05',2,16,0,0,0,2013,'https://youtube.com/watch?v=l16v8sQ62_0'),(1820,'2014-01-05',15,24,0,0,0,2013,'https://youtube.com/watch?v=-wdDcoKrnRc'),(1821,'2014-01-05',30,7,3,0,0,2013,'https://youtube.com/watch?v=OaOvDAiazNs'),(1822,'2014-01-05',14,9,0,0,0,2013,'https://youtube.com/watch?v=HHyjktxyEJk'),(1823,'2014-01-06',13,11,0,0,0,2013,'https://youtube.com/watch?v=KUROEGMQoVs'),(1824,'2014-01-06',8,17,0,0,0,2013,'https://youtube.com/watch?v=PdeNxi817B4'),(1825,'2014-01-06',28,10,0,0,0,2013,'https://youtube.com/watch?v=lCgXuDi1U5I'),(1826,'2014-01-07',25,1,0,0,0,2013,'https://youtube.com/watch?v=iZrPYNFT-_k'),(1827,'2014-01-07',7,15,0,0,0,2013,'https://youtube.com/watch?v=mdQq1_df8I8'),(1828,'2014-01-07',4,26,0,0,0,2013,'https://youtube.com/watch?v=8tImJeIK-zE'),(1829,'2014-01-07',30,5,0,0,0,2013,'https://youtube.com/watch?v=lEtUagKxVvA'),(1830,'2014-01-07',14,27,0,0,0,2013,'https://youtube.com/watch?v=AOUeyMKHPOA'),(1831,'2014-01-07',23,18,0,0,0,2013,'https://youtube.com/watch?v=d5QrUagTuvY'),(1832,'2014-01-07',2,8,0,0,0,2013,'https://youtube.com/watch?v=xj4ooMB1lis'),(1833,'2014-01-07',3,21,0,0,0,2013,'https://youtube.com/watch?v=9V4esLvRjtE'),(1834,'2014-01-07',19,6,0,0,0,2013,'https://youtube.com/watch?v=N4dHjoafM9I'),(1835,'2014-01-07',24,20,0,0,0,2013,'https://youtube.com/watch?v=sX_l-Ve7sTg'),(1836,'2014-01-07',16,9,0,0,0,2013,'https://youtube.com/watch?v=sdMyExX7uYg'),(1837,'2014-01-07',29,12,0,0,0,2013,'https://youtube.com/watch?v=NmOKad6Y6SQ'),(1838,'2014-01-08',28,1,0,0,0,2013,'https://youtube.com/watch?v=WN75LPRmpZs'),(1839,'2014-01-08',20,30,2,0,0,2013,'https://youtube.com/watch?v=V6mGZUM1IXw'),(1840,'2014-01-08',9,15,0,0,0,2013,'https://youtube.com/watch?v=nbYmVzNHI5g'),(1841,'2014-01-08',13,26,0,0,0,2013,'https://youtube.com/watch?v=icGtQgKewf0'),(1842,'2014-01-08',11,16,0,0,0,2013,'https://youtube.com/watch?v=q46F17g1L_s'),(1843,'2014-01-08',22,5,2,0,0,2013,'https://youtube.com/watch?v=_rbjX05akCA'),(1844,'2014-01-08',6,10,0,0,0,2013,'https://youtube.com/watch?v=dthi1TuIQQc'),(1845,'2014-01-08',17,21,0,0,0,2013,'https://youtube.com/watch?v=PgGRu8ZLN1I'),(1846,'2014-01-08',27,12,0,0,0,2013,'https://youtube.com/watch?v=Q9xZh0dVnXI'),(1847,'2014-01-09',7,14,1,0,0,2013,'https://youtube.com/watch?v=nXbYpv5Z7j0'),(1848,'2014-01-09',25,18,1,0,0,2013,'https://youtube.com/watch?v=ylgtz32f_E8'),(1849,'2014-01-10',26,1,0,0,0,2013,'https://youtube.com/watch?v=Y9dY2qYLRQ4'),(1850,'2014-01-10',17,29,0,0,0,2013,NULL),(1851,'2014-01-10',4,3,0,0,0,2013,'https://youtube.com/watch?v=ShR0jUiZ-Gg'),(1852,'2014-01-10',23,2,0,0,0,2013,'https://youtube.com/watch?v=otlUgp1GTR0'),(1853,'2014-01-10',27,30,0,0,0,2013,'https://youtube.com/watch?v=PwC88hXPwh8'),(1854,'2014-01-10',8,15,0,0,0,2013,'https://youtube.com/watch?v=nbagljsEw3k'),(1855,'2014-01-10',11,22,0,0,0,2013,'https://youtube.com/watch?v=Ge0IpJka5dE'),(1856,'2014-01-10',28,5,2,0,0,2013,'https://www.youtube.com/watch?v=HzZnOI4hkic'),(1857,'2014-01-10',13,14,2,0,0,2013,'https://youtube.com/watch?v=iF6hwK4-S9s'),(1858,'2014-01-10',19,10,0,0,0,2013,'https://youtube.com/watch?v=flJlAt_8JpU'),(1859,'2014-01-10',24,21,0,0,0,2013,NULL),(1860,'2014-01-10',16,12,0,0,0,2013,'https://youtube.com/watch?v=DF3Jnnm4EnA'),(1861,'2014-01-11',9,13,0,0,0,2013,'https://youtube.com/watch?v=P6_zKsvn6nE'),(1862,'2014-01-11',6,1,0,0,0,2013,'https://youtube.com/watch?v=BwnyEn-l8T4'),(1863,'2014-01-11',3,29,0,0,0,2013,'https://www.youtube.com/watch?v=V60LJiRjmKM'),(1864,'2014-01-11',12,22,0,0,0,2013,'https://youtube.com/watch?v=JzGX1lu7C2U'),(1865,'2014-01-11',18,4,0,0,0,2013,'https://youtube.com/watch?v=MIRi81IeFDA'),(1866,'2014-01-11',30,27,0,0,0,2013,'https://youtube.com/watch?v=lGbzNayWw_s'),(1867,'2014-01-11',8,7,0,0,0,2013,'https://youtube.com/watch?v=u2IWZmPYVCg'),(1868,'2014-01-11',25,10,0,0,0,2013,'https://youtube.com/watch?v=4R60nrLL9l0'),(1869,'2014-01-11',15,21,0,0,0,2013,'https://youtube.com/watch?v=9pPD5p6XNU8'),(1870,'2014-01-12',24,11,0,0,0,2013,'https://youtube.com/watch?v=fDtnhcpO_0M'),(1871,'2014-01-12',19,2,3,0,0,2013,'https://youtube.com/watch?v=fXvgy3ua_MI'),(1872,'2014-01-12',20,17,0,0,0,2013,'https://youtube.com/watch?v=B0s8GxF0ppU'),(1873,'2014-01-13',23,25,0,0,0,2013,'https://youtube.com/watch?v=KIhxTbt994I'),(1874,'2014-01-13',1,22,0,0,0,2013,'https://youtube.com/watch?v=bfoB6Q1QsBc'),(1875,'2014-01-13',9,4,0,0,0,2013,'https://youtube.com/watch?v=4MXu4kaHN4M'),(1876,'2014-01-13',30,10,0,0,0,2013,'https://youtube.com/watch?v=Fn6G3MB-74k'),(1877,'2014-01-13',7,21,0,0,0,2013,'https://youtube.com/watch?v=AQyBa-j2w8w'),(1878,'2014-01-13',27,20,0,0,0,2013,'https://youtube.com/watch?v=erZqr3bAmA0'),(1879,'2014-01-13',3,12,3,0,0,2013,'https://youtube.com/watch?v=McDsh1leuNA'),(1880,'2014-01-14',5,2,0,0,0,2013,'https://youtube.com/watch?v=gjqr57Qq3Tc'),(1881,'2014-01-14',29,7,0,0,0,2013,'https://www.youtube.com/watch?v=6671u4V_CWg'),(1882,'2014-01-14',24,18,0,0,0,2013,'https://youtube.com/watch?v=liGIM_9ujqA'),(1883,'2014-01-14',16,19,0,0,0,2013,'https://youtube.com/watch?v=qmPXw_MGdSs'),(1884,'2014-01-15',8,29,0,0,0,2013,'https://youtube.com/watch?v=bSSMAIEPd3E'),(1885,'2014-01-15',10,3,0,0,0,2013,'https://youtube.com/watch?v=W6M4yNCZiZo'),(1886,'2014-01-15',6,2,0,0,0,2013,'https://youtube.com/watch?v=L8nLXt7K1Lg'),(1887,'2014-01-15',28,30,0,0,0,2013,'https://www.youtube.com/watch?v=bM_WvYEg54k'),(1888,'2014-01-15',26,25,2,0,0,2013,'https://youtube.com/watch?v=666qdQCjGLI'),(1889,'2014-01-15',27,22,0,0,0,2013,'https://youtube.com/watch?v=cqr8DYTcNyU'),(1890,'2014-01-15',21,5,0,0,0,2013,'https://youtube.com/watch?v=JjnY8rNn1N4'),(1891,'2014-01-15',4,24,0,0,0,2013,'https://youtube.com/watch?v=nwbYU5KnwpQ'),(1892,'2014-01-15',12,14,0,0,0,2013,'https://youtube.com/watch?v=CbUwO1mX2H4'),(1893,'2014-01-15',17,19,0,0,0,2013,'https://youtube.com/watch?v=81-qAWr5XtQ'),(1894,'2014-01-15',1,9,0,0,0,2013,'https://youtube.com/watch?v=8NT4AH5WRlU'),(1895,'2014-01-15',20,23,2,0,0,2013,'https://www.youtube.com/watch?v=8J2a8kng5ko'),(1896,'2014-01-16',11,13,3,0,0,2013,'https://youtube.com/watch?v=b4RiAD6cJOc'),(1897,'2014-01-16',16,7,1,0,0,2013,'https://youtube.com/watch?v=Fo-0wlof44Y'),(1898,'2014-01-16',22,18,1,0,0,2013,'https://youtube.com/watch?v=7R8wVopTBTs'),(1899,'2014-01-17',10,29,0,0,0,2013,'https://www.youtube.com/watch?v=PHSvhYRznYA'),(1900,'2014-01-17',12,3,0,0,0,2013,'https://youtube.com/watch?v=OqL8-GGGlBk'),(1901,'2014-01-17',25,2,0,0,0,2013,NULL),(1902,'2014-01-17',21,30,0,0,0,2013,'https://youtube.com/watch?v=_IhHWbZj0vo'),(1903,'2014-01-17',18,26,2,0,0,2013,'https://youtube.com/watch?v=4ddLIcPX5rI'),(1904,'2014-01-17',7,28,2,0,0,2013,'https://youtube.com/watch?v=HkCWFC7sq1c'),(1905,'2014-01-17',1,5,0,0,0,2013,'https://www.youtube.com/watch?v=cvOu5t1pgIk'),(1906,'2014-01-17',8,14,0,0,0,2013,'https://youtube.com/watch?v=ccofWwFNZcY'),(1907,'2014-01-17',9,17,0,0,0,2013,'https://www.youtube.com/watch?v=R4GW3Tji2QI'),(1908,'2014-01-17',20,6,0,0,0,2013,'https://youtube.com/watch?v=eEEasrL8ZdY'),(1909,'2014-01-17',24,19,0,0,0,2013,NULL),(1910,'2014-01-17',15,23,0,0,0,2013,'https://youtube.com/watch?v=omOWLM-kBBQ'),(1911,'2014-01-18',12,15,0,0,0,2013,NULL),(1912,'2014-01-18',27,26,0,0,0,2013,'https://youtube.com/watch?v=UqdTAGcrzn4'),(1913,'2014-01-18',16,28,3,0,0,2013,'https://youtube.com/watch?v=YccFJH2TTNI'),(1914,'2014-01-18',29,14,0,0,0,2013,'https://www.youtube.com/watch?v=101g8HDASl0'),(1915,'2014-01-18',22,4,0,0,0,2013,NULL),(1916,'2014-01-18',3,8,0,0,0,2013,NULL),(1917,'2014-01-18',30,6,0,0,0,2013,'https://youtube.com/watch?v=CBQbeZH9bGc'),(1918,'2014-01-18',17,23,0,0,0,2013,NULL),(1919,'2014-01-19',10,1,0,0,0,2013,NULL),(1920,'2014-01-19',21,25,0,0,0,2013,NULL),(1921,'2014-01-19',9,5,0,0,0,2013,'https://youtube.com/watch?v=Hy0-IDBaFas'),(1922,'2014-01-19',20,4,0,0,0,2013,NULL),(1923,'2014-01-19',18,19,0,0,0,2013,NULL),(1924,'2014-01-20',7,13,2,0,0,2013,'https://youtube.com/watch?v=1xvXhX3S4Xg'),(1925,'2014-01-20',2,30,0,0,0,2013,NULL),(1926,'2014-01-20',26,16,1,0,0,2013,NULL),(1927,'2014-01-20',15,28,0,0,0,2013,NULL),(1928,'2014-01-20',3,5,1,0,0,2013,'https://youtube.com/watch?v=1DtGXy6Wyow'),(1929,'2014-01-20',11,14,0,0,0,2013,'https://youtube.com/watch?v=crTHnoA2MN8'),(1930,'2014-01-20',24,27,3,0,0,2013,NULL),(1931,'2014-01-20',12,8,0,0,0,2013,NULL),(1932,'2014-01-20',22,6,0,0,0,2013,'https://youtube.com/watch?v=5_NEr6KHs7g'),(1933,'2014-01-20',29,9,0,0,0,2013,'https://www.youtube.com/watch?v=qPurngHw0wQ'),(1934,'2014-01-21',14,1,0,0,0,2013,'https://youtube.com/watch?v=qaYLhd56zNQ'),(1935,'2014-01-21',23,17,0,0,0,2013,'https://youtube.com/watch?v=ykaHu4h5O6Q'),(1936,'2014-01-21',13,10,0,0,0,2013,'https://youtube.com/watch?v=HDY7qURdS-M'),(1937,'2014-01-21',18,6,0,0,0,2013,'https://youtube.com/watch?v=2kT6IDCQQiM'),(1938,'2014-01-21',27,19,0,0,0,2013,'https://youtube.com/watch?v=97r5g2I-MDU'),(1939,'2014-01-22',10,11,0,0,0,2013,'https://youtube.com/watch?v=lgdcIaKWGiM'),(1940,'2014-01-22',12,1,0,0,0,2013,'https://youtube.com/watch?v=Ab3E2gQpW8s'),(1941,'2014-01-22',2,3,2,0,0,2013,'https://youtube.com/watch?v=NzBF1DCAm2M'),(1942,'2014-01-22',9,30,0,0,0,2013,'https://youtube.com/watch?v=wHRrLVDP3LA'),(1943,'2014-01-22',4,15,0,0,0,2013,NULL),(1944,'2014-01-22',21,16,0,0,0,2013,'https://youtube.com/watch?v=dKyB6U-uye8'),(1945,'2014-01-22',29,28,0,0,0,2013,'https://www.youtube.com/watch?v=ST78Iilj8m4'),(1946,'2014-01-22',20,18,2,0,0,2013,'https://youtube.com/watch?v=1rRHxfFfjaQ'),(1947,'2014-01-22',7,8,0,0,0,2013,'https://www.youtube.com/watch?v=wbHCKXIWMl4'),(1948,'2014-01-22',22,19,0,0,0,2013,'https://youtube.com/watch?v=UTPgYILijeg'),(1949,'2014-01-23',6,25,1,0,0,2013,'https://youtube.com/watch?v=ggnxFSbW-84'),(1950,'2014-01-23',14,5,1,0,0,2013,'https://youtube.com/watch?v=bxADSYUFgPY'),(1951,'2014-01-24',7,29,0,0,0,2013,'https://www.youtube.com/watch?v=GVlls68u8ww'),(1952,'2014-01-24',13,30,0,0,0,2013,'https://youtube.com/watch?v=2YmfOY52Gss'),(1953,'2014-01-24',19,16,0,0,0,2013,NULL),(1954,'2014-01-24',3,28,2,0,0,2013,NULL),(1955,'2014-01-24',10,5,0,0,0,2013,NULL),(1956,'2014-01-24',22,24,0,0,0,2013,NULL),(1957,'2014-01-24',2,4,0,0,0,2013,NULL),(1958,'2014-01-24',26,17,3,0,0,2013,NULL),(1959,'2014-01-24',15,27,0,0,0,2013,NULL),(1960,'2014-01-24',1,18,0,0,0,2013,NULL),(1961,'2014-01-24',11,20,0,0,0,2013,NULL),(1962,'2014-01-24',8,9,0,0,0,2013,NULL),(1963,'2014-01-24',21,12,0,0,0,2013,NULL),(1964,'2014-01-25',4,11,0,0,0,2013,NULL),(1965,'2014-01-25',29,3,3,0,0,2013,NULL),(1966,'2014-01-25',24,22,0,0,0,2013,NULL),(1967,'2014-01-25',25,16,0,0,0,2013,NULL),(1968,'2014-01-25',9,28,0,0,0,2013,NULL),(1969,'2014-01-25',6,17,3,0,0,2013,NULL),(1970,'2014-01-25',8,18,0,0,0,2013,NULL),(1971,'2014-01-25',23,12,0,0,0,2013,NULL),(1972,'2014-01-26',1,13,2,0,0,2013,NULL),(1973,'2014-01-26',19,25,0,0,0,2013,NULL),(1974,'2014-01-26',30,15,0,0,0,2013,NULL),(1975,'2014-01-26',7,5,4,0,0,2013,NULL),(1976,'2014-01-26',27,10,0,0,0,2013,NULL),(1977,'2014-01-26',2,21,0,0,0,2013,NULL),(1978,'2014-01-26',26,6,0,0,0,2013,NULL),(1979,'2014-01-26',14,20,4,0,0,2013,NULL),(1980,'2014-01-27',18,11,0,0,0,2013,NULL),(1981,'2014-01-27',4,28,0,0,0,2013,NULL),(1982,'2014-01-27',3,17,3,0,0,2013,NULL),(1983,'2014-01-27',8,21,0,0,0,2013,NULL),(1984,'2014-01-27',23,19,0,0,0,2013,NULL),(1985,'2014-01-27',13,9,0,0,0,2013,NULL),(1986,'2014-01-28',7,1,0,0,0,2013,NULL),(1987,'2014-01-28',5,16,0,0,0,2013,NULL),(1988,'2014-01-28',6,24,0,0,0,2013,NULL),(1989,'2014-01-28',2,27,0,0,0,2013,NULL),(1990,'2014-01-28',15,10,0,0,0,2013,NULL),(1991,'2014-01-28',22,20,0,0,0,2013,NULL),(1992,'2014-01-28',26,12,0,0,0,2013,NULL),(1993,'2014-01-29',25,29,0,0,0,2013,NULL),(1994,'2014-01-29',20,3,2,0,0,2013,NULL),(1995,'2014-01-29',30,22,0,0,0,2013,NULL),(1996,'2014-01-29',19,24,0,0,0,2013,NULL),(1997,'2014-01-29',17,27,0,0,0,2013,NULL),(1998,'2014-01-29',14,18,2,0,0,2013,NULL),(1999,'2014-01-29',9,10,0,0,0,2013,NULL),(2000,'2014-01-29',1,8,0,0,0,2013,NULL),(2001,'2014-01-29',4,21,0,0,0,2013,NULL),(2002,'2014-01-29',28,12,0,0,0,2013,NULL),(2003,'2014-01-30',7,2,1,0,0,2013,NULL),(2004,'2014-01-30',26,28,1,0,0,2013,NULL),(2005,'2014-01-30',16,21,0,0,0,2013,NULL),(2006,'2014-01-31',8,11,0,0,0,2013,NULL),(2007,'2014-01-31',5,29,0,0,0,2013,NULL),(2008,'2014-01-31',23,26,2,0,0,2013,NULL),(2009,'2014-01-31',17,24,0,0,0,2013,NULL),(2010,'2014-01-31',10,4,0,0,0,2013,NULL),(2011,'2014-01-31',13,18,2,0,0,2013,NULL),(2012,'2014-01-31',30,19,0,0,0,2013,NULL),(2013,'2014-01-31',25,9,0,0,0,2013,NULL),(2014,'2014-02-01',16,13,0,0,0,2013,NULL),(2015,'2014-02-01',21,29,0,0,0,2013,NULL),(2016,'2014-02-01',27,3,0,0,0,2013,NULL),(2017,'2014-02-01',22,2,0,0,0,2013,NULL),(2018,'2014-02-01',7,14,2,0,0,2013,NULL),(2019,'2014-02-01',24,4,0,0,0,2013,NULL),(2020,'2014-02-01',11,17,0,0,0,2013,NULL),(2021,'2014-02-01',12,18,0,0,0,2013,NULL),(2022,'2014-02-01',15,8,0,0,0,2013,NULL),(2023,'2014-02-01',20,19,0,0,0,2013,NULL),(2024,'2014-02-01',6,9,0,0,0,2013,NULL),(2025,'2014-02-01',28,23,0,0,0,2013,NULL),(2026,'2014-02-02',1,10,0,0,0,2013,NULL),(2027,'2014-02-03',19,3,0,0,0,2013,NULL),(2028,'2014-02-03',30,2,0,0,0,2013,NULL),(2029,'2014-02-03',14,15,0,0,0,2013,NULL),(2030,'2014-02-03',25,28,0,0,0,2013,NULL),(2031,'2014-02-03',18,24,3,0,0,2013,NULL),(2032,'2014-02-03',4,7,0,0,0,2013,NULL),(2033,'2014-02-03',16,10,0,0,0,2013,NULL),(2034,'2014-02-03',13,8,0,0,0,2013,NULL),(2035,'2014-02-03',12,6,0,0,0,2013,NULL),(2036,'2014-02-03',27,20,0,0,0,2013,NULL),(2037,'2014-02-03',23,9,0,0,0,2013,NULL),(2038,'2014-02-04',26,29,0,0,0,2013,'https://youtube.com/watch?v=dMrXp23DOJg'),(2039,'2014-02-04',21,3,0,0,0,2013,'https://youtube.com/watch?v=l1Fj6Jb8UE8'),(2040,'2014-02-04',11,16,0,0,0,2013,'https://youtube.com/watch?v=rl1RRoq2Y0M'),(2041,'2014-02-04',17,5,0,0,0,2013,'https://youtube.com/watch?v=M7ZwYGf_COk'),(2042,'2014-02-05',27,11,0,0,0,2013,'https://youtube.com/watch?v=0aM31yMoqyY'),(2043,'2014-02-05',8,1,0,0,0,2013,'https://youtube.com/watch?v=EXzKX7iMqkA'),(2044,'2014-02-05',24,30,0,0,0,2013,'https://youtube.com/watch?v=jmCAuO2FYMc'),(2045,'2014-02-05',10,15,2,0,0,2013,'https://youtube.com/watch?v=EHiCbAojjP8'),(2046,'2014-02-05',2,5,0,0,0,2013,'https://youtube.com/watch?v=rxHkyPYB5Fk'),(2047,'2014-02-05',28,14,2,0,0,2013,'https://youtube.com/watch?v=DmZwtCqSp6o'),(2048,'2014-02-05',25,4,0,0,0,2013,'https://youtube.com/watch?v=TlrciMNWudg'),(2049,'2014-02-05',18,17,0,0,0,2013,'https://youtube.com/watch?v=jOikNRTNsB4'),(2050,'2014-02-05',22,21,0,0,0,2013,'https://youtube.com/watch?v=RgBcJzeJGgQ'),(2051,'2014-02-05',7,6,0,0,0,2013,'https://youtube.com/watch?v=4eoNPwL_vuE'),(2052,'2014-02-05',12,20,0,0,0,2013,NULL),(2053,'2014-02-05',19,9,0,0,0,2013,'https://youtube.com/watch?v=S7P3NC8arIU'),(2054,'2014-02-06',26,3,1,0,0,2013,'https://youtube.com/watch?v=Ac8yCtbO76Q'),(2055,'2014-02-06',13,20,1,0,0,2013,'https://youtube.com/watch?v=GSmfyVdgq5I'),(2056,'2014-02-07',15,13,0,0,0,2013,'https://youtube.com/watch?v=SAZmnI3qg4g'),(2057,'2014-02-07',12,2,2,0,0,2013,'https://youtube.com/watch?v=45IseHPCvPs'),(2058,'2014-02-07',7,25,0,0,0,2013,'https://youtube.com/watch?v=JvXBn51kj_s'),(2059,'2014-02-07',8,5,0,0,0,2013,'https://youtube.com/watch?v=iM3x-FLb7bc'),(2060,'2014-02-07',27,17,2,0,0,2013,'https://youtube.com/watch?v=7YhscChlS4A'),(2061,'2014-02-07',10,18,0,0,0,2013,'https://youtube.com/watch?v=73DR2gzXeaE'),(2062,'2014-02-07',16,6,0,0,0,2013,'https://youtube.com/watch?v=YVMwtyfn9Cw'),(2063,'2014-02-07',1,19,0,0,0,2013,'https://youtube.com/watch?v=adXA_GYkysM'),(2064,'2014-02-07',28,9,0,0,0,2013,'https://youtube.com/watch?v=5DsWxVtbL4o'),(2065,'2014-02-07',30,23,0,0,0,2013,NULL),(2066,'2014-02-08',15,25,3,0,0,2013,NULL),(2067,'2014-02-08',21,26,0,0,0,2013,'https://youtube.com/watch?v=vHBGtzs_rW0'),(2068,'2014-02-08',4,22,0,0,0,2013,'https://youtube.com/watch?v=HUYHSRaLolA'),(2069,'2014-02-08',11,24,0,0,0,2013,'https://youtube.com/watch?v=piySzioGsok'),(2070,'2014-02-08',23,14,0,0,0,2013,'https://youtube.com/watch?v=hGAkLPtqYq8'),(2071,'2014-02-08',17,6,0,0,0,2013,'https://youtube.com/watch?v=3d507K-PJic'),(2072,'2014-02-08',29,20,0,0,0,2013,'https://youtube.com/watch?v=nWQAnzJAMQ8'),(2073,'2014-02-09',5,3,4,0,0,2013,'https://youtube.com/watch?v=N5mR74agtwQ'),(2074,'2014-02-09',1,30,3,0,0,2013,'https://youtube.com/watch?v=Oi_n0CahBOM'),(2075,'2014-02-09',10,16,0,0,0,2013,'https://youtube.com/watch?v=cRhFo5z_7sU'),(2076,'2014-02-09',2,24,0,0,0,2013,'https://youtube.com/watch?v=YrmIJWtDAQE'),(2077,'2014-02-09',13,27,0,0,0,2013,'https://youtube.com/watch?v=aLqKgJfdorc'),(2078,'2014-02-09',18,7,4,0,0,2013,'https://youtube.com/watch?v=8Hpx51cquq8'),(2079,'2014-02-09',28,8,0,0,0,2013,'https://youtube.com/watch?v=Nia_mBIMU2Y'),(2080,'2014-02-09',12,19,0,0,0,2013,'https://youtube.com/watch?v=WZthZ2UPMig'),(2081,'2014-02-10',4,1,0,0,0,2013,NULL),(2082,'2014-02-10',16,25,0,0,0,2013,'https://youtube.com/watch?v=NMiQBYKa05I'),(2083,'2014-02-10',17,22,3,0,0,2013,'https://youtube.com/watch?v=USZknlsv0BI'),(2084,'2014-02-10',9,27,0,0,0,2013,NULL),(2085,'2014-02-10',26,8,0,0,0,2013,'https://youtube.com/watch?v=6sa4Rj6hgwc'),(2086,'2014-02-10',15,20,0,0,0,2013,'https://youtube.com/watch?v=Mms-9Jd9xH8'),(2087,'2014-02-11',3,11,0,0,0,2013,'https://youtube.com/watch?v=muWhObz3Bd0'),(2088,'2014-02-11',29,30,0,0,0,2013,NULL),(2089,'2014-02-11',21,14,0,0,0,2013,'https://youtube.com/watch?v=N51dRt1wpys'),(2090,'2014-02-11',6,18,0,0,0,2013,'https://youtube.com/watch?v=d4mZ73XMr9M'),(2091,'2014-02-11',2,19,0,0,0,2013,'https://youtube.com/watch?v=bFWfb8ad3DU'),(2092,'2014-02-11',5,23,0,0,0,2013,'https://youtube.com/watch?v=pvolSlMHNLQ'),(2093,'2014-02-11',24,12,0,0,0,2013,'https://youtube.com/watch?v=GmVYekgPW7Y'),(2094,'2014-02-12',9,11,0,0,0,2013,'https://youtube.com/watch?v=sPkEDMW_lBM'),(2095,'2014-02-12',13,29,0,0,0,2013,'https://youtube.com/watch?v=WSAzZz6tc9U'),(2096,'2014-02-12',15,2,0,0,0,2013,'https://youtube.com/watch?v=alxTod7IktU'),(2097,'2014-02-12',16,30,0,0,0,2013,NULL),(2098,'2014-02-12',17,25,0,0,0,2013,NULL),(2099,'2014-02-12',10,24,0,0,0,2013,NULL),(2100,'2014-02-12',26,14,3,0,0,2013,'https://youtube.com/watch?v=iWwaLH0Zx6E'),(2101,'2014-02-12',4,27,0,0,0,2013,NULL),(2102,'2014-02-12',23,8,0,0,0,2013,NULL),(2103,'2014-02-12',28,6,0,0,0,2013,NULL),(2104,'2014-02-12',1,20,0,0,0,2013,NULL),(2105,'2014-02-12',7,19,3,0,0,2013,'https://youtube.com/watch?v=oM29PU9kuoI'),(2106,'2014-02-12',22,12,0,0,0,2013,'https://youtube.com/watch?v=xhRkv3A9aQs'),(2107,'2014-02-13',3,13,1,0,0,2013,'https://youtube.com/watch?v=SuLl6n2B9UY'),(2108,'2014-02-13',5,18,1,0,0,2013,'https://youtube.com/watch?v=cvS9KXVd2nU'),(2109,'2014-02-18',16,11,0,0,0,2013,NULL),(2110,'2014-02-18',15,29,0,0,0,2013,NULL),(2111,'2014-02-18',8,2,0,0,0,2013,NULL),(2112,'2014-02-18',30,14,0,0,0,2013,NULL),(2113,'2014-02-18',24,7,0,0,0,2013,NULL),(2114,'2014-02-18',4,10,0,0,0,2013,NULL),(2115,'2014-02-18',25,21,0,0,0,2013,NULL),(2116,'2014-02-18',28,20,0,0,0,2013,NULL),(2117,'2014-02-18',12,9,0,0,0,2013,NULL),(2118,'2014-02-19',23,13,0,0,0,2013,NULL),(2119,'2014-02-19',21,1,0,0,0,2013,NULL),(2120,'2014-02-19',9,3,0,0,0,2013,NULL),(2121,'2014-02-19',29,15,0,0,0,2013,NULL),(2122,'2014-02-19',19,26,0,0,0,2013,NULL),(2123,'2014-02-19',5,22,2,0,0,2013,NULL),(2124,'2014-02-19',17,16,2,0,0,2013,NULL),(2125,'2014-02-19',27,7,0,0,0,2013,NULL),(2126,'2014-02-19',2,10,0,0,0,2013,NULL),(2127,'2014-02-19',6,20,0,0,0,2013,NULL),(2128,'2014-02-19',11,12,0,0,0,2013,NULL),(2129,'2014-02-20',4,25,0,0,0,2013,NULL),(2130,'2014-02-20',26,22,1,0,0,2013,NULL),(2131,'2014-02-20',18,14,1,0,0,2013,NULL),(2132,'2014-02-21',15,11,0,0,0,2013,'https://youtube.com/watch?v=gUctNXZYdzI'),(2133,'2014-02-21',5,1,2,0,0,2013,'https://youtube.com/watch?v=YkHfNkbDAfw'),(2134,'2014-02-21',9,2,0,0,0,2013,NULL),(2135,'2014-02-21',8,30,0,0,0,2013,'https://youtube.com/watch?v=9lHPShPLDUY'),(2136,'2014-02-21',3,25,2,0,0,2013,'https://youtube.com/watch?v=iXWXsmetZz8'),(2137,'2014-02-21',24,28,0,0,0,2013,'https://youtube.com/watch?v=bxLwMj0yS1o'),(2138,'2014-02-21',29,27,0,0,0,2013,'https://youtube.com/watch?v=jh1esdfkGfk'),(2139,'2014-02-21',10,7,0,0,0,2013,'https://youtube.com/watch?v=Ken7SMA5iVk'),(2140,'2014-02-21',21,20,0,0,0,2013,'https://youtube.com/watch?v=7xtPRqU7lmk'),(2141,'2014-02-21',6,23,0,0,0,2013,NULL),(2142,'2014-02-22',26,13,3,0,0,2013,NULL),(2143,'2014-02-22',19,1,0,0,0,2013,NULL),(2144,'2014-02-22',15,30,0,0,0,2013,NULL),(2145,'2014-02-22',4,16,0,0,0,2013,NULL),(2146,'2014-02-22',29,24,0,0,0,2013,NULL),(2147,'2014-02-22',23,17,0,0,0,2013,NULL),(2148,'2014-02-22',12,27,0,0,0,2013,NULL),(2149,'2014-02-22',11,7,3,0,0,2013,NULL),(2150,'2014-02-23',5,13,2,0,0,2013,'https://youtube.com/watch?v=xKXGcn20RGY'),(2151,'2014-02-23',14,3,4,0,0,2013,'https://youtube.com/watch?v=6GWl8vBpRxk'),(2152,'2014-02-23',21,22,0,0,0,2013,'https://youtube.com/watch?v=RDDvssWtwH4'),(2153,'2014-02-23',18,28,4,0,0,2013,'https://youtube.com/watch?v=zL436v9WDHM'),(2154,'2014-02-23',6,17,0,0,0,2013,'https://youtube.com/watch?v=4Vhy6QQNVow'),(2155,'2014-02-23',9,10,0,0,0,2013,'https://youtube.com/watch?v=4O2AI96a3Ss'),(2156,'2014-02-23',25,19,0,0,0,2013,'https://youtube.com/watch?v=bb6T5X8uTzM'),(2157,'2014-02-23',2,12,0,0,0,2013,'https://youtube.com/watch?v=IojiC3eQPoU'),(2158,'2014-02-24',23,1,0,0,0,2013,'https://youtube.com/watch?v=k8LDdAAZXoQ'),(2159,'2014-02-24',7,30,3,0,0,2013,'https://youtube.com/watch?v=oA5J6r1uYQA'),(2160,'2014-02-24',15,26,0,0,0,2013,'https://youtube.com/watch?v=kmUARvyLVgs'),(2161,'2014-02-24',27,28,0,0,0,2013,'https://youtube.com/watch?v=a_CKFs0nW8c'),(2162,'2014-02-24',8,4,0,0,0,2013,'https://youtube.com/watch?v=Upikvt6T-AA'),(2163,'2014-02-25',11,3,0,0,0,2013,'https://youtube.com/watch?v=_iUbTbuP-VQ'),(2164,'2014-02-25',19,22,0,0,0,2013,'https://youtube.com/watch?v=i0tlle27hn4'),(2165,'2014-02-25',16,5,0,0,0,2013,'https://youtube.com/watch?v=ZmNklUn48PI'),(2166,'2014-02-25',21,17,0,0,0,2013,'https://youtube.com/watch?v=uuaDUd2IBFg'),(2167,'2014-02-25',12,10,0,0,0,2013,NULL),(2168,'2014-02-25',25,6,0,0,0,2013,'https://youtube.com/watch?v=2ygoN9k1XBY'),(2169,'2014-02-25',2,9,0,0,0,2013,'https://youtube.com/watch?v=GEZn8i3_Ovo'),(2170,'2014-02-26',1,11,0,0,0,2013,NULL),(2171,'2014-02-26',6,13,0,0,0,2013,NULL),(2172,'2014-02-26',18,2,0,0,0,2013,NULL),(2173,'2014-02-26',20,15,0,0,0,2013,NULL),(2174,'2014-02-26',3,26,0,0,0,2013,NULL),(2175,'2014-02-26',28,22,2,0,0,2013,NULL),(2176,'2014-02-26',24,5,0,0,0,2013,NULL),(2177,'2014-02-26',30,27,2,0,0,2013,NULL),(2178,'2014-02-26',8,10,0,0,0,2013,NULL),(2179,'2014-02-26',23,21,0,0,0,2013,NULL),(2180,'2014-02-27',25,13,1,0,0,2013,'https://youtube.com/watch?v=CEutI7X0aCM'),(2181,'2014-02-27',16,4,0,0,0,2013,'https://youtube.com/watch?v=Gp98Ivq18hY'),(2182,'2014-02-27',14,7,1,0,0,2013,'https://youtube.com/watch?v=zlyMeqPPhG4'),(2183,'2014-02-27',9,12,0,0,0,2013,'https://youtube.com/watch?v=5neNaKyUZTc'),(2184,'2014-02-28',20,29,0,0,0,2013,'https://youtube.com/watch?v=q-VXaMpU7Vk'),(2185,'2014-02-28',30,3,0,0,0,2013,'https://youtube.com/watch?v=mPxwxsqu7V8'),(2186,'2014-02-28',7,26,2,0,0,2013,'https://youtube.com/watch?v=Gl_necuxFFo'),(2187,'2014-02-28',18,24,0,0,0,2013,'https://youtube.com/watch?v=ba4AaNaLSH0'),(2188,'2014-02-28',21,27,2,0,0,2013,'https://youtube.com/watch?v=2gg3MLQZ1P4'),(2189,'2014-02-28',5,19,0,0,0,2013,'https://youtube.com/watch?v=ub8RbuGS4KQ'),(2190,'2014-02-28',2,23,0,0,0,2013,'https://youtube.com/watch?v=T9rpOnWwaR0'),(2191,'2014-03-01',4,13,0,0,0,2013,NULL),(2192,'2014-03-01',24,2,0,0,0,2013,'https://youtube.com/watch?v=Dn3whD-H9-0'),(2193,'2014-03-01',6,25,3,0,0,2013,'https://youtube.com/watch?v=eKh72Tya1Ds'),(2194,'2014-03-01',22,15,0,0,0,2013,'https://youtube.com/watch?v=mChTIY11iqA'),(2195,'2014-03-01',1,16,0,0,0,2013,'https://youtube.com/watch?v=yIbRRgXu6lc'),(2196,'2014-03-01',19,17,0,0,0,2013,'https://youtube.com/watch?v=8kVlT6WnHbU'),(2197,'2014-03-01',28,27,0,0,0,2013,'https://youtube.com/watch?v=wN4eWftMPCw'),(2198,'2014-03-01',14,10,0,0,0,2013,'https://youtube.com/watch?v=3-w8YyRZ32c'),(2199,'2014-03-01',8,12,0,0,0,2013,'https://youtube.com/watch?v=wVGI0bZvkbQ'),(2200,'2014-03-02',21,11,0,0,0,2013,NULL),(2201,'2014-03-02',18,29,0,0,0,2013,'https://youtube.com/watch?v=mMmEzGIEXgU'),(2202,'2014-03-02',20,30,0,0,0,2013,'https://youtube.com/watch?v=X0vNJwp8SM0'),(2203,'2014-03-02',9,26,0,0,0,2013,'https://youtube.com/watch?v=Zimv0NKcSN4'),(2204,'2014-03-02',3,7,4,0,0,2013,NULL),(2205,'2014-03-02',10,8,0,0,0,2013,NULL),(2206,'2014-03-02',16,23,0,0,0,2013,NULL),(2207,'2014-03-03',14,29,0,0,0,2013,'https://youtube.com/watch?v=-d85wfTQY7A'),(2208,'2014-03-03',13,3,3,0,0,2013,'https://youtube.com/watch?v=J-BfL3lf8us'),(2209,'2014-03-03',6,5,0,0,0,2013,'https://youtube.com/watch?v=4m0geSFwdv4'),(2210,'2014-03-03',12,24,0,0,0,2013,NULL),(2211,'2014-03-03',25,17,0,0,0,2013,NULL),(2212,'2014-03-03',19,27,3,0,0,2013,NULL),(2213,'2014-03-03',15,7,0,0,0,2013,NULL),(2214,'2014-03-03',4,23,0,0,0,2013,NULL),(2215,'2014-03-04',16,26,0,0,0,2013,'https://youtube.com/watch?v=Y72B8bV2bq0'),(2216,'2014-03-04',21,28,0,0,0,2013,'https://youtube.com/watch?v=8pZ9KkU7OA0'),(2217,'2014-03-04',22,14,0,0,0,2013,'https://youtube.com/watch?v=BEk4uGqbbUc'),(2218,'2014-03-04',5,27,0,0,0,2013,'https://youtube.com/watch?v=aCuam-BhKOc'),(2219,'2014-03-04',18,8,0,0,0,2013,'https://youtube.com/watch?v=H7N8J2Z2yLY'),(2220,'2014-03-04',2,20,0,0,0,2013,'https://youtube.com/watch?v=0GBmvQbIcII'),(2221,'2014-03-05',6,11,2,0,0,2013,'https://youtube.com/watch?v=NkhbHvq6WWY'),(2222,'2014-03-05',15,3,0,0,0,2013,NULL),(2223,'2014-03-05',25,30,0,0,0,2013,'https://youtube.com/watch?v=gSAyZ4wGWLs'),(2224,'2014-03-05',1,26,0,0,0,2013,'https://youtube.com/watch?v=TnAOITxdWys'),(2225,'2014-03-05',10,22,0,0,0,2013,NULL),(2226,'2014-03-05',29,16,0,0,0,2013,'https://youtube.com/watch?v=D43lKMigj6M'),(2227,'2014-03-05',13,24,0,0,0,2013,NULL),(2228,'2014-03-05',17,7,2,0,0,2013,'https://youtube.com/watch?v=vvVcxaxM9gs'),(2229,'2014-03-05',4,19,0,0,0,2013,NULL),(2230,'2014-03-05',12,23,0,0,0,2013,NULL),(2231,'2014-03-06',5,28,1,0,0,2013,'https://youtube.com/watch?v=ItN7wFlgQk0'),(2232,'2014-03-06',20,14,1,0,0,2013,'https://youtube.com/watch?v=sHY0xRDMOmA'),(2233,'2014-03-06',21,18,0,0,0,2013,'https://youtube.com/watch?v=uoFdSKpARXo'),(2234,'2014-03-07',26,11,0,0,0,2013,'https://youtube.com/watch?v=O6BtaPoVL2U'),(2235,'2014-03-07',1,13,0,0,0,2013,'https://youtube.com/watch?v=VKUJYEZLwhU'),(2236,'2014-03-07',29,2,0,0,0,2013,'https://youtube.com/watch?v=SNM2FF4FRLs'),(2237,'2014-03-07',17,15,0,0,0,2013,'https://youtube.com/watch?v=4K7nKJmuyXg'),(2238,'2014-03-07',22,16,2,0,0,2013,'https://youtube.com/watch?v=XBHaSswfmM0'),(2239,'2014-03-07',25,5,0,0,0,2013,'https://youtube.com/watch?v=RPks3WTbHJg'),(2240,'2014-03-07',3,24,2,0,0,2013,'https://youtube.com/watch?v=6EuZpSfAnf4'),(2241,'2014-03-07',27,4,0,0,0,2013,'https://youtube.com/watch?v=IiP8LAdf06Y'),(2242,'2014-03-07',30,6,0,0,0,2013,'https://youtube.com/watch?v=UYnCj7qCWO4'),(2243,'2014-03-07',9,19,0,0,0,2013,'https://youtube.com/watch?v=m5BCa0D62As'),(2244,'2014-03-07',7,23,0,0,0,2013,'https://youtube.com/watch?v=pIkA99-DAS4'),(2245,'2014-03-08',28,11,0,0,0,2013,'https://youtube.com/watch?v=lRF2NGUoKZ0'),(2246,'2014-03-08',24,29,0,0,0,2013,'https://youtube.com/watch?v=SZEGnL7Pi9E'),(2247,'2014-03-08',2,7,3,0,0,2013,'https://youtube.com/watch?v=fCbaNBfHHzE'),(2248,'2014-03-08',20,10,0,0,0,2013,'https://youtube.com/watch?v=RVMsZ-TgJl0'),(2249,'2014-03-08',8,23,0,0,0,2013,'https://youtube.com/watch?v=yQ8aVO-mXeg'),(2250,'2014-03-08',4,12,0,0,0,2013,'https://youtube.com/watch?v=B5vkMS7lUHE'),(2251,'2014-03-09',27,25,0,0,0,2013,NULL),(2252,'2014-03-09',1,15,3,0,0,2013,NULL),(2253,'2014-03-09',30,16,0,0,0,2013,'https://youtube.com/watch?v=H7-bYSzlmLA'),(2254,'2014-03-09',3,14,4,0,0,2013,'https://youtube.com/watch?v=32trP6ei-BQ'),(2255,'2014-03-09',5,18,4,0,0,2013,'https://youtube.com/watch?v=8piSjqZP06Y'),(2256,'2014-03-09',26,21,3,0,0,2013,NULL),(2257,'2014-03-09',22,6,0,0,0,2013,'https://youtube.com/watch?v=pIusTS6M04s'),(2258,'2014-03-09',13,19,0,0,0,2013,'https://youtube.com/watch?v=Jwcr0oInqPI'),(2259,'2014-03-09',17,9,0,0,0,2013,NULL),(2260,'2014-03-10',23,11,0,0,0,2013,'https://youtube.com/watch?v=FuIr3eZL84s'),(2261,'2014-03-10',29,25,0,0,0,2013,'https://youtube.com/watch?v=kNMgmD0MHq0'),(2262,'2014-03-10',4,10,3,0,0,2013,NULL),(2263,'2014-03-10',7,8,0,0,0,2013,'https://youtube.com/watch?v=RikGTbIMncY'),(2264,'2014-03-10',28,21,3,0,0,2013,'https://youtube.com/watch?v=SpmyZ5VHq_4'),(2265,'2014-03-10',13,9,0,0,0,2013,'https://youtube.com/watch?v=90utuVxGgnQ'),(2266,'2014-03-10',14,12,0,0,0,2013,'https://youtube.com/watch?v=F50ebbcMp1U'),(2267,'2014-03-11',16,1,0,0,0,2013,'https://youtube.com/watch?v=4e5HsIxtEoE'),(2268,'2014-03-11',26,30,0,0,0,2013,'https://youtube.com/watch?v=tIG5ySvACME'),(2269,'2014-03-11',18,22,0,0,0,2013,'https://youtube.com/watch?v=4mlgDi7TrQw'),(2270,'2014-03-11',17,4,0,0,0,2013,'https://youtube.com/watch?v=j9s0vP2sEQM'),(2271,'2014-03-11',24,6,0,0,0,2013,'https://youtube.com/watch?v=uH_BppuxAh0'),(2272,'2014-03-11',3,20,0,0,0,2013,'https://youtube.com/watch?v=4CU3HF9FISY'),(2273,'2014-03-11',15,19,0,0,0,2013,NULL),(2274,'2014-03-12',14,13,2,0,0,2013,'https://youtube.com/watch?v=xIvc2b23rC0'),(2275,'2014-03-12',12,29,0,0,0,2013,NULL),(2276,'2014-03-12',21,2,0,0,0,2013,'https://youtube.com/watch?v=cQaUgR0uYoY'),(2277,'2014-03-12',23,30,0,0,0,2013,'https://youtube.com/watch?v=tUhD3IWLiBg'),(2278,'2014-03-12',10,25,0,0,0,2013,NULL),(2279,'2014-03-12',9,15,0,0,0,2013,'https://youtube.com/watch?v=7FtEDG2agtU'),(2280,'2014-03-12',28,26,0,0,0,2013,'https://youtube.com/watch?v=aMZAPw7zkw8'),(2281,'2014-03-12',27,24,0,0,0,2013,NULL),(2282,'2014-03-12',1,7,0,0,0,2013,'https://youtube.com/watch?v=omq1SSlt-FU'),(2283,'2014-03-12',20,6,2,0,0,2013,'https://youtube.com/watch?v=QXYScloqH1I'),(2284,'2014-03-12',8,19,0,0,0,2013,NULL),(2285,'2014-03-13',3,22,1,0,0,2013,'https://youtube.com/watch?v=QrtR0s4w9_A'),(2286,'2014-03-13',18,5,1,0,0,2013,NULL),(2287,'2014-03-13',11,4,0,0,0,2013,'https://youtube.com/watch?v=RTrMn9xNMcc'),(2288,'2014-03-14',26,2,0,0,0,2013,'https://youtube.com/watch?v=_WCEsYHvhqI'),(2289,'2014-03-14',14,25,0,0,0,2013,'https://youtube.com/watch?v=PKeTbCrlt88'),(2290,'2014-03-14',8,16,0,0,0,2013,'https://youtube.com/watch?v=ST-RNk0l8_Y'),(2291,'2014-03-14',23,28,0,0,0,2013,'https://youtube.com/watch?v=zpkVnJZMwrc'),(2292,'2014-03-14',20,5,3,0,0,2013,'https://youtube.com/watch?v=Yb4WH0mXfMI'),(2293,'2014-03-14',9,24,0,0,0,2013,'https://youtube.com/watch?v=3WR53iNSQ7Y'),(2294,'2014-03-14',29,17,0,0,0,2013,'https://youtube.com/watch?v=dMtmDQzL1PU'),(2295,'2014-03-14',1,21,0,0,0,2013,'https://youtube.com/watch?v=iQ3y68QiYvg'),(2296,'2014-03-14',27,6,0,0,0,2013,'https://youtube.com/watch?v=eEQRTZiqE8w'),(2297,'2014-03-14',10,12,0,0,0,2013,'https://youtube.com/watch?v=zj3S7Vjdh7s'),(2298,'2014-03-15',12,13,0,0,0,2013,'https://youtube.com/watch?v=8qBqemi-TGE'),(2299,'2014-03-15',11,25,3,0,0,2013,'https://youtube.com/watch?v=Xhg173kyXYo'),(2300,'2014-03-15',15,16,0,0,0,2013,'https://youtube.com/watch?v=uD-gbhhep_g'),(2301,'2014-03-15',8,24,0,0,0,2013,'https://youtube.com/watch?v=U6dmkiX4rfs'),(2302,'2014-03-15',7,4,0,0,0,2013,'https://youtube.com/watch?v=fSTdiZoE0NY'),(2303,'2014-03-15',3,19,0,0,0,2013,'https://youtube.com/watch?v=Svf3VLYJguI'),(2304,'2014-03-16',27,1,0,0,0,2013,NULL),(2305,'2014-03-16',4,29,0,0,0,2013,NULL),(2306,'2014-03-16',28,2,3,0,0,2013,'https://youtube.com/watch?v=fCDbJRxqv78'),(2307,'2014-03-16',18,30,0,0,0,2013,'https://youtube.com/watch?v=e6kKqQ8SUnU'),(2308,'2014-03-16',6,26,0,0,0,2013,'https://youtube.com/watch?v=vbIXy08_qMM'),(2309,'2014-03-16',14,22,4,0,0,2013,'https://youtube.com/watch?v=x_D401Nuh88'),(2310,'2014-03-16',9,21,0,0,0,2013,NULL),(2311,'2014-03-16',17,19,0,0,0,2013,NULL),(2312,'2014-03-16',20,23,0,0,0,2013,'https://youtube.com/watch?v=nEb3_AaDYRY'),(2313,'2014-03-17',29,11,0,0,0,2013,NULL),(2314,'2014-03-17',30,1,0,0,0,2013,'https://youtube.com/watch?v=ivDeTejDYu0'),(2315,'2014-03-17',25,28,2,0,0,2013,'https://youtube.com/watch?v=gSUsDGJrEtc'),(2316,'2014-03-17',3,18,2,0,0,2013,'https://youtube.com/watch?v=RwNmRPs2gmY'),(2317,'2014-03-17',16,8,0,0,0,2013,'https://youtube.com/watch?v=v_D3pIf82JY'),(2318,'2014-03-17',13,21,0,0,0,2013,'https://youtube.com/watch?v=qbb9L3RvGH8'),(2319,'2014-03-17',22,23,0,0,0,2013,'https://youtube.com/watch?v=tXfIRtNdApM'),(2320,'2014-03-18',2,14,0,0,0,2013,'https://youtube.com/watch?v=zxBAYaIFZ58'),(2321,'2014-03-18',6,4,0,0,0,2013,NULL),(2322,'2014-03-18',26,10,0,0,0,2013,NULL),(2323,'2014-03-18',11,9,0,0,0,2013,'https://youtube.com/watch?v=6KKXivE2TE8'),(2324,'2014-03-18',19,12,0,0,0,2013,NULL),(2325,'2014-03-19',13,29,0,0,0,2013,NULL),(2326,'2014-03-19',8,3,0,0,0,2013,NULL),(2327,'2014-03-19',25,15,0,0,0,2013,NULL),(2328,'2014-03-19',7,16,2,0,0,2013,NULL),(2329,'2014-03-19',1,14,0,0,0,2013,NULL),(2330,'2014-03-19',30,17,0,0,0,2013,NULL),(2331,'2014-03-19',21,10,0,0,0,2013,NULL),(2332,'2014-03-19',5,20,2,0,0,2013,NULL),(2333,'2014-03-19',27,9,0,0,0,2013,NULL),(2334,'2014-03-19',24,23,0,0,0,2013,NULL),(2335,'2014-03-20',26,4,0,0,0,2013,NULL),(2336,'2014-03-20',22,17,0,0,0,2013,NULL),(2337,'2014-03-20',2,18,0,0,0,2013,'https://youtube.com/watch?v=yIicsFv6MSI'),(2338,'2014-03-20',6,12,0,0,0,2013,NULL),(2339,'2014-03-21',13,1,0,0,0,2013,'https://youtube.com/watch?v=YtBLm3oJySk'),(2340,'2014-03-21',16,3,0,0,0,2013,'https://youtube.com/watch?v=VNover4Lafo'),(2341,'2014-03-21',30,25,0,0,0,2013,'https://youtube.com/watch?v=sObZCEl5LBg'),(2342,'2014-03-21',21,15,0,0,0,2013,NULL),(2343,'2014-03-21',14,24,0,0,0,2013,'https://youtube.com/watch?v=8n8b1ZT5frM'),(2344,'2014-03-21',11,27,0,0,0,2013,'https://youtube.com/watch?v=Zvt5h155LSM'),(2345,'2014-03-21',8,7,0,0,0,2013,'https://youtube.com/watch?v=LRayVDka5Ks'),(2346,'2014-03-21',9,18,0,0,0,2013,'https://youtube.com/watch?v=5ubc4UEU_Nk'),(2347,'2014-03-21',19,20,0,0,0,2013,'https://youtube.com/watch?v=hIl_jS53HL4'),(2348,'2014-03-21',5,12,0,0,0,2013,'https://youtube.com/watch?v=-vhTGN5UIxA'),(2349,'2014-03-22',28,15,0,0,0,2013,'https://youtube.com/watch?v=s_WneHguaXE'),(2350,'2014-03-22',2,22,0,0,0,2013,'https://youtube.com/watch?v=4nQQRcphQLw'),(2351,'2014-03-22',24,16,0,0,0,2013,'https://youtube.com/watch?v=UQFgjiyeygM'),(2352,'2014-03-22',27,14,0,0,0,2013,'https://youtube.com/watch?v=6z85UqCDHZo'),(2353,'2014-03-22',23,10,0,0,0,2013,'https://youtube.com/watch?v=tbEXt69_88U'),(2354,'2014-03-22',3,8,0,0,0,2013,'https://youtube.com/watch?v=iwkTh6b0P9I'),(2355,'2014-03-22',29,6,0,0,0,2013,'https://youtube.com/watch?v=dAHvCet4qTw'),(2356,'2014-03-22',26,20,3,0,0,2013,'https://youtube.com/watch?v=SS2P9YWOT5o'),(2357,'2014-03-23',9,11,0,0,0,2013,NULL),(2358,'2014-03-23',30,13,0,0,0,2013,NULL),(2359,'2014-03-23',7,2,0,0,0,2013,NULL),(2360,'2014-03-23',19,4,0,0,0,2013,NULL),(2361,'2014-03-23',5,10,0,0,0,2013,NULL),(2362,'2014-03-23',17,21,0,0,0,2013,NULL),(2363,'2014-03-23',25,12,0,0,0,2013,NULL),(2364,'2014-03-24',27,13,0,0,0,2013,NULL),(2365,'2014-03-24',18,25,0,0,0,2013,NULL),(2366,'2014-03-24',23,15,0,0,0,2013,NULL),(2367,'2014-03-24',29,22,0,0,0,2013,NULL),(2368,'2014-03-24',3,16,3,0,0,2013,NULL),(2369,'2014-03-24',28,4,0,0,0,2013,NULL),(2370,'2014-03-24',24,17,0,0,0,2013,NULL),(2371,'2014-03-24',20,8,0,0,0,2013,NULL),(2372,'2014-03-24',11,21,0,0,0,2013,NULL),(2373,'2014-03-24',14,6,0,0,0,2013,NULL),(2374,'2014-03-25',5,7,1,0,0,2013,'https://youtube.com/watch?v=7CrzAHWB6aU'),(2375,'2014-03-25',30,18,1,0,0,2013,'https://youtube.com/watch?v=fMO1DcRqVjo'),(2376,'2014-03-25',10,6,0,0,0,2013,'https://youtube.com/watch?v=po-Gs6CDwIY'),(2377,'2014-03-25',2,9,0,0,0,2013,'https://youtube.com/watch?v=2AEYBQbrV5U'),(2378,'2014-03-26',17,11,0,0,0,2013,NULL),(2379,'2014-03-26',29,13,0,0,0,2013,NULL),(2380,'2014-03-26',15,2,0,0,0,2013,NULL),(2381,'2014-03-26',20,25,0,0,0,2013,NULL),(2382,'2014-03-26',27,28,0,0,0,2013,NULL),(2383,'2014-03-26',23,24,2,0,0,2013,NULL),(2384,'2014-03-26',16,14,2,0,0,2013,NULL),(2385,'2014-03-26',19,7,0,0,0,2013,NULL),(2386,'2014-03-26',12,21,0,0,0,2013,NULL),(2387,'2014-03-26',1,9,0,0,0,2013,NULL),(2388,'2014-03-27',30,28,0,0,0,2013,'https://youtube.com/watch?v=dnA7eDG1JcM'),(2389,'2014-03-27',4,5,0,0,0,2013,'https://youtube.com/watch?v=tVIkxsHQK9I'),(2390,'2014-03-27',22,8,0,0,0,2013,'https://youtube.com/watch?v=ISKeI49bsxg'),(2391,'2014-03-27',11,6,0,0,0,2013,NULL),(2392,'2014-03-28',9,1,0,0,0,2013,'https://youtube.com/watch?v=P-H9JAsczuE'),(2393,'2014-03-28',10,29,0,0,0,2013,NULL),(2394,'2014-03-28',13,2,0,0,0,2013,'https://youtube.com/watch?v=TAwS3_ynDuc'),(2395,'2014-03-28',12,16,0,0,0,2013,'https://youtube.com/watch?v=84bSbx9ptmA'),(2396,'2014-03-28',17,5,0,0,0,2013,'https://youtube.com/watch?v=jx_y9kYogR4'),(2397,'2014-03-28',26,24,0,0,0,2013,'https://youtube.com/watch?v=Sqrpj6j1M6g'),(2398,'2014-03-28',15,14,0,0,0,2013,'https://www.youtube.com/watch?v=Z4lfRzHAk_E'),(2399,'2014-03-28',21,7,0,0,0,2013,'https://youtube.com/watch?v=sEXU3rB7UmE'),(2400,'2014-03-28',3,6,0,0,0,2013,'https://youtube.com/watch?v=LDDZwKfU3Ko'),(2401,'2014-03-28',25,20,0,0,0,2013,NULL),(2402,'2014-03-28',18,19,0,0,0,2013,'https://youtube.com/watch?v=i3_aNbX7Azk'),(2403,'2014-03-28',27,23,0,0,0,2013,NULL),(2404,'2014-03-29',12,11,0,0,0,2013,NULL),(2405,'2014-03-29',8,15,0,0,0,2013,'https://youtube.com/watch?v=MA79XRznGs8'),(2406,'2014-03-29',22,28,3,0,0,2013,'https://youtube.com/watch?v=AzWZNax6ngQ'),(2407,'2014-03-29',4,14,0,0,0,2013,'https://youtube.com/watch?v=xzZEr9EX7SI'),(2408,'2014-03-29',20,27,0,0,0,2013,'https://youtube.com/watch?v=i6o9-FlaIx0'),(2409,'2014-03-29',30,19,0,0,0,2013,'https://youtube.com/watch?v=G8a3-h-8I1Y'),(2410,'2014-03-30',1,3,0,0,0,2013,NULL),(2411,'2014-03-30',2,16,0,0,0,2013,NULL),(2412,'2014-03-30',6,24,3,0,0,2013,NULL),(2413,'2014-03-30',13,17,0,0,0,2013,NULL),(2414,'2014-03-30',26,7,0,0,0,2013,NULL),(2415,'2014-03-30',5,21,0,0,0,2013,NULL),(2416,'2014-03-30',10,9,0,0,0,2013,NULL),(2417,'2014-03-30',18,23,0,0,0,2013,NULL),(2418,'2014-03-31',3,1,0,0,0,2013,NULL),(2419,'2014-03-31',17,28,0,0,0,2013,NULL),(2420,'2014-03-31',25,24,0,0,0,2013,NULL),(2421,'2014-03-31',15,4,0,0,0,2013,NULL),(2422,'2014-03-31',23,7,0,0,0,2013,NULL),(2423,'2014-03-31',11,8,0,0,0,2013,NULL),(2424,'2014-03-31',16,20,3,0,0,2013,NULL),(2425,'2014-03-31',27,19,0,0,0,2013,NULL),(2426,'2014-03-31',14,9,0,0,0,2013,NULL),(2427,'2014-03-31',29,12,0,0,0,2013,NULL),(2428,'2014-04-01',30,26,0,0,0,2013,'https://youtube.com/watch?v=m58pODFT1l0'),(2429,'2014-04-01',13,22,1,0,0,2013,'https://youtube.com/watch?v=yJNl9SR_l04'),(2430,'2014-04-01',5,6,1,0,0,2013,'https://youtube.com/watch?v=0S6i8CP-0qc'),(2431,'2014-04-02',7,13,2,0,0,2013,NULL),(2432,'2014-04-02',12,1,0,0,0,2013,NULL),(2433,'2014-04-02',8,29,0,0,0,2013,NULL),(2434,'2014-04-02',11,3,0,0,0,2013,NULL),(2435,'2014-04-02',10,2,0,0,0,2013,NULL),(2436,'2014-04-02',16,15,0,0,0,2013,NULL),(2437,'2014-04-02',20,26,0,0,0,2013,NULL),(2438,'2014-04-02',9,22,0,0,0,2013,NULL),(2439,'2014-04-02',21,28,0,0,0,2013,NULL),(2440,'2014-04-02',19,5,0,0,0,2013,NULL),(2441,'2014-04-02',17,24,0,0,0,2013,NULL),(2442,'2014-04-02',14,4,0,0,0,2013,NULL),(2443,'2014-04-02',25,27,0,0,0,2013,NULL),(2444,'2014-04-03',28,30,1,0,0,2013,NULL),(2445,'2014-04-03',18,20,1,0,0,2013,NULL),(2446,'2014-04-04',11,2,0,0,0,2013,NULL),(2447,'2014-04-04',5,30,0,0,0,2013,NULL),(2448,'2014-04-04',24,25,2,0,0,2013,NULL),(2449,'2014-04-04',13,15,0,0,0,2013,NULL),(2450,'2014-04-04',9,16,0,0,0,2013,'https://youtube.com/watch?v=O12PMb8w8Eg'),(2451,'2014-04-04',3,4,0,0,0,2013,NULL),(2452,'2014-04-04',14,17,0,0,0,2013,'https://youtube.com/watch?v=7HrT-4SVm0I'),(2453,'2014-04-04',23,27,0,0,0,2013,NULL),(2454,'2014-04-04',22,18,2,0,0,2013,'https://youtube.com/watch?v=c5GBB5GCaYg'),(2455,'2014-04-04',29,10,0,0,0,2013,NULL),(2456,'2014-04-04',1,8,0,0,0,2013,NULL),(2457,'2014-04-04',6,21,0,0,0,2013,NULL),(2458,'2014-04-04',26,19,0,0,0,2013,NULL),(2459,'2014-04-04',7,12,0,0,0,2013,'https://youtube.com/watch?v=SU8OnT4B0r4'),(2460,'2014-04-05',8,13,0,0,0,2013,'https://youtube.com/watch?v=RNIWCLGDBxU'),(2461,'2014-04-05',15,1,0,0,0,2013,'https://youtube.com/watch?v=OeiE8EXcL_w'),(2462,'2014-04-05',2,29,0,0,0,2013,'https://youtube.com/watch?v=HuDPjG8GoXM'),(2463,'2014-04-05',12,3,0,0,0,2013,'https://youtube.com/watch?v=gRKp2qCtIbI'),(2464,'2014-04-05',10,17,0,0,0,2013,NULL),(2465,'2014-04-05',4,9,3,0,0,2013,'https://youtube.com/watch?v=i47G7Q66Eb0'),(2466,'2014-04-06',16,11,0,0,0,2013,'https://youtube.com/watch?v=4ZJPVKXoLC4'),(2467,'2014-04-06',19,30,0,0,0,2013,'https://youtube.com/watch?v=Wximp_mHiX8'),(2468,'2014-04-06',22,25,0,0,0,2013,'https://youtube.com/watch?v=4G72nlLokUQ'),(2469,'2014-04-06',28,5,4,0,0,2013,NULL),(2470,'2014-04-06',20,24,3,0,0,2013,'https://youtube.com/watch?v=-ire00aZ3wg'),(2471,'2014-04-06',6,27,0,0,0,2013,NULL),(2472,'2014-04-06',14,7,4,0,0,2013,'https://youtube.com/watch?v=6UhW2UpmSR4'),(2473,'2014-04-06',21,18,0,0,0,2013,'https://youtube.com/watch?v=TxM6Nwn4LCs'),(2474,'2014-04-06',26,23,0,0,0,2013,'https://youtube.com/watch?v=seD5vt6N6Dk'),(2475,'2014-04-08',14,13,1,0,0,2013,'https://youtube.com/watch?v=QC_YIM6KXQA'),(2476,'2014-04-08',11,15,0,0,0,2013,NULL),(2477,'2014-04-08',23,30,0,0,0,2013,'https://youtube.com/watch?v=Cy_sr8pskC0'),(2478,'2014-04-08',5,22,1,0,0,2013,'https://youtube.com/watch?v=1Gr-a64a-LI'),(2479,'2014-04-08',17,20,0,0,0,2013,'https://youtube.com/watch?v=svg07UF6ekc'),(2480,'2014-04-08',19,18,0,0,0,2013,NULL),(2481,'2014-04-09',10,13,0,0,0,2013,NULL),(2482,'2014-04-09',11,1,0,0,0,2013,NULL),(2483,'2014-04-09',12,29,0,0,0,2013,NULL),(2484,'2014-04-09',17,3,0,0,0,2013,NULL),(2485,'2014-04-09',2,15,0,0,0,2013,NULL),(2486,'2014-04-09',25,22,0,0,0,2013,NULL),(2487,'2014-04-09',4,16,0,0,0,2013,NULL),(2488,'2014-04-09',24,14,2,0,0,2013,NULL),(2489,'2014-04-09',28,18,1,0,0,2013,NULL),(2490,'2014-04-09',9,8,0,0,0,2013,NULL),(2491,'2014-04-09',27,21,0,0,0,2013,NULL),(2492,'2014-04-09',6,19,0,0,0,2013,NULL),(2493,'2014-04-10',26,25,1,0,0,2013,NULL),(2494,'2014-04-10',30,20,1,0,0,2013,NULL),(2495,'2014-04-11',13,11,0,0,0,2013,'https://youtube.com/watch?v=rR4-ygf2K_U'),(2496,'2014-04-11',1,29,0,0,0,2013,NULL),(2497,'2014-04-11',4,2,0,0,0,2013,'https://youtube.com/watch?v=TiawCcXCpTI'),(2498,'2014-04-11',3,15,0,0,0,2013,'https://youtube.com/watch?v=6xFxhGjyuWI'),(2499,'2014-04-11',5,26,3,0,0,2013,'https://youtube.com/watch?v=nvU901Vr6pM'),(2500,'2014-04-11',17,22,0,0,0,2013,'https://youtube.com/watch?v=2Av6_NkNUi4'),(2501,'2014-04-11',14,16,3,0,0,2013,'https://youtube.com/watch?v=mgfGzxZ4aW0'),(2502,'2014-04-11',18,27,0,0,0,2013,'https://youtube.com/watch?v=hTOKF7CXuf0'),(2503,'2014-04-11',9,7,0,0,0,2013,'https://youtube.com/watch?v=Fu0whT0nnMg'),(2504,'2014-04-11',24,8,0,0,0,2013,NULL),(2505,'2014-04-11',20,21,0,0,0,2013,'https://youtube.com/watch?v=rhnisXC0n8Y'),(2506,'2014-04-11',23,6,0,0,0,2013,'https://youtube.com/watch?v=X5uSziqRV38'),(2507,'2014-04-11',10,12,0,0,0,2013,NULL),(2508,'2014-04-12',2,1,0,0,0,2013,'https://youtube.com/watch?v=kmpFD4b7mo0'),(2509,'2014-04-12',11,14,0,0,0,2013,'https://youtube.com/watch?v=qMlLPX4DcS4'),(2510,'2014-04-12',12,4,3,0,0,2013,NULL),(2511,'2014-04-12',22,27,0,0,0,2013,'https://youtube.com/watch?v=yLC60fXw83g'),(2512,'2014-04-12',29,8,0,0,0,2013,'https://youtube.com/watch?v=FCqfwC2XiVM'),(2513,'2014-04-12',30,21,0,0,0,2013,'https://youtube.com/watch?v=OaLuSUR3tyg'),(2514,'2014-04-12',28,19,0,0,0,2013,NULL),(2515,'2014-04-12',25,23,0,0,0,2013,NULL),(2516,'2014-04-13',7,3,4,0,0,2013,'https://youtube.com/watch?v=qm6-5i4IZnA'),(2517,'2014-04-13',6,26,0,0,0,2013,'https://youtube.com/watch?v=eogOzzXUpWA'),(2518,'2014-04-13',5,24,3,0,0,2013,'https://youtube.com/watch?v=_8cKzjKDp4g'),(2519,'2014-04-13',19,17,0,0,0,2013,NULL),(2520,'2014-04-13',16,18,3,0,0,2013,'https://youtube.com/watch?v=Dd7Xsppyd20'),(2521,'2014-04-13',13,10,0,0,0,2013,'https://youtube.com/watch?v=5zB-K0fSdCc'),(2522,'2014-04-13',15,9,0,0,0,2013,NULL),(2523,'2014-04-14',8,1,0,0,0,2013,NULL),(2524,'2014-04-14',11,29,0,0,0,2013,NULL),(2525,'2014-04-14',23,5,0,0,0,2013,'https://youtube.com/watch?v=6KA1Qj8dJ3Q'),(2526,'2014-04-14',21,24,0,0,0,2013,'https://youtube.com/watch?v=YgXmfksdW5M'),(2527,'2014-04-14',12,14,0,0,0,2013,'https://youtube.com/watch?v=RIIt7zzczD8'),(2528,'2014-04-14',9,4,0,0,0,2013,NULL),(2529,'2014-04-14',26,17,3,0,0,2013,'https://youtube.com/watch?v=QlyiLLzWf6U'),(2530,'2014-04-14',27,18,0,0,0,2013,NULL),(2531,'2014-04-14',3,10,0,0,0,2013,NULL),(2532,'2014-04-14',22,20,3,0,0,2013,'https://youtube.com/watch?v=Dhofjbdv5y8'),(2533,'2014-04-15',28,25,1,0,0,2013,'https://youtube.com/watch?v=DYPTzx_tOKQ'),(2534,'2014-04-15',13,7,1,0,0,2013,'https://youtube.com/watch?v=z_s6pvpV_UE'),(2535,'2014-04-16',4,11,2,0,0,2013,NULL),(2536,'2014-04-16',2,13,0,0,0,2013,'https://youtube.com/watch?v=iBUiAZ8o15U'),(2537,'2014-04-16',29,3,0,0,0,2013,'https://youtube.com/watch?v=GrT9belg0_w'),(2538,'2014-04-16',18,15,0,0,0,2013,'https://youtube.com/watch?v=hwFqzMOf3MA'),(2539,'2014-04-16',27,22,0,0,0,2013,'https://youtube.com/watch?v=2NCBYzJ2_T8'),(2540,'2014-04-16',10,16,0,0,0,2013,'https://youtube.com/watch?v=3QLsBONNxiQ'),(2541,'2014-04-16',20,5,0,0,0,2013,'https://youtube.com/watch?v=zYrXBvVBWoU'),(2542,'2014-04-16',14,8,0,0,0,2013,'https://youtube.com/watch?v=zRJIblmv89I'),(2543,'2014-04-16',7,9,0,0,0,2013,'https://youtube.com/watch?v=JpTDcTR0TEo'),(2544,'2014-04-16',1,12,0,0,0,2013,'https://youtube.com/watch?v=16lMdIMBkK4'),(2545,'2014-04-16',24,30,0,0,0,2013,'https://youtube.com/watch?v=Inx5t5tId90'),(2546,'2014-04-16',17,23,0,0,0,2013,'https://youtube.com/watch?v=6O2ldbV-fS8'),(2547,'2014-04-16',25,26,2,0,0,2013,'https://youtube.com/watch?v=hj4IkQeMc2s'),(2548,'2014-04-16',6,28,0,0,0,2013,'https://youtube.com/watch?v=QhYJiAAfc6c'),(2549,'2014-04-16',19,21,0,0,0,2013,NULL),(2550,'2014-04-19',9,13,0,1,1,2013,'https://www.youtube.com/watch?v=pjARZNqKO7s'),(2551,'2014-04-19',28,26,0,1,1,2013,'https://www.youtube.com/watch?v=Er3QJKWEWJM'),(2552,'2014-04-19',16,11,0,1,1,2013,'https://www.youtube.com/watch?v=qZvsVL1V5Zo'),(2553,'2014-04-19',18,24,0,1,1,2013,'https://www.youtube.com/watch?v=QH5aS3x-UTw'),(2554,'2014-04-20',20,30,0,1,1,2013,'https://www.youtube.com/watch?v=k3IYIqc6k-I'),(2555,'2014-04-20',14,29,0,1,1,2013,'https://www.youtube.com/watch?v=BPDLGrIQ8us'),(2556,'2014-04-20',3,12,0,1,1,2013,'https://www.youtube.com/watch?v=DF87tq92BrI'),(2557,'2014-04-20',22,6,0,1,1,2013,'https://www.youtube.com/watch?v=9FKcDQLC7dM'),(2558,'2014-04-21',18,24,0,1,2,2013,'https://www.youtube.com/watch?v=Vqip335moNs'),(2559,'2014-04-21',28,26,0,1,2,2013,'https://www.youtube.com/watch?v=sFJhObUs_Ao'),(2560,'2014-04-22',16,11,0,1,2,2013,'https://www.youtube.com/watch?v=KywaoIPn93Q'),(2561,'2014-04-22',9,13,0,1,2,2013,'https://www.youtube.com/watch?v=PJE6OlNnoqU'),(2562,'2014-04-22',3,12,0,1,2,2013,'https://www.youtube.com/watch?v=WBb9ZagF0Zw'),(2563,'2014-04-23',14,29,0,1,2,2013,'https://www.youtube.com/watch?v=DIs403_1PeA'),(2564,'2014-04-23',20,30,0,1,2,2013,'https://www.youtube.com/watch?v=_YjGRXmf2AE'),(2565,'2014-04-23',22,6,0,1,2,2013,'https://www.youtube.com/watch?v=PdfAP8K4lvg'),(2566,'2014-04-24',11,16,0,1,3,2013,'https://www.youtube.com/watch?v=XblCffv77MI'),(2567,'2014-04-24',24,18,0,1,3,2013,'https://www.youtube.com/watch?v=UtMgpVAJZRk'),(2568,'2014-04-24',26,28,0,1,3,2013,'https://www.youtube.com/watch?v=XHG1iQ2JArM'),(2569,'2014-04-25',13,9,0,1,3,2013,'https://www.youtube.com/watch?v=O4Nv5GL9neg'),(2570,'2014-04-25',12,3,0,1,3,2013,'https://www.youtube.com/watch?v=VUMC8ZlpvZo'),(2571,'2014-04-25',6,22,0,1,3,2013,'https://www.youtube.com/watch?v=4VrPYdjPQYM'),(2572,'2014-04-26',11,16,0,1,4,2013,'https://www.youtube.com/watch?v=sEgJSrMh3iI'),(2573,'2014-04-26',30,20,0,1,3,2013,'https://www.youtube.com/watch?v=GyuxZqCQoyI'),(2574,'2014-04-26',29,14,0,1,3,2013,'https://www.youtube.com/watch?v=CR4IWuuA0BQ'),(2575,'2014-04-26',24,18,0,1,4,2013,'https://www.youtube.com/watch?v=NSZooCRWiyM'),(2576,'2014-04-27',12,3,0,1,4,2013,'https://www.youtube.com/watch?v=aIM_-miXL9I'),(2577,'2014-04-27',26,28,0,1,4,2013,'https://www.youtube.com/watch?v=iKF7dEsLiis'),(2578,'2014-04-27',13,9,0,1,4,2013,'https://www.youtube.com/watch?v=II75smD8Mv0'),(2579,'2014-04-27',6,22,0,1,4,2013,'https://www.youtube.com/watch?v=lR8h_f1Vtng'),(2580,'2014-04-28',29,14,0,1,4,2013,'https://www.youtube.com/watch?v=xJp9dnWcCyw'),(2581,'2014-04-28',16,11,0,1,5,2013,'https://www.youtube.com/watch?v=tTTOQc0qsAU'),(2582,'2014-04-28',30,20,0,1,4,2013,'https://www.youtube.com/watch?v=V2YW4UPZH68'),(2583,'2014-04-29',3,12,0,1,5,2013,'https://www.youtube.com/watch?v=6nERKtfnlUo'),(2584,'2014-04-29',18,24,0,1,5,2013,'https://www.youtube.com/watch?v=p20g7il-2MY'),(2585,'2014-04-29',28,26,0,1,5,2013,'https://www.youtube.com/watch?v=YDM1DSTImxs'),(2586,'2014-04-30',20,30,0,1,5,2013,'https://www.youtube.com/watch?v=JrPLlVlF5Lo'),(2587,'2014-04-30',9,13,0,1,5,2013,'https://www.youtube.com/watch?v=VEgkojeUrlI'),(2588,'2014-04-30',22,6,0,1,5,2013,'https://www.youtube.com/watch?v=-6Z09oAu1Qk'),(2589,'2014-05-01',11,16,0,1,6,2013,'https://www.youtube.com/watch?v=chJnoYMoKwI'),(2590,'2014-05-01',24,18,0,1,6,2013,'https://www.youtube.com/watch?v=Fubco2bRvrc'),(2591,'2014-05-01',26,28,0,1,6,2013,'https://www.youtube.com/watch?v=vIMUmwCv3I0'),(2592,'2014-05-02',13,9,0,1,6,2013,'https://www.youtube.com/watch?v=92U763pQJIQ'),(2593,'2014-05-02',30,20,0,1,6,2013,'https://www.youtube.com/watch?v=rFa7YgobReo'),(2594,'2014-05-02',6,22,0,1,6,2013,'https://www.youtube.com/watch?v=MjToZ2JjoqA'),(2595,'2014-05-03',16,11,0,1,7,2013,'https://www.youtube.com/watch?v=EEQ4IGVlGmc'),(2596,'2014-05-03',18,24,0,1,7,2013,'https://www.youtube.com/watch?v=VMQLSm5xBWA'),(2597,'2014-05-03',28,26,0,1,7,2013,'https://www.youtube.com/watch?v=ButrnkOeimA'),(2598,'2014-05-04',9,13,0,1,7,2013,'https://www.youtube.com/watch?v=q1NBuxZ3ZuQ'),(2599,'2014-05-04',20,30,0,1,7,2013,'https://www.youtube.com/watch?v=Az3rYCKYRV4'),(2600,'2014-05-05',16,12,0,2,1,2013,'https://www.youtube.com/watch?v=U_JGifGFJVY'),(2601,'2014-05-05',18,28,0,2,1,2013,'https://www.youtube.com/watch?v=OU4zCLHY7nI'),(2602,'2014-05-06',14,13,0,2,1,2013,'https://www.youtube.com/watch?v=m0GwpTthbBM'),(2603,'2014-05-06',20,6,0,2,1,2013,'https://www.youtube.com/watch?v=9SG1Y5-mVkE'),(2604,'2014-05-07',16,12,0,2,2,2013,'https://www.youtube.com/watch?v=T6PRWLKaqEo'),(2605,'2014-05-07',18,28,0,2,2,2013,'https://www.youtube.com/watch?v=XST6Qw6Jzc0'),(2606,'2014-05-08',14,13,0,2,2,2013,'https://www.youtube.com/watch?v=0I4nhdkjEls'),(2607,'2014-05-08',20,6,0,2,2,2013,'https://www.youtube.com/watch?v=3q0L6O9rRCg'),(2608,'2014-05-09',12,16,0,2,3,2013,'https://www.youtube.com/watch?v=l59l0STSOOQ'),(2609,'2014-05-09',28,18,0,2,3,2013,'https://www.youtube.com/watch?v=z-UMG18yGAs'),(2610,'2014-05-10',13,14,0,2,3,2013,'https://www.youtube.com/watch?v=asFmGkXc3Qw'),(2611,'2014-05-10',6,20,0,2,3,2013,'https://www.youtube.com/watch?v=8Modx-jJ7ck'),(2612,'2014-05-11',28,18,0,2,4,2013,'https://www.youtube.com/watch?v=x2y5vaiVmaY'),(2613,'2014-05-11',12,16,0,2,4,2013,'https://www.youtube.com/watch?v=izodH4etxdE'),(2614,'2014-05-12',13,14,0,2,4,2013,'https://www.youtube.com/watch?v=dATvkfX1yQ0'),(2615,'2014-05-12',6,20,0,2,4,2013,'https://www.youtube.com/watch?v=sE28U3eubxw'),(2616,'2014-05-13',16,12,0,2,5,2013,'https://www.youtube.com/watch?v=c-MZpsPX8rk'),(2617,'2014-05-13',18,28,0,2,5,2013,'https://www.youtube.com/watch?v=__dCnwUGQmk'),(2618,'2014-05-14',14,13,0,2,5,2013,'https://www.youtube.com/watch?v=iSH_i2J1Lfw'),(2619,'2014-05-14',20,6,0,2,5,2013,'https://www.youtube.com/watch?v=zNcofWe-KSM'),(2620,'2014-05-15',12,16,0,2,6,2013,'https://www.youtube.com/watch?v=a73b1BjYMyU'),(2621,'2014-05-15',28,18,0,2,6,2013,'https://www.youtube.com/watch?v=kzYKcAwjGgI'),(2622,'2014-05-18',16,14,0,3,1,2013,'https://www.youtube.com/watch?v=V5ZL_dvYayU'),(2623,'2014-05-19',20,18,0,3,1,2013,'https://www.youtube.com/watch?v=57BUaNrO2Pc'),(2624,'2014-05-20',16,14,0,3,2,2013,'https://www.youtube.com/watch?v=c4aUcpEsD9Q'),(2625,'2014-05-21',20,18,0,3,2,2013,'https://www.youtube.com/watch?v=_FWvsb3hDQI'),(2626,'2014-05-24',14,16,0,3,3,2013,'https://www.youtube.com/watch?v=S8KXeujoZ5Y'),(2627,'2014-05-25',18,20,0,3,3,2013,'https://www.youtube.com/watch?v=48ypz66I4sU'),(2628,'2014-05-26',14,16,0,3,4,2013,'https://www.youtube.com/watch?v=gjMzdI0RsgM'),(2629,'2014-05-27',18,20,0,3,4,2013,'https://www.youtube.com/watch?v=QgY3_DJ5IDI'),(2630,'2014-05-28',16,14,0,3,5,2013,'https://www.youtube.com/watch?v=q1pEn1gfP0E'),(2631,'2014-05-29',20,18,0,3,5,2013,'https://www.youtube.com/watch?v=DMWqqkAQtCc'),(2632,'2014-05-30',14,16,0,3,6,2013,'https://www.youtube.com/watch?v=Bp6132VHObE'),(2633,'2014-05-31',18,20,0,3,6,2013,'https://www.youtube.com/watch?v=b-Qzc4UC0Cw'),(2634,'2014-06-05',20,14,0,4,1,2013,'https://www.youtube.com/watch?v=y0hJ6n_QOnw'),(2635,'2014-06-08',20,14,0,4,2,2013,'https://www.youtube.com/watch?v=Yh8dyYGzsyk'),(2636,'2014-06-10',14,20,0,4,3,2013,'https://www.youtube.com/watch?v=EW4N_JIR7WE'),(2637,'2014-06-12',14,20,0,4,4,2013,'https://www.youtube.com/watch?v=ifyqG8V-K0Y'),(2638,'2014-06-15',20,14,0,4,5,2013,'https://www.youtube.com/watch?v=_ti-NBr2gP0');
/*!40000 ALTER TABLE `game` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `game_quarter`
--

DROP TABLE IF EXISTS `game_quarter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `game_quarter` (
  `game_id` int(11) NOT NULL DEFAULT '0',
  `quarter_id` int(11) NOT NULL DEFAULT '0',
  `home_team_score` int(11) NOT NULL DEFAULT '0',
  `away_team_score` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`game_id`,`quarter_id`),
  KEY `fk_game_quarter_quarter` (`quarter_id`),
  CONSTRAINT `fk_game_quarter_game` FOREIGN KEY (`game_id`) REFERENCES `game` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_game_quarter_quarter` FOREIGN KEY (`quarter_id`) REFERENCES `quarter` (`number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `game_quarter`
--

LOCK TABLES `game_quarter` WRITE;
/*!40000 ALTER TABLE `game_quarter` DISABLE KEYS */;
INSERT INTO `game_quarter` VALUES (1320,1,23,18),(1320,2,17,26),(1320,3,29,20),(1320,4,28,23),(1321,1,17,15),(1321,2,37,18),(1321,3,24,25),(1321,4,29,37),(1322,1,28,30),(1322,2,27,27),(1322,3,20,22),(1322,4,41,24),(1323,1,33,28),(1323,2,20,27),(1323,3,33,24),(1323,4,32,30),(1324,1,27,26),(1324,2,22,22),(1324,3,30,22),(1324,4,19,24),(1325,1,21,26),(1325,2,28,11),(1325,3,22,34),(1325,4,22,16),(1326,1,17,19),(1326,2,28,20),(1326,3,22,22),(1326,4,29,22),(1327,1,25,22),(1327,2,23,23),(1327,3,22,27),(1327,4,20,16),(1328,1,24,14),(1328,2,26,22),(1328,3,16,23),(1328,4,24,36),(1329,1,26,16),(1329,2,33,24),(1329,3,37,23),(1329,4,29,31),(1330,1,18,20),(1330,2,30,7),(1330,3,24,31),(1330,4,29,36),(1331,1,33,14),(1331,2,18,35),(1331,3,34,45),(1331,4,29,16),(1332,1,24,18),(1332,2,32,13),(1332,3,18,33),(1332,4,16,19),(1333,1,29,29),(1333,2,19,28),(1333,3,25,24),(1333,4,25,20),(1334,1,38,27),(1334,2,22,25),(1334,3,27,28),(1334,4,16,23),(1334,5,17,12),(1335,1,30,16),(1335,2,20,30),(1335,3,31,23),(1335,4,23,22),(1336,1,25,22),(1336,2,30,21),(1336,3,26,30),(1336,4,32,29),(1337,1,36,26),(1337,2,32,29),(1337,3,25,25),(1337,4,33,35),(1338,1,26,16),(1338,2,17,22),(1338,3,28,23),(1338,4,11,20),(1339,1,30,23),(1339,2,24,26),(1339,3,21,17),(1339,4,15,18),(1340,1,38,22),(1340,2,23,28),(1340,3,24,22),(1340,4,28,33),(1341,1,17,21),(1341,2,30,20),(1341,3,20,28),(1341,4,28,26),(1341,5,16,13),(1342,1,22,24),(1342,2,23,30),(1342,3,32,25),(1342,4,24,31),(1343,1,27,18),(1343,2,20,29),(1343,3,31,20),(1343,4,23,33),(1344,1,29,16),(1344,2,34,31),(1344,3,20,24),(1344,4,15,34),(1345,1,22,20),(1345,2,31,15),(1345,3,32,25),(1345,4,25,30),(1346,1,34,19),(1346,2,25,20),(1346,3,29,21),(1346,4,12,21),(1347,1,33,21),(1347,2,21,23),(1347,3,20,30),(1347,4,28,35),(1348,1,23,24),(1348,2,27,40),(1348,3,21,27),(1348,4,27,22),(1349,1,23,16),(1349,2,19,25),(1349,3,19,22),(1349,4,24,28),(1350,1,25,24),(1350,2,24,15),(1350,3,30,29),(1350,4,23,27),(1351,1,29,23),(1351,2,14,23),(1351,3,20,16),(1351,4,24,22),(1352,1,33,15),(1352,2,23,26),(1352,3,21,21),(1352,4,28,22),(1353,1,22,34),(1353,2,27,30),(1353,3,33,19),(1353,4,25,21),(1354,1,21,16),(1354,2,22,21),(1354,3,19,18),(1354,4,27,19),(1355,1,24,16),(1355,2,32,24),(1355,3,17,33),(1355,4,20,31),(1356,1,32,16),(1356,2,17,27),(1356,3,24,20),(1356,4,38,36),(1357,1,21,19),(1357,2,29,20),(1357,3,32,35),(1357,4,33,31),(1358,1,27,17),(1358,2,29,19),(1358,3,23,23),(1358,4,19,28),(1359,1,19,25),(1359,2,27,26),(1359,3,19,26),(1359,4,25,20),(1360,1,33,22),(1360,2,29,27),(1360,3,26,27),(1360,4,17,27),(1361,1,22,22),(1361,2,19,16),(1361,3,33,21),(1361,4,33,27),(1362,1,24,21),(1362,2,21,14),(1362,3,18,23),(1362,4,24,19),(1363,1,19,40),(1363,2,30,24),(1363,3,29,29),(1363,4,22,16),(1364,1,21,24),(1364,2,23,21),(1364,3,23,25),(1364,4,36,26),(1365,1,33,27),(1365,2,28,21),(1365,3,26,16),(1365,4,16,29),(1366,1,27,24),(1366,2,19,26),(1366,3,20,22),(1366,4,29,16),(1367,1,22,36),(1367,2,20,30),(1367,3,23,32),(1367,4,25,12),(1368,1,42,25),(1368,2,36,41),(1368,3,26,23),(1368,4,33,29),(1369,1,31,23),(1369,2,24,15),(1369,3,21,23),(1369,4,17,31),(1370,1,32,25),(1370,2,13,29),(1370,3,20,28),(1370,4,35,23),(1371,1,28,31),(1371,2,26,33),(1371,3,22,18),(1371,4,21,20),(1372,1,31,30),(1372,2,19,25),(1372,3,23,29),(1372,4,28,32),(1373,1,14,29),(1373,2,27,9),(1373,3,22,36),(1373,4,28,25),(1374,1,35,22),(1374,2,32,26),(1374,3,27,29),(1374,4,29,27),(1375,1,25,23),(1375,2,25,29),(1375,3,24,26),(1375,4,21,26),(1376,1,28,17),(1376,2,17,24),(1376,3,24,37),(1376,4,29,26),(1377,1,27,24),(1377,2,25,19),(1377,3,26,29),(1377,4,16,30),(1378,1,28,18),(1378,2,26,20),(1378,3,31,23),(1378,4,19,27),(1379,1,25,19),(1379,2,12,24),(1379,3,26,19),(1379,4,34,18),(1380,1,30,23),(1380,2,25,30),(1380,3,28,26),(1380,4,26,25),(1381,1,33,31),(1381,2,24,20),(1381,3,28,24),(1381,4,22,18),(1382,1,28,26),(1382,2,19,24),(1382,3,24,29),(1382,4,22,27),(1383,1,29,20),(1383,2,28,22),(1383,3,15,32),(1383,4,26,16),(1384,1,18,33),(1384,2,23,18),(1384,3,16,28),(1384,4,27,20),(1385,1,29,21),(1385,2,22,32),(1385,3,22,20),(1385,4,26,23),(1386,1,32,18),(1386,2,21,35),(1386,3,23,17),(1386,4,16,20),(1387,1,23,26),(1387,2,27,8),(1387,3,34,28),(1387,4,13,25),(1388,1,27,39),(1388,2,24,21),(1388,3,25,29),(1388,4,26,27),(1389,1,26,26),(1389,2,28,25),(1389,3,29,32),(1389,4,26,24),(1390,1,28,31),(1390,2,24,25),(1390,3,24,17),(1390,4,26,24),(1391,1,19,36),(1391,2,31,28),(1391,3,27,17),(1391,4,21,18),(1392,1,27,33),(1392,2,26,25),(1392,3,20,15),(1392,4,26,26),(1392,5,13,9),(1393,1,24,17),(1393,2,25,29),(1393,3,19,25),(1393,4,21,20),(1394,1,14,28),(1394,2,30,14),(1394,3,33,19),(1394,4,17,18),(1395,1,28,24),(1395,2,27,32),(1395,3,30,25),(1395,4,31,27),(1396,1,35,29),(1396,2,29,18),(1396,3,20,40),(1396,4,30,16),(1397,1,27,20),(1397,2,13,13),(1397,3,24,22),(1397,4,12,19),(1398,1,28,27),(1398,2,27,21),(1398,3,14,18),(1398,4,27,19),(1399,1,22,28),(1399,2,25,23),(1399,3,22,34),(1399,4,22,16),(1400,1,22,20),(1400,2,29,35),(1400,3,25,29),(1400,4,34,35),(1401,1,29,22),(1401,2,25,27),(1401,3,23,17),(1401,4,27,25),(1402,1,22,32),(1402,2,22,14),(1402,3,28,13),(1402,4,19,25),(1403,1,30,18),(1403,2,21,22),(1403,3,27,16),(1403,4,19,17),(1404,1,31,25),(1404,2,28,35),(1404,3,23,20),(1404,4,28,31),(1405,1,19,34),(1405,2,21,21),(1405,3,24,13),(1405,4,19,23),(1406,1,32,29),(1406,2,22,21),(1406,3,36,27),(1406,4,18,13),(1407,1,21,23),(1407,2,25,21),(1407,3,21,28),(1407,4,24,24),(1408,1,26,22),(1408,2,29,24),(1408,3,16,27),(1408,4,23,34),(1409,1,28,22),(1409,2,18,23),(1409,3,26,26),(1409,4,32,23),(1410,1,30,27),(1410,2,23,21),(1410,3,22,37),(1410,4,32,22),(1410,5,9,9),(1410,6,11,9),(1411,1,18,21),(1411,2,20,24),(1411,3,16,24),(1411,4,31,27),(1412,1,30,16),(1412,2,32,20),(1412,3,29,24),(1412,4,24,31),(1413,1,23,47),(1413,2,25,20),(1413,3,28,23),(1413,4,14,23),(1414,1,19,16),(1414,2,23,22),(1414,3,29,27),(1414,4,30,29),(1415,1,17,35),(1415,2,28,26),(1415,3,15,29),(1415,4,29,30),(1416,1,27,24),(1416,2,10,18),(1416,3,28,31),(1416,4,31,23),(1416,5,10,9),(1417,1,29,26),(1417,2,25,20),(1417,3,16,34),(1417,4,24,23),(1418,1,20,17),(1418,2,25,19),(1418,3,19,24),(1418,4,32,21),(1419,1,26,20),(1419,2,19,26),(1419,3,23,24),(1419,4,13,30),(1420,1,34,30),(1420,2,24,25),(1420,3,25,23),(1420,4,26,25),(1421,1,23,16),(1421,2,23,23),(1421,3,26,16),(1421,4,23,24),(1422,1,23,26),(1422,2,36,32),(1422,3,26,22),(1422,4,24,27),(1423,1,31,25),(1423,2,28,25),(1423,3,28,24),(1423,4,33,31),(1424,1,13,31),(1424,2,25,26),(1424,3,26,26),(1424,4,21,26),(1425,1,24,20),(1425,2,23,13),(1425,3,24,29),(1425,4,16,25),(1425,5,8,8),(1425,6,15,9),(1426,1,35,16),(1426,2,27,25),(1426,3,32,30),(1426,4,19,24),(1427,1,32,23),(1427,2,24,22),(1427,3,28,17),(1427,4,34,33),(1428,1,22,19),(1428,2,33,20),(1428,3,31,23),(1428,4,30,33),(1429,1,33,34),(1429,2,28,15),(1429,3,27,30),(1429,4,17,16),(1430,1,23,19),(1430,2,29,21),(1430,3,28,19),(1430,4,27,27),(1431,1,21,27),(1431,2,22,24),(1431,3,21,20),(1431,4,19,18),(1432,1,38,24),(1432,2,32,23),(1432,3,38,29),(1432,4,16,19),(1433,1,28,31),(1433,2,32,26),(1433,3,20,33),(1433,4,26,16),(1433,5,17,11),(1434,1,33,28),(1434,2,27,26),(1434,3,23,25),(1434,4,28,20),(1435,1,23,36),(1435,2,22,18),(1435,3,27,20),(1435,4,22,17),(1436,1,22,29),(1436,2,23,26),(1436,3,28,22),(1436,4,38,28),(1437,1,24,29),(1437,2,21,26),(1437,3,23,10),(1437,4,23,30),(1438,1,25,33),(1438,2,28,29),(1438,3,30,16),(1438,4,28,25),(1439,1,25,22),(1439,2,16,21),(1439,3,21,25),(1439,4,28,21),(1440,1,20,26),(1440,2,24,29),(1440,3,27,23),(1440,4,16,25),(1441,1,25,17),(1441,2,27,25),(1441,3,18,15),(1441,4,22,22),(1442,1,23,28),(1442,2,29,25),(1442,3,20,22),(1442,4,34,34),(1443,1,32,33),(1443,2,30,29),(1443,3,33,24),(1443,4,21,29),(1444,1,29,18),(1444,2,21,28),(1444,3,17,27),(1444,4,25,19),(1444,5,6,8),(1445,1,18,12),(1445,2,19,21),(1445,3,21,24),(1445,4,22,29),(1446,1,16,27),(1446,2,15,18),(1446,3,23,29),(1446,4,26,22),(1447,1,31,32),(1447,2,29,19),(1447,3,26,27),(1447,4,24,26),(1448,1,21,27),(1448,2,30,27),(1448,3,19,26),(1448,4,20,17),(1449,1,17,24),(1449,2,23,16),(1449,3,26,23),(1449,4,20,26),(1450,1,31,21),(1450,2,21,16),(1450,3,23,24),(1450,4,29,16),(1451,1,35,26),(1451,2,21,34),(1451,3,30,21),(1451,4,31,32),(1452,1,25,17),(1452,2,29,39),(1452,3,28,17),(1452,4,31,30),(1453,1,21,23),(1453,2,30,34),(1453,3,27,33),(1453,4,18,19),(1454,1,29,16),(1454,2,17,25),(1454,3,21,19),(1454,4,15,31),(1455,1,26,24),(1455,2,21,30),(1455,3,22,26),(1455,4,21,30),(1456,1,29,26),(1456,2,25,29),(1456,3,22,20),(1456,4,34,28),(1457,1,33,24),(1457,2,22,26),(1457,3,34,20),(1457,4,17,18),(1458,1,25,18),(1458,2,24,26),(1458,3,20,20),(1458,4,21,26),(1458,5,6,13),(1459,1,24,31),(1459,2,22,28),(1459,3,34,28),(1459,4,20,21),(1460,1,33,23),(1460,2,30,23),(1460,3,27,29),(1460,4,32,36),(1461,1,31,20),(1461,2,29,15),(1461,3,24,24),(1461,4,26,35),(1462,1,16,26),(1462,2,25,19),(1462,3,19,23),(1462,4,21,29),(1463,1,23,23),(1463,2,17,17),(1463,3,25,32),(1463,4,14,20),(1464,1,34,22),(1464,2,33,24),(1464,3,36,20),(1464,4,32,32),(1465,1,27,13),(1465,2,24,21),(1465,3,23,29),(1465,4,28,25),(1466,1,27,29),(1466,2,23,27),(1466,3,29,15),(1466,4,35,28),(1467,1,18,25),(1467,2,16,22),(1467,3,31,27),(1467,4,21,23),(1468,1,29,31),(1468,2,25,26),(1468,3,15,22),(1468,4,33,23),(1468,5,8,16),(1469,1,26,21),(1469,2,14,23),(1469,3,22,15),(1469,4,24,22),(1470,1,28,39),(1470,2,32,24),(1470,3,23,29),(1470,4,32,21),(1471,1,19,22),(1471,2,17,37),(1471,3,29,19),(1471,4,22,20),(1472,1,20,29),(1472,2,31,23),(1472,3,30,29),(1472,4,21,25),(1473,1,18,21),(1473,2,25,26),(1473,3,31,24),(1473,4,23,23),(1474,1,40,31),(1474,2,23,25),(1474,3,15,27),(1474,4,20,25),(1475,1,24,25),(1475,2,24,20),(1475,3,30,23),(1475,4,26,20),(1476,1,40,18),(1476,2,28,26),(1476,3,20,13),(1476,4,21,28),(1477,1,27,34),(1477,2,24,29),(1477,3,30,18),(1477,4,23,19),(1478,1,26,24),(1478,2,17,19),(1478,3,28,20),(1478,4,21,23),(1479,1,33,25),(1479,2,21,37),(1479,3,28,26),(1479,4,25,16),(1480,1,30,29),(1480,2,23,21),(1480,3,30,20),(1480,4,12,21),(1481,1,22,25),(1481,2,26,23),(1481,3,32,22),(1481,4,24,23),(1482,1,15,13),(1482,2,28,33),(1482,3,23,18),(1482,4,27,21),(1483,1,29,40),(1483,2,32,28),(1483,3,26,33),(1483,4,36,19),(1484,1,19,14),(1484,2,23,23),(1484,3,20,21),(1484,4,27,31),(1484,5,7,14),(1485,1,24,24),(1485,2,22,22),(1485,3,21,25),(1485,4,31,31),(1486,1,26,16),(1486,2,18,18),(1486,3,13,25),(1486,4,18,16),(1486,5,6,13),(1487,1,20,25),(1487,2,29,29),(1487,3,22,36),(1487,4,21,30),(1488,1,24,23),(1488,2,27,30),(1488,3,13,17),(1488,4,18,21),(1489,1,27,27),(1489,2,23,28),(1489,3,12,19),(1489,4,44,39),(1490,1,25,25),(1490,2,23,30),(1490,3,29,38),(1490,4,21,15),(1491,1,20,17),(1491,2,25,24),(1491,3,28,28),(1491,4,32,29),(1492,1,19,30),(1492,2,19,26),(1492,3,21,24),(1492,4,32,18),(1493,1,24,25),(1493,2,26,23),(1493,3,20,14),(1493,4,27,25),(1494,1,28,22),(1494,2,23,21),(1494,3,30,29),(1494,4,24,19),(1495,1,22,27),(1495,2,22,22),(1495,3,24,24),(1495,4,21,23),(1496,1,30,14),(1496,2,27,23),(1496,3,33,21),(1496,4,21,23),(1497,1,22,32),(1497,2,22,27),(1497,3,34,12),(1497,4,20,24),(1498,1,21,20),(1498,2,21,31),(1498,3,28,20),(1498,4,34,29),(1499,1,22,21),(1499,2,33,25),(1499,3,20,17),(1499,4,27,32),(1500,1,25,22),(1500,2,25,20),(1500,3,8,25),(1500,4,24,30),(1501,1,28,20),(1501,2,27,33),(1501,3,20,20),(1501,4,27,29),(1501,5,13,5),(1502,1,24,27),(1502,2,20,28),(1502,3,19,19),(1502,4,28,24),(1503,1,21,26),(1503,2,16,25),(1503,3,28,20),(1503,4,21,31),(1504,1,31,18),(1504,2,27,16),(1504,3,22,30),(1504,4,23,29),(1505,1,32,27),(1505,2,19,11),(1505,3,15,32),(1505,4,30,18),(1506,1,24,25),(1506,2,29,24),(1506,3,21,15),(1506,4,13,30),(1507,1,21,25),(1507,2,18,21),(1507,3,12,28),(1507,4,21,22),(1508,1,30,21),(1508,2,35,11),(1508,3,31,35),(1508,4,30,29),(1509,1,35,22),(1509,2,30,31),(1509,3,21,27),(1509,4,16,20),(1510,1,25,18),(1510,2,30,24),(1510,3,27,32),(1510,4,30,27),(1511,1,26,27),(1511,2,23,25),(1511,3,27,17),(1511,4,22,20),(1512,1,16,20),(1512,2,23,35),(1512,3,32,22),(1512,4,30,22),(1513,1,25,22),(1513,2,31,30),(1513,3,21,14),(1513,4,29,32),(1514,1,24,23),(1514,2,30,26),(1514,3,30,32),(1514,4,17,32),(1515,1,29,13),(1515,2,28,35),(1515,3,18,21),(1515,4,28,33),(1516,1,31,24),(1516,2,34,28),(1516,3,31,21),(1516,4,25,9),(1517,1,19,23),(1517,2,32,21),(1517,3,15,34),(1517,4,31,31),(1518,1,21,31),(1518,2,23,22),(1518,3,28,27),(1518,4,24,24),(1519,1,29,24),(1519,2,26,24),(1519,3,18,13),(1519,4,27,25),(1520,1,22,13),(1520,2,25,17),(1520,3,28,13),(1520,4,20,30),(1521,1,21,14),(1521,2,17,33),(1521,3,28,21),(1521,4,20,28),(1522,1,23,18),(1522,2,17,14),(1522,3,24,24),(1522,4,14,22),(1522,5,11,5),(1523,1,27,32),(1523,2,24,24),(1523,3,26,29),(1523,4,19,25),(1524,1,24,20),(1524,2,20,12),(1524,3,19,23),(1524,4,23,38),(1525,1,38,18),(1525,2,27,16),(1525,3,27,32),(1525,4,21,28),(1526,1,28,24),(1526,2,20,22),(1526,3,25,22),(1526,4,25,16),(1527,1,27,24),(1527,2,30,16),(1527,3,34,25),(1527,4,21,28),(1528,1,34,18),(1528,2,22,21),(1528,3,25,30),(1528,4,21,22),(1529,1,24,21),(1529,2,26,26),(1529,3,29,24),(1529,4,28,21),(1530,1,28,26),(1530,2,23,29),(1530,3,25,26),(1530,4,24,21),(1531,1,18,28),(1531,2,31,29),(1531,3,28,19),(1531,4,24,26),(1532,1,31,29),(1532,2,28,26),(1532,3,23,22),(1532,4,34,34),(1533,1,25,26),(1533,2,28,23),(1533,3,20,36),(1533,4,19,24),(1534,1,30,19),(1534,2,26,26),(1534,3,21,22),(1534,4,36,17),(1535,1,29,25),(1535,2,24,26),(1535,3,15,25),(1535,4,11,23),(1536,1,27,28),(1536,2,28,36),(1536,3,28,26),(1536,4,27,27),(1537,1,28,22),(1537,2,27,24),(1537,3,27,25),(1537,4,21,28),(1538,1,11,22),(1538,2,27,21),(1538,3,14,17),(1538,4,22,39),(1539,1,18,34),(1539,2,22,20),(1539,3,28,23),(1539,4,26,22),(1540,1,13,27),(1540,2,23,22),(1540,3,23,20),(1540,4,34,31),(1541,1,28,22),(1541,2,14,27),(1541,3,18,21),(1541,4,24,25),(1542,1,29,27),(1542,2,20,18),(1542,3,25,23),(1542,4,19,12),(1543,1,33,27),(1543,2,22,23),(1543,3,22,23),(1543,4,28,21),(1544,1,21,32),(1544,2,40,26),(1544,3,29,18),(1544,4,30,30),(1545,1,19,21),(1545,2,24,25),(1545,3,25,15),(1545,4,26,27),(1546,1,23,25),(1546,2,25,24),(1546,3,20,22),(1546,4,19,16),(1546,5,5,13),(1547,1,33,17),(1547,2,33,23),(1547,3,26,22),(1547,4,22,33),(1548,1,28,10),(1548,2,27,29),(1548,3,24,19),(1548,4,24,28),(1549,1,23,28),(1549,2,16,25),(1549,3,25,22),(1549,4,24,12),(1550,1,32,28),(1550,2,22,23),(1550,3,22,31),(1550,4,28,22),(1550,5,9,8),(1551,1,24,23),(1551,2,21,27),(1551,3,27,23),(1551,4,22,21),(1551,5,4,10),(1552,1,32,31),(1552,2,23,25),(1552,3,32,21),(1552,4,15,29),(1553,1,22,27),(1553,2,21,30),(1553,3,27,21),(1553,4,13,12),(1554,1,24,20),(1554,2,27,21),(1554,3,20,18),(1554,4,21,17),(1555,1,30,35),(1555,2,25,26),(1555,3,22,26),(1555,4,28,34),(1556,1,30,20),(1556,2,21,25),(1556,3,24,22),(1556,4,22,28),(1557,1,33,31),(1557,2,18,31),(1557,3,27,33),(1557,4,23,17),(1558,1,24,29),(1558,2,21,34),(1558,3,25,18),(1558,4,21,28),(1559,1,28,14),(1559,2,15,22),(1559,3,26,20),(1559,4,24,17),(1560,1,28,20),(1560,2,26,24),(1560,3,25,26),(1560,4,29,31),(1561,1,19,24),(1561,2,18,24),(1561,3,28,25),(1561,4,23,24),(1562,1,19,27),(1562,2,28,14),(1562,3,23,22),(1562,4,22,22),(1563,1,27,25),(1563,2,29,26),(1563,3,21,15),(1563,4,20,27),(1564,1,24,30),(1564,2,22,27),(1564,3,34,26),(1564,4,26,29),(1565,1,24,29),(1565,2,23,25),(1565,3,30,30),(1565,4,29,28),(1566,1,23,28),(1566,2,30,21),(1566,3,24,29),(1566,4,27,34),(1567,1,24,21),(1567,2,23,27),(1567,3,14,25),(1567,4,38,25),(1568,1,31,25),(1568,2,14,22),(1568,3,27,29),(1568,4,26,36),(1569,1,26,24),(1569,2,27,32),(1569,3,27,34),(1569,4,33,25),(1570,1,22,29),(1570,2,25,24),(1570,3,27,31),(1570,4,26,21),(1571,1,26,32),(1571,2,29,26),(1571,3,23,25),(1571,4,35,20),(1572,1,20,16),(1572,2,29,28),(1572,3,25,32),(1572,4,25,27),(1573,1,40,25),(1573,2,30,21),(1573,3,24,36),(1573,4,21,18),(1574,1,24,32),(1574,2,26,21),(1574,3,24,41),(1574,4,34,20),(1575,1,25,23),(1575,2,25,26),(1575,3,23,22),(1575,4,29,29),(1576,1,36,23),(1576,2,17,27),(1576,3,29,24),(1576,4,27,29),(1577,1,20,23),(1577,2,25,23),(1577,3,27,26),(1577,4,34,30),(1578,1,21,24),(1578,2,35,26),(1578,3,24,27),(1578,4,23,26),(1578,5,6,6),(1578,6,13,13),(1578,7,6,9),(1579,1,22,22),(1579,2,30,19),(1579,3,23,20),(1579,4,23,19),(1580,1,22,18),(1580,2,17,24),(1580,3,21,25),(1580,4,29,15),(1581,1,29,27),(1581,2,21,31),(1581,3,15,31),(1581,4,22,22),(1582,1,18,28),(1582,2,25,26),(1582,3,25,28),(1582,4,29,25),(1583,1,28,23),(1583,2,20,18),(1583,3,21,22),(1583,4,39,37),(1584,1,31,19),(1584,2,16,31),(1584,3,18,28),(1584,4,30,19),(1585,1,29,34),(1585,2,29,23),(1585,3,27,23),(1585,4,19,24),(1585,5,14,14),(1585,6,8,7),(1586,1,23,19),(1586,2,23,35),(1586,3,36,20),(1586,4,28,17),(1587,1,19,36),(1587,2,29,29),(1587,3,22,23),(1587,4,42,15),(1588,1,24,27),(1588,2,29,25),(1588,3,24,23),(1588,4,20,25),(1589,1,31,24),(1589,2,25,28),(1589,3,23,21),(1589,4,19,15),(1590,1,19,26),(1590,2,31,19),(1590,3,17,35),(1590,4,31,25),(1591,1,23,17),(1591,2,25,30),(1591,3,19,21),(1591,4,19,27),(1592,1,29,21),(1592,2,26,23),(1592,3,24,26),(1592,4,28,27),(1593,1,25,27),(1593,2,23,32),(1593,3,35,21),(1593,4,28,24),(1594,1,20,25),(1594,2,20,26),(1594,3,21,22),(1594,4,27,24),(1595,1,20,18),(1595,2,22,22),(1595,3,11,24),(1595,4,28,37),(1596,1,29,20),(1596,2,29,24),(1596,3,27,19),(1596,4,22,24),(1597,1,23,29),(1597,2,20,21),(1597,3,16,34),(1597,4,24,29),(1598,1,37,20),(1598,2,26,23),(1598,3,19,21),(1598,4,26,25),(1599,1,39,15),(1599,2,25,29),(1599,3,23,33),(1599,4,19,21),(1600,1,31,12),(1600,2,30,25),(1600,3,26,29),(1600,4,18,17),(1601,1,30,28),(1601,2,25,24),(1601,3,32,29),(1601,4,13,25),(1602,1,30,34),(1602,2,13,22),(1602,3,31,22),(1602,4,28,24),(1602,5,3,7),(1603,1,26,24),(1603,2,26,34),(1603,3,16,22),(1603,4,27,29),(1604,1,28,31),(1604,2,31,23),(1604,3,30,15),(1604,4,32,14),(1605,1,36,33),(1605,2,26,18),(1605,3,22,21),(1605,4,21,16),(1606,1,27,27),(1606,2,25,23),(1606,3,29,24),(1606,4,25,23),(1607,1,39,22),(1607,2,28,34),(1607,3,40,13),(1607,4,23,29),(1608,1,18,20),(1608,2,22,19),(1608,3,19,26),(1608,4,23,25),(1609,1,30,28),(1609,2,23,27),(1609,3,23,24),(1609,4,30,29),(1610,1,27,25),(1610,2,26,24),(1610,3,24,28),(1610,4,15,26),(1611,1,24,25),(1611,2,23,22),(1611,3,9,24),(1611,4,19,21),(1612,1,19,29),(1612,2,24,20),(1612,3,17,28),(1612,4,22,31),(1613,1,28,20),(1613,2,20,32),(1613,3,17,35),(1613,4,35,24),(1614,1,29,23),(1614,2,21,26),(1614,3,17,17),(1614,4,21,16),(1615,1,25,24),(1615,2,17,31),(1615,3,18,21),(1615,4,22,27),(1616,1,24,23),(1616,2,26,24),(1616,3,20,27),(1616,4,27,23),(1616,5,5,15),(1617,1,11,34),(1617,2,20,24),(1617,3,25,34),(1617,4,17,22),(1618,1,28,18),(1618,2,28,19),(1618,3,34,32),(1618,4,28,25),(1619,1,21,29),(1619,2,32,30),(1619,3,17,32),(1619,4,25,19),(1620,1,28,18),(1620,2,24,20),(1620,3,31,23),(1620,4,15,27),(1621,1,20,30),(1621,2,27,21),(1621,3,21,22),(1621,4,26,33),(1622,1,34,23),(1622,2,23,24),(1622,3,35,26),(1622,4,20,24),(1623,1,22,18),(1623,2,23,22),(1623,3,15,18),(1623,4,14,17),(1624,1,27,21),(1624,2,26,20),(1624,3,30,36),(1624,4,32,34),(1625,1,17,23),(1625,2,19,21),(1625,3,24,32),(1625,4,23,18),(1626,1,23,16),(1626,2,28,14),(1626,3,22,30),(1626,4,21,25),(1627,1,22,22),(1627,2,23,29),(1627,3,19,26),(1627,4,30,28),(1628,1,31,20),(1628,2,25,27),(1628,3,29,25),(1628,4,19,24),(1629,1,19,30),(1629,2,21,17),(1629,3,28,17),(1629,4,22,20),(1630,1,14,20),(1630,2,28,15),(1630,3,15,20),(1630,4,17,23),(1631,1,32,33),(1631,2,19,31),(1631,3,26,32),(1631,4,17,25),(1632,1,31,19),(1632,2,17,26),(1632,3,33,20),(1632,4,28,29),(1633,1,21,21),(1633,2,18,27),(1633,3,29,28),(1633,4,24,25),(1634,1,21,26),(1634,2,30,30),(1634,3,23,23),(1634,4,34,35),(1635,1,36,24),(1635,2,17,35),(1635,3,21,30),(1635,4,29,27),(1636,1,15,17),(1636,2,31,15),(1636,3,22,22),(1636,4,15,24),(1637,1,16,23),(1637,2,28,32),(1637,3,22,17),(1637,4,29,21),(1638,1,29,28),(1638,2,28,23),(1638,3,26,23),(1638,4,13,22),(1638,5,15,10),(1639,1,23,20),(1639,2,22,19),(1639,3,19,27),(1639,4,24,30),(1640,1,22,25),(1640,2,20,32),(1640,3,31,32),(1640,4,27,27),(1641,1,18,16),(1641,2,24,27),(1641,3,20,24),(1641,4,21,25),(1642,1,20,39),(1642,2,28,22),(1642,3,30,20),(1642,4,28,18),(1643,1,16,32),(1643,2,24,31),(1643,3,14,29),(1643,4,23,17),(1644,1,23,26),(1644,2,23,32),(1644,3,26,38),(1644,4,29,26),(1645,1,21,20),(1645,2,22,24),(1645,3,33,32),(1645,4,35,28),(1646,1,20,25),(1646,2,36,19),(1646,3,27,18),(1646,4,19,31),(1647,1,23,24),(1647,2,38,20),(1647,3,25,24),(1647,4,17,31),(1648,1,27,25),(1648,2,29,30),(1648,3,23,21),(1648,4,20,18),(1649,1,18,26),(1649,2,33,21),(1649,3,18,15),(1649,4,21,29),(1650,1,28,19),(1650,2,23,31),(1650,3,25,23),(1650,4,24,36),(1651,1,29,30),(1651,2,22,28),(1651,3,22,24),(1651,4,39,34),(1652,1,38,28),(1652,2,28,23),(1652,3,28,23),(1652,4,28,23),(1653,1,26,34),(1653,2,29,20),(1653,3,27,11),(1653,4,22,33),(1654,1,27,30),(1654,2,35,24),(1654,3,18,35),(1654,4,37,21),(1655,1,29,26),(1655,2,25,22),(1655,3,14,25),(1655,4,22,13),(1656,1,36,21),(1656,2,20,27),(1656,3,27,28),(1656,4,25,24),(1657,1,28,34),(1657,2,30,27),(1657,3,27,21),(1657,4,31,25),(1658,1,28,33),(1658,2,16,20),(1658,3,31,20),(1658,4,18,30),(1659,1,21,19),(1659,2,27,27),(1659,3,23,15),(1659,4,15,25),(1659,5,15,13),(1660,1,26,22),(1660,2,31,26),(1660,3,24,29),(1660,4,30,29),(1661,1,35,29),(1661,2,33,23),(1661,3,16,28),(1661,4,30,27),(1662,1,28,34),(1662,2,18,25),(1662,3,31,30),(1662,4,20,24),(1663,1,23,22),(1663,2,20,22),(1663,3,25,20),(1663,4,17,24),(1664,1,38,26),(1664,2,21,15),(1664,3,34,20),(1664,4,13,32),(1665,1,34,32),(1665,2,30,39),(1665,3,15,40),(1665,4,26,28),(1666,1,17,23),(1666,2,23,32),(1666,3,26,25),(1666,4,18,20),(1667,1,21,24),(1667,2,20,27),(1667,3,25,22),(1667,4,11,26),(1668,1,33,27),(1668,2,26,26),(1668,3,22,27),(1668,4,25,22),(1669,1,28,28),(1669,2,29,21),(1669,3,24,22),(1669,4,25,20),(1670,1,17,28),(1670,2,29,28),(1670,3,27,21),(1670,4,20,24),(1671,1,24,27),(1671,2,28,25),(1671,3,23,16),(1671,4,27,25),(1672,1,28,22),(1672,2,28,27),(1672,3,27,22),(1672,4,18,27),(1673,1,22,29),(1673,2,29,21),(1673,3,33,23),(1673,4,15,26),(1673,5,10,12),(1674,1,28,31),(1674,2,21,25),(1674,3,24,23),(1674,4,23,22),(1675,1,20,28),(1675,2,27,26),(1675,3,35,19),(1675,4,32,27),(1676,1,29,21),(1676,2,22,29),(1676,3,23,19),(1676,4,27,28),(1677,1,14,21),(1677,2,21,22),(1677,3,24,24),(1677,4,23,16),(1678,1,32,22),(1678,2,26,26),(1678,3,42,25),(1678,4,30,21),(1679,1,21,28),(1679,2,34,21),(1679,3,23,21),(1679,4,37,22),(1680,1,26,20),(1680,2,21,30),(1680,3,36,21),(1680,4,34,23),(1681,1,21,26),(1681,2,21,27),(1681,3,35,22),(1681,4,24,27),(1682,1,24,34),(1682,2,23,18),(1682,3,20,15),(1682,4,25,29),(1683,1,26,19),(1683,2,31,20),(1683,3,31,26),(1683,4,16,28),(1684,1,24,29),(1684,2,20,23),(1684,3,21,23),(1684,4,28,30),(1685,1,28,26),(1685,2,31,29),(1685,3,29,37),(1685,4,28,27),(1686,1,35,22),(1686,2,21,21),(1686,3,22,29),(1686,4,17,15),(1687,1,15,18),(1687,2,32,19),(1687,3,23,33),(1687,4,25,25),(1687,5,7,9),(1688,1,24,16),(1688,2,33,30),(1688,3,26,20),(1688,4,26,28),(1689,1,42,23),(1689,2,21,29),(1689,3,18,28),(1689,4,25,27),(1690,1,22,26),(1690,2,19,26),(1690,3,30,24),(1690,4,26,18),(1691,1,27,21),(1691,2,25,18),(1691,3,26,27),(1691,4,27,25),(1692,1,27,22),(1692,2,25,23),(1692,3,26,20),(1692,4,30,30),(1693,1,22,24),(1693,2,22,21),(1693,3,22,23),(1693,4,21,19),(1693,5,7,7),(1693,6,7,13),(1694,1,31,22),(1694,2,38,21),(1694,3,29,35),(1694,4,22,31),(1695,1,34,29),(1695,2,24,30),(1695,3,23,28),(1695,4,20,21),(1696,1,28,26),(1696,2,25,28),(1696,3,32,33),(1696,4,39,20),(1697,1,20,27),(1697,2,19,22),(1697,3,23,19),(1697,4,20,18),(1698,1,28,30),(1698,2,25,29),(1698,3,24,26),(1698,4,30,28),(1699,1,35,24),(1699,2,20,28),(1699,3,29,20),(1699,4,23,23),(1700,1,23,18),(1700,2,28,35),(1700,3,23,29),(1700,4,28,22),(1701,1,29,31),(1701,2,31,26),(1701,3,22,26),(1701,4,26,25),(1701,5,13,12),(1702,1,31,22),(1702,2,28,22),(1702,3,30,31),(1702,4,17,41),(1703,1,25,20),(1703,2,31,25),(1703,3,31,20),(1703,4,27,16),(1704,1,25,26),(1704,2,22,21),(1704,3,23,23),(1704,4,26,26),(1704,5,18,15),(1705,1,35,26),(1705,2,16,27),(1705,3,30,23),(1705,4,23,15),(1706,1,28,20),(1706,2,34,28),(1706,3,20,24),(1706,4,17,31),(1707,1,33,36),(1707,2,34,25),(1707,3,31,21),(1707,4,24,21),(1708,1,33,22),(1708,2,19,27),(1708,3,29,29),(1708,4,20,23),(1708,5,7,8),(1709,1,30,16),(1709,2,25,18),(1709,3,30,24),(1709,4,33,27),(1710,1,33,26),(1710,2,27,17),(1710,3,21,22),(1710,4,19,19),(1711,1,38,25),(1711,2,25,33),(1711,3,28,24),(1711,4,32,26),(1712,1,28,18),(1712,2,28,25),(1712,3,23,17),(1712,4,33,31),(1713,1,24,33),(1713,2,29,28),(1713,3,18,25),(1713,4,26,28),(1714,1,27,26),(1714,2,19,16),(1714,3,26,15),(1714,4,30,26),(1715,1,22,25),(1715,2,18,25),(1715,3,21,22),(1715,4,26,23),(1716,1,21,26),(1716,2,31,27),(1716,3,31,25),(1716,4,27,29),(1717,1,21,21),(1717,2,29,40),(1717,3,26,24),(1717,4,24,28),(1718,1,29,23),(1718,2,30,26),(1718,3,26,23),(1718,4,31,34),(1719,1,31,25),(1719,2,27,31),(1719,3,19,19),(1719,4,23,30),(1720,1,21,17),(1720,2,25,25),(1720,3,20,28),(1720,4,19,18),(1721,1,30,14),(1721,2,21,30),(1721,3,25,30),(1721,4,23,32),(1722,1,20,17),(1722,2,32,20),(1722,3,28,21),(1722,4,26,21),(1723,1,24,24),(1723,2,32,30),(1723,3,27,31),(1723,4,23,21),(1723,5,14,10),(1724,1,21,25),(1724,2,35,37),(1724,3,28,13),(1724,4,14,29),(1725,1,33,23),(1725,2,17,31),(1725,3,27,30),(1725,4,34,27),(1725,5,10,8),(1726,1,26,20),(1726,2,31,30),(1726,3,21,36),(1726,4,26,25),(1727,1,18,28),(1727,2,22,30),(1727,3,24,31),(1727,4,28,26),(1728,1,22,30),(1728,2,21,17),(1728,3,23,17),(1728,4,15,25),(1729,1,17,19),(1729,2,22,26),(1729,3,19,30),(1729,4,28,28),(1730,1,28,24),(1730,2,36,27),(1730,3,26,17),(1730,4,27,22),(1731,1,17,33),(1731,2,35,21),(1731,3,26,24),(1731,4,23,23),(1731,5,10,9),(1732,1,27,28),(1732,2,25,24),(1732,3,25,25),(1732,4,23,36),(1733,1,27,29),(1733,2,14,36),(1733,3,35,19),(1733,4,22,19),(1734,1,25,26),(1734,2,30,23),(1734,3,23,23),(1734,4,34,27),(1735,1,27,21),(1735,2,26,27),(1735,3,24,23),(1735,4,27,23),(1736,1,23,21),(1736,2,15,20),(1736,3,20,36),(1736,4,20,18),(1737,1,25,40),(1737,2,26,20),(1737,3,24,23),(1737,4,23,28),(1738,1,22,30),(1738,2,29,23),(1738,3,24,25),(1738,4,30,25),(1739,1,27,21),(1739,2,19,30),(1739,3,28,25),(1739,4,21,25),(1740,1,29,35),(1740,2,17,25),(1740,3,21,27),(1740,4,27,36),(1741,1,27,26),(1741,2,21,24),(1741,3,24,26),(1741,4,23,19),(1741,5,13,13),(1741,6,17,19),(1742,1,19,14),(1742,2,28,32),(1742,3,29,27),(1742,4,25,28),(1742,5,15,11),(1743,1,26,23),(1743,2,19,30),(1743,3,21,19),(1743,4,34,20),(1744,1,20,27),(1744,2,31,31),(1744,3,26,26),(1744,4,30,32),(1745,1,34,25),(1745,2,24,20),(1745,3,23,21),(1745,4,24,23),(1746,1,26,21),(1746,2,29,27),(1746,3,30,18),(1746,4,24,26),(1747,1,25,23),(1747,2,30,29),(1747,3,28,29),(1747,4,22,22),(1748,1,19,32),(1748,2,26,23),(1748,3,29,18),(1748,4,15,16),(1748,5,19,14),(1749,1,31,18),(1749,2,17,19),(1749,3,28,23),(1749,4,28,33),(1750,1,20,21),(1750,2,16,21),(1750,3,24,20),(1750,4,25,27),(1751,1,28,22),(1751,2,31,18),(1751,3,26,24),(1751,4,30,22),(1752,1,25,18),(1752,2,24,22),(1752,3,22,26),(1752,4,12,29),(1753,1,22,23),(1753,2,39,24),(1753,3,27,27),(1753,4,32,24),(1754,1,29,27),(1754,2,29,29),(1754,3,28,20),(1754,4,19,15),(1755,1,25,22),(1755,2,20,28),(1755,3,26,27),(1755,4,30,24),(1755,5,17,15),(1756,1,24,22),(1756,2,35,22),(1756,3,26,22),(1756,4,18,34),(1757,1,19,30),(1757,2,15,31),(1757,3,22,25),(1757,4,27,19),(1758,1,27,29),(1758,2,28,27),(1758,3,30,16),(1758,4,35,27),(1759,1,31,23),(1759,2,31,18),(1759,3,24,21),(1759,4,20,20),(1760,1,34,30),(1760,2,28,28),(1760,3,26,25),(1760,4,19,25),(1761,1,28,34),(1761,2,27,30),(1761,3,21,39),(1761,4,19,14),(1762,1,31,22),(1762,2,21,30),(1762,3,22,21),(1762,4,33,25),(1763,1,26,22),(1763,2,31,22),(1763,3,28,27),(1763,4,30,29),(1764,1,36,27),(1764,2,24,32),(1764,3,28,22),(1764,4,27,20),(1765,1,17,20),(1765,2,25,23),(1765,3,26,22),(1765,4,30,25),(1766,1,26,20),(1766,2,30,29),(1766,3,23,27),(1766,4,30,26),(1767,1,35,26),(1767,2,29,29),(1767,3,20,27),(1767,4,15,17),(1767,5,5,9),(1768,1,26,14),(1768,2,30,30),(1768,3,34,26),(1768,4,27,16),(1769,1,22,20),(1769,2,30,32),(1769,3,25,34),(1769,4,27,25),(1770,1,27,23),(1770,2,30,26),(1770,3,24,38),(1770,4,31,17),(1771,1,21,21),(1771,2,21,13),(1771,3,21,19),(1771,4,20,27),(1772,1,22,17),(1772,2,22,29),(1772,3,20,25),(1772,4,27,24),(1773,1,23,29),(1773,2,20,33),(1773,3,38,19),(1773,4,17,19),(1774,1,30,29),(1774,2,25,17),(1774,3,22,26),(1774,4,17,25),(1775,1,24,30),(1775,2,16,31),(1775,3,19,27),(1775,4,29,19),(1776,1,26,21),(1776,2,30,28),(1776,3,33,33),(1776,4,21,26),(1777,1,32,33),(1777,2,31,20),(1777,3,24,25),(1777,4,12,28),(1778,1,23,20),(1778,2,21,19),(1778,3,23,23),(1778,4,24,30),(1779,1,30,20),(1779,2,29,16),(1779,3,39,32),(1779,4,15,24),(1780,1,23,25),(1780,2,18,19),(1780,3,24,22),(1780,4,26,10),(1781,1,15,26),(1781,2,20,32),(1781,3,24,16),(1781,4,22,20),(1782,1,12,23),(1782,2,21,19),(1782,3,27,32),(1782,4,19,20),(1783,1,30,24),(1783,2,24,18),(1783,3,24,29),(1783,4,16,27),(1784,1,24,29),(1784,2,28,29),(1784,3,34,22),(1784,4,20,30),(1785,1,16,21),(1785,2,26,15),(1785,3,20,21),(1785,4,17,28),(1786,1,25,27),(1786,2,31,29),(1786,3,25,13),(1786,4,31,16),(1787,1,20,25),(1787,2,22,14),(1787,3,19,20),(1787,4,17,28),(1788,1,26,18),(1788,2,14,26),(1788,3,26,19),(1788,4,29,19),(1789,1,33,28),(1789,2,28,19),(1789,3,36,26),(1789,4,27,39),(1790,1,30,24),(1790,2,26,44),(1790,3,25,27),(1790,4,21,19),(1791,1,26,29),(1791,2,33,15),(1791,3,18,22),(1791,4,16,29),(1792,1,24,21),(1792,2,24,24),(1792,3,22,17),(1792,4,24,20),(1793,1,39,21),(1793,2,31,28),(1793,3,30,28),(1793,4,34,27),(1794,1,33,38),(1794,2,28,27),(1794,3,26,31),(1794,4,27,27),(1795,1,26,22),(1795,2,15,31),(1795,3,32,16),(1795,4,18,30),(1796,1,20,20),(1796,2,31,22),(1796,3,23,19),(1796,4,22,26),(1797,1,25,26),(1797,2,22,26),(1797,3,28,29),(1797,4,26,24),(1798,1,19,23),(1798,2,22,16),(1798,3,16,23),(1798,4,22,17),(1798,5,8,2),(1799,1,25,30),(1799,2,26,31),(1799,3,26,31),(1799,4,27,21),(1800,1,21,24),(1800,2,25,22),(1800,3,26,18),(1800,4,28,37),(1801,1,39,33),(1801,2,31,34),(1801,3,17,22),(1801,4,25,30),(1802,1,28,23),(1802,2,30,25),(1802,3,19,27),(1802,4,34,33),(1803,1,17,22),(1803,2,26,27),(1803,3,29,24),(1803,4,20,22),(1804,1,20,24),(1804,2,28,23),(1804,3,25,34),(1804,4,29,19),(1805,1,17,26),(1805,2,28,22),(1805,3,16,36),(1805,4,27,17),(1806,1,30,12),(1806,2,22,28),(1806,3,31,27),(1806,4,27,32),(1807,1,26,18),(1807,2,24,27),(1807,3,17,19),(1807,4,24,20),(1808,1,27,32),(1808,2,25,33),(1808,3,30,24),(1808,4,21,24),(1809,1,22,17),(1809,2,29,21),(1809,3,16,27),(1809,4,22,17),(1810,1,37,17),(1810,2,33,18),(1810,3,18,35),(1810,4,28,22),(1811,1,24,30),(1811,2,22,18),(1811,3,24,33),(1811,4,24,29),(1812,1,28,26),(1812,2,32,23),(1812,3,27,29),(1812,4,29,22),(1813,1,15,27),(1813,2,29,22),(1813,3,30,12),(1813,4,25,21),(1814,1,30,26),(1814,2,25,23),(1814,3,32,28),(1814,4,24,38),(1815,1,19,32),(1815,2,31,20),(1815,3,26,17),(1815,4,23,32),(1816,1,34,26),(1816,2,32,30),(1816,3,26,22),(1816,4,27,18),(1817,1,29,26),(1817,2,32,34),(1817,3,22,33),(1817,4,32,44),(1818,1,36,28),(1818,2,22,30),(1818,3,15,34),(1818,4,23,20),(1819,1,18,22),(1819,2,17,22),(1819,3,23,23),(1819,4,20,15),(1820,1,27,28),(1820,2,29,23),(1820,3,11,28),(1820,4,17,33),(1821,1,17,29),(1821,2,18,23),(1821,3,22,15),(1821,4,23,25),(1822,1,29,29),(1822,2,23,22),(1822,3,27,33),(1822,4,23,13),(1823,1,27,21),(1823,2,19,31),(1823,3,26,15),(1823,4,19,19),(1824,1,29,32),(1824,2,25,38),(1824,3,20,35),(1824,4,21,21),(1825,1,36,18),(1825,2,24,16),(1825,3,25,21),(1825,4,16,26),(1826,1,31,23),(1826,2,37,22),(1826,3,35,33),(1826,4,26,20),(1827,1,24,21),(1827,2,17,20),(1827,3,32,17),(1827,4,16,27),(1828,1,30,28),(1828,2,18,22),(1828,3,20,29),(1828,4,12,22),(1829,1,33,31),(1829,2,27,22),(1829,3,25,24),(1829,4,25,20),(1830,1,25,24),(1830,2,18,25),(1830,3,32,21),(1830,4,32,18),(1831,1,30,28),(1831,2,29,19),(1831,3,31,27),(1831,4,22,27),(1832,1,36,20),(1832,2,28,21),(1832,3,27,25),(1832,4,20,27),(1833,1,27,25),(1833,2,22,21),(1833,3,21,17),(1833,4,22,24),(1834,1,24,35),(1834,2,31,25),(1834,3,25,13),(1834,4,43,46),(1835,1,22,25),(1835,2,19,28),(1835,3,23,21),(1835,4,34,24),(1835,5,10,12),(1836,1,22,15),(1836,2,22,21),(1836,3,27,22),(1836,4,15,21),(1837,1,21,24),(1837,2,18,19),(1837,3,16,23),(1837,4,28,31),(1838,1,32,23),(1838,2,27,32),(1838,3,29,27),(1838,4,23,23),(1839,1,25,16),(1839,2,20,22),(1839,3,37,24),(1839,4,30,28),(1840,1,26,25),(1840,2,24,29),(1840,3,34,20),(1840,4,28,17),(1841,1,22,32),(1841,2,37,20),(1841,3,16,24),(1841,4,27,22),(1842,1,25,12),(1842,2,24,20),(1842,3,30,34),(1842,4,18,21),(1843,1,24,28),(1843,2,28,29),(1843,3,33,15),(1843,4,28,27),(1844,1,24,24),(1844,2,21,27),(1844,3,26,24),(1844,4,39,19),(1845,1,23,27),(1845,2,24,26),(1845,3,30,19),(1845,4,26,32),(1846,1,28,28),(1846,2,16,33),(1846,3,22,26),(1846,4,30,15),(1847,1,21,27),(1847,2,22,21),(1847,3,32,23),(1847,4,27,21),(1848,1,27,26),(1848,2,33,25),(1848,3,29,15),(1848,4,12,22),(1849,1,24,21),(1849,2,23,28),(1849,3,25,18),(1849,4,27,30),(1850,1,29,28),(1850,2,39,20),(1850,3,27,22),(1850,4,24,22),(1851,1,27,20),(1851,2,18,27),(1851,3,14,22),(1851,4,13,12),(1852,1,26,26),(1852,2,23,20),(1852,3,21,39),(1852,4,32,28),(1853,1,24,31),(1853,2,25,31),(1853,3,16,22),(1853,4,25,23),(1854,1,36,28),(1854,2,27,27),(1854,3,18,29),(1854,4,23,30),(1855,1,10,18),(1855,2,29,23),(1855,3,26,19),(1855,4,18,20),(1856,1,43,25),(1856,2,27,27),(1856,3,31,8),(1856,4,22,27),(1857,1,33,32),(1857,2,20,13),(1857,3,23,19),(1857,4,13,25),(1857,5,4,4),(1857,6,11,2),(1858,1,18,24),(1858,2,28,16),(1858,3,30,24),(1858,4,27,19),(1859,1,25,29),(1859,2,23,26),(1859,3,26,19),(1859,4,30,25),(1860,1,18,18),(1860,2,27,19),(1860,3,20,14),(1860,4,28,15),(1861,1,24,18),(1861,2,23,24),(1861,3,21,22),(1861,4,28,16),(1862,1,27,32),(1862,2,31,28),(1862,3,32,26),(1862,4,22,18),(1863,1,24,17),(1863,2,28,25),(1863,3,18,28),(1863,4,33,27),(1864,1,29,29),(1864,2,17,34),(1864,3,33,31),(1864,4,28,20),(1865,1,14,10),(1865,2,24,25),(1865,3,39,27),(1865,4,24,23),(1866,1,17,22),(1866,2,25,15),(1866,3,42,40),(1866,4,26,30),(1867,1,28,20),(1867,2,12,32),(1867,3,28,32),(1867,4,24,18),(1868,1,34,25),(1868,2,35,22),(1868,3,23,19),(1868,4,28,28),(1869,1,35,21),(1869,2,29,30),(1869,3,25,28),(1869,4,21,29),(1870,1,21,18),(1870,2,27,23),(1870,3,29,31),(1870,4,31,29),(1871,1,30,32),(1871,2,29,18),(1871,3,30,11),(1871,4,35,19),(1872,1,28,21),(1872,2,24,28),(1872,3,29,22),(1872,4,23,15),(1873,1,35,31),(1873,2,32,22),(1873,3,26,24),(1873,4,25,26),(1874,1,27,19),(1874,2,16,33),(1874,3,22,32),(1874,4,27,20),(1875,1,38,24),(1875,2,20,26),(1875,3,30,23),(1875,4,28,21),(1876,1,28,20),(1876,2,31,21),(1876,3,25,25),(1876,4,23,22),(1877,1,28,21),(1877,2,24,22),(1877,3,23,25),(1877,4,17,24),(1877,5,6,4),(1878,1,28,24),(1878,2,24,27),(1878,3,21,25),(1878,4,22,25),(1879,1,19,26),(1879,2,24,30),(1879,3,25,22),(1879,4,20,24),(1880,1,23,28),(1880,2,40,29),(1880,3,22,31),(1880,4,33,32),(1881,1,27,24),(1881,2,28,22),(1881,3,23,27),(1881,4,30,25),(1882,1,24,16),(1882,2,19,31),(1882,3,29,20),(1882,4,18,20),(1883,1,25,20),(1883,2,34,25),(1883,3,27,29),(1883,4,30,18),(1884,1,24,27),(1884,2,29,18),(1884,3,19,23),(1884,4,23,24),(1885,1,20,26),(1885,2,29,20),(1885,3,31,27),(1885,4,21,28),(1885,5,10,10),(1885,6,8,8),(1885,7,6,9),(1886,1,26,27),(1886,2,28,23),(1886,3,23,25),(1886,4,31,21),(1887,1,30,32),(1887,2,42,30),(1887,3,28,36),(1887,4,29,29),(1888,1,32,35),(1888,2,26,30),(1888,3,24,26),(1888,4,34,32),(1889,1,30,19),(1889,2,26,26),(1889,3,25,29),(1889,4,19,29),(1890,1,26,27),(1890,2,28,31),(1890,3,34,24),(1890,4,33,32),(1891,1,10,20),(1891,2,25,22),(1891,3,25,16),(1891,4,17,24),(1892,1,43,18),(1892,2,26,30),(1892,3,17,29),(1892,4,28,20),(1893,1,23,24),(1893,2,24,34),(1893,3,26,25),(1893,4,35,28),(1894,1,23,25),(1894,2,22,16),(1894,3,28,15),(1894,4,15,27),(1895,1,28,25),(1895,2,22,20),(1895,3,31,24),(1895,4,28,36),(1896,1,27,31),(1896,2,26,34),(1896,3,21,34),(1896,4,36,28),(1897,1,30,31),(1897,2,33,17),(1897,3,24,21),(1897,4,30,20),(1898,1,32,36),(1898,2,41,23),(1898,3,10,24),(1898,4,9,21),(1899,1,18,30),(1899,2,35,22),(1899,3,21,26),(1899,4,27,33),(1900,1,30,27),(1900,2,24,23),(1900,3,20,24),(1900,4,22,19),(1901,1,29,26),(1901,2,28,42),(1901,3,23,19),(1901,4,29,30),(1902,1,30,36),(1902,2,26,22),(1902,3,19,26),(1902,4,32,26),(1903,1,39,32),(1903,2,32,33),(1903,3,30,26),(1903,4,26,30),(1904,1,27,23),(1904,2,23,27),(1904,3,17,26),(1904,4,28,33),(1905,1,23,25),(1905,2,35,27),(1905,3,24,24),(1905,4,22,31),(1906,1,24,34),(1906,2,17,24),(1906,3,20,21),(1906,4,25,22),(1907,1,22,15),(1907,2,22,25),(1907,3,25,21),(1907,4,25,28),(1908,1,27,27),(1908,2,22,27),(1908,3,29,23),(1908,4,22,32),(1909,1,20,21),(1909,2,24,21),(1909,3,28,29),(1909,4,19,19),(1910,1,25,27),(1910,2,20,31),(1910,3,20,31),(1910,4,24,21),(1911,1,29,22),(1911,2,25,24),(1911,3,22,33),(1911,4,22,25),(1912,1,29,24),(1912,2,25,28),(1912,3,18,26),(1912,4,15,19),(1913,1,28,18),(1913,2,29,23),(1913,3,21,27),(1913,4,28,24),(1914,1,29,27),(1914,2,31,26),(1914,3,16,22),(1914,4,14,15),(1914,5,6,14),(1915,1,29,23),(1915,2,33,29),(1915,3,29,26),(1915,4,23,26),(1916,1,24,19),(1916,2,27,12),(1916,3,27,20),(1916,4,25,27),(1917,1,23,35),(1917,2,29,36),(1917,3,18,33),(1917,4,41,23),(1918,1,23,14),(1918,2,28,9),(1918,3,28,22),(1918,4,19,27),(1919,1,18,26),(1919,2,35,20),(1919,3,13,18),(1919,4,27,27),(1920,1,34,25),(1920,2,28,31),(1920,3,22,23),(1920,4,33,24),(1921,1,36,29),(1921,2,22,25),(1921,3,23,28),(1921,4,25,30),(1922,1,29,16),(1922,2,24,22),(1922,3,31,22),(1922,4,26,22),(1923,1,28,30),(1923,2,29,22),(1923,3,32,22),(1923,4,19,19),(1924,1,16,27),(1924,2,22,25),(1924,3,17,19),(1924,4,25,32),(1925,1,23,30),(1925,2,14,29),(1925,3,29,20),(1925,4,31,23),(1926,1,21,35),(1926,2,19,18),(1926,3,29,24),(1926,4,25,25),(1927,1,28,26),(1927,2,25,38),(1927,3,25,30),(1927,4,25,18),(1928,1,31,26),(1928,2,18,26),(1928,3,20,20),(1928,4,24,21),(1928,5,9,7),(1929,1,34,31),(1929,2,37,39),(1929,3,26,22),(1929,4,24,22),(1930,1,20,25),(1930,2,20,16),(1930,3,29,27),(1930,4,23,27),(1931,1,29,23),(1931,2,32,28),(1931,3,25,22),(1931,4,21,26),(1932,1,37,28),(1932,2,34,28),(1932,3,35,35),(1932,4,20,22),(1933,1,26,11),(1933,2,29,25),(1933,3,23,24),(1933,4,22,35),(1934,1,29,15),(1934,2,22,25),(1934,3,20,27),(1934,4,22,19),(1935,1,16,34),(1935,2,23,20),(1935,3,23,30),(1935,4,35,28),(1936,1,27,21),(1936,2,19,21),(1936,3,27,14),(1936,4,28,34),(1937,1,21,27),(1937,2,30,25),(1937,3,26,23),(1937,4,28,22),(1938,1,20,38),(1938,2,36,26),(1938,3,14,27),(1938,4,27,23),(1939,1,21,29),(1939,2,35,31),(1939,3,24,28),(1939,4,29,24),(1940,1,22,32),(1940,2,21,29),(1940,3,30,15),(1940,4,26,23),(1940,5,12,14),(1941,1,17,23),(1941,2,27,20),(1941,3,18,28),(1941,4,25,27),(1942,1,15,34),(1942,2,31,17),(1942,3,22,22),(1942,4,25,12),(1943,1,25,28),(1943,2,25,28),(1943,3,31,29),(1943,4,23,16),(1944,1,30,29),(1944,2,32,20),(1944,3,34,30),(1944,4,28,21),(1945,1,26,25),(1945,2,22,24),(1945,3,24,21),(1945,4,23,21),(1946,1,24,30),(1946,2,29,25),(1946,3,22,21),(1946,4,30,35),(1947,1,26,33),(1947,2,30,28),(1947,3,24,23),(1947,4,26,26),(1948,1,29,22),(1948,2,26,22),(1948,3,33,29),(1948,4,31,25),(1949,1,27,30),(1949,2,32,37),(1949,3,27,24),(1949,4,24,14),(1950,1,30,27),(1950,2,27,19),(1950,3,28,29),(1950,4,24,27),(1951,1,30,21),(1951,2,37,25),(1951,3,34,20),(1951,4,24,30),(1952,1,18,21),(1952,2,39,25),(1952,3,21,24),(1952,4,29,36),(1953,1,37,26),(1953,2,23,24),(1953,3,24,29),(1953,4,19,24),(1953,5,8,13),(1954,1,26,41),(1954,2,29,27),(1954,3,25,24),(1954,4,15,20),(1955,1,28,32),(1955,2,25,23),(1955,3,38,25),(1955,4,23,25),(1956,1,20,21),(1956,2,15,23),(1956,3,29,20),(1956,4,23,24),(1957,1,24,23),(1957,2,22,14),(1957,3,25,18),(1957,4,22,23),(1958,1,36,36),(1958,2,27,27),(1958,3,35,28),(1958,4,22,30),(1959,1,26,25),(1959,2,22,29),(1959,3,32,17),(1959,4,21,32),(1960,1,28,27),(1960,2,18,23),(1960,3,13,27),(1960,4,24,24),(1961,1,14,27),(1961,2,20,28),(1961,3,22,29),(1961,4,23,21),(1962,1,28,27),(1962,2,25,25),(1962,3,25,28),(1962,4,17,24),(1963,1,29,30),(1963,2,28,21),(1963,3,19,31),(1963,4,19,19),(1964,1,25,31),(1964,2,20,29),(1964,3,19,36),(1964,4,23,16),(1965,1,24,22),(1965,2,15,17),(1965,3,16,18),(1965,4,32,32),(1966,1,16,14),(1966,2,30,21),(1966,3,25,19),(1966,4,28,27),(1967,1,22,18),(1967,2,33,18),(1967,3,31,40),(1967,4,23,20),(1968,1,37,36),(1968,2,28,35),(1968,3,28,22),(1968,4,25,33),(1969,1,27,29),(1969,2,38,28),(1969,3,22,24),(1969,4,28,23),(1970,1,26,26),(1970,2,18,27),(1970,3,27,30),(1970,4,20,20),(1971,1,21,29),(1971,2,30,24),(1971,3,26,24),(1971,4,27,24),(1972,1,17,11),(1972,2,17,24),(1972,3,19,24),(1972,4,26,26),(1973,1,31,30),(1973,2,28,35),(1973,3,34,30),(1973,4,24,30),(1974,1,28,25),(1974,2,28,21),(1974,3,28,35),(1974,4,32,25),(1975,1,22,25),(1975,2,29,22),(1975,3,32,34),(1975,4,27,22),(1976,1,27,21),(1976,2,27,23),(1976,3,21,25),(1976,4,25,23),(1977,1,29,22),(1977,2,32,21),(1977,3,6,25),(1977,4,23,31),(1978,1,28,22),(1978,2,26,33),(1978,3,22,12),(1978,4,27,21),(1979,1,34,28),(1979,2,24,22),(1979,3,33,21),(1979,4,22,30),(1980,1,26,32),(1980,2,24,25),(1980,3,29,30),(1980,4,32,22),(1981,1,25,32),(1981,2,16,32),(1981,3,20,20),(1981,4,25,30),(1982,1,20,23),(1982,2,26,31),(1982,3,19,18),(1982,4,21,23),(1983,1,26,40),(1983,2,28,22),(1983,3,28,33),(1983,4,31,29),(1984,1,20,22),(1984,2,30,28),(1984,3,31,20),(1984,4,25,29),(1985,1,26,25),(1985,2,30,32),(1985,3,25,25),(1985,4,22,22),(1986,1,31,15),(1986,2,32,22),(1986,3,23,22),(1986,4,28,29),(1987,1,19,22),(1987,2,30,27),(1987,3,20,30),(1987,4,23,25),(1988,1,22,31),(1988,2,24,30),(1988,3,12,20),(1988,4,23,17),(1989,1,29,26),(1989,2,15,30),(1989,3,21,27),(1989,4,24,17),(1990,1,20,22),(1990,2,33,21),(1990,3,25,17),(1990,4,25,27),(1991,1,20,28),(1991,2,19,18),(1991,3,33,18),(1991,4,25,26),(1992,1,22,24),(1992,2,27,21),(1992,3,16,21),(1992,4,20,22),(1993,1,21,32),(1993,2,31,21),(1993,3,23,22),(1993,4,23,26),(1994,1,15,21),(1994,2,21,19),(1994,3,25,28),(1994,4,25,28),(1995,1,30,32),(1995,2,27,31),(1995,3,28,28),(1995,4,30,26),(1996,1,24,25),(1996,2,22,23),(1996,3,17,21),(1996,4,26,30),(1997,1,23,16),(1997,2,24,19),(1997,3,20,27),(1997,4,21,15),(1998,1,30,21),(1998,2,20,34),(1998,3,25,36),(1998,4,20,21),(1999,1,33,20),(1999,2,22,20),(1999,3,25,25),(1999,4,18,18),(2000,1,26,23),(2000,2,21,30),(2000,3,24,21),(2000,4,23,21),(2001,1,19,28),(2001,2,31,34),(2001,3,34,29),(2001,4,33,35),(2002,1,30,31),(2002,2,32,20),(2002,3,19,23),(2002,4,29,29),(2003,1,38,21),(2003,2,22,15),(2003,3,21,29),(2003,4,36,21),(2004,1,32,21),(2004,2,32,35),(2004,3,26,11),(2004,4,21,25),(2005,1,19,36),(2005,2,30,30),(2005,3,25,11),(2005,4,20,25),(2006,1,21,27),(2006,2,31,37),(2006,3,23,38),(2006,4,24,23),(2007,1,27,31),(2007,2,22,31),(2007,3,25,24),(2007,4,26,24),(2008,1,21,23),(2008,2,27,18),(2008,3,23,25),(2008,4,19,29),(2009,1,22,30),(2009,2,15,20),(2009,3,30,16),(2009,4,23,28),(2010,1,35,20),(2010,2,32,26),(2010,3,21,18),(2010,4,25,38),(2011,1,16,30),(2011,2,19,33),(2011,3,24,26),(2011,4,36,31),(2012,1,24,20),(2012,2,30,29),(2012,3,21,32),(2012,4,32,22),(2013,1,25,29),(2013,2,28,31),(2013,3,17,26),(2013,4,20,14),(2014,1,25,24),(2014,2,21,21),(2014,3,26,25),(2014,4,25,26),(2015,1,32,27),(2015,2,27,14),(2015,3,31,22),(2015,4,15,32),(2016,1,23,21),(2016,2,27,18),(2016,3,21,18),(2016,4,17,22),(2017,1,31,23),(2017,2,30,29),(2017,3,23,21),(2017,4,22,19),(2018,1,22,29),(2018,2,24,24),(2018,3,25,24),(2018,4,20,29),(2019,1,17,24),(2019,2,26,25),(2019,3,24,20),(2019,4,32,21),(2020,1,25,24),(2020,2,23,30),(2020,3,38,21),(2020,4,34,38),(2021,1,25,13),(2021,2,17,25),(2021,3,36,26),(2021,4,18,17),(2022,1,32,22),(2022,2,25,27),(2022,3,36,21),(2022,4,20,26),(2023,1,27,24),(2023,2,25,29),(2023,3,19,25),(2023,4,24,15),(2024,1,31,19),(2024,2,26,21),(2024,3,26,34),(2024,4,23,29),(2025,1,19,21),(2025,2,23,21),(2025,3,34,23),(2025,4,26,22),(2026,1,27,19),(2026,2,27,26),(2026,3,17,19),(2026,4,25,25),(2027,1,24,12),(2027,2,20,21),(2027,3,27,24),(2027,4,28,13),(2028,1,27,25),(2028,2,32,27),(2028,3,35,27),(2028,4,30,28),(2029,1,32,29),(2029,2,31,28),(2029,3,21,23),(2029,4,18,16),(2030,1,25,29),(2030,2,35,31),(2030,3,22,21),(2030,4,34,34),(2031,1,20,18),(2031,2,31,18),(2031,3,18,25),(2031,4,17,16),(2032,1,18,19),(2032,2,32,24),(2032,3,25,26),(2032,4,26,29),(2033,1,29,22),(2033,2,30,28),(2033,3,16,13),(2033,4,23,16),(2034,1,24,16),(2034,2,30,33),(2034,3,30,20),(2034,4,24,33),(2035,1,32,29),(2035,2,24,26),(2035,3,26,14),(2035,4,18,21),(2036,1,27,25),(2036,2,27,17),(2036,3,22,22),(2036,4,19,38),(2037,1,27,24),(2037,2,17,31),(2037,3,18,16),(2037,4,17,23),(2038,1,13,26),(2038,2,26,25),(2038,3,18,21),(2038,4,18,19),(2039,1,13,21),(2039,2,20,23),(2039,3,30,25),(2039,4,29,32),(2040,1,15,19),(2040,2,28,23),(2040,3,12,24),(2040,4,30,23),(2041,1,38,26),(2041,2,30,26),(2041,3,21,26),(2041,4,20,21),(2042,1,28,24),(2042,2,19,27),(2042,3,24,24),(2042,4,34,25),(2043,1,23,34),(2043,2,24,22),(2043,3,35,32),(2043,4,26,26),(2044,1,26,21),(2044,2,29,31),(2044,3,17,26),(2044,4,24,32),(2045,1,26,26),(2045,2,31,17),(2045,3,31,31),(2045,4,24,24),(2046,1,17,36),(2046,2,32,34),(2046,3,31,28),(2046,4,28,21),(2047,1,24,36),(2047,2,31,26),(2047,3,20,27),(2047,4,37,27),(2048,1,30,24),(2048,2,21,28),(2048,3,33,20),(2048,4,26,28),(2049,1,26,25),(2049,2,30,29),(2049,3,24,23),(2049,4,26,20),(2050,1,35,30),(2050,2,31,33),(2050,3,29,27),(2050,4,27,18),(2051,1,23,26),(2051,2,23,21),(2051,3,22,30),(2051,4,22,17),(2052,1,33,25),(2052,2,29,23),(2052,3,21,34),(2052,4,16,17),(2052,5,16,16),(2052,6,3,10),(2053,1,30,23),(2053,2,37,29),(2053,3,25,20),(2053,4,17,29),(2054,1,16,29),(2054,2,34,17),(2054,3,26,22),(2054,4,26,19),(2055,1,17,24),(2055,2,23,15),(2055,3,35,29),(2055,4,28,21),(2056,1,30,17),(2056,2,37,27),(2056,3,29,29),(2056,4,15,22),(2057,1,38,32),(2057,2,25,35),(2057,3,22,26),(2057,4,28,22),(2058,1,20,26),(2058,2,30,18),(2058,3,33,24),(2058,4,34,22),(2059,1,35,26),(2059,2,29,35),(2059,3,21,26),(2059,4,13,25),(2060,1,25,26),(2060,2,17,21),(2060,3,19,24),(2060,4,37,20),(2061,1,23,36),(2061,2,28,29),(2061,3,29,23),(2061,4,23,14),(2062,1,16,28),(2062,2,29,22),(2062,3,26,27),(2062,4,32,26),(2062,5,15,10),(2063,1,21,29),(2063,2,28,17),(2063,3,22,23),(2063,4,28,20),(2064,1,29,22),(2064,2,38,29),(2064,3,25,32),(2064,4,26,22),(2065,1,28,23),(2065,2,26,20),(2065,3,28,24),(2065,4,21,14),(2066,1,30,29),(2066,2,35,32),(2066,3,32,25),(2066,4,29,23),(2067,1,29,28),(2067,2,34,31),(2067,3,32,31),(2067,4,27,19),(2068,1,26,29),(2068,2,19,27),(2068,3,24,25),(2068,4,26,20),(2069,1,29,27),(2069,2,14,10),(2069,3,11,24),(2069,4,22,18),(2070,1,32,20),(2070,2,20,30),(2070,3,16,16),(2070,4,26,23),(2071,1,23,28),(2071,2,31,27),(2071,3,29,28),(2071,4,27,34),(2072,1,25,21),(2072,2,17,20),(2072,3,28,28),(2072,4,30,35),(2073,1,23,34),(2073,2,23,18),(2073,3,16,25),(2073,4,24,15),(2074,1,16,17),(2074,2,22,27),(2074,3,18,28),(2074,4,35,30),(2075,1,28,31),(2075,2,15,21),(2075,3,21,22),(2075,4,29,18),(2076,1,22,18),(2076,2,20,15),(2076,3,17,25),(2076,4,19,20),(2076,5,13,5),(2077,1,29,14),(2077,2,22,14),(2077,3,20,32),(2077,4,22,21),(2078,1,29,28),(2078,2,29,25),(2078,3,28,25),(2078,4,26,22),(2079,1,46,15),(2079,2,23,15),(2079,3,31,21),(2079,4,23,27),(2080,1,28,24),(2080,2,29,21),(2080,3,18,19),(2080,4,18,20),(2081,1,24,26),(2081,2,22,23),(2081,3,22,21),(2081,4,18,32),(2082,1,31,20),(2082,2,30,20),(2082,3,24,16),(2082,4,34,24),(2083,1,28,34),(2083,2,30,33),(2083,3,20,15),(2083,4,11,25),(2084,1,31,20),(2084,2,18,29),(2084,3,33,21),(2084,4,26,31),(2085,1,29,21),(2085,2,37,12),(2085,3,32,19),(2085,4,25,28),(2086,1,25,24),(2086,2,34,24),(2086,3,33,24),(2086,4,17,28),(2087,1,33,17),(2087,2,25,22),(2087,3,22,31),(2087,4,20,15),(2088,1,28,26),(2088,2,30,18),(2088,3,31,21),(2088,4,25,24),(2089,1,25,22),(2089,2,21,21),(2089,3,28,28),(2089,4,23,32),(2090,1,25,19),(2090,2,30,26),(2090,3,25,35),(2090,4,15,18),(2091,1,30,23),(2091,2,25,20),(2091,3,25,25),(2091,4,29,31),(2092,1,27,16),(2092,2,10,32),(2092,3,23,20),(2092,4,19,28),(2093,1,24,23),(2093,2,28,16),(2093,3,27,31),(2093,4,13,19),(2094,1,19,24),(2094,2,26,20),(2094,3,33,21),(2094,4,26,18),(2095,1,30,29),(2095,2,20,15),(2095,3,35,19),(2095,4,20,26),(2096,1,28,22),(2096,2,23,18),(2096,3,15,19),(2096,4,23,34),(2097,1,19,19),(2097,2,23,25),(2097,3,20,16),(2097,4,11,21),(2098,1,31,19),(2098,2,30,22),(2098,3,28,23),(2098,4,28,26),(2099,1,17,24),(2099,2,17,18),(2099,3,27,22),(2099,4,20,22),(2100,1,20,28),(2100,2,26,29),(2100,3,36,27),(2100,4,28,27),(2101,1,19,25),(2101,2,30,21),(2101,3,27,37),(2101,4,22,19),(2102,1,31,22),(2102,2,25,26),(2102,3,22,21),(2102,4,27,31),(2103,1,31,30),(2103,2,30,31),(2103,3,31,34),(2103,4,30,22),(2104,1,19,25),(2104,2,25,23),(2104,3,22,23),(2104,4,26,33),(2105,1,33,22),(2105,2,21,26),(2105,3,20,24),(2105,4,19,21),(2105,5,8,13),(2106,1,38,26),(2106,2,25,28),(2106,3,30,36),(2106,4,20,22),(2107,1,29,19),(2107,2,20,22),(2107,3,20,20),(2107,4,23,15),(2108,1,24,17),(2108,2,30,28),(2108,3,28,27),(2108,4,21,35),(2109,1,35,23),(2109,2,22,26),(2109,3,30,26),(2109,4,21,23),(2110,1,21,32),(2110,2,22,22),(2110,3,24,25),(2110,4,29,29),(2111,1,25,31),(2111,2,18,33),(2111,3,19,21),(2111,4,23,29),(2112,1,28,30),(2112,2,26,30),(2112,3,31,24),(2112,4,21,33),(2113,1,22,17),(2113,2,28,20),(2113,3,16,27),(2113,4,32,29),(2114,1,25,22),(2114,2,28,25),(2114,3,28,32),(2114,4,23,21),(2115,1,25,31),(2115,2,26,21),(2115,3,26,24),(2115,4,22,23),(2115,5,8,13),(2116,1,26,24),(2116,2,25,32),(2116,3,25,26),(2116,4,27,31),(2117,1,27,27),(2117,2,22,28),(2117,3,21,29),(2117,4,23,19),(2118,1,28,21),(2118,2,28,27),(2118,3,18,27),(2118,4,25,30),(2119,1,29,21),(2119,2,23,29),(2119,3,24,21),(2119,4,24,23),(2120,1,21,31),(2120,2,20,17),(2120,3,21,22),(2120,4,30,24),(2121,1,28,21),(2121,2,25,26),(2121,3,33,25),(2121,4,30,26),(2122,1,26,30),(2122,2,24,29),(2122,3,26,16),(2122,4,16,26),(2123,1,22,32),(2123,2,21,32),(2123,3,32,40),(2123,4,33,30),(2124,1,30,18),(2124,2,22,21),(2124,3,30,33),(2124,4,22,19),(2125,1,24,23),(2125,2,23,30),(2125,3,23,25),(2125,4,21,20),(2126,1,26,11),(2126,2,29,25),(2126,3,17,32),(2126,4,29,25),(2127,1,24,18),(2127,2,28,33),(2127,3,29,28),(2127,4,28,32),(2128,1,14,31),(2128,2,33,27),(2128,3,36,33),(2128,4,14,23),(2129,1,22,31),(2129,2,20,19),(2129,3,25,28),(2129,4,23,23),(2130,1,20,24),(2130,2,27,19),(2130,3,24,24),(2130,4,18,22),(2130,5,13,10),(2131,1,17,34),(2131,2,30,20),(2131,3,18,22),(2131,4,16,27),(2132,1,19,22),(2132,2,33,41),(2132,3,34,20),(2132,4,29,24),(2133,1,19,28),(2133,2,25,18),(2133,3,19,28),(2133,4,38,18),(2134,1,16,22),(2134,2,23,22),(2134,3,37,21),(2134,4,22,26),(2135,1,23,41),(2135,2,39,28),(2135,3,27,32),(2135,4,23,23),(2136,1,32,19),(2136,2,37,27),(2136,3,25,23),(2136,4,23,20),(2137,1,21,27),(2137,2,32,23),(2137,3,20,18),(2137,4,29,28),(2138,1,25,17),(2138,2,18,15),(2138,3,25,27),(2138,4,22,28),(2139,1,31,30),(2139,2,22,30),(2139,3,26,26),(2139,4,27,20),(2139,5,7,7),(2139,6,16,8),(2140,1,19,23),(2140,2,28,12),(2140,3,27,22),(2140,4,32,28),(2141,1,16,15),(2141,2,27,24),(2141,3,21,34),(2141,4,38,21),(2142,1,28,23),(2142,2,21,23),(2142,3,19,18),(2142,4,25,22),(2143,1,23,16),(2143,2,28,27),(2143,3,26,27),(2143,4,28,28),(2144,1,27,29),(2144,2,27,35),(2144,3,28,24),(2144,4,20,25),(2145,1,18,27),(2145,2,21,24),(2145,3,29,24),(2145,4,32,35),(2146,1,28,21),(2146,2,14,27),(2146,3,22,15),(2146,4,28,26),(2147,1,21,26),(2147,2,28,33),(2147,3,32,35),(2147,4,23,27),(2148,1,24,21),(2148,2,19,22),(2148,3,23,23),(2148,4,28,27),(2149,1,24,23),(2149,2,15,29),(2149,3,29,21),(2149,4,39,25),(2150,1,21,33),(2150,2,26,30),(2150,3,27,23),(2150,4,28,22),(2151,1,20,24),(2151,2,20,16),(2151,3,25,12),(2151,4,28,27),(2152,1,16,30),(2152,2,40,30),(2152,3,37,23),(2152,4,19,32),(2153,1,32,28),(2153,2,34,44),(2153,3,27,27),(2153,4,24,26),(2154,1,26,34),(2154,2,26,26),(2154,3,32,20),(2154,4,24,17),(2155,1,19,14),(2155,2,25,27),(2155,3,36,24),(2155,4,25,25),(2156,1,27,27),(2156,2,25,21),(2156,3,18,39),(2156,4,25,22),(2157,1,27,30),(2157,2,25,28),(2157,3,20,20),(2157,4,11,18),(2158,1,27,18),(2158,2,32,28),(2158,3,24,22),(2158,4,27,30),(2159,1,21,31),(2159,2,38,29),(2159,3,23,24),(2159,4,26,26),(2160,1,37,33),(2160,2,25,30),(2160,3,21,18),(2160,4,13,23),(2161,1,26,32),(2161,2,27,29),(2161,3,25,32),(2161,4,32,30),(2162,1,28,30),(2162,2,16,43),(2162,3,32,33),(2162,4,34,24),(2163,1,30,20),(2163,2,21,34),(2163,3,24,26),(2163,4,28,27),(2164,1,17,42),(2164,2,34,27),(2164,3,26,35),(2164,4,26,25),(2165,1,30,23),(2165,2,27,31),(2165,3,34,16),(2165,4,27,28),(2166,1,28,34),(2166,2,29,21),(2166,3,24,20),(2166,4,20,35),(2167,1,35,31),(2167,2,27,22),(2167,3,31,27),(2167,4,22,26),(2168,1,21,32),(2168,2,24,20),(2168,3,24,30),(2168,4,26,18),(2169,1,17,23),(2169,2,24,24),(2169,3,28,21),(2169,4,24,31),(2170,1,25,27),(2170,2,33,29),(2170,3,23,23),(2170,4,34,25),(2171,1,29,20),(2171,2,29,14),(2171,3,24,25),(2171,4,42,21),(2172,1,27,26),(2172,2,25,25),(2172,3,24,21),(2172,4,28,42),(2173,1,28,26),(2173,2,29,27),(2173,3,33,28),(2173,4,30,29),(2174,1,21,24),(2174,2,35,21),(2174,3,24,14),(2174,4,23,24),(2175,1,26,22),(2175,2,20,26),(2175,3,28,25),(2175,4,27,20),(2176,1,31,23),(2176,2,34,23),(2176,3,17,27),(2176,4,26,30),(2177,1,20,27),(2177,2,29,16),(2177,3,29,24),(2177,4,30,22),(2178,1,22,19),(2178,2,22,21),(2178,3,23,27),(2178,4,23,34),(2179,1,28,25),(2179,2,25,19),(2179,3,25,20),(2179,4,31,22),(2180,1,8,29),(2180,2,28,30),(2180,3,20,30),(2180,4,33,23),(2181,1,30,15),(2181,2,20,35),(2181,3,23,16),(2181,4,28,30),(2182,1,28,22),(2182,2,27,28),(2182,3,32,14),(2182,4,21,18),(2183,1,27,21),(2183,2,27,36),(2183,3,24,26),(2183,4,28,23),(2183,5,8,8),(2183,6,4,4),(2183,7,11,16),(2184,1,14,25),(2184,2,27,20),(2184,3,25,20),(2184,4,26,17),(2185,1,32,20),(2185,2,22,31),(2185,3,22,22),(2185,4,15,27),(2186,1,27,38),(2186,2,25,35),(2186,3,28,26),(2186,4,23,27),(2187,1,29,22),(2187,2,28,20),(2187,3,30,29),(2187,4,26,36),(2188,1,30,28),(2188,2,26,26),(2188,3,25,27),(2188,4,35,23),(2189,1,27,31),(2189,2,27,34),(2189,3,41,34),(2189,4,31,23),(2190,1,20,27),(2190,2,19,14),(2190,3,30,19),(2190,4,30,19),(2191,1,29,31),(2191,2,24,24),(2191,3,19,22),(2191,4,26,30),(2192,1,22,30),(2192,2,32,35),(2192,3,33,15),(2192,4,23,16),(2193,1,32,24),(2193,2,24,24),(2193,3,28,25),(2193,4,18,23),(2194,1,41,20),(2194,2,28,26),(2194,3,26,34),(2194,4,23,30),(2195,1,27,28),(2195,2,21,27),(2195,3,30,21),(2195,4,19,26),(2196,1,31,30),(2196,2,25,23),(2196,3,14,31),(2196,4,27,24),(2197,1,30,17),(2197,2,21,19),(2197,3,28,20),(2197,4,29,20),(2198,1,32,30),(2198,2,29,23),(2198,3,28,20),(2198,4,23,25),(2199,1,28,41),(2199,2,34,33),(2199,3,21,23),(2199,4,20,25),(2200,1,40,37),(2200,2,39,28),(2200,3,23,30),(2200,4,27,25),(2201,1,31,25),(2201,2,30,30),(2201,3,24,26),(2201,4,31,18),(2202,1,25,22),(2202,2,23,25),(2202,3,30,23),(2202,4,34,36),(2203,1,25,28),(2203,2,30,22),(2203,3,20,28),(2203,4,29,20),(2204,1,37,16),(2204,2,22,32),(2204,3,21,20),(2204,4,29,22),(2205,1,28,27),(2205,2,15,19),(2205,3,23,23),(2205,4,26,12),(2206,1,21,20),(2206,2,24,26),(2206,3,30,24),(2206,4,19,21),(2207,1,29,26),(2207,2,31,28),(2207,3,38,25),(2207,4,26,28),(2208,1,27,18),(2208,2,23,24),(2208,3,26,17),(2208,4,20,21),(2209,1,20,33),(2209,2,36,30),(2209,3,28,24),(2209,4,22,20),(2210,1,20,20),(2210,2,25,30),(2210,3,19,29),(2210,4,40,31),(2211,1,25,40),(2211,2,24,26),(2211,3,34,32),(2211,4,45,34),(2212,1,23,18),(2212,2,17,20),(2212,3,28,21),(2212,4,28,30),(2213,1,20,28),(2213,2,19,16),(2213,3,30,20),(2213,4,27,21),(2214,1,30,21),(2214,2,25,27),(2214,3,40,19),(2214,4,19,21),(2215,1,21,25),(2215,2,21,23),(2215,3,28,25),(2215,4,26,25),(2216,1,25,24),(2216,2,30,20),(2216,3,18,37),(2216,4,23,23),(2217,1,39,32),(2217,2,14,20),(2217,3,30,21),(2217,4,23,30),(2218,1,23,35),(2218,2,28,32),(2218,3,34,28),(2218,4,40,37),(2219,1,37,23),(2219,2,24,22),(2219,3,37,31),(2219,4,27,16),(2220,1,23,13),(2220,2,17,37),(2220,3,28,35),(2220,4,33,37),(2221,1,29,19),(2221,2,27,19),(2221,3,23,17),(2221,4,23,23),(2222,1,25,19),(2222,2,22,33),(2222,3,23,19),(2222,4,24,34),(2223,1,41,34),(2223,2,27,17),(2223,3,11,22),(2223,4,36,37),(2224,1,22,30),(2224,2,18,31),(2224,3,14,23),(2224,4,34,24),(2225,1,32,19),(2225,2,16,22),(2225,3,17,34),(2225,4,24,26),(2226,1,28,8),(2226,2,19,30),(2226,3,26,19),(2226,4,36,30),(2227,1,30,19),(2227,2,24,25),(2227,3,33,16),(2227,4,16,34),(2228,1,24,38),(2228,2,31,28),(2228,3,31,22),(2228,4,20,30),(2229,1,26,28),(2229,2,22,33),(2229,3,26,34),(2229,4,28,21),(2230,1,28,23),(2230,2,26,21),(2230,3,25,27),(2230,4,25,20),(2231,1,27,29),(2231,2,13,44),(2231,3,20,36),(2231,4,34,33),(2232,1,37,22),(2232,2,25,29),(2232,3,20,23),(2232,4,29,13),(2233,1,32,41),(2233,2,29,24),(2233,3,40,33),(2233,4,27,24),(2234,1,32,31),(2234,2,34,21),(2234,3,19,25),(2234,4,26,20),(2235,1,26,20),(2235,2,27,21),(2235,3,25,29),(2235,4,13,14),(2236,1,32,25),(2236,2,23,25),(2236,3,21,24),(2236,4,25,18),(2237,1,39,21),(2237,2,27,24),(2237,3,31,24),(2237,4,17,32),(2238,1,27,16),(2238,2,23,27),(2238,3,38,16),(2238,4,24,27),(2239,1,42,35),(2239,2,35,31),(2239,3,33,25),(2239,4,24,35),(2240,1,12,15),(2240,2,27,20),(2240,3,24,30),(2240,4,14,20),(2241,1,22,25),(2241,2,29,24),(2241,3,27,28),(2241,4,34,27),(2242,1,33,10),(2242,2,24,28),(2242,3,18,36),(2242,4,28,24),(2243,1,29,19),(2243,2,22,25),(2243,3,29,19),(2243,4,19,24),(2244,1,39,22),(2244,2,21,19),(2244,3,24,19),(2244,4,24,21),(2245,1,25,32),(2245,2,32,26),(2245,3,31,20),(2245,4,21,30),(2246,1,25,21),(2246,2,27,23),(2246,3,27,17),(2246,4,32,28),(2247,1,19,23),(2247,2,31,35),(2247,3,26,19),(2247,4,21,30),(2248,1,31,27),(2248,2,28,34),(2248,3,29,22),(2248,4,33,29),(2249,1,22,24),(2249,2,30,26),(2249,3,18,25),(2249,4,22,29),(2250,1,27,36),(2250,2,26,39),(2250,3,21,10),(2250,4,33,29),(2251,1,17,29),(2251,2,26,25),(2251,3,30,19),(2251,4,21,21),(2251,5,17,13),(2252,1,26,22),(2252,2,31,27),(2252,3,38,35),(2252,4,23,27),(2253,1,30,18),(2253,2,18,27),(2253,3,28,26),(2253,4,29,23),(2254,1,21,19),(2254,2,16,24),(2254,3,22,24),(2254,4,27,19),(2254,5,9,2),(2255,1,26,35),(2255,2,25,21),(2255,3,36,19),(2255,4,27,35),(2256,1,22,29),(2256,2,34,32),(2256,3,38,17),(2256,4,19,29),(2257,1,28,30),(2257,2,19,24),(2257,3,26,31),(2257,4,33,21),(2257,5,12,7),(2258,1,28,19),(2258,2,21,21),(2258,3,28,25),(2258,4,27,24),(2259,1,33,33),(2259,2,19,20),(2259,3,24,30),(2259,4,28,28),(2260,1,22,28),(2260,2,22,31),(2260,3,36,19),(2260,4,30,34),(2261,1,25,22),(2261,2,26,23),(2261,3,28,23),(2261,4,26,30),(2262,1,13,24),(2262,2,32,27),(2262,3,23,20),(2262,4,37,27),(2263,1,26,31),(2263,2,35,30),(2263,3,30,24),(2263,4,32,25),(2264,1,34,23),(2264,2,28,22),(2264,3,28,31),(2264,4,22,29),(2265,1,19,30),(2265,2,31,21),(2265,3,28,22),(2265,4,23,24),(2266,1,31,23),(2266,2,22,22),(2266,3,20,28),(2266,4,26,17),(2267,1,24,20),(2267,2,25,20),(2267,3,20,21),(2267,4,25,22),(2268,1,29,22),(2268,2,26,22),(2268,3,24,13),(2268,4,29,28),(2269,1,26,24),(2269,2,30,17),(2269,3,21,26),(2269,4,29,31),(2270,1,28,33),(2270,2,27,28),(2270,3,31,23),(2270,4,26,17),(2271,1,22,23),(2271,2,32,24),(2271,3,24,22),(2271,4,31,30),(2272,1,14,38),(2272,2,19,23),(2272,3,33,29),(2272,4,30,14),(2273,1,28,31),(2273,2,24,23),(2273,3,20,11),(2273,4,27,24),(2274,1,22,22),(2274,2,20,20),(2274,3,29,31),(2274,4,24,23),(2275,1,27,22),(2275,2,19,26),(2275,3,20,21),(2275,4,19,29),(2276,1,24,37),(2276,2,23,23),(2276,3,30,22),(2276,4,24,28),(2277,1,25,23),(2277,2,28,32),(2277,3,25,25),(2277,4,23,28),(2278,1,27,23),(2278,2,23,29),(2278,3,24,33),(2278,4,38,35),(2279,1,29,21),(2279,2,23,24),(2279,3,22,24),(2279,4,27,18),(2280,1,29,29),(2280,2,25,27),(2280,3,30,23),(2280,4,27,19),(2281,1,26,28),(2281,2,31,20),(2281,3,17,19),(2281,4,14,23),(2282,1,24,36),(2282,2,24,32),(2282,3,27,17),(2282,4,17,31),(2283,1,30,24),(2283,2,26,16),(2283,3,17,24),(2283,4,30,26),(2284,1,24,28),(2284,2,30,30),(2284,3,22,32),(2284,4,22,25),(2285,1,25,20),(2285,2,25,22),(2285,3,35,16),(2285,4,26,29),(2286,1,33,19),(2286,2,27,27),(2286,3,41,31),(2286,4,30,25),(2287,1,23,30),(2287,2,24,23),(2287,3,21,14),(2287,4,34,30),(2288,1,32,16),(2288,2,21,36),(2288,3,18,32),(2288,4,23,19),(2289,1,30,20),(2289,2,23,38),(2289,3,18,27),(2289,4,36,26),(2290,1,20,27),(2290,2,25,25),(2290,3,21,26),(2290,4,28,23),(2291,1,33,22),(2291,2,18,21),(2291,3,21,34),(2291,4,15,19),(2292,1,29,14),(2292,2,32,20),(2292,3,28,26),(2292,4,30,25),(2293,1,19,24),(2293,2,28,20),(2293,3,24,23),(2293,4,28,19),(2294,1,33,33),(2294,2,32,20),(2294,3,23,22),(2294,4,17,18),(2295,1,22,29),(2295,2,22,17),(2295,3,16,18),(2295,4,20,23),(2296,1,26,29),(2296,2,29,24),(2296,3,26,27),(2296,4,22,31),(2297,1,21,27),(2297,2,20,17),(2297,3,25,23),(2297,4,21,20),(2297,5,14,18),(2298,1,19,26),(2298,2,29,31),(2298,3,24,22),(2298,4,29,15),(2299,1,28,15),(2299,2,25,22),(2299,3,24,34),(2299,4,20,21),(2300,1,29,20),(2300,2,31,21),(2300,3,19,32),(2300,4,21,27),(2300,5,4,12),(2301,1,21,22),(2301,2,15,23),(2301,3,21,29),(2301,4,20,29),(2302,1,30,23),(2302,2,30,19),(2302,3,28,24),(2302,4,27,28),(2303,1,23,23),(2303,2,25,20),(2303,3,16,20),(2303,4,30,24),(2304,1,27,25),(2304,2,30,39),(2304,3,27,20),(2304,4,28,28),(2304,5,9,8),(2305,1,28,23),(2305,2,22,23),(2305,3,24,30),(2305,4,18,25),(2306,1,27,18),(2306,2,25,20),(2306,3,24,21),(2306,4,26,21),(2307,1,23,29),(2307,2,25,30),(2307,3,22,32),(2307,4,16,18),(2308,1,24,23),(2308,2,31,21),(2308,3,30,33),(2308,4,27,36),(2309,1,32,28),(2309,2,25,26),(2309,3,22,27),(2309,4,34,23),(2310,1,35,37),(2310,2,24,24),(2310,3,31,35),(2310,4,23,25),(2311,1,32,29),(2311,2,21,25),(2311,3,24,20),(2311,4,27,28),(2312,1,26,23),(2312,2,35,30),(2312,3,30,23),(2312,4,31,28),(2313,1,28,22),(2313,2,24,24),(2313,3,16,30),(2313,4,15,21),(2314,1,26,22),(2314,2,24,21),(2314,3,14,18),(2314,4,30,28),(2315,1,23,25),(2315,2,33,28),(2315,3,27,30),(2315,4,27,17),(2316,1,21,23),(2316,2,24,24),(2316,3,22,27),(2316,4,18,23),(2317,1,21,24),(2317,2,37,26),(2317,3,17,17),(2317,4,24,23),(2318,1,30,20),(2318,2,32,29),(2318,3,28,23),(2318,4,18,23),(2319,1,28,20),(2319,2,32,21),(2319,3,32,28),(2319,4,32,17),(2320,1,25,37),(2320,2,29,22),(2320,3,25,20),(2320,4,17,21),(2321,1,26,29),(2321,2,26,18),(2321,3,23,25),(2321,4,23,26),(2321,5,22,17),(2322,1,30,27),(2322,2,27,20),(2322,3,30,19),(2322,4,16,23),(2323,1,17,26),(2323,2,32,23),(2323,3,31,29),(2323,4,26,28),(2323,5,12,7),(2324,1,30,19),(2324,2,17,27),(2324,3,23,27),(2324,4,30,27),(2324,5,17,11),(2325,1,26,21),(2325,2,28,25),(2325,3,21,24),(2325,4,29,29),(2326,1,26,28),(2326,2,19,24),(2326,3,24,23),(2326,4,25,27),(2327,1,27,28),(2327,2,27,33),(2327,3,31,23),(2327,4,33,25),(2328,1,21,14),(2328,2,26,21),(2328,3,20,27),(2328,4,25,24),(2329,1,22,34),(2329,2,31,25),(2329,3,27,19),(2329,4,21,18),(2330,1,24,37),(2330,2,35,29),(2330,3,28,28),(2330,4,26,19),(2330,5,9,10),(2331,1,25,25),(2331,2,27,27),(2331,3,30,24),(2331,4,27,17),(2332,1,29,35),(2332,2,28,23),(2332,3,30,34),(2332,4,22,33),(2333,1,32,24),(2333,2,25,32),(2333,3,28,25),(2333,4,15,26),(2334,1,30,19),(2334,2,18,13),(2334,3,26,31),(2334,4,22,23),(2335,1,29,21),(2335,2,24,30),(2335,3,29,24),(2335,4,33,35),(2336,1,27,33),(2336,2,37,21),(2336,3,34,28),(2336,4,31,24),(2337,1,25,21),(2337,2,21,35),(2337,3,22,29),(2337,4,27,17),(2338,1,23,28),(2338,2,30,23),(2338,3,33,22),(2338,4,30,30),(2339,1,34,28),(2339,2,30,26),(2339,3,28,22),(2339,4,22,22),(2340,1,19,23),(2340,2,25,20),(2340,3,31,19),(2340,4,16,17),(2341,1,26,29),(2341,2,35,24),(2341,3,29,25),(2341,4,32,28),(2342,1,26,27),(2342,2,25,23),(2342,3,22,21),(2342,4,25,21),(2343,1,15,22),(2343,2,30,21),(2343,3,23,25),(2343,4,23,18),(2344,1,16,20),(2344,2,28,24),(2344,3,27,25),(2344,4,34,42),(2345,1,24,21),(2345,2,12,20),(2345,3,29,31),(2345,4,27,21),(2346,1,20,22),(2346,2,26,20),(2346,3,25,30),(2346,4,25,24),(2346,5,11,11),(2346,6,11,12),(2347,1,23,24),(2347,2,14,23),(2347,3,20,22),(2347,4,22,30),(2348,1,21,33),(2348,2,26,25),(2348,3,34,30),(2348,4,26,29),(2349,1,36,26),(2349,2,20,29),(2349,3,24,15),(2349,4,32,33),(2350,1,31,39),(2350,2,24,28),(2350,3,24,34),(2350,4,32,17),(2351,1,19,17),(2351,2,24,13),(2351,3,21,19),(2351,4,18,22),(2352,1,22,22),(2352,2,23,21),(2352,3,31,29),(2352,4,29,23),(2353,1,27,16),(2353,2,22,27),(2353,3,17,18),(2353,4,23,27),(2354,1,20,25),(2354,2,21,13),(2354,3,24,21),(2354,4,26,22),(2355,1,33,22),(2355,2,36,24),(2355,3,29,27),(2355,4,26,21),(2356,1,22,32),(2356,2,25,18),(2356,3,22,26),(2356,4,21,23),(2357,1,16,25),(2357,2,26,24),(2357,3,18,22),(2357,4,36,15),(2358,1,29,15),(2358,2,19,26),(2358,3,24,24),(2358,4,19,26),(2358,5,13,16),(2359,1,34,27),(2359,2,27,19),(2359,3,23,31),(2359,4,16,29),(2360,1,39,16),(2360,2,31,28),(2360,3,34,26),(2360,4,20,37),(2361,1,29,24),(2361,2,26,24),(2361,3,20,25),(2361,4,28,21),(2362,1,41,27),(2362,2,32,35),(2362,3,30,31),(2362,4,17,34),(2363,1,21,29),(2363,2,26,20),(2363,3,30,24),(2363,4,28,29),(2364,1,20,26),(2364,2,22,32),(2364,3,31,18),(2364,4,25,22),(2364,5,11,6),(2365,1,41,24),(2365,2,31,34),(2365,3,18,15),(2365,4,27,23),(2366,1,23,26),(2366,2,17,34),(2366,3,29,26),(2366,4,25,28),(2367,1,24,25),(2367,2,26,29),(2367,3,18,24),(2367,4,21,22),(2368,1,15,19),(2368,2,18,15),(2368,3,31,22),(2368,4,25,21),(2369,1,35,25),(2369,2,22,27),(2369,3,22,22),(2369,4,27,24),(2370,1,30,15),(2370,2,27,24),(2370,3,24,29),(2370,4,28,24),(2371,1,31,24),(2371,2,29,20),(2371,3,29,24),(2371,4,24,23),(2372,1,23,25),(2372,2,22,17),(2372,3,23,35),(2372,4,27,25),(2373,1,22,25),(2373,2,24,17),(2373,3,26,19),(2373,4,21,30),(2374,1,14,22),(2374,2,36,20),(2374,3,51,31),(2374,4,26,23),(2375,1,28,24),(2375,2,31,36),(2375,3,25,29),(2375,4,27,22),(2375,5,17,8),(2376,1,23,26),(2376,2,27,16),(2376,3,29,23),(2376,4,16,20),(2377,1,26,17),(2377,2,33,28),(2377,3,29,36),(2377,4,14,19),(2378,1,20,19),(2378,2,28,22),(2378,3,27,20),(2378,4,32,22),(2379,1,24,28),(2379,2,34,31),(2379,3,25,19),(2379,4,22,27),(2379,5,11,6),(2380,1,33,24),(2380,2,18,26),(2380,3,31,16),(2380,4,14,31),(2381,1,34,28),(2381,2,29,15),(2381,3,21,24),(2381,4,24,36),(2382,1,29,27),(2382,2,26,25),(2382,3,21,23),(2382,4,22,21),(2383,1,25,17),(2383,2,25,23),(2383,3,21,22),(2383,4,16,29),(2384,1,23,17),(2384,2,21,28),(2384,3,19,23),(2384,4,21,15),(2385,1,28,31),(2385,2,20,32),(2385,3,24,23),(2385,4,27,21),(2386,1,23,25),(2386,2,21,29),(2386,3,25,25),(2386,4,24,20),(2387,1,22,31),(2387,2,24,24),(2387,3,16,22),(2387,4,28,22),(2388,1,29,29),(2388,2,31,29),(2388,3,21,23),(2388,4,22,28),(2389,1,26,30),(2389,2,29,23),(2389,3,32,27),(2389,4,21,25),(2390,1,35,28),(2390,2,28,21),(2390,3,37,31),(2390,4,20,18),(2391,1,16,22),(2391,2,21,31),(2391,3,27,25),(2391,4,21,22),(2392,1,32,26),(2392,2,24,27),(2392,3,29,20),(2392,4,20,30),(2393,1,16,30),(2393,2,25,20),(2393,3,33,31),(2393,4,23,16),(2393,5,13,8),(2394,1,29,29),(2394,2,32,21),(2394,3,24,27),(2394,4,23,20),(2395,1,24,21),(2395,2,20,16),(2395,3,30,19),(2395,4,17,22),(2396,1,41,24),(2396,2,33,19),(2396,3,37,34),(2396,4,32,30),(2397,1,30,27),(2397,2,23,25),(2397,3,26,24),(2397,4,21,17),(2398,1,23,28),(2398,2,19,29),(2398,3,18,35),(2398,4,18,18),(2399,1,34,26),(2399,2,28,14),(2399,3,26,26),(2399,4,24,22),(2400,1,16,19),(2400,2,20,28),(2400,3,22,26),(2400,4,16,18),(2401,1,23,31),(2401,2,20,31),(2401,3,31,35),(2401,4,28,36),(2402,1,32,15),(2402,2,22,23),(2402,3,28,13),(2402,4,12,30),(2403,1,20,22),(2403,2,23,16),(2403,3,29,28),(2403,4,30,29),(2404,1,28,27),(2404,2,22,25),(2404,3,25,19),(2404,4,26,26),(2405,1,33,23),(2405,2,37,28),(2405,3,28,17),(2405,4,25,30),(2406,1,33,23),(2406,2,25,38),(2406,3,26,27),(2406,4,23,30),(2407,1,12,21),(2407,2,17,25),(2407,3,17,19),(2407,4,21,23),(2408,1,28,15),(2408,2,24,20),(2408,3,18,24),(2408,4,26,21),(2409,1,26,19),(2409,2,28,23),(2409,3,18,28),(2409,4,31,30),(2410,1,26,25),(2410,2,24,26),(2410,3,27,27),(2410,4,25,29),(2411,1,25,20),(2411,2,24,16),(2411,3,24,22),(2411,4,17,18),(2412,1,25,23),(2412,2,32,22),(2412,3,29,25),(2412,4,19,28),(2413,1,30,27),(2413,2,29,27),(2413,3,26,28),(2413,4,29,17),(2414,1,32,22),(2414,2,12,34),(2414,3,22,18),(2414,4,18,15),(2415,1,26,15),(2415,2,35,28),(2415,3,28,31),(2415,4,26,25),(2416,1,22,27),(2416,2,16,30),(2416,3,26,16),(2416,4,29,25),(2417,1,26,9),(2417,2,33,31),(2417,3,33,37),(2417,4,24,19),(2418,1,25,24),(2418,2,23,26),(2418,3,23,20),(2418,4,23,10),(2419,1,22,26),(2419,2,29,28),(2419,3,15,34),(2419,4,38,26),(2420,1,16,25),(2420,2,29,22),(2420,3,23,28),(2420,4,24,19),(2421,1,34,30),(2421,2,18,31),(2421,3,29,21),(2421,4,35,29),(2422,1,27,21),(2422,2,22,27),(2422,3,20,31),(2422,4,14,13),(2423,1,18,31),(2423,2,25,22),(2423,3,32,20),(2423,4,28,22),(2424,1,15,25),(2424,2,20,23),(2424,3,24,21),(2424,4,18,34),(2425,1,22,29),(2425,2,33,24),(2425,3,21,27),(2425,4,21,22),(2426,1,24,23),(2426,2,30,28),(2426,3,20,14),(2426,4,19,18),(2427,1,25,20),(2427,2,19,40),(2427,3,26,20),(2427,4,30,14),(2428,1,21,30),(2428,2,41,23),(2428,3,19,32),(2428,4,27,23),(2428,5,12,14),(2429,1,29,24),(2429,2,25,27),(2429,3,29,28),(2429,4,22,17),(2430,1,27,29),(2430,2,34,34),(2430,3,22,28),(2430,4,29,33),(2431,1,29,20),(2431,2,34,18),(2431,3,19,23),(2431,4,28,20),(2432,1,29,21),(2432,2,28,25),(2432,3,32,16),(2432,4,29,30),(2433,1,19,31),(2433,2,19,32),(2433,3,25,25),(2433,4,30,35),(2434,1,31,31),(2434,2,18,26),(2434,3,23,21),(2434,4,20,27),(2435,1,27,35),(2435,2,20,35),(2435,3,21,24),(2435,4,30,25),(2436,1,28,27),(2436,2,22,19),(2436,3,23,28),(2436,4,28,20),(2437,1,31,18),(2437,2,26,24),(2437,3,30,25),(2437,4,24,23),(2438,1,23,25),(2438,2,32,25),(2438,3,35,30),(2438,4,17,23),(2439,1,25,30),(2439,2,37,30),(2439,3,29,18),(2439,4,17,34),(2440,1,24,23),(2440,2,36,29),(2440,3,27,24),(2440,4,20,26),(2441,1,20,20),(2441,2,28,21),(2441,3,29,20),(2441,4,25,27),(2442,1,33,19),(2442,2,23,19),(2442,3,21,19),(2442,4,19,20),(2443,1,40,26),(2443,2,31,27),(2443,3,34,28),(2443,4,32,26),(2444,1,26,32),(2444,2,30,26),(2444,3,25,28),(2444,4,26,27),(2445,1,22,24),(2445,2,26,27),(2445,3,32,20),(2445,4,26,23),(2446,1,39,23),(2446,2,22,26),(2446,3,29,24),(2446,4,27,25),(2447,1,23,27),(2447,2,31,25),(2447,3,24,30),(2447,4,17,25),(2448,1,24,18),(2448,2,19,29),(2448,3,26,18),(2448,4,31,27),(2449,1,22,22),(2449,2,35,23),(2449,3,34,24),(2449,4,25,35),(2450,1,27,28),(2450,2,27,18),(2450,3,21,29),(2450,4,27,19),(2451,1,27,15),(2451,2,24,20),(2451,3,31,27),(2451,4,20,28),(2452,1,29,24),(2452,2,23,28),(2452,3,23,25),(2452,4,22,20),(2452,5,12,12),(2452,6,12,13),(2453,1,25,23),(2453,2,18,22),(2453,3,30,20),(2453,4,27,31),(2454,1,27,23),(2454,2,23,22),(2454,3,32,39),(2454,4,29,23),(2455,1,20,19),(2455,2,33,17),(2455,3,19,24),(2455,4,19,20),(2456,1,17,23),(2456,2,34,26),(2456,3,20,27),(2456,4,31,35),(2457,1,26,28),(2457,2,28,23),(2457,3,26,28),(2457,4,13,30),(2458,1,25,14),(2458,2,34,13),(2458,3,25,23),(2458,4,18,19),(2459,1,21,27),(2459,2,22,12),(2459,3,24,25),(2459,4,22,26),(2460,1,21,27),(2460,2,21,30),(2460,3,27,24),(2460,4,32,24),(2461,1,29,32),(2461,2,26,33),(2461,3,30,30),(2461,4,30,16),(2462,1,21,17),(2462,2,12,23),(2462,3,33,22),(2462,4,16,20),(2462,5,12,14),(2463,1,16,28),(2463,2,10,24),(2463,3,35,24),(2463,4,17,20),(2464,1,25,26),(2464,2,21,22),(2464,3,26,29),(2464,4,28,15),(2465,1,22,28),(2465,2,34,19),(2465,3,20,28),(2465,4,22,27),(2466,1,11,33),(2466,2,12,22),(2466,3,36,24),(2466,4,29,28),(2467,1,24,29),(2467,2,24,16),(2467,3,17,23),(2467,4,26,25),(2468,1,22,27),(2468,2,47,25),(2468,3,19,36),(2468,4,29,29),(2468,5,13,8),(2469,1,25,22),(2469,2,32,27),(2469,3,37,23),(2469,4,26,25),(2470,1,26,10),(2470,2,28,28),(2470,3,27,29),(2470,4,31,25),(2471,1,25,25),(2471,2,23,30),(2471,3,29,14),(2471,4,23,25),(2472,1,25,26),(2472,2,23,24),(2472,3,25,14),(2472,4,29,27),(2473,1,28,25),(2473,2,34,28),(2473,3,32,38),(2473,4,28,24),(2474,1,35,22),(2474,2,31,30),(2474,3,35,21),(2474,4,29,29),(2475,1,14,26),(2475,2,29,18),(2475,3,22,18),(2475,4,22,26),(2476,1,27,35),(2476,2,25,23),(2476,3,26,23),(2476,4,17,21),(2477,1,25,39),(2477,2,21,22),(2477,3,19,20),(2477,4,18,14),(2478,1,26,35),(2478,2,35,31),(2478,3,29,49),(2478,4,40,30),(2479,1,27,19),(2479,2,27,15),(2479,3,31,29),(2479,4,25,28),(2480,1,27,30),(2480,2,22,31),(2480,3,28,24),(2480,4,15,22),(2481,1,20,22),(2481,2,35,21),(2481,3,28,35),(2481,4,32,33),(2482,1,32,23),(2482,2,24,28),(2482,3,14,26),(2482,4,35,20),(2483,1,18,32),(2483,2,23,22),(2483,3,25,17),(2483,4,21,16),(2483,5,1,7),(2484,1,25,26),(2484,2,28,22),(2484,3,17,27),(2484,4,17,27),(2485,1,31,18),(2485,2,38,19),(2485,3,29,33),(2485,4,24,30),(2486,1,30,18),(2486,2,38,40),(2486,3,37,30),(2486,4,18,28),(2487,1,25,25),(2487,2,25,28),(2487,3,17,19),(2487,4,35,32),(2488,1,31,32),(2488,2,23,26),(2488,3,26,22),(2488,4,27,22),(2489,1,22,29),(2489,2,32,30),(2489,3,19,26),(2489,4,28,22),(2490,1,34,28),(2490,2,34,32),(2490,3,30,29),(2490,4,27,25),(2491,1,14,23),(2491,2,32,24),(2491,3,18,24),(2491,4,24,23),(2492,1,27,20),(2492,2,29,26),(2492,3,23,25),(2492,4,21,28),(2493,1,28,15),(2493,2,25,28),(2493,3,22,30),(2493,4,24,27),(2494,1,22,30),(2494,2,29,19),(2494,3,21,34),(2494,4,28,26),(2495,1,23,16),(2495,2,24,39),(2495,3,26,19),(2495,4,15,19),(2496,1,28,29),(2496,2,29,26),(2496,3,27,20),(2496,4,22,28),(2497,1,37,32),(2497,2,25,37),(2497,3,30,18),(2497,4,27,29),(2498,1,17,28),(2498,2,21,28),(2498,3,32,24),(2498,4,36,18),(2499,1,26,26),(2499,2,17,32),(2499,3,26,25),(2499,4,26,29),(2500,1,39,32),(2500,2,20,31),(2500,3,23,21),(2500,4,30,26),(2501,1,23,25),(2501,2,22,17),(2501,3,31,20),(2501,4,22,24),(2502,1,30,23),(2502,2,30,24),(2502,3,27,15),(2502,4,29,32),(2503,1,26,24),(2503,2,21,21),(2503,3,30,33),(2503,4,23,30),(2504,1,30,24),(2504,2,27,23),(2504,3,30,17),(2504,4,30,31),(2505,1,24,37),(2505,2,25,25),(2505,3,37,19),(2505,4,26,23),(2506,1,31,23),(2506,2,20,30),(2506,3,25,23),(2506,4,23,35),(2507,1,29,17),(2507,2,22,28),(2507,3,19,22),(2507,4,16,29),(2508,1,18,28),(2508,2,24,32),(2508,3,16,29),(2508,4,41,22),(2509,1,28,23),(2509,2,21,26),(2509,3,20,13),(2509,4,29,23),(2510,1,27,26),(2510,2,28,26),(2510,3,32,22),(2510,4,17,17),(2511,1,22,20),(2511,2,24,39),(2511,3,26,23),(2511,4,39,22),(2512,1,26,24),(2512,2,30,35),(2512,3,31,19),(2512,4,24,27),(2513,1,27,26),(2513,2,19,31),(2513,3,29,21),(2513,4,26,20),(2514,1,27,26),(2514,2,29,21),(2514,3,29,32),(2514,4,32,22),(2515,1,18,23),(2515,2,16,21),(2515,3,30,21),(2515,4,37,29),(2516,1,19,22),(2516,2,26,17),(2516,3,32,25),(2516,4,23,25),(2517,1,23,19),(2517,2,21,33),(2517,3,32,23),(2517,4,29,30),(2517,5,14,12),(2518,1,27,23),(2518,2,25,30),(2518,3,17,34),(2518,4,21,15),(2519,1,30,28),(2519,2,17,24),(2519,3,28,24),(2519,4,31,27),(2520,1,22,21),(2520,2,25,24),(2520,3,27,21),(2520,4,28,31),(2521,1,25,28),(2521,2,21,21),(2521,3,33,21),(2521,4,18,18),(2522,1,26,42),(2522,2,23,21),(2522,3,37,24),(2522,4,21,29),(2523,1,33,33),(2523,2,34,17),(2523,3,19,34),(2523,4,27,24),(2524,1,24,26),(2524,2,26,18),(2524,3,30,21),(2524,4,13,30),(2525,1,30,23),(2525,2,21,34),(2525,3,35,29),(2525,4,18,33),(2526,1,14,24),(2526,2,28,22),(2526,3,25,21),(2526,4,24,30),(2527,1,27,26),(2527,2,43,22),(2527,3,28,17),(2527,4,16,28),(2528,1,32,19),(2528,2,27,27),(2528,3,25,23),(2528,4,26,31),(2529,1,28,42),(2529,2,34,22),(2529,3,35,28),(2529,4,33,28),(2530,1,23,21),(2530,2,22,25),(2530,3,25,23),(2530,4,31,20),(2531,1,26,21),(2531,2,31,23),(2531,3,24,26),(2531,4,27,25),(2532,1,30,21),(2532,2,20,22),(2532,3,26,25),(2532,4,28,30),(2533,1,38,26),(2533,2,25,20),(2533,3,25,34),(2533,4,29,25),(2534,1,18,29),(2534,2,25,26),(2534,3,24,28),(2534,4,31,26),(2535,1,39,29),(2535,2,24,29),(2535,3,20,24),(2535,4,20,29),(2536,1,33,21),(2536,2,18,28),(2536,3,30,15),(2536,4,33,21),(2537,1,16,21),(2537,2,27,18),(2537,3,16,21),(2537,4,21,20),(2537,5,11,6),(2538,1,28,30),(2538,2,26,25),(2538,3,25,32),(2538,4,33,24),(2539,1,28,30),(2539,2,25,20),(2539,3,27,28),(2539,4,25,22),(2540,1,20,25),(2540,2,20,21),(2540,3,22,29),(2540,4,24,26),(2541,1,23,33),(2541,2,28,18),(2541,3,24,35),(2541,4,25,27),(2542,1,27,29),(2542,2,24,26),(2542,3,15,29),(2542,4,21,16),(2543,1,21,28),(2543,2,23,29),(2543,3,30,17),(2543,4,21,18),(2544,1,24,38),(2544,2,32,30),(2544,3,19,23),(2544,4,27,27),(2545,1,29,24),(2545,2,22,29),(2545,3,24,20),(2545,4,18,20),(2545,5,13,12),(2546,1,17,31),(2546,2,31,20),(2546,3,22,29),(2546,4,37,27),(2546,5,12,12),(2546,6,11,17),(2547,1,27,36),(2547,2,25,30),(2547,3,28,22),(2547,4,32,28),(2548,1,37,29),(2548,2,31,23),(2548,3,14,33),(2548,4,28,19),(2549,1,24,21),(2549,2,23,26),(2549,3,27,24),(2549,4,25,33),(2550,1,21,29),(2550,2,25,21),(2550,3,16,17),(2550,4,25,27),(2551,1,29,24),(2551,2,23,28),(2551,3,27,35),(2551,4,26,22),(2552,1,22,28),(2552,2,28,22),(2552,3,16,30),(2552,4,27,21),(2553,1,29,16),(2553,2,27,18),(2553,3,13,31),(2553,4,31,21),(2554,1,21,12),(2554,2,22,32),(2554,3,22,21),(2554,4,25,20),(2555,1,19,23),(2555,2,30,19),(2555,3,23,23),(2555,4,27,23),(2556,1,22,24),(2556,2,32,24),(2556,3,21,24),(2556,4,18,30),(2557,1,20,27),(2557,2,29,21),(2557,3,30,25),(2557,4,27,33),(2557,5,14,16),(2558,1,16,24),(2558,2,27,22),(2558,3,22,22),(2558,4,34,31),(2558,5,6,12),(2559,1,31,20),(2559,2,36,21),(2559,3,38,32),(2559,4,33,25),(2560,1,21,26),(2560,2,27,26),(2560,3,31,13),(2560,4,22,20),(2561,1,21,19),(2561,2,24,20),(2561,3,19,27),(2561,4,36,29),(2562,1,20,31),(2562,2,29,25),(2562,3,26,14),(2562,4,16,21),(2562,5,8,10),(2563,1,29,19),(2563,2,28,28),(2563,3,22,25),(2563,4,22,25),(2564,1,23,24),(2564,2,28,32),(2564,3,24,32),(2564,4,17,25),(2565,1,31,23),(2565,2,22,30),(2565,3,24,30),(2565,4,28,29),(2566,1,24,24),(2566,2,15,14),(2566,3,28,20),(2566,4,31,27),(2567,1,24,18),(2567,2,20,18),(2567,3,27,25),(2567,4,14,24),(2567,5,13,10),(2568,1,21,24),(2568,2,22,22),(2568,3,21,29),(2568,4,32,23),(2569,1,19,23),(2569,2,30,22),(2569,3,28,21),(2569,4,25,32),(2570,1,30,28),(2570,2,21,20),(2570,3,18,24),(2570,4,28,28),(2571,1,24,35),(2571,2,31,19),(2571,3,23,27),(2571,4,32,29),(2571,5,6,11),(2572,1,22,29),(2572,2,26,13),(2572,3,17,24),(2572,4,23,25),(2573,1,27,34),(2573,2,32,20),(2573,3,18,20),(2573,4,32,34),(2574,1,27,23),(2574,2,19,35),(2574,3,19,28),(2574,4,20,12),(2575,1,18,15),(2575,2,17,27),(2575,3,17,22),(2575,4,28,16),(2575,5,9,12),(2576,1,28,18),(2576,2,27,22),(2576,3,27,22),(2576,4,16,27),(2577,1,39,24),(2577,2,27,24),(2577,3,23,23),(2577,4,29,26),(2578,1,22,35),(2578,2,22,16),(2578,3,23,16),(2578,4,12,20),(2579,1,23,29),(2579,2,28,32),(2579,3,28,23),(2579,4,27,22),(2579,5,17,14),(2580,1,27,26),(2580,2,27,26),(2580,3,17,32),(2580,4,27,25),(2581,1,21,20),(2581,2,19,41),(2581,3,27,26),(2581,4,30,20),(2582,1,23,18),(2582,2,13,32),(2582,3,29,23),(2582,4,24,20),(2583,1,15,23),(2583,2,26,18),(2583,3,11,20),(2583,4,17,14),(2584,1,25,30),(2584,2,18,25),(2584,3,27,21),(2584,4,20,14),(2584,5,9,10),(2585,1,31,21),(2585,2,24,29),(2585,3,22,22),(2585,4,36,31),(2586,1,27,26),(2586,2,31,23),(2586,3,21,22),(2586,4,30,32),(2587,1,28,25),(2587,2,34,19),(2587,3,29,25),(2587,4,24,44),(2588,1,30,27),(2588,2,26,21),(2588,3,26,29),(2588,4,26,21),(2589,1,22,20),(2589,2,17,24),(2589,3,28,20),(2589,4,21,31),(2590,1,17,25),(2590,2,24,31),(2590,3,20,26),(2590,4,23,22),(2591,1,25,25),(2591,2,23,26),(2591,3,22,16),(2591,4,30,32),(2592,1,34,19),(2592,2,26,22),(2592,3,19,18),(2592,4,18,24),(2593,1,34,26),(2593,2,24,26),(2593,3,18,29),(2593,4,37,30),(2594,1,28,29),(2594,2,28,29),(2594,3,22,21),(2594,4,21,19),(2595,1,24,23),(2595,2,23,13),(2595,3,24,27),(2595,4,21,17),(2596,1,27,36),(2596,2,34,22),(2596,3,33,23),(2596,4,26,28),(2597,1,22,32),(2597,2,34,32),(2597,3,31,20),(2597,4,39,37),(2598,1,28,26),(2598,2,25,35),(2598,3,20,20),(2598,4,30,23),(2599,1,35,23),(2599,2,33,23),(2599,3,26,22),(2599,4,25,28),(2600,1,15,28),(2600,2,28,28),(2600,3,19,13),(2600,4,34,33),(2601,1,25,39),(2601,2,27,30),(2601,3,26,35),(2601,4,27,18),(2602,1,22,20),(2602,2,24,23),(2602,3,33,23),(2602,4,28,20),(2603,1,29,16),(2603,2,36,23),(2603,3,25,26),(2603,4,26,27),(2604,1,23,23),(2604,2,20,22),(2604,3,25,19),(2604,4,18,18),(2605,1,37,28),(2605,2,24,28),(2605,3,33,21),(2605,4,18,24),(2606,1,15,21),(2606,2,30,25),(2606,3,24,21),(2606,4,25,15),(2607,1,29,26),(2607,2,41,25),(2607,3,17,20),(2607,4,27,26),(2608,1,17,17),(2608,2,16,17),(2608,3,12,26),(2608,4,18,25),(2609,1,33,29),(2609,2,30,32),(2609,3,27,25),(2609,4,22,32),(2610,1,29,30),(2610,2,22,19),(2610,3,26,14),(2610,4,27,27),(2611,1,18,28),(2611,2,22,32),(2611,3,29,23),(2611,4,34,35),(2612,1,15,32),(2612,2,31,25),(2612,3,17,18),(2612,4,38,24),(2613,1,26,27),(2613,2,29,11),(2613,3,17,33),(2613,4,20,24),(2614,1,22,27),(2614,2,27,29),(2614,3,27,23),(2614,4,20,23),(2615,1,29,24),(2615,2,21,24),(2615,3,35,20),(2615,4,18,24),(2616,1,19,25),(2616,2,19,20),(2616,3,14,31),(2616,4,27,26),(2617,1,25,34),(2617,2,27,24),(2617,3,28,28),(2617,4,25,18),(2618,1,23,22),(2618,2,19,27),(2618,3,24,26),(2618,4,30,19),(2619,1,19,19),(2619,2,32,25),(2619,3,26,19),(2619,4,27,19),(2620,1,23,29),(2620,2,17,23),(2620,3,23,19),(2620,4,17,22),(2621,1,30,16),(2621,2,20,26),(2621,3,22,30),(2621,4,26,32),(2622,1,30,24),(2622,2,25,21),(2622,3,28,25),(2622,4,24,26),(2623,1,30,27),(2623,2,37,32),(2623,3,22,23),(2623,4,33,23),(2624,1,21,20),(2624,2,16,21),(2624,3,26,21),(2624,4,20,25),(2625,1,24,26),(2625,2,34,18),(2625,3,33,18),(2625,4,21,15),(2626,1,14,21),(2626,2,24,21),(2626,3,33,22),(2626,4,28,23),(2627,1,28,29),(2627,2,29,24),(2627,3,26,23),(2627,4,23,21),(2628,1,27,19),(2628,2,22,25),(2628,3,31,20),(2628,4,22,26),(2629,1,26,20),(2629,2,32,23),(2629,3,25,24),(2629,4,22,25),(2630,1,22,16),(2630,2,11,26),(2630,3,31,15),(2630,4,29,33),(2631,1,32,32),(2631,2,33,23),(2631,3,29,19),(2631,4,23,15),(2632,1,24,13),(2632,2,36,21),(2632,3,31,24),(2632,4,26,34),(2633,1,23,20),(2633,2,26,22),(2633,3,20,37),(2633,4,32,22),(2633,5,6,11),(2634,1,26,20),(2634,2,28,29),(2634,3,20,29),(2634,4,36,17),(2635,1,26,19),(2635,2,17,24),(2635,3,35,34),(2635,4,18,21),(2636,1,25,41),(2636,2,25,30),(2636,3,25,15),(2636,4,17,25),(2637,1,17,26),(2637,2,19,29),(2637,3,21,26),(2637,4,29,26),(2638,1,22,29),(2638,2,25,11),(2638,3,30,18),(2638,4,27,29);
/*!40000 ALTER TABLE `game_quarter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `phpgen_user`
--

DROP TABLE IF EXISTS `phpgen_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `phpgen_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `password` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `phpgen_user`
--

LOCK TABLES `phpgen_user` WRITE;
/*!40000 ALTER TABLE `phpgen_user` DISABLE KEYS */;
INSERT INTO `phpgen_user` VALUES (1,'boston','3c66157844fa8ce7e9b67b0022383d7709ba2b30f8306d3c9b2eceb2cd91e4dc'),(5,'lakers','be392b792809651cdec3485da4357568972ceb4cfd939c4bf5e5c3d011b04837'),(41,'admin','8c6976e5b5410415bde908bd4dee15dfb167a9c873fc4bb8a81f6f2ab448a918'),(43,'game_manager','6ca5cab77e702c787b4c14b3d3bf26bad43da606be6eed04ab0b9720120ae081');
/*!40000 ALTER TABLE `phpgen_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `phpgen_user_perm`
--

DROP TABLE IF EXISTS `phpgen_user_perm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `phpgen_user_perm` (
  `user_id` int(11) NOT NULL,
  `page_name` varchar(100) NOT NULL,
  `perm_name` varchar(6) NOT NULL,
  PRIMARY KEY (`user_id`,`page_name`,`perm_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `phpgen_user_perm`
--

LOCK TABLES `phpgen_user_perm` WRITE;
/*!40000 ALTER TABLE `phpgen_user_perm` DISABLE KEYS */;
INSERT INTO `phpgen_user_perm` VALUES (-1,'','SELECT'),(0,'','SELECT'),(1,'','DELETE'),(1,'','INSERT'),(1,'','SELECT'),(1,'','UPDATE'),(5,'','DELETE'),(5,'','INSERT'),(5,'','SELECT'),(5,'','UPDATE'),(41,'','ADMIN'),(43,'game_list','ADMIN'),(43,'game_list.game_quarter','ADMIN');
/*!40000 ALTER TABLE `phpgen_user_perm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `player`
--

DROP TABLE IF EXISTS `player`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `player` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(50) NOT NULL,
  `last_name` varchar(50) NOT NULL,
  `photo` longblob,
  `career_start_year` int(11) NOT NULL DEFAULT '0',
  `career_end_year` int(11) DEFAULT '0',
  `country_id` int(11) NOT NULL DEFAULT '0',
  `height` int(11) DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `weight` decimal(10,2) DEFAULT NULL,
  `college_id` int(11) DEFAULT NULL,
  `current_team_id` int(11) DEFAULT NULL,
  `current_number` int(11) DEFAULT NULL,
  `rating` int(11) DEFAULT NULL,
  `nba_profile` varchar(20) DEFAULT NULL,
  `photo_play` varchar(50) DEFAULT NULL,
  `position` set('Center','Guard','Forward') DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_player_college` (`college_id`),
  KEY `fk_player_country` (`country_id`),
  CONSTRAINT `fk_player_college` FOREIGN KEY (`college_id`) REFERENCES `college` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_player_country` FOREIGN KEY (`country_id`) REFERENCES `country` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=571 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `player`
--

LOCK TABLES `player` WRITE;
/*!40000 ALTER TABLE `player` DISABLE KEYS */;
INSERT INTO `player` VALUES (66,'Kobe','Bryant',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png','Guard'),(78,'Vince','Carter',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png','Guard,Forward'),(80,'Tyson','Chandler',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png','Center'),(90,'Jamal','Crawford',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png','Guard'),(116,'Tim','Duncan',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png','Forward'),(118,'Kevin','Durant',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png','Guard,Forward'),(136,'Danilo','Gallinari',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png','Forward'),(139,'Kevin','Garnett',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png','Center,Forward'),(140,'Marc','Gasol',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png','Center'),(141,'Pau','Gasol',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png','Center'),(142,'Rudy','Gay',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png','Forward'),(146,'Manu','Ginobili',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png','Guard'),(149,'Ben','Gordon',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png','Guard'),(154,'Danny','Granger',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png','Guard,Forward'),(167,'Udonis','Haslem',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png','Center,Forward'),(183,'Dwight','Howard',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png','Center'),(191,'Andre','Iguodala',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png','Guard,Forward'),(201,'LeBron','James',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png','Forward'),(206,'Al','Jefferson',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png','Center'),(208,'Richard','Jefferson',0x89504E470D0A1A0A0000000D49484452000000E6000000B908030000000B6CB3AB0000000467414D410000B18E7CFB519300000300504C5445000000562B19E0DAE155616D7A422A5D5351F3F3FA302D3E1C4F91D4C0BD2E40562B252E5B6770616E76EFEEF9EFF0F9F0EFF9E8E8F4F0F0F9FBFAFFF2F1F8EBEBF5EDEDF8E9E9F4ECE8EEE3E3EFE7E7F3EEEFF9F8F8FDE0E1EDA85C33F0F1FAA45930102042A05B3D96451C773717E0DFECAC6138AB5E33613A2A883B18AB592F9A5432AD5E38A85E3C885237AE633F8A3F16AC55281E26450201040E14278F44206B351A772D0CB36138793E20151A31A24B1E793A198A46242C589A652F16A04D25211011743F29AC5C3371371A643825924F2C5A2F1BBA7150A357348B472A591B05B46949874427B76D43B06439743E2703061C012976A96240985438B2683F894421B55827763A1D833914A95D37E5E3ED6A2D0F6A22056C3119E0E0E9BF744AE5E6F19A522EA6582F823A1817192DAA59337B3916A96038262B49A3644AB9B7C55F331F9A512D7E351880472A713B20B6613383492CCF8961B7603111172D6B3820BA673A834221995A39E5E4EF8236105C91D79A4A21C2754E722F0FA84B1CCBA6A0D1D3E2C57E57D9D8E4944921045BC57A35110E142A914015833F1BB4653A6636209D4F29C9815F82442AB25F3370371D7E3F247F36149B512A603019BD7757A35C39904B2A5B2A13B66740481B0DC77B4F934B279548259451316A2A0B11172C9141188B3A127A3B1E89411EB25D30B26944974C27AA8279023DA40C1120B05F377D4327BE6E438C4927B86E4958240E8C4B2BA45B35C0785158312097502C713517733C25B05D3379452B3D180FA0542C65321B8D6A628A4A2E5F3D43A2532A27212D7F3F1EB6623767351B802F099546205433270606131A213BAC5A2F8A401AB2643F915538AB623C90421BAE6339994E27C67C534A291C0A0F25EFEFF9BA6940EFEFF7964C29CB82588D51320E183E6D3014D5D6E3E2E2EDDBDCE9D2D1DBDDDBE5C6764DF9F8FAA9562BBB724AA65932A85A37A3552FA05632763316D8DAE7E3E3EDE7E6F1E2E1EBE6E5EFE0DEE9E4E4F1E9E9F3ECECF6F2F3FAF3F3FBF0F0F8EAEAF4FFFFFFE8E8F2F3F4FCF1F1F9F2F2FAECECF5DEDDE9C0F093220000000E74524E5300FEF048F293F2E2E0F486EA280BA17E8D30000020004944415478DAED9D093CD5FBDEEF8FA4CEDEA7F6DE65D34186CC92A132675809654EE642929029D9C5A2A46DCC94395486321532649E42126596C296B1B02CD684C45A86FBFDADDAF7B9CF70EFF3DC7BCF7E4EEBBCCE6F0D5669DBDEEBF3F94EFFF51FFEF4A77FAE7FAE7FAE7FAE7FAE7FAE7FAE7FAEBFE3DAB9630733F30EE69DFFC88C3B985958581A5944E1C1B263E73FA88C2C2CA2E54C29292989AEC75DCBDB441B59FEF134DDC1D2D8E6AA56EFE5D5121919D9D2D212E92A2ADAD6F68F45BA83B9B1ED38B02546467A457A21C816F4E4A5295A0EA43BFE41DCCA229A08545E9191AE20A487975C8B9C1C02F5424B53D3559485F91F80925934452DB2A53EB2BEBEBEC5C3C242D10296069D13817A78896ABA96B3EC64782953D4BC80B2A55E4E4E4EC351595159394B390B3841D3162F0DC004414541518606DDD1960259C70B082B3594951D1D05051D951D9B9595053560796878696880A291A2908E449919D9B0AE912816352C042B95C32DC3C32D1DC3C3ED2DC39B1D9505959595C1BDB1B1721E722D88B38D85512959CA3541C858104ED0D1315CBA43BAA7A3435ABA039EC2C3C31D1D959535342C2C62E534E42A35E9A03B1895D2032863C1A38EF1E162D21D3D3D02C10F1F0A04CB0AF400B03D421554B68077A172CE0371F633A2715944B77A80542826E3E32D33C5A41F3E0C13F0A3AF3EBF603AA9B4A53D882A5859193BE7A10E55940139598EAB5779C442542A3BDADB8B49676622CA237E47FAFC8E609A309860010101696969B1F8787B484C951A821A1E5E9AE5FD8C16A0DF97D7787878A0A8B40F97EE11087B2820007C478EF8F91D693A72B0095E0A08F4644A77585AC6C7C70BCEC1B2888DD564343D998F6F8DF5F0B0800262D9D11ADCEAE70784180CE6E091A68370BB39D5D47444E048D84350580C81CE090ACE094294BAF6B7315201DDD91FEB11EBA101B9C752FAA15F1DA6E9FCD4D4D4C1A99B07FF65D1057DF8B0471A382D43813354505043ADFC1E23D996A544111C6BA1EC78CDB2A7C7AF6E56E2C0B1EAEAA99C9C8307DB73CCCD7F076DC2F8B5CAF6485B76885986863A0ACE39CED92432D5328E6D994B40CC580B417B314BB1B4A83A6DDC81CE82028588CB97AF5C8647CCE583393939D539FBF73B34F5C9CACA8AD98B89B987CE85829E9572894C8C63DBED191E1610988E62E162ADF83A1C4EAAB3B3F3EEDD01EFAFEBF2E598CBDEDE7715223A0FCCFAC9A689898985DBC7870A42C60DAD5473BDF73DA38899A2ECE181CAE53559BFBE599E0352BDB906D3D3C5D3858585DE7007CC172FBC235E14DF3D20E510D59AD66369D961EF0E0937DE51D0BF3231B19F41BA2116EB580BD4F9C44BF7D49D9F3976E040A75EF1F4F48D1BB685F4E5ED5DE87D79E0C5C089137A5212337EAD3D1D503E43ED2D1DDD1D052B47122319240BED4891B380EC131A6F29DD1135731E02D3A0B8F8465960E087FBF7EF7F808558070A8BF5EE00272E4A40F6A198181415CB784790B3522391A97F2763A4590D544AE22D21CDFA35CD3A1CD03328BE5376FB4DE06F8059F8A1F07EA1F787FB376E9C380198DD387C5F6B0F642AD425806B81B39E89317A84ED561A904C42432D33A505FCA064E61A18DCB91378FBB7DBF7BFA809A41FDE94DDB97DFBC49D3B277098A8B4A156E96CFBF8F86BF18EF6CA1A722D89BADB19C2B3D0A10AC6875EBB760DB5EA4DC70C8ACB6E94DD06CEDF7EBB4FF76D213C6E04DE7E7CE7CE1DBD6E282A157E3DA872829AF6827395C0C90849E8FB94914A2466E84BD4AEFBD5151894DD290BBC7DFBB75F7EF9E5B7FBC8B8B00203EF040606DEBEA327D53D3BDB8730E3AF01274A42728989F79819213447A0D087CABF0CBD16261D7664CA10442B434CBFA0852405D4DF7EBB1D78E736A8997BE0346EB6EF116AE14343AFB90B0A8EC8B51C2F6180D2B93D0589E92FFF123C1B268011B97BA20CE42C7BF3DBEF9888F44D20080CFC2772BBA1A844F540CB0789365E3074AEB2A5E5380304E7CE36AB117F417FFF50C0044ABE5E5303200AFC1048372DB22D5A6FDE4012BA037A424D71C2D9C9F6F4A01C140AED5EA59CDAF194B66F1F73BB9A556528C27C992980E199E98E2886387C73E3F66F81741DE10E5A7E282B9BA6BBF64EAE54AE94B66C47873D2A28A173232380C9F4EDE7A09D6D6A56FE40297FED5A6658D37927615330EDEDDBBF400E0A7CF3DB07C8B55F1A04DB695B24E6895C3D3DBD2401348E41D69AAB1C416A1EAF6500CC14392B2B2B64DACC234D7C3CC2B9F43CFBCB6DDBFBC8B25FFB20DBE9C2E9B213D0EEC1CA35C6B7CA42F71EEA0F26181951536362FAF653ED8E3635357FAB0C7F79F96B617E097C22A60627EEA014646B5B880CFBE1F76EAFF0C67471B19EB39E73B1B1445205B8D612202BFD47D4AC5A521860E8DCD19F68359291219F110A3D901F9FB0A9A9C1B4C17419B2A92D322CBADFA7534E9F28CE3535CE354E4A72E2B393B5B494CFC80031AD46D412FBBFFD618CB91F99362323E39AB44070021F8F93546E67F17471992DC2BBFFC5B5E8A90C388B739D9C8CBB8D4BF1E2E2A91D96F2FE73FE566A5623A0260398B63F45ED2B6670705F134F3788593C0D65F3B7375F4A265ABFBD090C845C3B6D60DA2B655C9A248E4F2D920DF70F75F41FB1521B41B1C9C2006A2602A6BFBF63584F701F9F0818165620D4CC37D01BA0D2F9A545B80D7D51D989E962033DD3241F3B2D956C7B47A8277356296A6A894C8C60DA443A66A863B874309FC87419EA77E8FDCF2FFF6AD1FF0E58CB02EF14778B279B353B3A3A02668A9515C26461801494482F288E40C963807AD9DBBFFC07EBF6EDDB308BC1D31D6767E324712DACA3B2E35C28726DFD71C6C04CB152F3F717740CD6BAE4E37CC2F9193C9C81E80B1D5DD3DF6CA7A7939E4AD257A3644D55CDB04F924AB3200CD5735036A1D9FBF63177B631A9410EAA540EF64C3C5E23893ED0D3F4A8196E303EF1DBFFE47C23955481F58874EDAF7DDEDF262AD9E85A5313AD8515ACB4170CAD847A92C200983088A5A88D54563617B5B4D534B63DEF7F5EDBCF942277C9E7F4F457297FF9A52C3709DB50C5C454FBBCB6B6BF0DF454F78C8D2BC23A3643748EA831446CFE697B891AF4DF16E11EC7DB6A4445FB6B8FD6D61E2F49D14AE833FD7D3EB97F7FDA49EB69ECF17BB5B5E59E92C39E35E0DD9AAA3895E6F06641C14AB514A6140698AB59EEA5B4546A68A895B88AD6805D35409B448BE63E3E9ECBB6A82D40ED41A18171A916B685292511456592A4674D4D4D95DA08603ACE55AA319530407B802A8A9C85855C4ACA4950C9C7C9A7482331A545B139BB82CFDCBB10DAD90F85DE7C7EE195724CB5B5F74445CB6B6A148BD2B59ED8287A8C649935DBA379938911B6ED31F71F6FB1D0A86C51C45E1A1E6E71F510EDEFBF77B4F65E4AA57D70BB77E1FD0FB606BDA9D0D495D4F68BB6D51E3D7AF4796D62A20D169B9ADCDC6CD6AC3C3722773C85113E478154DBA2A12CA86C666696527B0F380EBF3A0CCF4C6AFEE14DDE6FEEC3A4C253D4ACD8E2A5AE29DAD8F8FAF0F3C310BCB5BA96A9A9A958336CB360A55CCAF11446D8EECE5252AFD1DC1C1E1C9E518BD4CA7F76B8B1F1D9BD7B91CAC17D11B6F70B6D4D792A8615BB24754BBE9BB8F8FC55DBE1678DB5F7EA15A565658B8AB0CD7360DA4486F87881B9564E43595A5ADAB112D4FCB511F43ADC36F14C57F28959F094C8E52BA6ED515A152ACECF1A1EFF75B2EDF0E1C3CF1F3B57660C3BA7F741A7AF622F5839D262757CC79F767EF3B6656E6BF17004CC6071456BE9C72E4079D8E53B49673D2CB6A3B5C93CA7BD2FB8A3A24EECD9E3138FBFFBB5FF68DBE33BB2A126CECE7AFC7C76A9D948CD14ABAD5BB7466EFDB63977B24846BAC60266429DB3B1A07C58E0AF8DFDCF1E3FF368506C2E0A176832373F8691CD96151FD68F566EBEE42319EEFCF859EA23E3E213CEB949F8A26C2CB4072995B2D50E7ED7BEED64CB127650F1B886E3C33E3EA7DCDCE050ACCFE3DC8AE1E6CA275E1658C58E23052FCC639A6455B28BBA7CD27DBA3C87D37D9CF59292720D7273BBBBF912FA649B0547D4AC1C65B5AB73CCBFEDF8DC7A13B33552C332B88ECFA9D7D429A1CFC7D9A74BD2F349A5461C162B7033E7CA0B730C26391B1BAD1FAD339C3EECE3C3CF6F9C6B6C6ADADB5BEA93D0171CAE51A9A6169E6A669D91F94D63EEDC6A1E8CD554940E0EAE03CC6E27E3626767671FFD2C1B8D66D956819BE6575EBC3888194A9335C3C6618B925387C4F149DDDDBDA6A606BDA57575A9C1D9CA36566AE1B2DA5B75BF6D4CE6E197BAF6EA8A3DC17D22BDBDA051AEB38F8F16148AE6F01E598123D503DE57BCABD3306E51514315760915156EE26E750EF00F0D0C4C7B4B13FACCC295E7D46CEC1FDE2CCCB496FC967310CB4BEB9758F5666930AD2150761B3BF9D8550CA5A6A509C0C2A05D0F065E605A67F1385CB794A114AE14771A77CCB0B3F3AEC1B401385CB6234B50CD262BF84AB5B9F5CB6F3907B1DCBCE99DE06516DCD7C4676A60EAD46D9CE4E424515A3A8BF1C31C1138E8ED0D6A1656B762B4B5A5F48AEF164F1BF42ADC35E88C1828B485974E7CC166CD166AB11ABA0F3BEF685BB37CD38936E7B2B487565F539388015AA6A6B9D3C5771D9A30188C40D841FA3E33850EAD69B3B39DC5274EA0DD2E6CD116B1B21B65C5A6A64EF85495E62C359B6C6BDD974D9D2FBF654C9D9BDE612F15ED129AA60C0D4DA7CBCAA60D72A7EF2A1C98F1C3601E42680E5C014CF3B4B4A8599C5EF18DB237376E947DB85176FB76E08DE201293EBC1DA8596F13DE2AF032335B7EEBB79C680F7A1FC17AF6051F110121A7A7CB6C21E8EE161C03CF42685617169A5FF17E518DC1A4CDE2A48A4FDCB8F1E1CD8D0FE8836B5073A0B3B4AE2FB55943AD3EBB7576E89ABCF5378D79A4B329DD333838A1D770FABE8181ADADEDF4F4DD5E074C949F801F26E7C515A4E68BD9D69E34A94EBD1B20E69B373702DF04DE411FA8E4F2D425148557A6A8A9D4A5BD74B7FEB663F3E5EC913ECFE03EC084C8B42DB42DBB5178B7F38043548F6CD4418C39A21CE89CC5F4E8E0F440CCB237816F3EDC78737FBAEC8641B1294F425F91BD5CA25C7A5DA6B5BCEECB6F1BF35A66F03036814F242222E2CD1BDBFB1075C59D05523AEED97E514D075F1416165E71C0A4C9BA0FE99DB8F3E1C31BA0FC507803DE8D6205DC4C42AA4A964D8A8D0F8FBCAEB56EE6B75C5098E5ADE5FD25C3FBF8440C23EE078225DF044E0F141C1BB27C28E0E777C4BCF0C387812BD54D7E47C4B24D3A8BC1B3818537DED8DEB87163FAAED44C5D9F6CB8454BC9C9DB43BABABAD635DFF247B93B1AACADAD472E819A86DEB6818181B637CA0C1414B47B3031310E7E47AEFCF2CB6FB707AA0BE09696C62F3170E3CE8D1BB7DF0496951517DF3DA69D9016DE5C599F52136D6DADFB6D7B16B976CE3EC3A3AF4EE4B261E19B1BD3B6C50A0E0538D9A68137817A37CD7FFDF597DF7EB9AD70F7CEED1B9D69E9DA908502A1980406BEB1BDDB793E6AC82C3BCBA63EB244374C563E0CF38D0F6237DD12943555FA30BD06DE85A052A7834341539A43C101BDEA232F7EF9E5C3870FDE0E2F4E74EA7546A5F36B1F38F12110140D0C2C8E3856D737948A8DB55173B57938857984F9C6B793EC943C5257248A0DF613F18E8830B85B3D8B3BB01F935627A69B21DF73D3FB8AF9952B37D36CEEDDB376181AE2C775EA151697BD292BFB50DC39E336145CD46C535F9FA2EF17158591FCD677B260C108F8B99E4CED6BF78E50D8DF3ED3B4DF0133A52DF632D9B9213D0AD3EA2E86318956AB727777D7C149E8DD1D18283C51F6667ABA733F0F7E28D52C56AE3E3131FD40D34DC96F7E53D04EC99B57345D5383CF1BC654EF3FEF303B05EDEC6C9A7B6BA79E1E3FBF89BB3EBF89899E9E89982CAE73A0F3AEDE4031BA1998CE40435BD43CA2565F9F987CB3622B03EC9BB853D25CB1FF696A5FD3547B81210F74ED535353B351696E1227F4EEDCFEE5F61D3D3D6709136D30ECC0DDCEBBE8016398417712BEC8DE2256CDA63E516C2B631C71BDF399667F4DAA595F7BFBD4FEF3E73198A66A0587216D673DB4F7DAED3B279C4F381BF3E3700A2F3A0F1C50E8EC8C302C3034902AD5D25251D6901B91532B619C4356594ABCB02A753C7C4730B34D7E7E98FD0E51E2FC7ACECEC079C71938F99D4DF81168C181039D119D113CC70CEB528B8A2E29CA55C6CA599533CEF18DCC4C91352A5A7C7598BE28E9B02398A8283713673D0984E97CE2F1093D7E67676793746D5C01CEC1E180F001273EBE8AE46015452F39B5160B06D82DF15F7AA1E35E1ECD457D7D7E4D0FC582FDFA86D24D4CBA7C9C61900621F5F4F48C81B2CB04E253DB61561B373B33DB376486C55679C5DAC869646C67204C262F2F0F6C9F5F5F9F6C4F5A6AD1D3AE612D1F716329299C094E1B77574F8A3F7D58D20496DB2CBE0FCF375B5751A4828D53948BB588957BC948986D361E272F819AC1D96645459E4F9F1669E19360F4D21BE8D43B81F64894303149EF92EC32F1114F4B4B88C25414619B9F286A5858C8C95931D2B170A295A21E9782FD823BB0976A542E61B5DCF0E2FC26127A7A273EE8E97522DF4A99A437E8344836748917A52604DB15293E51044C8F7A1B4632ED9FB6877A697AA80407073F51F4503453A970D3D1D7412E75860E61089E21D3F20FA53734C475F93C4D1E0A4E35B3F0508C05CFB6D89430D4918D56EA9084CC648B2E69C89D7CAA151D5715DD60620277E881E0E16C2219AD9F6CF254C5F3A9E7136C91AC99A2A26256AC8745AC8D4509231D8FCB52E2A1E9A568D6837DD22C97C8C4A40994920D92D13A3A263AF06830916C88D68CD44CACF768F6BC842D6AC5C682693DBCBC62632B5318099339E5A4878707D6ACE792E713B59412DDE3559AEE5536EEBFAFAAAA2A1BCDFADAA3F7229F7679EA6BA96441585679C4DA447AA9313112E68EFE168F1A90B343A56B18AB933E078428329DE9F16982BA03131D751B7793E82EFE2E4F336CB3628B073AF74C62BD1A431D5CFDA7ED29F08B2B5EC29A790E37E837C0606282D3BB43DF17F1F663F4A4E7AC837252D7B04FD7136C968557A4A217C26CB166A4448B82B3C54BCEC3235CF1C9A5618847137D1DC0BCAD7707CA2680FE7A9BAE6B03E4DBE127FA6616F5AE5E729A552DF5F56A258C85B98329A5C5CBC34251D1A326DDCDA4A10148F56EFF8A0E7F43FB973EA6DB37BA81DF19302F3D9103CCFAFA48AFFAC47A5D063BC1C3F692442F2F0D4545AF9A8661BC5B438309703E46BBCF3E468786A1D8D4893691E097ECAAA98A4467BC4A4C4C6C714D642AD9FA270673EDF1C416398F2AAF9A4B0DDAA05C74B40E4A3DD001212175D09F1BB4F9BB242FA94321A9AFF742274EF24AECB762303559EE1D77ADF7F2F0D2ACB924992E6E92161DDDE8DEF8F50E0F1DA034C1990C37D4A803618B5C7DBD6B62627D39933CA36196B4B9BAA2533BA9AB37A40FE140C1341DB44C4055933413FAE23791AC51D774ADB791933B9E0837A67E9BCCED0C8669CDC454EE5ADFA2A9A97E69381D664BFAD2E3E7D7C3E9C157136DC4E9395CA37932D2CBAB25D1F53860F6BBC6319C9AF25EFD4CE589AEAE9AEA273D010AC78F73460F7E78D203501C3FCC289E3597D4BDBCBC12EB5B2213135D99FAB3E2FC45194DCD2CCDFE7ED71657CDC84B35C326DAFC1280E7AC8733E107483D671C24A2861ACF1A75512FF54810F2787DE4F1FEE3EE71FE0C675A65C5F236D744D772D79A93D1906DF861DCD40345D1EE79E8D9C444D253B24654D3A3AA1E2C9BA859DECF149B65C170A6B5B6C75695B7959703A78767BA493A241C702A68290194F481AC4B525254DDD535313232B1DE55B3BF36F2645595BC26A3C5A672DC93D87E48B7AE9A9A8AFAC3306B467F1937E94BB2ABCB47B2A646B3ADDC55D3B5FCF871D1FE5A578F9355B1568CD61E583B2A4657B9F6B789BA6A8A7A9DF4AC9184960FF542D168BC969494EC72AEA99144A7868C3C5E5E5EDE5FDBAFAE7EB22ACB9FB12614C0146C8E53F438DEDFD6E6EAE5A1AE5EA52E2949DF7E00B4206C0D3A2A431D3C0B65A7DCB5ADBFBF5F13FE4D5CD69C26A361CE29C63D89532F477AAAABAB477AA90368037D30918C6E8C06396B44CB45DBA0EAB421CA7EF847558A59A10C87E96891E5F9A4A60638DBDAD423412CF5E8868668E45C491013D4AC11152D477E6D03C7960365CD93B82C774DC63A7762A3757873565C5C8DA73AA8E55A5EAE095D9F7A43349D145EA937AA8BD231BF48D95F2EAA5E5353959535E7BA83C1D454C6362BC6816C9AC7FB81C715E43AA91EADDE20D9100DC2D578898A6A826511652D8A5F88DDE8AC2C8D39576606C3B4C78209913D4541B236515148B9354847A014556F3C29AA2E0A7FDDF6BCB6BF9F892EF5C938C52C0BE51446C3844C1B0D2EBDA45E23EADA867413051851FA8297E5E890C77E3A64391304AEA77A1CAC2C0B06C3DC9A11AAAC0F8198E57909F484F208018844450ABA22683A632D4C319A6D281383CA5955FA71CA250CA6A6BC72B3998E27365ABF0138D535BDBC5CFB9950B2A9A53FE8876EF6A316C815448EAE893B99157752312E4B308385C130C5C2C3B158C527FA719ECD27D5BDAAD4ABAA342353EED5D6A2233A8F02A36B24DAB8A0AEA95955A35E157D32362EFA090362BE0CCF06CC06CF862C7A7C421BF4E4A457555C95EBBD14E87CEA153D34D5814F14C2D2EBA47AD5C9AAB838F5686C9CBB350B83C56678B68A8A994A517443DC134FC54B3550446A1A86A39F34E800F59393D16065346E46AAD754C579464743028632DB2C28DFC6706ACA0EA5163DD56FD089D3A8F14447DCD6780EC36062D235ECE979C9131D260F0506EEC0088FE868FD38FDACAC115186EAF644E5B1B2A9081338A32D629F444B0EA30EAF6BB88B1F06CD61FAC9002035012934BED171744C7D7DD4ED3114E6D697D8E047C1453AC94345FAFA4FE3AA4E7A0E4BC21C3DDC00885D5D92D15FE494F4AC82A08C1E1E8626501FAB82C56E7567AC36A8F16576B2D6A3D4A2E48A8AA74F8775E2146B7460289144DB0C4CF8F9BB102A1AACD5AB62E3BABA205E1B54F4E1FDD0C72A8F30D219FB776EBD169E5C915A3104C635D1D2D2D1897E02CED47A0AA1E9E3ECEC8CF60C4287C8C5C556497635340C276BE914E9E8D35D6B51B29D71385952C2B35387C4ED2AD2ED86B4927CB49E3678463F390999166293DFC7C7D94772B84BF289E2134F98409FE8A76B693DD54298D171CD16F5250C7222FB9DCC2C4C36F666B21575787171377C6A459238703640047A5E8AF6F4ECF2817CFB54FFE9931A9DE1E1AEE1A7E9E2E9C93A0D45C9C93AFA58686B23D54A8EFFE5FB6F9C7407F3F7DFDF7A6EADE6D55C14FCA82F413C3DBD14AF55210E9C2AC33EE9E9504B9E5C1A1EF61C4E7EAAE5E363923EDCA0A5955E919E9E9C9CFCB428B9018B8DCB8A4DACF7CF386AB4FD9B2505C43FE7BD373A5AE26F9568D3AC929A9ADAE786D7F6E14F12C7E3B5C59F3E4DC7FB2425F9A483AC5A5A3ECEFC3EE23EC3C3E9E9E215E2E95AE95AC945C9280561E362EBD5D4462A4B5E19E5857C93A4DFAB5EBFFEFED551DD7A7FFF4AB5D83895D4A1A13AF06D297FA976525229289A2E2E9E04AF008EDFD998DF47ABCB243D592B19EF66A76D97AEA3A3556486C562A3E32CEA8FDBCC8D548E1C35CABBAEFAE76F0C74E78E3FAB7EB7E5BAD1512B352B7FC1399BD86C95227418AA78425DA9716E125FC210BE420B307D928C7DC44D40D5241F1F10D1AEC24E1B5FAA2D9EAC65976EA6AFAFA21F1757559FA856395739976174CA85743DEFDB5174C7772C7F56BDEE3231F1DDF557BA19FE8E8EA19595165895D4BE0AB70437713C9F54AE446969525D5AAA385D4E10B434C9A70ED405C3E24FE393C487D24DF06E2A2A08331A9BE595A86633A7EC98F13E2FE8AF7FBD1E12F2E76FA2C0EC6499587099D8B265C20530DFEB863ADA3B86CE69C4C615A5DA5554D8E1F1A5B8993A27A95C749E39BC9DB89353A95D69A95352A938DCA0AADA49242589F3E3EDEC8A8AA03D80A20272DAD8540A666567BCBFFED78989BF7E773DE4CFD7BFFBBB93EE70D9C53911C03101941393BF9EBA97691FEEE89EA56111A79F3C3434E456C7E7D42D729A47D8D4C9D8B81B8FB093F0789E241F1EBEBE3ABC960F3EE9F469604EA8108754ABA2A28385D259E565A3319715DC7FCAE5AF011313140075D9F6DDDF9D92FBDC36EEF951809C081877C97B1E166EEF6E9F159B858D2BAA181AB2C3CF960AF74A99F6763BF13895764B192769E3F94A9D664A9DC0B8494912A5223CA57C783CDEAE62283959052A276066C56A546A08865DC89B20CE07044C046C41CBE5EF1AA2CC13EF0697E64703265C02020246E7FFAA7AEAA57478B87DB3721674E2C943A96E7C7CA7A57A85A54C4D4D9DA4BA4B9D724D73BBC1B3A74BBB7BA5BA93ECFA66799C9C66F84AEB2A52538B54A0E5D38F06CC2C0B0D8DAC97EF437EDE9C0F181D859FCBB16DCBB62D7FAF967EE74E179751EA7850C0C464C0C4E8E8E4FCE4E6EA75C0C46637DB6735EBABA81441E54F0010614343C3DE6E53C36EA752A7EE5C29A96EA76E61A7EED33C60589C53370F1F1F68595101C1096AC2D4A998052BDBEAD4F5D5F1F9D1F1797813B9C777CDCF6F71F97B04E88EEF7FDDB6C56592826C3519141434B9B9397EE6E3C4A93681F06C6C3854C0E4A2222D2829781E1E274343D35E2727612727539ED34E3C86C2B33CBDC210934EC23CA7457866EA12120033393935B9015A7C6810E2E09EF93C6F821582619C9B7B7E7C817B1CECBB6582F9BFDDB9DFBF7A35C1EA32313E1F043A1236832629674967CF5059430E8565676763B1CD59452A45A9400909A71796B053AF532F0AC419116191F3C286C2333C3C333CA77978F8EAF07580999A9C9C0E23389A53B0587DFDECB053213F73728FCE0B8D718F732F2C70C39BB9C04B0BF8EEBF774CFBFEB0D15F26462726E0ED9EA490C884CDB3670964C218195C1BE6A7A2928D355351419876755051784E0B8BF42A44F48A88CC0025CFF9F6820843619159E01416E1E3E3ABAB734BA800E1B5A07B0752B47482154FB9EC3D333E3F0E6A6E72EC3AC709A699D8B58B735B80D17FC7F93199B77F8FD65F8C6E195D1C9D70393B46D90C225317C9040E5FC239DF31EAEA685EDBCDE054153315482920661D3E019DBD555844D834C2B057584444A47D66E698437B7B3BE838C3237240A47436015A21BBF4D4A18AA7D0FA2523CE86A2BEC63C97D505C0E486B5B08B6D21607CDE65827B95779BCB2B99EFFF584577327F7FF8EB92517AD538EE12B044241382A82B8B1B642A910CAF899F7F0EB978137AF6A2A2D4E422E869F1757551757C3CC2BD109EA620A1B0618CC80CCFF9FDEDFBF7CF9C17118118AD03BD132AA0F654C002CC229DA74F7592C1B3CB3F2C8096E058CE3D0B7BCE4D8C2E809E52A30FBC00001B2449444154E39CACDB2E1A19197DCFBCE38F3B3FD48E5346AFF2651EBC3AFC4AE601602EB94CAE9C251227FFBA41DDA01289442AD1D7970AAE75DF9F30945A945A94EC9620CE575A5A5757D7749E47A4D3D43422C2103D44440A8E1D035D45848521644BF176756E8FA091A8A810B783E2A9959EFE541FEF057916120FB7D0D8C239F29E05B6F100C084F81C5D61BD68F4C0E8F0AB5B7F91D9FEFD1F536398F38CF2F3658032FFC1D55B871F9F0B2050494B84203260B27152A9444E3299BAEA92D7888146BDA8C84CC72D01EF84AF837687AFEEFC8C6184A1610C5416C3CB313131862231906B450A84DB79A068260C3DEA8351CD0E064F800449D3FD9EE705B072D21DCBB14064232E8D07042C8C0366C02EDE8BF94A320F5EBF7F6BF4F66DFEBE3FC2BFCCA78E0225125349E9ED6197F9894522E74F6726491B1B1B2B8B8B8BA02879D7F272C8FBB05CF10A084F9093A7BB3401520CE214112E881101429118C318B47A45F8C0B5E7E1BB097DA9157CB37CDAD0CC036945FA70BAC44BC8B33F9D1BE7E6004C5FEA0A2727F4091C50530202C67EBE68A42493FFE0B5D255A5D7174E8530FF1198F932F9484C2525A5FC572E01F3D40502179914049C4B2B744C222727EBF553369DDDF847109DA9D0B677E70AF3F035CDCE9E173135CC1189415E4598F05A244698E77C5D53025A4375A54E4E1249E2765AC93095F2F3DD833C4BE418E758181B5BF0DDB5676533603480837B3360627E410830956464AE5E855F4266DF1F81F9E753471166FE0325A5ABAF2EB88C9E5DE420FD48381B441A1CE44294E05BE2E2AA50C8F3B0E9A4845459D90ABCB653AF69C46961BEBAA6D976F02B6809911983EE31223922EDEDE7DBCF4735D53DEAAB2B9592CA954A12A70F67E2C6A1EF4302587781921CBE631CC45DC43DE313F3139B1C42A8784E5CB8F55AE9C185ABB7AE2A5DBDF0C760EE3392C907312F28295D38DC383F4A60235279CF6C5248EC5CEC2B484EE0A4B2819CBAB8DCA48AD4A247309DF4760258370F0F3089A0E0045291CBF0423826A65DA43D4764FF6C1D0CDEDDD0D41B1B3B6B57886B55F8180FD79EBAFEC32E4E21680BCE71732FB271EE421DDFE6781074450B2EB76E29293D90B97A4BE6D6D53F46CDEFDFE7E7E7BF7AF540E9F56B9957CFF69088EC04322F811434C9BEC4B682181757A8644E5697BCA3F2B93E3E76A9A975DD52A6B9B98652A721320D4D0D2F5F3644A605CB5E0639DBE195A154F7E9D9D2D3A7BBBB738B73738DE1BD792A9EC4AFAB94E7C2BAB030E6CBC1B1C0C1B167D79E855130EDF8FC26C76800BB8BD15BA5D757656480F242FEFB3F44CDF7466F5FBDCA7FADF45A291F12EDB94D2E5FEA4F93672727A94BD40DA4E5E2CA2299B8BE1C724A37DA3849BCA222C109288BA773859D66780C4D0D220C2FF7422B94D3DE9E03B25E8E301830B82B058D110CDDC5B97A279C737D86922BC48DBD6A4F85B0B20120E7B905D073CFB93D42A360DAD14D218E80009ACB61C05492790B98B7FE10CC9D7F3642625E780DB1F1EA81CBB973907F569648240A85425C1A042141CD15327117ABCBA95A5D1FE35268F44ABB0D7273A7734D4DBB85BB2322BC916973DA632E7B5F863F987A1B0CDCED9C99C119E7EA15EBE5E69ED033C65724571847D73E471D103896089864E8F0A01B1A85541B1404C996FDD96199AB2807C9DCBAF540E68FC0643EF50A30F3E1BD5492397CF1ECB973636BBED48D4DD2266592F06E896DCF174CF2E2327BC8EB7BCAC63E76783C9F69B18141F10930A414A8F9A53710B97CD9DBDBDBC0D0D0A070C0C07466464A4FEF0450E63AEB39275568890F97D4D23B208E054E2268796E1727E75810740701109E634101B46746571F5C557A00055C46267F5FC8DF7C666151054CE80C2032C1B3CFF62E1228CB44E2C6E459CAE6E4192E7A74AEC0932FE72EE8846A4BECF0097678645A039830E14B6EAEA93760991A181878DBDA1A141A781BD8829A1212C6C6B952DD9067737393DCD2545432EE1DA54726B405C8B49C9CE738C747B9E9437B90D0FCE8AAEAE1AB5721D1CAD031DF87FC8DDB03E6EDBAA7A03BC8CFBF006242B7F598C6758EB07E86B8422140F77E76093017414C084EF20AEB99BCE7B5A1757DA9C1906A4D0D0C7B0F14981A1497190C781B4C1BD84EDBA2B32B97BDB19DBE31D029952B819370C039E066A0E30B964D93CD06315559D939C1B244783AB702B0F3F3083300C6958051DAB3C3B71EC092C97F8BD4CCFB9B7E86BF83A5BFC45A751F98F601F26CFEE17C17DE4F04C232994A3D4B4613F5E212DBC69E15C449242F1259919CB2C1B202C151097C22C70A0C7B0BEE1A944D4F4F171A4C970506DEBF1FF85B606060996DA18181A9C3E91968EF5B7B7A645B1FA56687CF819801AB202627AC734468DBCF71C36C3D8A3047C747273EAA1E06191FC8400E929179752AEF6F7858EB4E968BFDF74A4A4EA17A8228A1797F3ECEC5CB415EA62E122984A04DCA59F2D2CA1248C9B6C206B976713520EF82EE5C4747AB5F5F1406737E0A064C8362FAB55E6CA7CBDE048294881330A70D0C8F9DF70B16686D6D0D969595CDB677CF809AB9778113B91516F11C1B27F7FC3C14132829E8CBFC4748413220A60C0467FED17D21737FAB7D3276B2B4F5EB6694E8B69D7A0B62429EBD009DD0C50D4EDA1899D7974A387B76F4EC2489C0B6B1415D04EB42749257F6203933ECB34120CCECF9F3B3FB0B6222A66D0BCBA66DCBA6CB6C6195DD2F2BB345AF06AAA73018BF4769ADAD69B21D62D9587BEBF7211456C084044BA5722E70EEE21C0F023EA01C9D9FDF9C0FE07A76385FE61688F916359EA7F25AACFF26879531835D33E4E5FD33742FE67DF52C1495C38D7BCFD10844DE338BA4C9CD09C259F226851D0897D890A4E43D6CABA321EFADC5C464D330A89B3DD0AB50603870B710B8CAD005355070C2D7FBB65049DB8FCD34453D7A949696D62A2B962D9BD99FE782C4DCB5671795BA87C8B9B487733468737E1CEA09C829341F4053A563C23B9EFFF62DA8695592A1FBFFFBB9EF0E96ED20E43558A1FE198DA75E815DA032438790DFB8CAC97B866D89BC223409E584E2BB19B4B4020D1F1B64A2152A910D3ABE3CDDCC476960DAA6F3B3ED077A2360991643744ED34FA6E8FDE53947C1B0A07DFF6C535413E6516BEBA334D923F26059F6A55DD4953D8B28A371B1B173068C7207CD23D7CE07048DCF430ACA47D907E47C9B7F186213966EFFFFC71622606C2BB1CE900FBD9669692916FA5215CD2717A062BD3282568FB6878BC0BE4459A46F25D9246C062D6E8065B9D8606D5057D8597F0E399579B02FCACFAF69E6BC7081426744C4C05D3A1BF4B339E8CAB18657A05B88E9AD6E6FDF3F3535338BC144016DD8C5901F58D9D939E187B0B12D2DB1F32EBDE308820404C5046EA341E3E3AC9082F2E990906B5FEDCB4BD12D294929B9B79DF9FFD5AC6D4C1919FEFEA1A1D72CA51F3EECC804CCA33250B00033FFC22B55562A17997D85C046990C1AA59E3D1734411EDC586367675F823BDB223BFB6A4048FFCD59984C668E19161C50507801457300AA263440DE305A03E16540CDC98929A8AEAE7698DAEF303B1B357BB3112613B61FD8D8D8B9B8B8060797DEBDE35DD8DCDC5C181F0F1ADD045600A6A11404EF377D416CA6949458595965589730B1FCDF7F76B6637BDB3DEB0C88C9D06BD732A57B04828301735FBECC850B1764508760F4EC23D712998B4A58A2044D4E92830894200279F0F3E0D2207DB16DFCF403D8B6CA5CDBC1A14021A2E0988282428481C1DD08850874CD5868E1AF5CBE0C234A4EF50B3AE5FEFD530E0E5312E6EA79D759D97F5A023CF821BC5CEF7877AFFB8ECD4F9E1312DADCE486D89CE49EDFFBEC151213A520C0DC9797616D055AF803A8B575CAF6FF3BF332B795640064E8CB6BD72C33C37A5A83D382C32CF34EBD7A20F3E02A12F3B5D1B355F60D12D799C9A5B1C9C94922604E12CE7C5E5BE70254B436067F5A855E48E0B244416767C4C040CC0B859817112F40D3880818AA73622E5F86290CB48C69DFDFDE5EBD1FD47470F01ECABBBECAFA033BFB3B58BB3FAFBDE35D5B66DB248E839AA4CD716E88CF20EEF1D5AFA6CD47A9F6D53E55AB0CFF4AFFD0B950F95079F997F210A5FF754951724590A1D7C400F2A1002A6A995521FB8E3EB8F0E016BDDD33525D656323B313092B93E34141C4B3C4C9D195C9C5E5B5B5776B9F3F7F21655FFD29E494B937BAC6F15DA8272F625E5C565000AB5E81B88C89996A47734A4ECED4C1FDE89543B503CEFB665EC847D61F7EFA42C9BBB6B6F6E9D33A717C9790D0C224C7F8E802C21C0B5A7D7C18CA09BD3B788B4C9B212F88AEAA1B1A1F1F0AA0F2D6D625FFD53065D10529FD41C94C7405CD1E0168503A2C5F8A86BCFFE25919A5D787404D5E32858BB4B9026252C893E4310A5B1089B6B6BCF6F977CECF5CABB4908BE6039D9D9D05110A2F222EBF882800F52ED3574E5313826C376F3F78107250CE7E87CE2B3755437E06CBFE0056DDFD79F7DAEEDDCBCBCBECE4B13D9B429CE30B9BE3E74683844052DA63D40541BF77EB16D4CDF7AAFEF2F1F66262F6F1EEC0290FA4FEF2D656FF9502B393E51E68E98F8232F3615866CFC38E0E31B170C7978D216F655002823E0861D27889677929418B9B9B938445129132C93679766D7999B686301128D7DA3B48438DDEB69DC70A3A21346372145EC47C55F34AFB41F376FA45C9DBE19ED30EE1F9C2BC316482F5E7F59FDEADEDFECC0BFEFFBCBE4CFB618520C436E6CB393FC6BD790E3AF749A179D6EB872F404B0BED3B8CD6109B23F296D9D96262F1F1F6F6EEF1A1D75ECAFBFB6758FFE73BC4EDDCAE9B619521FF12FC7A4D2C2C2C2C530C96A57DA87C639ECC05A5AB689BDAEB4387DE3F5BA5F9FABEF325F94E9E0D22ED390B984B9B6737687B69CB6BEBBBBF82F2F27201E79501289A9082AA73AA61D6CCC9B972191E57202CA70EB61F44A4070F02E41573D51017D6B5F5778360D6DDBBE1B1BCBECCCBB1B230B6B4495A19E3101A276E6E0A417FF0F1D757B7508A50BA8A304FA9868686777400A7BD25BA8AF0B5F86BD0CA5859FF6717A7D8B9DD3AA324832E25726CA6B4583CBAD8B298FD4BD5BCFC0B17D01652A03C6474FDE33A81C24526F80641F259A1902941F0EB701106F7D2D6D7D6D790A4A0272F2FCD25A4D1BCB0F3C58042757B750EDDA7398008F783ED53F48BCC1F042D0B0AAE5C815242A3D178B9E8FF35BC556BB4E5652EC20A81C42EC4B142E1E01EE3842CB4C91D447379F5165204E2BCF5E0E8A9BCD0D00E59D91E00B58FB7875FD512AC2B6F9591F19F74F42C19E8E258905F333341CA87D2D019C4A3C29999A99A77544909263D4479E82DC42695FC8E42214C4229592151414D0AE91D6963EF326D9DFE8B22502E2E1AE879D1BCB017B2D0FEFD28AB7EE5CC81A09C323F88564E75B5025DCBBDBCEBBC5CA0E33AFD4E03FF93493F8C9196480BBB84A0A4B08D07F96E726F72B918DD7A70EB0BE685C3A754E3433B5A8361BE81D072B704504BCB6BD0994267C4F27FCE3E6A4099292D9D19F6F0E1C330702E20431A1240DD8192921274EE872E5EBCF8F6D95EDA19F292AFEFE6286192BCB84925519626296B64EA32ED23EDF31750D0F347D0332044F5A6F74004149417D53974410FD25545E9C77C0A9C5B7DCC3C272F649E15FCCEF56E6DED8B9CCBB4E58D2528CB63042ECA189544151A5F12DAE408DAE4DEEB72EB2D7816613EB87AF4946A6C280C08002ADB83AE230C94C01A8A38FF0F7A02E5887FBCE5B5AF528649678A59664A3F6C15F03B9209BD1ECC604A74CA7D109BBC04021B81341944225117295402857D93B4EE4B1C5CFF485B5EFFCAF9999D97C6BB372024EFE09501E8F620D3E6C4D0534F7BCC419466D153B5C3952BB379216756D77FA784F5191C4B6363A312B908BEEC145F4EA145EE4D84392E34CE1EA4F4F6C10325B4A9F8C183FC5321F1F16669C1A8EF07EBA20003352DAFC5BBFB5BFDEFF564EE07CA504B693174F15EB84943020A7B2820E0178511C80C39F55C092559847908EAE63B32996D9282FAF645B6332B044841045E12757010E4FCB8F605147CFB238D77953B244FD2BC30F7EE8B17A81D00D49C1CBA6DF71FDC3F0571692E9E77FDE3EA67DAFAEE77BBE990EB484BDA1E122F9963B7AFEF1281089863424B429405C064133A940FE9076D74BFAA046A7688A53EEA7B84407B3A404F08B1CC4CCB4CCB502BAB94FF0DE7CE36EB913974F1F08761E89CFA02E0DA87D2E82CC151534704A4434EC9BCFE8A498F4D2E120146EAC9492A756991B24109623F7BE647F2E2E0E6C65EC8B76BA0CD1AAAA1280FADEEBD9ED7683E80926D41CC65F39CF6FD5FB2510EF4ECFB73CCD3E994CB6BBCBC5F2897D72117EDE65A24BE23939641CD31CE5D427BC628EC4263C451A1CD5D7F451F2E287DC17C95A7DA112E3B9410D5D7D7171C1C0C112A26064ECC94CEBC36079CFFB16F597421FB588A3D04FD8E08DC3CE227D003D1F9D0CFEF485353D3CDB8908B109774CC4387A0D9DBFBE324890C8DC1E422690F95B444991C249D8129FB1D61F1F3CF7B69B49FD7E91917F4FCBCBE7BF5D3F590C69BF4F6B5BABAFD60750C04690C7405FBA79AA6CC3179D77FFCF8799D97FEB6FC4E49FB819DE8BBEC0B73BB2F3B8948DD5CF425B00B91D86012125ABAF856097D7E7281AE66889F7DB61D3E2A210A13D5E7D70AA9E861474F5898988018E22C61FA0F3ABF1D4C1973A1F19055FDFC30478E6060A8EF81D4E38769C234354D35D584ECBBF0FAAB98AF0FBDBABECA4EE4246F42D95CA4AC50291B67273F436C12A86B24EAC63AEDE3F2DE2FEE03D2C1C14F6BD0DF865C449CFBABA17C2ABC80E782EA29CCEC548EF910D2F2130D845CDBFD9512EC4024D1086334A22F2F81BC2444DC4358E1DE64E720B309118416B81A8D94E85282A247F3541F661789E3EB66616685A9AF1540215FB6825062EEEE2323196DFF9198F273F1F162617E18C435D584E96BF5F3EB833FC06B071891F6FD4E0998468F3F523789484DCA0A69831330377F9C3CB34E5EDC4D5EE1226CD0E8BEFD1AA08383CBBCACAB2EC069AE009C2FAA6130A96E87896476CAC1FC66DE751A2BEFA7DD5FCBE527DAFA3278619D485EA79068C81C4476212295C4C641591A1BDB4359181BDBABFA4A49E92B66FE29D5A2701D373B879999D93AB7A8A8A83E14A2AD180C8CE81DF6732336FFBE4D60064A24A64054DDEC8C43FBCCF928BF237D7DE0D7A9F6F6F32202CFBE62D23DBBEFEDE355EA24756C93BA79964A59A29B96EB0CF91379114807092B906FA14F585F5EA657D0C1C175C8B850406F56438B5E0D9EADBE822612071CA2FCB8CA4B7BF72567C17FF1090CBB77F91D99482310D7D12734C425C22291C246106217E266231161446944B149E75402357BB255DCF0DADAB3003A3BEB70BE09385BD330518FD2D2B2DDE74632FE9D6DB75BFBCF41BB231D353B731A77FA00CF6C13A6AEAEA96EF6FCB10211A75EE8ABE991099087E0ABD1631A27799130E93B796685B4B448DA20900609C4650295462223DF0E42AAFCB8FE69F9F702BAF6890685E5629879F57EA467B582C314DC72807270EF8F9FB81020C2A4A1B8DC4B20D13888CB1CE4750E2AD7D8CA1261850C3D02658983B06793CC21B4FACCE8BDD25750993CD5B46C9D0A71EDD252DC0C0E37A38DAF8B1A4A034A3C7C290A171C19F9B7D976871ADDB21DADB37C07849D24700EE781F03CDADBA3BAD341E40A1DF310BD033AF45AE9FD5B975532658580661376F2D2C69925D2E63AE50C30424DF991B8B2441A44BE5DA79750D009F5B7341AD25301C95950500D523A381C6C0C21B0727D7A07FD2BC24494E0581A4829445E2711219D718D2D2E11D9C8426C1C634BDCA43D14A22F6555D5E8F517CAABAF516C9AE954E0252470A5A74FE370DA78373C5817E415B71B0A360339534A76FC9BC8F49F73B4EF904DC59FEEEE96EAC669CFCE9E9F397F9AA7F474A7E1E9D322375555BF74B38852E9EAEB091A91B242995C242F2E913688147612659D44A691A9EB0422EF18959DBCF199F671EF5E3AE5A775A427E8C48A38AFC03452AD505DE0302B013309F7EAE027AE41646F44F909E29275FD4714926C3F12A8F0962DF92EED195B22129608047602C72E21EAC2E6EA337A6CA2EDC5484DBF2F981249802A518A2BD5C6E3DDDCDCB4F9EDDC86B2DD0547D4FEF5A5D77694CB0365B6AC6C9F364EC258AABB5B1B3F0BEE45FB9E49758BF4E698ABE65DF82226FAF1EF1B3768640A1B89429C5C64A3B0A1A68CB24E21D0888BBC6788EB67A83F923616097B21637E0248188E9171D769A8912FBFA950007A5617CC6A9B67875C6765A7BD1B0448D409D32BC95E3004FC14DF452E21F0C4D206796985C8E52B34C8C1C13536C649A152291F558DD0A73874D20B484DFD747C120EE404565C122E093887A24C7038F1A1EC6CFB39A6927B3BFEB598EE0833B50EE764DCDDDD7DBA547B8607873B2D6C2AE5E4D42D1C73103A773A26FA3FA08D0783A4C9251209DA3C36D20A60829A605A328A4D1A09D4D818F41D5CDEBB77EF2788CF4F48ABCFC8C67BAF87C8DF5400BF161CC039DC3C757D7595C6C505DF460B6672E458947916D9CFB0B3919696282BA0264C086412D719C28F4242548E154E0AC4E66B3AE7FB2F6AEAEB278B8394F49584C349F02799E0C5C5B5F9F1693AD9EEEE89FDFF2A3AB75BCFC5BBDB87A725D4E1404B27271CBED409CC2EDCDBD929DC2BDCEBED0CBDDE45149CAFD1FFC3E8D9EAA02F697192C446585C212C51CF0E42DAF882E94B5D265279891B5CC40D76E0A2D1C3F3774EA89F79990E0E0760754260AEACAEF1B2AF7DA5A4D7CBDDEC44AE2502FB126169096D37FC610F898B4A784726BC238C71F9923927A92B1C348489D2A092D2F3FC10D587FAFA0D15FF1313DD937026DA6E7813FE219D6CB1CAFEFE92FE7FD996C0AC261F1A6A1F9E9D5A81C7754B19239BF3489CC61DE895EA94EA95EA36F59604CCD7AF2F1EBAF845CDC7B41F49944502197A0336123B95F28E83B40699C31785270D61B2AD11160729307E427CD2130CF4E38893F5FAA19B05059DB84E73F59000D6C1E52F94EBCBF41C4B5B198484C6455C5A117AB748E45D39C3C5068C42345F02EF18613707994AA112B9579FBDDDA78462077E910B743575B4B47FE734E6E787676D136D71BC895B5AB6587D7FFFFF7ACD5216DDD039777B33D9B4286D2709BAC9794E9F761296523860D8999B9B6BD0FE2CE4D0F3DF4DFBFA10245A2ECAE620609236D850DD64279F593F43C7F4F5459FAD1056DE913706894B5047F62E7F5DEB839F81643EC4E6606741E701BFBCEBAC308E0EFEFE4D44B9BE085EE5A512689C841FD9C8EF167D61A6E5251278C96706C788BC67C854212AF9ECC7EBC8B4F07BBC7FFDFA42886A585C9C4EB2385EC2D81820E126C12FC1CF4FE774D3D1CFB638DEDF6FBDFDF7E8DCD1661DBAF5DAD656D9A1BA19A47B2998DC49C249AAF3804467B1DEDDE25CA827DB0F1DFACBA143DB915D0EDD72D9B66DCB966DDCC46D5BB6EDD9B28DB8651B2779DB96B16D5B7CB711B66C5BD9B66D71DBB633F04DCE6DFF6EB1BAE4C97676761EBC787DDBEABFFD1E79CBB66DBBBEFEC0852DDB76716EA3D25F9FA3FFA82DBBB66DD9B365CBEA63A37D57FFB2EF8B9C30CB6ED5D93A64974497D3F80B27A421136D1337B7B4AD625B13995232985074FE0F609E716EC0D43F5E0000000049454E44AE426082,2001,NULL,1,201,'1980-06-21',106.10,15,30,24,8,'2210','2210.png','Forward'),(213,'Joe','Johnson',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png','Guard,Forward'),(272,'Mike','Miller',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png','Forward'),(289,'Joakim','Noah',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