{if $isMasterGrid}
    <table class="playoff-series">
        <tr>
            <td class="playoff-series-team">
                <h3 class="playoff-series-team-title">{$DataGrid.Rows.0.DataCells.first_team_caption.Value} <span class="text-muted">({$DataGrid.Rows.0.DataCells.first_team_seed.Value})</span></h3>
                <div class="playoff-series-team-logo">
                    <img src="nba_images/teams/{$DataGrid.Rows.0.DataCells.first_team_short_caption.Value}.svg" title="{$DataGrid.Rows.0.DataCells.first_team_caption.Value}">
                </div>
            </td>
            <td class="playoff-series-vs text-muted">vs</td>
            <td class="playoff-series-team">
                <h3 class="playoff-series-team-title">{$DataGrid.Rows.0.DataCells.second_team_caption.Value} <span class="text-muted">({$DataGrid.Rows.0.DataCells.second_team_seed.Value})</span></h3>
                <div class="playoff-series-team-logo">
                    <img src="nba_images/teams/{$DataGrid.Rows.0.DataCells.second_team_short_caption.Value}.svg" title="{$DataGrid.Rows.0.DataCells.second_team_caption.Value}">
                </div>
            </td>
        </tr>
        <tr>
            <td class="playoff-series-wins{if $DataGrid.Rows.0.DataCells.first_team_wins.Value > $DataGrid.Rows.0.DataCells.second_team_wins.Value} playoff-series-wins-winner{/if}">
                {$DataGrid.Rows.0.DataCells.first_team_wins.Value}
            </td>
            <td></td>
            <td class="playoff-series-wins{if $DataGrid.Rows.0.DataCells.first_team_wins.Value < $DataGrid.Rows.0.DataCells.second_team_wins.Value} playoff-series-wins-winner{/if}">
                {$DataGrid.Rows.0.DataCells.second_team_wins.Value}
            </td>
        </tr>
    </table>
{else}
    <img class="playoff-title" src="nba_images/playoffs.svg">
    <div class="playoff">
        <div class="playoff-conference playoff-conference-left">
            <h2 class="playoff-conference-heading">West<span class="visible-lg-inline">ern conference</span></h2>
            {include file='custom_templates/playoff_round.tpl' Round=1 Conference=2 Rows=$DataGrid.Rows}
            {include file='custom_templates/playoff_round.tpl' Round=2 Conference=2 Rows=$DataGrid.Rows}
            {include file='custom_templates/playoff_round.tpl' Round=3 Conference=2 Rows=$DataGrid.Rows}
        </div>

        {include file='custom_templates/playoff_round.tpl' Round=4 Rows=$DataGrid.Rows}

        <div class="playoff-conference playoff-conference-right">
            <h2 class="playoff-conference-heading">East<span class="visible-lg-inline">ern conference</span></h2>
            {include file='custom_templates/playoff_round.tpl' Round=1 Conference=1 Rows=$DataGrid.Rows}
            {include file='custom_templates/playoff_round.tpl' Round=2 Conference=1 Rows=$DataGrid.Rows}
            {include file='custom_templates/playoff_round.tpl' Round=3 Conference=1 Rows=$DataGrid.Rows}
        </div>
    </div>

    <script>{literal}
    require(['jquery'], function () {
        $(function () {
            var $playoff = $('.playoff');
            $playoff.on('mouseover', '.playoff-round-game-team-logo', function (e) {
                var $el = $(e.currentTarget);
                var id = $el.closest('.playoff-round-game-team').data('id');
                $playoff
                    .find('.playoff-round-game-team')
                    .removeClass('playoff-round-game-team-highlight')
                    .filter('[data-id=' + id + ']')
                    .addClass('playoff-round-game-team-highlight');
            });
            $playoff.on('mouseout', '.playoff-round-game-team-logo', function (e) {
                $playoff.find('.playoff-round-game-team').removeClass('playoff-round-game-team-highlight');
            });
        });
    });
    {/literal}</script>
{/if}