{if $isMasterGrid}
    {include file='list/single_row_card.tpl'}
{else}
{if count($DataGrid.Rows) > 0}

    {foreach item=Row from=$DataGrid.Rows name=RowsGrid}

        {if $Row.Classes}
            {assign var="rowClasses" value="pg-row "|cat:$Row.Classes}
        {else}
            {assign var="rowClasses" value="pg-row"}
        {/if}

        <div class="grid-card-item {if $isMasterGrid}col-md-12{else}{$DataGrid.CardClasses}{/if} {$rowClasses} player-card" style="{$Row.Style};">

            <table class="player-card-table">
                <tr>
                    <td class="player-card-photo">
                        {$Row.DataCells.photo.Data}
                    </td>
                    <td class="player-card-number">
                        {$Row.DataCells.current_number.Data}
                        {if $DataGrid.AllowSelect}
                            <div class="player-card-select row-selection">
                                <input id="record_{'_'|@implode:$Row.PrimaryKeys|@escape}" type="checkbox" name="rec{$smarty.foreach.RowsGrid.index}" data-value="{to_json value=$Row.PrimaryKeys escape=true}" />
                            </div>
                        {/if}
                    </td>
                    <td class="player-card-basic">
                        <div class="player-card-name">
                            {$Row.DataCells.first_name.Data}<br>
                            {$Row.DataCells.last_name.Data}
                        </div>
                        <div class="player-card-job">
                            {$Row.DataCells.position.Data} {$Row.DataCells.current_team_id.Data}
                        </div>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <div class="player-card-info">
                            {$Row.DataCells.weight.Data} kg / {$Row.DataCells.height.Data} cm<br>
                            Born: {$Row.DataCells.birthday.Data}<br>
                            Exp: from {$Row.DataCells.career_start_year.Data}<br>
                            College: {$Row.DataCells.college_id.Data}<br>
                        </div>
                    </td>
                    <td class="player-card-actions" style="vertical-align: top;padding:1em;">
                        {include file="list/action_list.tpl" Actions=$Row.ActionsDataCells}
                    </td>
                </tr>
            </table>

        </div>

    {/foreach}
{/if}
{/if}