{capture assign=GridBeforeFilterStatus}
{if not $isMasterGrid}
{* icons *}
<svg  viewBox="0 0 48 48" enable-background="new 0 0 48 48" class="hide">
    <defs>
        <symbol id="icon-custom-filter">
            <path id="path0_fill" d="M 46.522 3.55271e-15L 0.0750411 0C -0.0269589 0 0.0580411 17.636 0.0190411 17.73C -0.0199589 17.824 0.00204105 17.934 0.0750411 18.005L 17.57 35.406L 17.57 47.747C 17.57 47.888 17.683 48 17.822 48L 28.775 48C 28.914 48 29.027 47.888 29.027 47.747L 29.027 35.408L 46.522 18.005C 46.595 17.933 46.617 17.824 46.578 17.73C 46.538 17.635 46.522 3.55271e-15 46.522 3.55271e-15Z"/>
        </symbol>
    </defs>
</svg>

<form action="GET" class="js-custom-filter-container">
    <ul class="nav nav-pills pull-right grid-card-column-filter">
        <li {if $customFilterActive.game_selection}class="active"{/if}>
            <a href="#" class="js-filter-trigger" title="">
            <svg viewBox="0 0 48 48" class="svg-icon">
              <use xlink:href="#icon-custom-filter"></use>
            </svg>&nbsp;Game selection
            </a>
            <div class="js-content hide">
                <div class="form-group">
                    {foreach from=$divisions item=division}
                        <div class="checkbox">
                            <label>
                                {assign var='id' value=$division.id}
                                <input type="checkbox" class="custom-filter-groups" name="customfilter[divisions][]" value="{$id}"
                                        {if $id|in_array:$customFilter.divisions} checked="checked"{/if}>
                                {$division.caption} division
                            </label>
                        </div>
                    {/foreach}
                    <hr class="custom_filter_separator">
                    {foreach from=$conferences item=conference}
                        <div class="checkbox">
                            <label>
                                {assign var='id' value=$conference.id}
                                <input type="checkbox" class="custom-filter-groups" name="customfilter[conferences][]" value="{$id}"
                                        {if $id|in_array:$customFilter.conferences} checked="checked"{/if}>
                                Cross-division games ({$conference.caption|substr:0:4|ucfirst})
                            </label>
                        </div>
                    {/foreach}
                    <hr class="custom_filter_separator">
                    <div class="checkbox">
                        <label>
                            <input type="checkbox" class="custom-filter-groups" name="customfilter[cross_conference][]" value="1"
                                    {if $customFilter.cross_conference} checked="checked"{/if}>
                            Cross-conference games
                        </label>
                    </div>
                </div>
            </div>
        </li>
        <li {if $customFilterActive.diffscore}class="active"{/if}>
            <a href="#" class="js-filter-trigger" title="">
                <svg viewBox="0 0 48 48" class="svg-icon">
                  <use xlink:href="#icon-custom-filter"></use>
                </svg>&nbsp;Score difference
            </a>
            <div class="js-content hide">
                <div class="form-group">
                    <div class="CustomFilterDiffScore">
                        <span class="CustomFilterDiffScore-start">{$diffscores.min}</span>
                        <span class="CustomFilterDiffScore-container">
                            <input class="custom_filter_diffscore" name="customfilter[diffscore]" type="text" class="form-control custom_filter_not_auto" value="{","|implode:$customFilter.diffscore}" data-slider-min="{$diffscores.min}" data-slider-max="{$diffscores.max}" data-slider-step="1" data-slider-value="[{","|implode:$customFilter.diffscore}]"/>
                        </span>
                        <span class="CustomFilterDiffScore-end">{$diffscores.max}</span>
                    </div>
                    <table class="custom_filter_diff_inputs">
                        <tr>
                            <td>
                                <input type="number" class="form-control custom_filter_diff_inputs_start custom_filter_not_auto" min="{$diffscores.min}" max="{$diffscores.max}" value="{$customFilter.diffscore.0}">
                            </td>
                            <td class="custom_filter_diff_inputs_center">&nbsp;-&nbsp;</td>
                            <td>
                                <input type="number" class="form-control custom_filter_diff_inputs_end custom_filter_not_auto" min="{$diffscores.min}" max="{$diffscores.max}" value="{$customFilter.diffscore.1}">
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </li>
        <li {if $customFilterActive.winner}class="active"{/if}>
            <a href="#" class="js-filter-trigger" title="">
                <svg viewBox="0 0 48 48" class="svg-icon">
                  <use xlink:href="#icon-custom-filter"></use>
                </svg>&nbsp;Winner
            </a>
            <div class="js-content hide">
                <div class="form-group">
                    {foreach from=$winner key=key item=text}
                        <div class="radio">
                            <label>
                                <input type="radio" name="customfilter[winner]" value="{$key}" {if $customFilter.winner == $key} checked="checked"{/if}>
                                {$text}
                            </label>
                        </div>
                    {/foreach}
                 </div>
            </div>
        </li>
    </ul>
</form>
<script type="text/html" id="custom_filter_content">
    <div class="custom_filter">
        <button data-dismiss="alert" class="close" type="button">&times;</button>
        <div class="js-content"></div>
        <hr class="custom_filter_separator">
        <div class="btn-toolbar pull-right custom_filter_toolbar">
            <button type="submit" class="btn btn-sm btn-primary js-apply">Apply</button>
        </div>
        <div class="clearfix"></div>
    </div>
</script>
{/if}
{if isset($GridBeforeFilterStatus)}{$GridBeforeFilterStatus}{/if}
{/capture}

{capture assign=FilterStatus}
    {if $customFilterActive.game_selection or $customFilterActive.diffscore or $customFilterActive.winner}
        <div class="filter-status-value filter-status-value-custom-filter" title="{$customFilterStatusString|strip_tags:false}">
            <svg viewBox="0 0 48 48" class="svg-icon filter-status-value-icon">
              <use xlink:href="#icon-custom-filter"></use>
            </svg>
            <span class="filter-status-value-expr">{$customFilterStatusString}</span>
            <div class="filter-status-value-controls">
                <a href="#" class="js-reset-custom-filter" title="{$Captions->GetMessageString('ResetFilter')}">
                    <i class="icon-remove"></i>
                </a>
            </div>
        </div>
    {/if}
{/capture}

{if $Grid->GetViewMode() == 0}
    {include file='list/grid_table.tpl'}
{else}
    {include file='list/grid_card.tpl'}
{/if}
