<div id="arenas-map" style="width: 100%; height: 400px; margin: 16px 0; color: #000"></div>

<script type="text/javascript">
{literal}var rows = {/literal}{$Markers|@json_encode}{literal}; // {/}
function initMap() {
require(['underscore', 'jquery'], function (_) {
    var infoTemplate = _.template('<h4><%=caption %></h4><img src="<%=logo %>" class="hidden-xs" style="float:right; margin: 10px; width: 130px"/><p><%=about%></p>');
    var $container = $('#arenas-map')
    var map = new google.maps.Map($container.get(0), {
        scrollwheel: false
    });

    var infowindow = new google.maps.InfoWindow();
    var bounds = new google.maps.LatLngBounds();
    var markers = {};
    $.each(rows, function (i, arena) {
        var marker = new google.maps.Marker({
            position: {lat: parseFloat(arena.lat), lng: parseFloat(arena.lng)},
            map: map,
            title: arena.caption
        });

        marker.addListener('click', function () {
            infowindow.setContent(infoTemplate(arena));
            infowindow.open(map, marker);
        });

        bounds.extend(marker.getPosition());
        markers[arena.id] = marker;
    });

    map.fitBounds(bounds);

    function selectMarkerFromHash() {
        var marker = markers[parseInt(location.hash.substr(6))];
        if (marker) {
            map.setCenter(marker.getPosition());
            map.setZoom(18);
	    map.setMapTypeId('satellite');
            new google.maps.event.trigger(marker, 'click');
            window.scrollTo(0, $container.offset().top - $('#navnav').height());
        }
    }

    var markerCluster = new MarkerClusterer(map, _.values(markers), {gridSize: 30, imagePath: 'nba_images/map/m'});

    setTimeout(selectMarkerFromHash, 1500);
    $(window).on('hashchange', selectMarkerFromHash);

});
}
{/literal}</script>
<script src="markerclusterer.js"></script>
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDmxmB53C3fTuvf7ptsu4tQ2OUVonxOFUw&callback=initMap"></script>

{if $Grid->GetViewMode() == 0}
    {include file='list/grid_table.tpl'}
{else}
    {include file='list/grid_card.tpl'}
{/if}
