<?php

return array(

    // Data Grid

    'data_grid_table_view.php' => array(
        'description' => 'Table view is the default option for all pages.'
    ),

    'data_grid_card_view.php' => array(
        'description' => 'Card view is an alternative way to browse data. It allows you to get a 100% responsive page without any custom settings.',
        'demo_video_link' => 'https://www.youtube.com/watch?v=DgMi2v19uCo',
        'class_attribute' => 'pro'
    ),

    'data_grid_autohiding_columns.php' => array(
        'description' => 'To make a table view responsive, define column visibilities for each display resolution (mobile, tablet, desktop, and large desktop).',
        'demo_video_link' => 'https://www.youtube.com/watch?v=u1G4lR6kaHA'
    ),

    'data_grid_totals.php' => array(
        'description' => 'You can display summaries (Sum, Average, Count, etc) for all or certain grid columns.',
        'class_attribute' => 'pro'
    ),

    'data_grid_header.php' => array(
        'description' => 'This property is used to display a brief description of the page.'
    ),

    'data_grid_column_grouping.php' => array(
        'description' => 'You can organize columns in logical groups and display them using multi-row header representation.',
        'class_attribute' => 'pro'
    ),

    'data_grid_record_comparison.php' => array(
        'description' => 'Compare records and find identical/different values in a couple of clicks.',
        'demo_video_link' => 'https://www.youtube.com/watch?v=BcTpc3t8hPk',
        'class_attribute' => 'pro'
    ),

    'data_grid_unicode_support.php' => array(
        'description' => 'It is possible to display and edit data in any language.'
    ),

    'data_grid_rss.php' => array(
        'description' => 'PHP Generator provides support for full-fledged RSS feeds.',
        'class_attribute' => 'pro'
    ),

    'data_grid_custom_drawing.php' => array(
        'description' => 'You can easily change default appearance of any grid row depending on the row data.',
        'class_attribute' => 'pro'
    ),

    'data_grid_custom_table_template.php' => array(
        'alternative_caption' => 'Grid View',
        'description' => 'This page demonstrates how it is possible to define a custom template for a grid view.',
        'class_attribute' => 'pro custom'
    ),

    'data_grid_custom_card_template.php' => array(
        'alternative_caption' => 'Card View',
        'description' => 'This page demonstrates how it is possible to define a custom template for a card view.',
        'class_attribute' => 'pro custom'
    ),

    'data_grid_custom_grid_toolbar_template.php' => array(
        'alternative_caption' => 'Grid Toolbar',
        'description' => 'This page demonstrates how to customize a grid toolbar.',
        'class_attribute' => 'recently-added custom'
    ),

    'data_grid_custom_single_record_view.php' => array(
        'alternative_caption' => 'Single Record View',
        'description' => 'This page demonstrates how to define a custom template for a single record view form.',
        'class_attribute' => 'pro custom'
    ),

    // Grid Columns

    'data_grid_columns_column_types.php' => array(
        'description' => 'This page presents all the supported data grid column types.'
    ),

    'data_grid_columns_text_truncating.php' => array(
        'description' => 'It is possible to truncate long text values.'
    ),

    'data_grid_columns_column_fixed_width.php' => array(
        'description' => 'You can specify exact width for certain data grid column(s).'
    ),

    'data_grid_columns_formatting.php' => array(
        'description' => 'You can use various formatting options for columns, such as font, alignment, and even inline styles.'
    ),

    'data_grid_columns_null_label.php' => array(
        'description' => 'It is possible to define a custom character string that will be displayed when a NULL value is stored in the database.'
    ),

    'data_grid_columns_hyperlinks.php' => array(
        'description' => 'You can display the contents of a grid cell as a hyperlink.'
    ),

    'data_grid_columns_html_display.php' => array(
        'description' => 'It is possible to enable or disable HTML display.',
    ),

    'data_grid_columns_lookup_data_view.php' => array(
        'description' => 'You can view the linked record of a lookup column.',
        'class_attribute' => 'pro'
    ),

    'data_grid_columns_custom_rendering.php' => array(
        'description' => 'You can control the rendering of each cell via the OnCustomRenderColumn event.',
        'class_attribute' => 'pro'
    ),

    // Grid Options

    'data_grid_fixed_grid_width.php' => array(
        'description' => 'You can limit the maximum width of the data grid.'
    ),

    'data_grid_fixed_column_header.php' => array(
        'description' => 'It is possible to get the grid header non-scrollable.',
        'class_attribute' => 'pro'
    ),

    'data_grid_bordered_table.php' => array(
        'description' => 'Turn this option ON for borders on all sides of the grid and cells.'
    ),

    'data_grid_condensed_table.php' => array(
        'description' => 'This option allows you to make the grid more compact by cutting cell padding in half.'
    ),

    'data_grid_line_numbers.php' => array(
        'description' => 'There is also an option to display row numbers.'
    ),

    'data_grid_control_buttons_position.php' => array(
        'description' => 'It is possible to place the control buttons on the left (default) or on the right side of the data grid.'
    ),

    // Master-Detail Views

    'master_detail_basic_example.php' => array(
        'description' => 'A basic example of master/detail features provided by PHP Generator.',
        'class_attribute' => 'pro'
    ),

    'master_detail_multiple_details.php' => array(
        'description' => 'It is possible to have multiple detail views for a single master view.',
        'class_attribute' => 'pro'
    ),

    'master_detail_nested_details.php' => array(
        'description' => 'Nested detail views are also supported. There is no limit to the depth of nesting.',
        'class_attribute' => 'pro'
    ),

    'master_detail_card_mode_details.php' => array(
        'description' => 'Starting from the version 16.9 inline details (and all the related features) are also supported for card views.',
        'class_attribute' => 'pro'
    ),

    // Data Input Forms

    'data_editing_separate_page.php' => array(
        'description' => 'By default View, Edit, Insert, and Copy forms are displayed on a separate page.'
    ),

    'data_editing_modal_window.php' => array(
        'description' => 'It is also possible to insert, view, edit, and copy data using modal windows.',
        'class_attribute' => 'pro'
    ),

    'data_editing_inline_editing.php' => array(
        'description' => 'Inline editing allows you to insert, edit, and copy records directly in the data grid.',
        'class_attribute' => 'pro'
    ),

    'data_editing_custom_separate_page.php' => array(
        'alternative_caption' => 'Separate Page Editing',
        'description' => 'Define your own templates to customize Edit and Insert forms in a separate page.',
        'class_attribute' => 'pro custom'
    ),

    'data_editing_custom_modal_dialog.php' => array(
        'alternative_caption' => 'Modal Dialog Editing',
        'description' => 'Define your own templates to customize Edit and Insert modal dialogs.',
        'class_attribute' => 'pro custom'
    ),

    'data_editing_custom_inline_form.php' => array(
        'alternative_caption' => 'Inline Form Editing',
        'description' => 'Define your own templates to customize Edit and Insert inline forms.',
        'class_attribute' => 'pro custom'
    ),

    'data_editing_wizard_form.php' => array(
        'description' => 'Learn how to how to split a data input form into multiple steps.',
        'class_attribute' => 'pro custom'
    ),

    'data_editing_multiple_insert.php' => array(
        'description' => 'This page displays how to quickly add multiple records.',
        'class_attribute' => 'pro'
    ),

    'data_editing_custom_form_layouts.php' => array(
        'description' => 'Customize Edit, Insert, and View forms with just a few lines of code.',
        'demo_video_link' => 'https://www.youtube.com/watch?v=kpKFXXKBkL8',
        'class_attribute' => 'pro'
    ),

    'data_editing_tabbed_forms.php' => array(
        'description' => 'Customize Edit, Insert, and View forms with just a few lines of code.',
        'class_attribute' => 'recently-added'
    ),

    'data_editing_editors.php' => array(
        'description' => 'This page demonstarates all the data editors provided by our software.'
    ),

    'data_editing_validation.php' => array(
        'description' => 'PHP Generator provides support for both control level and form level client-side data validation.',
        'class_attribute' => 'pro'
    ),

    'data_editing_clientside_api.php' => array(
        'description' => 'Get full control over the Edit and Insert forms via the client-side events.',
        'class_attribute' => 'pro'
    ),

    'data_editing_dependent_lookups.php' => array(
        'description' => 'Learn how to implement cascading lookup controls using client-side events.',
        'class_attribute' => 'pro'
    ),

    'data_editing_on_the_fly_adding.php' => array(
        'description' => 'Add missing data items to lookup controls directly from Edit and Insert forms.',
        'demo_video_link' => 'https://www.youtube.com/watch?v=RAL9KTWjA3o',
        'class_attribute' => 'pro'
    ),

    'data_editing_quick_edit.php' => array(
        'description' => 'You can change the value of a grid cell even without having to go to an Edit form.',
        'class_attribute' => 'pro'
    ),

    'data_editing_multi_edit.php' => array(
        'description' => 'You can update multiple records at a time.',
        'class_attribute' => 'pro'
    ),

    'data_editing_custom_default_values.php' => array(
        'description' => 'You can provide a non-trivial default value for a column in the Insert form.',
        'class_attribute' => 'pro'
    ),

    // Editors

    'editors_text.php' => array(
        'alternative_caption' => 'Text Editor',
        'description' => 'A single-line plain text edit control.'
    ),

    'editors_text_area.php' => array(
        'alternative_caption' => 'Text Area Editor',
        'description' => 'A multi-line plain text edit control.'
    ),

    'editors_spin_range.php' => array(
        'alternative_caption' => 'Spin & Range Editors',
        'description' => 'Allow users to edit numeric values with ease.'
    ),

    'editors_combobox.php' => array(
        'alternative_caption' => 'Combobox Editor',
        'description' => 'A drop-down list for selecting among a set of options.'
    ),

    'editors_radio_group.php' => array(
        'alternative_caption' => 'Radio Group Editor',
        'description' => 'Allows to select one of a limited number of choices.'
    ),

    'editors_dynamic_combobox.php' => array(
        'alternative_caption' => 'Dynamic Combobox',
        'description' => 'Use this editor for lookup columns when the lookup datasource has a large amount of records.',
        'class_attribute' => 'pro'
    ),

    'editors_multiple_select.php' => array(
        'alternative_caption' => 'Multiple Select Editor',
        'description' => 'Allows to select multiple values from a drop-down list.'
    ),

    'editors_checkbox_group.php' => array(
        'alternative_caption' => 'Checkbox Group Editor',
        'description' => 'Allows to select multiple values from a set of checkboxes.'
    ),

    'editors_upload_to_folder.php' => array(
        'alternative_caption' => 'Upload To Folder Editors',
        'description' => 'Use this editors to upload a file or an image to a specified folder.'
    ),

    'editors_wysiwyg.php' => array(
        'description' => 'A powerful editor to add and edit HTML content without any coding knowledge.',
        'class_attribute' => 'upd'
    ),

    'editors_dynamic_cascading_combobox.php' => array(
        'description' => 'Allows to select a value using multiple dynamic comboboxes.',
        'class_attribute' => 'pro'
    ),

    'editors_cascading_combobox.php' => array(
        'description' => 'Allows to select a value using multiple comboboxes.',
        'class_attribute' => 'pro'
    ),

    'editors_autocomplete.php' => array(
        'description' => 'Provides suggestions while you type into the field.',
        'class_attribute' => 'pro'
    ),

    'editors_common_properties.php' => array(
        'alternative_caption' => 'Editor Common Properties',
        'description' => 'These properties are supported for all editors.'
    ),

    // Filtering

    'data_filtering_quick_filter.php' => array(
        'description' => 'The Quick Filter tool allows you to quickly search across all rows.'
    ),

    'data_filtering_filter_builder.php' => array(
        'description' => 'Filter Builder is the most flexible and powerful data filtering tool provided by PHP Generator.',
        'demo_video_link' => 'https://www.youtube.com/watch?v=l5ijiRV1s9M',
        'class_attribute' => 'pro'
    ),

    'data_filtering_column_filter.php' => array(
        'description' => 'Column filter allows you to filter data against a specific column.',
        'demo_video_link' => 'https://www.youtube.com/watch?v=1kql1gEV59Y',
        'class_attribute' => 'pro'
    ),

    'filtering_custom_filter_simple.php' => array(
        'description' => 'Learn how to create a simple custom filter panel.',
        'class_attribute' => 'pro custom'
    ),

    'filtering_custom_filter_advanced.php' => array(
        'description' => 'Learn how to create an advanced custom filter.',
        'class_attribute' => 'pro custom'
    ),

    'filtering_preliminary_filter.php' => array(
        'description' => 'You can display data only after providing one or more filter conditions.',
        'class_attribute' => 'pro'
    ),

    'filtering_selection_filters.php' => array(
        'description' => 'You can create your own filters to select records on a page.',
        'class_attribute' => 'pro'
    ),

    // Sorting

    'data_sorting_by_click.php' => array(
        'description' => 'This page explains how to sort data by single or multiple columns using the column header.'
    ),

    'data_sorting_by_dialog.php' => array(
        'description' => 'Another way to sort data is to use the Sort dialog window.',
        'class_attribute' => 'pro'
    ),

    'data_sorting_default_sort_order.php' => array(
        'description' => 'It is also possible to specify the default sort order for a page.'
    ),

    // Partitioning

    'data_partitioning_range.php' => array(
        'description' => 'Range partitioning means that each partition contains rows for which the partitioning expression value lies within a given range.',
        'class_attribute' => 'pro'
    ),

    'data_partitioning_list.php' => array(
        'description' => 'In the list partitioning each partition is defined and selected based on the membership of a column value in one of a set of value lists.',
        'class_attribute' => 'pro'
    ),

    'data_partitioning_custom.php' => array(
        'description' => 'If neither range nor list partitioning is suitable for your needs, you can define a couple of PHP functions to split data to different partitions in any way you like.',
        'class_attribute' => 'pro'
    ),

    // Exporting & Printing

    'data_exporting_grid.php' => array(
        'description' => 'It is possible to export and print the whole grid.',
        'class_attribute' => 'pro'
    ),

    'data_exporting_single_record.php' => array(
        'description' => 'You can also export and print a single record from a View form or directly from the data grid.',
        'class_attribute' => 'pro'
    ),

    'data_exporting_export_options.php' => array(
        'alternative_caption' => 'Export options',
        'description' => 'Some advanced export options can be configured via the OnGetCustomExportOptions event.',
        'class_attribute' => 'upd pro'
    ),

    'data_exporting_custom_grid.php' => array(
        'alternative_caption' => 'Export & Print: Data Grid',
        'description' => 'Learn how to customize Export and Print views for the whole data grid.',
        'class_attribute' => 'pro custom'
    ),

    'data_exporting_custom_single_record.php' => array(
        'alternative_caption' => 'Invoice generation',
        'description' => 'Learn how to customize Export and Print views for a single record.',
        'class_attribute' => 'upd custom'
    ),

    'data_exporting_user_defined_styles.php' => array(
        'description' => 'You can use your own styles for the printer-friendly version and export to PDF.'
    ),

    // Charts

    'charts_pie.php' => array(
        'description' => 'An example of a simple Pie chart with default settings.',
        'demo_video_link' => 'https://www.youtube.com/watch?v=9yZp9Swq6H0',
        'class_attribute' => 'pro'
    ),

    'charts_column.php' => array(
        'description' => 'A simple Column chart, also with default settings.',
        'demo_video_link' => 'https://www.youtube.com/watch?v=9yZp9Swq6H0',
        'class_attribute' => 'pro'
    ),

    'charts_bar.php' => array(
        'description' => 'A Bar chart with a couple of series.',
        'class_attribute' => 'pro'
    ),

    'charts_line.php' => array(
        'description' => 'An example of a multiple series Line chart.',
        'class_attribute' => 'pro'
    ),

    'charts_area.php' => array(
        'description' => 'An example of an Area chart.',
        'class_attribute' => 'pro'
    ),

    'charts_geo.php' => array(
        'description' => 'An example of a geographical chart.',
        'class_attribute' => 'pro'
    ),

    'charts_stepped_area.php' => array(
        'alternative_caption' => 'Stepped Area Chart',
        'description' => 'An example of a couple Stepped Area charts.',
        'class_attribute' => 'recently-added'
    ),

    'charts_candlestick.php' => array(
        'alternative_caption' => 'Candlestick Chart',
        'description' => 'An example of a Candlestick chart.',
        'class_attribute' => 'recently-added'
    ),

    'charts_histogram.php' => array(
        'alternative_caption' => 'Histogram Chart',
        'description' => 'An example of a Histogram chart.',
        'class_attribute' => 'recently-added'
    ),

    'charts_bubble.php' => array(
        'alternative_caption' => 'Bubble Chart',
        'description' => 'An example of a Bubble chart.',
        'class_attribute' => 'recently-added'
    ),

    'charts_timeline.php' => array(
        'alternative_caption' => 'Timeline Chart',
        'description' => 'An example of a Timeline chart.',
        'class_attribute' => 'recently-added'
    ),

    'charts_gantt.php' => array(
        'alternative_caption' => 'Gantt Chart',
        'description' => 'An example of a Gantt chart.',
        'class_attribute' => 'recently-added'
    ),

    'charts_scatter.php' => array(
        'alternative_caption' => 'Scatter Chart',
        'description' => 'An example of a Scatter chart.',
        'class_attribute' => 'recently-added'
    ),

    'charts_tree_map.php' => array(
        'alternative_caption' => 'Tree Map Chart',
        'description' => 'An example of a Tree Map chart.',
        'class_attribute' => 'recently-added'
    ),

    'charts_multiple_charts.php' => array(
        'description' => 'It is possible to place multiple charts on any of generated pages.',
        'demo_video_link' => 'https://www.youtube.com/watch?v=9yZp9Swq6H0',
        'class_attribute' => 'pro'
    ),

    'charts_chart_placement.php' => array(
        'description' => 'Charts can be placed above or below the data grid.',
        'demo_video_link' => 'https://www.youtube.com/watch?v=9yZp9Swq6H0',
        'class_attribute' => 'pro'
    ),

    'charts_customizing_charts.php' => array(
        'description' => 'You can customize any chart according to your needs with the OnPrepareChart event.',
        'demo_video_link' => 'https://www.youtube.com/watch?v=9yZp9Swq6H0',
        'class_attribute' => 'pro'
    ),

    'charts_dashboard.php' => array(
        'description' => 'It is also possible to create dashboard-like pages i.e. pages that consist only of charts.',
        'class_attribute' => 'pro'
    ),

    // Fine-tuning & Tweaking

    'tweaking_custom_icons.php' => array(
        'description' => 'Change the default set of icons to your own.'
    ),

    'tweaking_custom_theme.php' => array(
        'description' => 'Customize any of color themes that comes with PHP Generator.'
    ),

    'tweaking_custom_editor.php' => array(
        'description' => 'Investigate how it is possible to use a third-party edit control in data input forms.'
    ),

    'tweaking_embedding_via_iframe.php' => array(
        'alternative_link' => 'external_data/site/index.html',
        'description' => 'Learn how to embed a generated page into an existing website.'
    ),

    'tweaking_ajax_based_validation.php' => array(
        'description' => 'Implement client-side data validation using the Ajax technique.',
        'class_attribute' => 'pro'
    ),

    'color_themes.php' => array(
        'description' => 'Get familiar with 25 built-in color themes.'
    ),

    'tweaking_barcodes_generation.php' => array(
        'description' => 'Learn how to generate barcodes of any kind on your page.',
        'class_attribute' => 'pro'
    ),

    'tweaking_inline_button.php' => array(
        'description' => 'Learn how to change a value in the database without opening a data input form.',
        'class_attribute' => 'upd'
    ),

    'tweaking_conditional_details.php' => array(
        'description' => 'Learn how to show or hide details depending on a condition.',
        'class_attribute' => 'pro'
    ),

    'tweaking_using_ajax_in_data_input_forms.php' => array(
        'description' => 'Learn how to use Ajax in data input forms to retrieve some information from the server.',
        'class_attribute' => 'pro'
    ),

    // Many-to-Many Relations
    'many_to_many_classic_junction_table.php' => array(
        'alternative_caption' => 'Many-to-Many: Example 1',
        'description' => 'Handling many-to-many relationships: classic junction table.',
        'class_attribute' => 'pro'
    ),

    'many_to_many_handling_extra_columns.php' => array(
        'alternative_caption' => 'Many-to-Many: Example 2',
        'description' => 'Handling many-to-many relationships: junction table with extra columns.',
        'class_attribute' => 'pro'
    ),

    // Data sources
    'data_sources_table.php' => array(
        'description' => 'Learn how to use a table as page data source.',
        'alternative_caption'=> 'Data sources: tables'
    ),

    'data_sources_view.php' => array(
        'description' => 'Learn how to use a view as page data source.',
        'alternative_caption'=> 'Data sources: views'
    ),

    'data_sources_non_updatable_query.php' => array(
        'description' => 'Learn how to use a read-only query as page data source.',
        'alternative_caption'=> 'Read-only queries'
    ),

    'data_sources_updatable_query.php' => array(
        'description' => 'Learn how to use an updatable query as page data source.',
        'alternative_caption'=> 'Updatable queries',
        'class_attribute' => 'pro'
    ),

    'data_sources_updatable_view.php' => array(
        'description' => 'Learn how to use an updatable view as page data source.',
        'class_attribute' => 'pro'
    ),

    // Emailing
    'emailing_basic_usage.php' => array(
        'description' => 'A simple example of sending an email from a server-side event.',
        'alternative_caption' => 'Emailing: basic usage',
        'class_attribute' => 'pro'
    ),

    'emailing_advanced_usage.php' => array(
        'description' => 'A more complex example of sending an email from a server-side event.',
        'alternative_caption' => 'Emailing: advanced usage',
        'class_attribute' => 'pro'
    ),

    // Calculated Columns
    'calculated_columns1.php' => array(
        'description' => 'Introduction to calculated columns.',
        'alternative_caption' => 'Calculated columns - 1',
        'class_attribute' => 'pro'
    ),

    'calculated_columns2.php' => array(
        'description' => 'A more complex example of using calculated columns.',
        'alternative_caption' => 'Calculated columns - 2',
        'class_attribute' => 'pro'
    ),

    // Image Management
    'image_management_linked_images.php' => array(
        'description' => 'You can link set of images to any column in a grid.',
        'class_attribute' => 'pro'
    ),

    'image_management_multi_upload1.php' => array(
        'description' => 'You can now upload multiple images at once.',
        'class_attribute' => 'pro'
    ),

    'image_management_multi_upload2.php' => array(
        'description' => 'Learn how to use multi upload for detail pages.',
        'class_attribute' => 'pro'
    ),

    'image_management_image_gallery.php' => array(
        'description' => 'All page images can be viewed in a gallery mode.'
    ),

    'image_management_thumbnails.php' => array(
        'description' => 'Example of using thumbnails.',
    ),

    'image_management_watermarks.php' => array(
        'description' => 'Example of using watermarks.',
        'class_attribute' => 'recently-added',
  ),
);